
SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `news_categorias`
-- ----------------------------

CREATE TABLE `news_categorias` (
  `categoria_id` int(11) NOT NULL AUTO_INCREMENT,
  `categoria_nome` varchar(50) DEFAULT NULL,
  `categoris_descricao` varchar(255) DEFAULT NULL,
  `categoria_editor` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`categoria_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of news_categorias
-- ----------------------------
INSERT INTO `news_categorias` VALUES ('1', 'Sports', 'Sports related news, baseball , basketball, \ngolf amd more', 'editor');
INSERT INTO `news_categorias` VALUES ('2', 'Police reports', 'Criminal facts around the country, \nmost comons crimes and more', 'editor');
INSERT INTO `news_categorias` VALUES ('3', 'Politics', 'Politics related news, the most important \nelections facts, politicals analysis', 'editor');
INSERT INTO `news_categorias` VALUES ('4', 'Fun', 'Your online guide for having fun in the bigest \nUSA cities, plays , movies, shows, what is hapening in your town', 'editor');

-- ----------------------------
-- Table structure for `news_config_sistema`
-- ----------------------------

CREATE TABLE `news_config_sistema` (
  `news_config_chave_atualizacao` int(11) NOT NULL,
  `news_config_pub_req_aut_editor` char(1) DEFAULT NULL,
  `news_config_noticia_dias_no_ar` int(11) DEFAULT NULL,
  PRIMARY KEY (`news_config_chave_atualizacao`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of news_config_sistema
-- ----------------------------
INSERT INTO `news_config_sistema` VALUES ('1', 'S', '7');

-- ----------------------------
-- Table structure for `news_noticias`
-- ----------------------------

CREATE TABLE `news_noticias` (
  `noticia_id` int(11) NOT NULL,
  `categoria_id` int(11) NOT NULL,
  `reporter_id` varchar(10) NOT NULL DEFAULT '',
  `noticia_data_noticia` datetime DEFAULT NULL,
  `noticia_hora_noticia` time DEFAULT NULL,
  `noticia_data_pub` datetime DEFAULT NULL,
  `noticia_hora_pub` time DEFAULT NULL,
  `noticia_titulo` varchar(255) DEFAULT NULL,
  `noticia_corpo` text,
  `noticia_img` longblob,
  `noticia_flag_man_editorial` char(1) DEFAULT NULL,
  PRIMARY KEY (`noticia_id`),
  KEY `FK_Categoria_id` (`categoria_id`),
  KEY `FK_reporter_id` (`reporter_id`),
  CONSTRAINT `news_noticias_ibfk_1` FOREIGN KEY (`categoria_id`) REFERENCES `news_categorias` (`categoria_id`),
  CONSTRAINT `news_noticias_ibfk_2` FOREIGN KEY (`reporter_id`) REFERENCES `news_usuario` (`usuario_login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `news_usuario`
-- ----------------------------

CREATE TABLE `news_usuario` (
  `usuario_login` varchar(10) NOT NULL,
  `usuario_nome` varchar(50) NOT NULL DEFAULT '',
  `usuario_senha` varchar(10) NOT NULL DEFAULT '',
  `usuario_perfil` varchar(10) NOT NULL DEFAULT '',
  `usuario_email` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`usuario_login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of news_usuario
-- ----------------------------
INSERT INTO `news_usuario` VALUES ('editor', 'News editor', '123456', 'editor', 'wiliam@bonner.com');
INSERT INTO `news_usuario` VALUES ('reporter', 'John Albert', '123456', 'reporter', 'francisco@jose.com.br');
INSERT INTO `news_usuario` VALUES ('somebody', 'John Doe', '123456', 'user', 'somebody@something.com');

-- ----------------------------
-- Table structure for `news_usuarios_categorias`
-- ----------------------------

CREATE TABLE `news_usuarios_categorias` (
  `usuario_login` varchar(10) NOT NULL,
  `categoria_id` int(11) NOT NULL,
  PRIMARY KEY (`usuario_login`,`categoria_id`),
  KEY `categoria_id` (`categoria_id`),
  CONSTRAINT `news_usuarios_categorias_ibfk_1` FOREIGN KEY (`usuario_login`) REFERENCES `news_usuario` (`usuario_login`),
  CONSTRAINT `news_usuarios_categorias_ibfk_2` FOREIGN KEY (`categoria_id`) REFERENCES `news_categorias` (`categoria_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of news_usuarios_categorias
-- ----------------------------
INSERT INTO `news_usuarios_categorias` VALUES ('editor', '1');
INSERT INTO `news_usuarios_categorias` VALUES ('editor', '2');
INSERT INTO `news_usuarios_categorias` VALUES ('editor', '3');
INSERT INTO `news_usuarios_categorias` VALUES ('editor', '4');
INSERT INTO `news_usuarios_categorias` VALUES ('reporter', '1');
INSERT INTO `news_usuarios_categorias` VALUES ('reporter', '2');
INSERT INTO `news_usuarios_categorias` VALUES ('reporter', '3');
INSERT INTO `news_usuarios_categorias` VALUES ('reporter', '4');
INSERT INTO `news_usuarios_categorias` VALUES ('somebody', '3');
INSERT INTO `news_usuarios_categorias` VALUES ('somebody', '4');
