<?php

declare(strict_types=1);

namespace Money;

use InvalidArgumentException;

/**
 * This is a generated file. Do not edit it manually!
 *
 * @method static Money AED(numeric-string|int $amount)
 * @method static Money ALL(numeric-string|int $amount)
 * @method static Money AMD(numeric-string|int $amount)
 * @method static Money ANG(numeric-string|int $amount)
 * @method static Money AOA(numeric-string|int $amount)
 * @method static Money ARS(numeric-string|int $amount)
 * @method static Money AUD(numeric-string|int $amount)
 * @method static Money AWG(numeric-string|int $amount)
 * @method static Money AZN(numeric-string|int $amount)
 * @method static Money BAM(numeric-string|int $amount)
 * @method static Money BBD(numeric-string|int $amount)
 * @method static Money BDT(numeric-string|int $amount)
 * @method static Money BGN(numeric-string|int $amount)
 * @method static Money BHD(numeric-string|int $amount)
 * @method static Money BIF(numeric-string|int $amount)
 * @method static Money BMD(numeric-string|int $amount)
 * @method static Money BND(numeric-string|int $amount)
 * @method static Money BOB(numeric-string|int $amount)
 * @method static Money BOV(numeric-string|int $amount)
 * @method static Money BRL(numeric-string|int $amount)
 * @method static Money BSD(numeric-string|int $amount)
 * @method static Money BTN(numeric-string|int $amount)
 * @method static Money BWP(numeric-string|int $amount)
 * @method static Money BYN(numeric-string|int $amount)
 * @method static Money BZD(numeric-string|int $amount)
 * @method static Money CAD(numeric-string|int $amount)
 * @method static Money CDF(numeric-string|int $amount)
 * @method static Money CHE(numeric-string|int $amount)
 * @method static Money CHF(numeric-string|int $amount)
 * @method static Money CHW(numeric-string|int $amount)
 * @method static Money CLF(numeric-string|int $amount)
 * @method static Money CLP(numeric-string|int $amount)
 * @method static Money CNY(numeric-string|int $amount)
 * @method static Money COP(numeric-string|int $amount)
 * @method static Money COU(numeric-string|int $amount)
 * @method static Money CRC(numeric-string|int $amount)
 * @method static Money CUC(numeric-string|int $amount)
 * @method static Money CUP(numeric-string|int $amount)
 * @method static Money CVE(numeric-string|int $amount)
 * @method static Money CZK(numeric-string|int $amount)
 * @method static Money DJF(numeric-string|int $amount)
 * @method static Money DKK(numeric-string|int $amount)
 * @method static Money DOP(numeric-string|int $amount)
 * @method static Money DZD(numeric-string|int $amount)
 * @method static Money EGP(numeric-string|int $amount)
 * @method static Money ERN(numeric-string|int $amount)
 * @method static Money ETB(numeric-string|int $amount)
 * @method static Money EUR(numeric-string|int $amount)
 * @method static Money FJD(numeric-string|int $amount)
 * @method static Money FKP(numeric-string|int $amount)
 * @method static Money GBP(numeric-string|int $amount)
 * @method static Money GEL(numeric-string|int $amount)
 * @method static Money GHS(numeric-string|int $amount)
 * @method static Money GIP(numeric-string|int $amount)
 * @method static Money GMD(numeric-string|int $amount)
 * @method static Money GNF(numeric-string|int $amount)
 * @method static Money GTQ(numeric-string|int $amount)
 * @method static Money GYD(numeric-string|int $amount)
 * @method static Money HKD(numeric-string|int $amount)
 * @method static Money HNL(numeric-string|int $amount)
 * @method static Money HRK(numeric-string|int $amount)
 * @method static Money HTG(numeric-string|int $amount)
 * @method static Money HUF(numeric-string|int $amount)
 * @method static Money IDR(numeric-string|int $amount)
 * @method static Money ILS(numeric-string|int $amount)
 * @method static Money INR(numeric-string|int $amount)
 * @method static Money IQD(numeric-string|int $amount)
 * @method static Money IRR(numeric-string|int $amount)
 * @method static Money ISK(numeric-string|int $amount)
 * @method static Money JMD(numeric-string|int $amount)
 * @method static Money JOD(numeric-string|int $amount)
 * @method static Money JPY(numeric-string|int $amount)
 * @method static Money KES(numeric-string|int $amount)
 * @method static Money KGS(numeric-string|int $amount)
 * @method static Money KHR(numeric-string|int $amount)
 * @method static Money KMF(numeric-string|int $amount)
 * @method static Money KPW(numeric-string|int $amount)
 * @method static Money KRW(numeric-string|int $amount)
 * @method static Money KWD(numeric-string|int $amount)
 * @method static Money KYD(numeric-string|int $amount)
 * @method static Money KZT(numeric-string|int $amount)
 * @method static Money LAK(numeric-string|int $amount)
 * @method static Money LBP(numeric-string|int $amount)
 * @method static Money LKR(numeric-string|int $amount)
 * @method static Money LRD(numeric-string|int $amount)
 * @method static Money LSL(numeric-string|int $amount)
 * @method static Money LYD(numeric-string|int $amount)
 * @method static Money MAD(numeric-string|int $amount)
 * @method static Money MDL(numeric-string|int $amount)
 * @method static Money MGA(numeric-string|int $amount)
 * @method static Money MKD(numeric-string|int $amount)
 * @method static Money MMK(numeric-string|int $amount)
 * @method static Money MNT(numeric-string|int $amount)
 * @method static Money MOP(numeric-string|int $amount)
 * @method static Money MRU(numeric-string|int $amount)
 * @method static Money MUR(numeric-string|int $amount)
 * @method static Money MVR(numeric-string|int $amount)
 * @method static Money MWK(numeric-string|int $amount)
 * @method static Money MXN(numeric-string|int $amount)
 * @method static Money MXV(numeric-string|int $amount)
 * @method static Money MYR(numeric-string|int $amount)
 * @method static Money MZN(numeric-string|int $amount)
 * @method static Money NAD(numeric-string|int $amount)
 * @method static Money NGN(numeric-string|int $amount)
 * @method static Money NIO(numeric-string|int $amount)
 * @method static Money NOK(numeric-string|int $amount)
 * @method static Money NPR(numeric-string|int $amount)
 * @method static Money NZD(numeric-string|int $amount)
 * @method static Money OMR(numeric-string|int $amount)
 * @method static Money PAB(numeric-string|int $amount)
 * @method static Money PEN(numeric-string|int $amount)
 * @method static Money PGK(numeric-string|int $amount)
 * @method static Money PHP(numeric-string|int $amount)
 * @method static Money PKR(numeric-string|int $amount)
 * @method static Money PLN(numeric-string|int $amount)
 * @method static Money PYG(numeric-string|int $amount)
 * @method static Money QAR(numeric-string|int $amount)
 * @method static Money RON(numeric-string|int $amount)
 * @method static Money RSD(numeric-string|int $amount)
 * @method static Money RUB(numeric-string|int $amount)
 * @method static Money RWF(numeric-string|int $amount)
 * @method static Money SAR(numeric-string|int $amount)
 * @method static Money SBD(numeric-string|int $amount)
 * @method static Money SCR(numeric-string|int $amount)
 * @method static Money SDG(numeric-string|int $amount)
 * @method static Money SEK(numeric-string|int $amount)
 * @method static Money SGD(numeric-string|int $amount)
 * @method static Money SHP(numeric-string|int $amount)
 * @method static Money SLL(numeric-string|int $amount)
 * @method static Money SOS(numeric-string|int $amount)
 * @method static Money SRD(numeric-string|int $amount)
 * @method static Money SSP(numeric-string|int $amount)
 * @method static Money STN(numeric-string|int $amount)
 * @method static Money SVC(numeric-string|int $amount)
 * @method static Money SYP(numeric-string|int $amount)
 * @method static Money SZL(numeric-string|int $amount)
 * @method static Money THB(numeric-string|int $amount)
 * @method static Money TJS(numeric-string|int $amount)
 * @method static Money TMT(numeric-string|int $amount)
 * @method static Money TND(numeric-string|int $amount)
 * @method static Money TOP(numeric-string|int $amount)
 * @method static Money TRY(numeric-string|int $amount)
 * @method static Money TTD(numeric-string|int $amount)
 * @method static Money TWD(numeric-string|int $amount)
 * @method static Money TZS(numeric-string|int $amount)
 * @method static Money UAH(numeric-string|int $amount)
 * @method static Money UGX(numeric-string|int $amount)
 * @method static Money USD(numeric-string|int $amount)
 * @method static Money USN(numeric-string|int $amount)
 * @method static Money UYI(numeric-string|int $amount)
 * @method static Money UYU(numeric-string|int $amount)
 * @method static Money UYW(numeric-string|int $amount)
 * @method static Money UZS(numeric-string|int $amount)
 * @method static Money VES(numeric-string|int $amount)
 * @method static Money VND(numeric-string|int $amount)
 * @method static Money VUV(numeric-string|int $amount)
 * @method static Money WST(numeric-string|int $amount)
 * @method static Money XAF(numeric-string|int $amount)
 * @method static Money XAG(numeric-string|int $amount)
 * @method static Money XAU(numeric-string|int $amount)
 * @method static Money XBA(numeric-string|int $amount)
 * @method static Money XBB(numeric-string|int $amount)
 * @method static Money XBC(numeric-string|int $amount)
 * @method static Money XBD(numeric-string|int $amount)
 * @method static Money XBT(numeric-string|int $amount)
 * @method static Money XCD(numeric-string|int $amount)
 * @method static Money XDR(numeric-string|int $amount)
 * @method static Money XOF(numeric-string|int $amount)
 * @method static Money XPD(numeric-string|int $amount)
 * @method static Money XPF(numeric-string|int $amount)
 * @method static Money XPT(numeric-string|int $amount)
 * @method static Money XSU(numeric-string|int $amount)
 * @method static Money XTS(numeric-string|int $amount)
 * @method static Money XUA(numeric-string|int $amount)
 * @method static Money XXX(numeric-string|int $amount)
 * @method static Money YER(numeric-string|int $amount)
 * @method static Money ZAR(numeric-string|int $amount)
 * @method static Money ZMW(numeric-string|int $amount)
 * @method static Money ZWL(numeric-string|int $amount)
 * @psalm-immutable
 */
trait MoneyFactory
{
    /**
     * Convenience factory method for a Money object.
     *
     * <code>
     * $fiveDollar = Money::USD(500);
     * </code>
     *
     * @param array $arguments
     * @psalm-param non-empty-string          $method
     * @psalm-param array{numeric-string|int} $arguments
     *
     * @throws InvalidArgumentException If amount is not integer(ish).
     *
     * @psalm-pure
     */
    public static function __callStatic(string $method, array $arguments): Money
    {
        return new Money($arguments[0], new Currency($method));
    }
}
