<?php

/* Classes ancestrais */
nm_load_class('page', 'Page');

/* Definicao da classe */

class nmPagePreUpdate extends nmPage
{
    function __construct()
    {
        $this->doAjax();
        $this->SetBody('nmPage');
        $this->SetMargin(10);
        $this->SetPage('PreUpdate');
        $this->CheckLogin();
        $this->SetPageSubtitle('');
        $this->Display();
    }
    function doAjax(){
        if (isset($_POST['ajax']) && $_POST['ajax'] == 'nm') {
            $str_return = "";
            switch ($_POST['nm_action']) {
                 case 'service':
                    $str_return = $this->checkProdService();
                    break;
                default:
                    break;
            }
            echo $str_return;
            exit;
        }
    }
    function checkProdService(){
        $dir        = dirname(__DIR__, 5);
        $url = "webservice.scriptcase.com.br";
        if (file_exists($dir . '/is_dev')) {
            $url = "webservices-dev.scriptcase.info";
        }
        $endpoint   = "http://{$url}/prodservicev9/nm_prod_service_v9.php";
        $curl       = curl_init();
        curl_setopt_array($curl, [CURLOPT_URL => $endpoint,CURLOPT_RETURNTRANSFER => true,CURLOPT_CUSTOMREQUEST => 'GET', CURLOPT_TIMEOUT => 60]);
        curl_exec($curl);
        $httpCode   = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        return json_encode(['success' => $httpCode === 200]);
    }
    function DisplayContent()
    {
        global $nm_template, $nm_lang;
        $nm_template->Display('body_pre_update');
    }
    function PageJavascript()
    {
        global $nm_config, $scSuffixUrl, $nm_lang;
        $endpoint     = $nm_config['url_lib'].$scSuffixUrl.'pre_update.php';
        $errorMessage = $nm_lang['pre_update_service_error'];
        $str_js=<<<JS
            function goToUpdate(){
                $.ajax({
                    method: 'POST',
                    url: '{$endpoint}',
                    data: {
                        ajax: 'nm',
                        nm_action: 'service',
                    },
                    beforeSend: function(jqXHR){
                        $("#id_button_pre_update").addClass("disabled");
                        $("#id_button_pre_update").hide();
                        $("#info-message").show();
                    },
                    success: function (data) {
                        let response = JSON.parse(data);
                        if(response.success){
                            parent.nm_set_option('update', '', 'nm_iframe');
                        }else{
                            parent.show_update_modal('{$errorMessage}','error','');
                            $("#info-message").hide();
                            $("#id_button_pre_update").removeClass("disabled");
                            $("#id_button_pre_update").show();
                        }
                    }
                });
            }
JS;
            $this->AddJavascript($str_js);
    }
    function PageJs()
    {
        $this->AddJs('third', 'jquery/js/jquery.js');
        $this->AddJs('third', 'jquery/js/jquery-ui.js');
        $this->AddJs('third', 'semantic-ui/semantic.min.js');
    }
    function PageStyle(){
        $str_style=<<<CSS
            #info-message{ display:none }
CSS;
        $this->AddStyle($str_style);
    }
    function PageStyleCss()
    {
        $this->AddStyleCss('third', 'semantic-ui/semantic.min.css');
        $this->AddStyleCss('third', 'font-awesome/6/css/all.min.css');
    }
}