<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.4.1
*/namespace
Adminer;const
VERSION="5.4.1";error_reporting(24575);set_error_handler(function($Ec,$Gc){return!!preg_match('~^Undefined (array key|offset|index)~',$Gc);},E_WARNING|E_NOTICE);$cd=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($cd||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$xj=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($xj)$$X=$xj;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($h=null){return($h?:Db::$instance);}function
adminer(){return
Adminer::$instance;}function
driver(){return
Driver::$instance;}function
connect(){$Hb=adminer()->credentials();$J=Driver::connect($Hb[0],$Hb[1],$Hb[2]);return(is_object($J)?$J:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$Le=substr($v,-1);return
str_replace($Le.$Le,$Le,substr($v,1,-1));}function
q($Q){return
connection()->quote($Q);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($xa,$y,$l=null){return($xa&&array_key_exists($y,$xa)?$xa[$y]:$l);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$eh,$cd=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($eh)){foreach($X
as$Ce=>$W){unset($eh[$y][$Ce]);if(is_array($W)){$eh[$y][stripslashes($Ce)]=$W;$eh[]=&$eh[$y][stripslashes($Ce)];}else$eh[$y][stripslashes($Ce)]=($cd?$W:stripslashes($W));}}}}function
bracket_escape($v,$Ea=false){static$gj=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Ea?array_flip($gj):$gj));}function
min_version($Pj,$af="",$h=null){$h=connection($h);$Zh=$h->server_info;if($af&&preg_match('~([\d.]+)-MariaDB~',$Zh,$A)){$Zh=$A[1];$Pj=$af;}return$Pj&&version_compare($Zh,$Pj)>=0;}function
charset(Db$g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
ini_bool($me){$X=ini_get($me);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
ini_bytes($me){$X=ini_get($me);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
sid(){static$J;if($J===null)$J=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$J;}function
set_password($Oj,$N,$V,$F){$_SESSION["pwds"][$Oj][$N][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$J=get_session("pwds");if(is_array($J))$J=($_COOKIE["adminer_key"]?decrypt_string($J[0],$_COOKIE["adminer_key"]):false);return$J;}function
get_val($H,$n=0,$vb=null){$vb=connection($vb);$I=$vb->query($H);if(!is_object($I))return
false;$K=$I->fetch_row();return($K?$K[$n]:false);}function
get_vals($H,$d=0){$J=array();$I=connection()->query($H);if(is_object($I)){while($K=$I->fetch_row())$J[]=$K[$d];}return$J;}function
get_key_vals($H,$h=null,$ci=true){$h=connection($h);$J=array();$I=$h->query($H);if(is_object($I)){while($K=$I->fetch_row()){if($ci)$J[$K[0]]=$K[1];else$J[]=$K[0];}}return$J;}function
get_rows($H,$h=null,$m="<p class='error'>"){$vb=connection($h);$J=array();$I=$vb->query($H);if(is_object($I)){while($K=$I->fetch_assoc())$J[]=$K;}elseif(!$I&&!$h&&$m&&(defined('Adminer\PAGE_HEADER')||$m=="-- "))echo$m.error()."\n";return$J;}function
unique_array($K,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$J=array();foreach($w["columns"]as$y){if(!isset($K[$y]))continue
2;$J[$y]=$K[$y];}return$J;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$A))return$A[1].idf_escape(idf_unescape($A[2])).$A[3];return
idf_escape($y);}function
where(array$Z,array$o=array()){$J=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,true);$d=escape_key($y);$n=idx($o,$y,array());$Zc=$n["type"];$J[]=$d.(JUSH=="sql"&&$Zc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="pgsql"&&preg_match('~^json~',$Zc)?"::jsonb = ".q($X)."::jsonb":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Zc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($n,q($X))))));if(JUSH=="sql"&&preg_match('~char|text~',$Zc)&&preg_match("~[^ -@]~",$X))$J[]="$d = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$y)$J[]=escape_key($y)." IS NULL";return
implode(" AND ",$J);}function
where_check($X,array$o=array()){parse_str($X,$Ya);remove_slashes(array(&$Ya));return
where($Ya,$o);}function
where_link($t,$d,$Y,$bg="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$bg:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$e,array$o,array$M=array()){$J="";foreach($e
as$y=>$X){if($M&&!in_array(idf_escape($y),$M))continue;$ya=convert_field($o[$y]);if($ya)$J
.=", $ya AS ".idf_escape($y);}return$J;}function
cookie($B,$Y,$Te=2592000){header("Set-Cookie: $B=".urlencode($Y).($Te?"; expires=".gmdate("D, d M Y H:i:s",time()+$Te)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($Db){parse_str($_COOKIE[$Db],$di);return$di;}function
get_setting($y,$Db="adminer_settings",$l=null){return
idx(get_settings($Db),$y,$l);}function
save_settings(array$di,$Db="adminer_settings"){$Y=http_build_query($di+get_settings($Db));cookie($Db,$Y);$_COOKIE[$Db]=$Y;}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1));}function
stop_session($kd=false){$Gj=ini_bool("session.use_cookies");if(!$Gj||$kd){if($Gj&&@ini_set("session.use_cookies",'0')===false);}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Oj,$N,$V,$k=null){$Cj=remove_from_uri(implode("|",array_keys(SqlDriver::$drivers))."|username|ext|".($k!==null?"db|":"").($Oj=='mssql'||$Oj=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$Cj,$A);return"$A[1]?".(sid()?SID."&":"").($Oj!="server"||$N!=""?urlencode($Oj)."=".urlencode($N)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($A[2]?"&$A[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($We,$pf=null){if($pf!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($We!==null?$We:$_SERVER["REQUEST_URI"]))][]=$pf;}if($We!==null){if($We=="")$We=".";header("Location: $We");exit;}}function
query_redirect($H,$We,$pf,$nh=true,$Lc=true,$Uc=false,$Ti=""){if($Lc){$si=microtime(true);$Uc=!connection()->query($H);$Ti=format_time($si);}$mi=($H?adminer()->messageQuery($H,$Ti,$Uc):"");if($Uc){adminer()->error
.=error().$mi.script("messagesPrint();")."<br>";return
false;}if($nh)redirect($We,$pf.$mi);return
true;}class
Queries{static$queries=array();static$start=0;}function
queries($H){if(!Queries::$start)Queries::$start=microtime(true);Queries::$queries[]=(preg_match('~;$~',$H)?"DELIMITER ;;\n$H;\nDELIMITER ":$H).";";return
connection()->query($H);}function
apply_queries($H,array$T,$Hc='Adminer\table'){foreach($T
as$R){if(!queries("$H ".$Hc($R)))return
false;}return
true;}function
queries_redirect($We,$pf,$nh){$ih=implode("\n",Queries::$queries);$Ti=format_time(Queries::$start);return
query_redirect($ih,$We,$pf,$nh,false,!$nh,$Ti);}function
format_time($si){return
lang(0,max(0,microtime(true)-$si));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($yg=""){return
substr(preg_replace("~(?<=[?&])($yg".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Tb=false,$Zb=""){$bd=$_FILES[$y];if(!$bd)return
null;foreach($bd
as$y=>$X)$bd[$y]=(array)$X;$J='';foreach($bd["error"]as$y=>$m){if($m)return$m;$B=$bd["name"][$y];$bj=$bd["tmp_name"][$y];$_b=file_get_contents($Tb&&preg_match('~\.gz$~',$B)?"compress.zlib://$bj":$bj);if($Tb){$si=substr($_b,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$si))$_b=iconv("utf-16","utf-8",$_b);elseif($si=="\xEF\xBB\xBF")$_b=substr($_b,3);}$J
.=$_b;if($Zb)$J
.=(preg_match("($Zb\\s*\$)",$_b)?"":$Zb)."\n\n";}return$J;}function
upload_error($m){$kf=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(1).($kf?" ".lang(2,$kf):""):lang(3));}function
repeat_pattern($Kg,$Re){return
str_repeat("$Kg{0,65535}",$Re/65535)."$Kg{0,".($Re%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Vc=false){$J=table_status($R,$Vc);return($J?reset($J):array("Name"=>$R));}function
column_foreign_keys($R){$J=array();foreach(adminer()->foreignKeys($R)as$q){foreach($q["source"]as$X)$J[$X][]=$q;}return$J;}function
fields_from_edit(){$J=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$B=bracket_escape($y,true);$J[$B]=array("field"=>$B,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==driver()->primary),);}return$J;}function
dump_headers($Sd,$_f=false){$J=adminer()->dumpHeaders($Sd,$_f);$ug=$_POST["output"];if($ug!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($Sd).".$J".($ug!="file"&&preg_match('~^[0-9a-z]+$~',$ug)?".$ug":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$J;}function
dump_csv(array$K){foreach($K
as$y=>$X){if(preg_match('~["\n,;\t]|^0.|\.\d*0$~',$X)||$X==="")$K[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$K)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$J=ini_get("upload_tmp_dir");if(!$J){if(function_exists('sys_get_temp_dir'))$J=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return'';$J=dirname($p);unlink($p);}}return$J;}function
file_open_lock($p){if(is_link($p))return;$r=@fopen($p,"c+");if(!$r)return;@chmod($p,0660);if(!flock($r,LOCK_EX)){fclose($r);return;}return$r;}function
file_write_unlock($r,$Nb){rewind($r);fwrite($r,$Nb);ftruncate($r,strlen($Nb));file_unlock($r);}function
file_unlock($r){flock($r,LOCK_UN);fclose($r);}function
first(array$xa){return
reset($xa);}function
password_file($i){$p=get_temp_dir()."/adminer.key";if(!$i&&!file_exists($p))return'';$r=file_open_lock($p);if(!$r)return'';$J=stream_get_contents($r);if(!$J){$J=rand_string();file_write_unlock($r,$J);}else
file_unlock($r);return$J;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$_,array$n,$Si){if(is_array($X)){$J="";foreach($X
as$Ce=>$W)$J
.="<tr>".($X!=array_values($X)?"<th>".h($Ce):"")."<td>".select_value($W,$_,$n,$Si);return"<table>$J</table>";}if(!$_)$_=adminer()->selectLink($X,$n);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$J=adminer()->editVal($X,$n);if($J!==null){if(!is_utf8($J))$J="\0";elseif($Si!=""&&is_shortable($n))$J=shorten_utf8($J,max(0,+$Si));else$J=h($J);}return
adminer()->selectVal($J,$_,$n,$X);}function
is_blob(array$n){return
preg_match('~blob|bytea|raw|file~',$n["type"])&&!in_array($n["type"],idx(driver()->structuredTypes(),lang(6),array()));}function
is_mail($vc){$za='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Kg="$za+(\\.$za+)*@($ic?\\.)+$ic";return
is_string($vc)&&preg_match("(^$Kg(,\\s*$Kg)*\$)i",$vc);}function
is_url($Q){$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($ic?\\.)+$ic(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable(array$n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea|hstore~',$n["type"]);}function
host_port($N){return(preg_match('~^(\[(.+)]|([^:]+)):([^:]+)$~',$N,$A)?array($A[2].$A[3],$A[4]):array($N,''));}function
count_rows($R,array$Z,$we,array$yd){$H=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($we&&(JUSH=="sql"||count($yd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$yd).")$H":"SELECT COUNT(*)".($we?" FROM (SELECT 1$H GROUP BY ".implode(", ",$yd).") x":$H));}function
slow_query($H){$k=adminer()->database();$Ui=adminer()->queryTimeout();$hi=driver()->slowQuery($H,$Ui);$h=null;if(!$hi&&support("kill")){$h=connect();if($h&&($k==""||$h->select_db($k))){$Fe=get_val(connection_id(),0,$h);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$Fe&token=".get_token()."'); }, 1000 * $Ui);");}}ob_flush();flush();$J=@get_key_vals(($hi?:$H),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$J;}function
get_token(){$lh=rand(1,1e6);return($lh^$_SESSION["token"]).":$lh";}function
verify_token(){list($cj,$lh)=explode(":",$_POST["token"]);return($lh^$_SESSION["token"])==$cj;}function
lzw_decompress($Ka){$ec=256;$La=8;$ib=array();$yh=0;$zh=0;for($t=0;$t<strlen($Ka);$t++){$yh=($yh<<8)+ord($Ka[$t]);$zh+=8;if($zh>=$La){$zh-=$La;$ib[]=$yh>>$zh;$yh&=(1<<$zh)-1;$ec++;if($ec>>$La)$La++;}}$dc=range("\0","\xFF");$J="";$Yj="";foreach($ib
as$t=>$hb){$uc=$dc[$hb];if(!isset($uc))$uc=$Yj.$Yj[0];$J
.=$uc;if($t)$dc[]=$Yj.$uc[0];$Yj=$uc;}return$J;}function
script($ji,$fj="\n"){return"<script".nonce().">$ji</script>$fj";}function
script_src($Dj,$Wb=false){return"<script src='".h($Dj)."'".nonce().($Wb?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($B,$Y=""){return"<input type='hidden' name='".h($B)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($B,$Y,$bb,$He="",$ag="",$fb="",$Je=""){$J="<input type='checkbox' name='$B' value='".h($Y)."'".($bb?" checked":"").($Je?" aria-labelledby='$Je'":"").">".($ag?script("qsl('input').onclick = function () { $ag };",""):"");return($He!=""||$fb?"<label".($fb?" class='$fb'":"").">$J".h($He)."</label>":$J);}function
optionlist($fg,$Rh=null,$Hj=false){$J="";foreach($fg
as$Ce=>$W){$gg=array($Ce=>$W);if(is_array($W)){$J
.='<optgroup label="'.h($Ce).'">';$gg=$W;}foreach($gg
as$y=>$X)$J
.='<option'.($Hj||is_string($y)?' value="'.h($y).'"':'').($Rh!==null&&($Hj||is_string($y)?(string)$y:$X)===$Rh?' selected':'').'>'.h($X);if(is_array($W))$J
.='</optgroup>';}return$J;}function
html_select($B,array$fg,$Y="",$Zf="",$Je=""){static$He=0;$Ie="";if(!$Je&&substr($fg[""],0,1)=="("){$He++;$Je="label-$He";$Ie="<option value='' id='$Je'>".h($fg[""]);unset($fg[""]);}return"<select name='".h($B)."'".($Je?" aria-labelledby='$Je'":"").">".$Ie.optionlist($fg,$Y)."</select>".($Zf?script("qsl('select').onchange = function () { $Zf };",""):"");}function
html_radios($B,array$fg,$Y="",$Vh=""){$J="";foreach($fg
as$y=>$X)$J
.="<label><input type='radio' name='".h($B)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>$Vh";return$J;}function
confirm($pf="",$Sh="qsl('input')"){return
script("$Sh.onclick = () => confirm('".($pf?js_escape($pf):lang(7))."');","");}function
print_fieldset($u,$Qe,$Sj=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$Qe</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($Sj?"":" class='hidden'").">\n";}function
bold($Na,$fb=""){return($Na?" class='active $fb'":($fb?" class='$fb'":""));}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
pagination($D,$Kb){return" ".($D==$Kb?$D+1:'<a href="'.h(remove_from_uri("page").($D?"&page=$D".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($D+1)."</a>");}function
hidden_fields(array$eh,array$Wd=array(),$Wg=''){$J=false;foreach($eh
as$y=>$X){if(!in_array($y,$Wd)){if(is_array($X))hidden_fields($X,array(),$y);else{$J=true;echo
input_hidden(($Wg?$Wg."[$y]":$y),$X);}}}return$J;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
file_input($oe){$ff="max_file_uploads";$gf=ini_get($ff);$Aj="upload_max_filesize";$Bj=ini_get($Aj);return(ini_bool("file_uploads")?$oe.script("qsl('input[type=\"file\"]').onchange = partialArg(fileChange, "."$gf, '".lang(8,"$ff = $gf")."', ".ini_bytes("upload_max_filesize").", '".lang(8,"$Aj = $Bj")."')"):lang(9));}function
enum_input($U,$_a,array$n,$Y,$yc=""){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$df);$Wg=($n["type"]=="enum"?"val-":"");$bb=(is_array($Y)?in_array("null",$Y):$Y===null);$J=($n["null"]&&$Wg?"<label><input type='$U'$_a value='null'".($bb?" checked":"")."><i>$yc</i></label>":"");foreach($df[1]as$X){$X=stripcslashes(str_replace("''","'",$X));$bb=(is_array($Y)?in_array($Wg.$X,$Y):$Y===$X);$J
.=" <label><input type='$U'$_a value='".h($Wg.$X)."'".($bb?' checked':'').'>'.h(adminer()->editVal($X,$n)).'</label>';}return$J;}function
input(array$n,$Y,$s,$Da=false){$B=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Y=json_encode($Y,128|64|256);$s="json";}$xh=(JUSH=="mssql"&&$n["auto_increment"]);if($xh&&!$_POST["save"])$s=null;$td=(isset($_GET["select"])||$xh?array("orig"=>lang(10)):array())+adminer()->editFunctions($n);$Dc=driver()->enumLength($n);if($Dc){$n["type"]="enum";$n["length"]=$Dc;}$fc=stripos($n["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$_a=" name='fields[$B]".($n["type"]=="enum"||$n["type"]=="set"?"[]":"")."'$fc".($Da?" autofocus":"");echo
driver()->unconvertFunction($n)." ";$R=$_GET["edit"]?:$_GET["select"];if($n["type"]=="enum")echo
h($td[""])."<td>".adminer()->editInput($R,$n,$_a,$Y);else{$Fd=(in_array($s,$td)||isset($td[$s]));echo(count($td)>1?"<select name='function[$B]'$fc>".optionlist($td,$s===null||$Fd?$s:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($td))).'<td>';$oe=adminer()->editInput($R,$n,$_a,$Y);if($oe!="")echo$oe;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$_a value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$_a value='1'>";elseif($n["type"]=="set")echo
enum_input("checkbox",$_a,$n,(is_string($Y)?explode(",",$Y):$Y));elseif(is_blob($n)&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$B'>";elseif($s=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$_a cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($Qi=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($Qi&&JUSH!="sqlite")$_a
.=" cols='50' rows='12'";else{$L=min(12,substr_count($Y,"\n")+1);$_a
.=" cols='30' rows='$L'";}echo"<textarea$_a>".h($Y).'</textarea>';}else{$rj=driver()->types();$mf=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$A)?((preg_match("~binary~",$n["type"])?2:1)*$A[1]+($A[3]?1:0)+($A[2]&&!$n["unsigned"]?1:0)):($rj[$n["type"]]?$rj[$n["type"]]+($n["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$mf+=7;echo"<input".((!$Fd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($mf?" data-maxlength='$mf'":"").(preg_match('~char|binary~',$n["type"])&&$mf>20?" size='".($mf>99?60:40)."'":"")."$_a>";}echo
adminer()->editHint($R,$n,$Y);$dd=0;foreach($td
as$y=>$X){if($y===""||!$X)break;$dd++;}if($dd&&count($td)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $dd);");}}function
process_input(array$n){if(stripos($n["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($n["field"]);$s=idx($_POST["function"],$v);$Y=idx($_POST["fields"],$v);if($n["type"]=="enum"||driver()->enumLength($n)){$Y=$Y[0];if($Y=="orig")return
false;if($Y=="null")return"NULL";$Y=substr($Y,4);}if($n["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($s=="NULL")return"NULL";if($n["type"]=="set")$Y=implode(",",(array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(is_blob($n)&&ini_bool("file_uploads")){$bd=get_file("fields-$v");if(!is_string($bd))return
false;return
driver()->quoteBinary($bd);}return
adminer()->processInput($n,$Y,$s);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$Uh="<ul>\n";foreach(table_status('',true)as$R=>$S){$B=adminer()->tableName($S);if(isset($S["Engine"])&&$B!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$I=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$I||$I->fetch_row()){$ah="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$B</a>";echo"$Uh<li>".($I?$ah:"<p class='error'>$ah: ".error())."\n";$Uh="";}}}echo($Uh?"<p class='message'>".lang(11):"</ul>")."\n";}function
on_help($ob,$fi=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $ob, $fi) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$o,$K,$_j,$m=''){$Di=adminer()->tableName(table_status1($R,true));page_header(($_j?lang(12):lang(13)),$m,array("select"=>array($R,$Di)),$Di);adminer()->editRowPrint($R,$o,$K,$_j);if($K===false){echo"<p class='error'>".lang(14)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$o)echo"<p class='error'>".lang(15)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$Da=!$_POST;foreach($o
as$B=>$n){echo"<tr><th>".adminer()->fieldName($n);$l=idx($_GET["set"],bracket_escape($B));if($l===null){$l=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$l,$uh))$l=$uh[1];if(JUSH=="sql"&&preg_match('~binary~',$n["type"]))$l=bin2hex($l);}$Y=($K!==null?($K[$B]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$n["type"])&&is_array($K[$B])?implode(",",$K[$B]):(is_bool($K[$B])?+$K[$B]:$K[$B])):(!$_j&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$l)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$n);$s=($_POST["save"]?idx($_POST["function"],$B,""):($_j&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$_j&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}if($n["type"]=="uuid"&&$Y=="uuid()"){$Y="";$s="uuid";}if($Da!==false)$Da=($n["auto_increment"]||$s=="now"||$s=="uuid"?null:true);input($n,$Y,$s,$Da);if($Da)$Da=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(16)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($_j?lang(17):lang(18))."' title='Ctrl+Shift+Enter'>\n",($_j?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(19)."…', this); };"):"");}echo($_j?"<input type='submit' name='delete' value='".lang(20)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($Q,$Re=80,$yi=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Re).")($)?)u",$Q,$A))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Re).")($)?)",$Q,$A);return
h($A[1]).$yi.(isset($A[2])?"":"<i>…</i>");}function
icon($Rd,$B,$Qd,$Wi){return"<button type='submit' name='$B' title='".h($Wi)."' class='icon icon-$Rd'><span>$Qd</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}@ini_set("zlib.output_compression",'1');if($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgб\"PimcQCa	2ód<fa:;NBqR;1Lf9u7&)l;3J/CQXr2Mai0)e:LuÝh-923li7mZw4њ<-̴!U,Févt2S,a҇FVXaNq)-ǜh:n59Y;j-_9krٓ;.tTqo0{y\rHnGSZh;i^uxWΒC@k=b/A0+(l\\x:\rb8\00!\0F\nB͎(3\r\\Ȅa'I|(i\n\r4Og@4C@@!QB	°c¯q,\r1Eh&2PZiGH9G\"v4rDR\npJ-A|/.cDu:,=R]U5mVkLLQ@-\\@9%SrMPDIa\r(YY\\@Xp:plLC O,\r2]7?m06pTaҥC;_˗yȴd>bnnܣ3X8\r[ˀ-)i>V[Yy&L3#X|	X\\ù`C#H22.#Z`<sÒ\0uh־M_\niZeO/CӒ_`31>=k3R/;/d\0ڵm7/AXq.sL :\$Fw8߾~Hj\"Գ7gSFLίQ_O'W]c=51X~7;i\r*\nJS1ZctAV86fdy;Y]zIpc3Y]}@\$.+1'>ZcpdGL#k8PzYAuv]s9_Aq:\nKhB;XbAHq,CI`jS[ˌ1Vr;pB)#鐉;4H/*<3L;lf\ns\$K`}Ք7jx`d%j]4YHbYJ`GG.KfI)2MfָXRC̱V,~g\0g6:[j1H:AlIqu3\"q|8<9s'Q]J|\0`pjfObq\$1J>RH(ǔq\n#r@e(yVJ0Q҈6P[C:G伞4^PZ\\(\n)~9R%Sj{70_s	z|8H	\"@#9DVL\$H5WJ@zaJ ^	)2\nQv]j (ABB056b˰][kAwvkgƴ+k[jmzc}MyDZi\$5eʷ	ACY%.Wb*뮼.q/%}BXZV337ʻawW[LQ޲_2`1Ii,曣Mf&(s-Aİ*DwTNɻjX\$x+;F93JkS;qR{>l;B1AIb)(6r\r\rڇZR^SOy/M#9{kv\"KCJrEo\0\\,|fa͚hI/o4k^p1H^phǡVvox@`g&(;~Ǎz68*5EpӘ3ņgrDL)4g{峩L&>脻Z7\0̊@ffRVh֝Iۈrw)=x^,k2ݓjbl0u\"fp1RIz[]wpN6dIzn.7X{;3-I	7pjÝR#,_-[>3\\WqqJ֘uhFbLKyVľѕVf{K}SޝM̀.M\\ixb1+α?<3~H\$\\2\$ e6tÖ\$sxxCnSkV=z6'æNaָhR噣8gw:_ҒIRKÝ.nkVU+dwj%`#,{醳Y(oվ.c0gDXOk7Klhx;؏ ݃L\$09*9 hNrM.>\0rP9\$g	\0\$\\F*d'L:b429@Hnb-E #ĜrPY t \n5.\$oplX\n@`\r	\r  	 	@@\n  	\0j@Q@1\r@ 	\$p	 V\0``\n\0\n \n@'\n\0`\r	\r\0r	\0`	{	,\"^P0\n4\n0.0p\rp\rppqQ0%1Q8\n \0kȼ\0^\0`@>\no1w,Y	h*=P:іVи.q\r\rp1Q	1 `/17\r^\"y`\n #\0	 p\n\n` r Qb13\n##1\$q\$ѱ%0%q%&&q &'1\rR}16	 @b\r``\r	d	j\n``\n`dcсP,1R\$rIO 	Q	Y32b1&01  f\0\0f\0j\nf`	 \n`@\$n=`\0v nI\$P(d'g6--C7R 	4-1&2t\r\"\n 	H*@	`\n  	l2,z\r~ \rFthmz~\0]GF\\I\\}ItC\nT}IEJ\rx>MpIH~fht.bxYEiKoj\nLtr.~dH2U4G\\A4uPt谐L/P	\"G!RMtO-<#APuIR\$cDƊ-GO`Pv^W@tH;QRę\$gKF<\rR*\$4'[IUmh:+5@/lI2^\0OD\rR'\rTЭ[ĪMCMZ4E B\"`euN,䙬]t\r`@h*\r.V%!MBlPF\"&/@v\\C:mMgni8I2\rpvj+Z mTuefv>fИ`DU[ZTVCT\rUvk^Lb/KSev2ubvOVDIm\$%X?ud!W|,\r+cnUeZʖ-~XBGd\$iMv!t#L3oUIOu?ZweRcw.`ȡi\rb%bH\"\"\"h_\$b@z\0f\"rW*B|\$\$Bנ\"@r(\r` C(0&.`Nk9B\n&#(@䂯d^ @`I-{0\nB{4sG{;zb{ {bׯ){BxKŇ5=cڪy&JPrI/ \0V\r׉=N\\ئ=K}XVxإˋxdՊی*H'δ{X==\08\0[ɫJtOeɋ\rDXŇ}z)y''яI([l(5`f\\`e.lY(=zה!Y%hO+`ٙ\"e ėKߚ#SEIY.HJtG`HJ55~ 6ChXDz\nxyshFKczjZY8(%|yIߑ؃eYXu i]cM;ȧ>ǡQT [~W~c݂zz\r:  \0rYx)!ɡK+z!ӀC+ٮï:ݎZg~z4f	:sӪ+x%=GIf3?+Yq@GyoѴp\r~{W[y:\0\\;eۡYI\"zdkZ|[uu+׹9qnR ˮBׁz|\rᤄk^[1%.pA2<=ء\$;5)m!XXYx5vT\\Q%:>ɛ;e|/yWxנ|gC\\<9z\\#.FV;8NX7\"8&d5P4Gj?\0?\"=HER");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgh0LЁd91S!	F!\"-6NbdGg:;Nr)c7\r(Hb81s9k\rc)m8OVAc1c34Of*-P1r416d2ցo#3Bf#	g9Φ،fc\rIb6EC&,bum7aVs#m!hrv\\3\rL:SAdk5naF3e6fSyr!L-K,3L@J˲*J쵣	bc99@H8\\6>`Ŏ;A<T'p&qqE4\rlh<5#pR #I%fBIܲ>ʫ29<Cj27j8jc(n?(a\0@5*3:δ60-AlLP4@ɰ\$H4n311t0͙9WO!rH9Q96F<7\r-xC\n @:\$iضm4Kid{\n6\rxhˋ#^'4V@a<#h0S-c9+pa2cyhBO\$9wiXɔVY9*rHtm	@b|@/l\$z+%p2l.7;&{mXC<l96x9m7R0\\4P)AoxqO#f[;6~P\raTGT0uޟ\n3\\ \\ʎJudCGPZ>d8ҨC?VdLL.(ti>,֜R+9iޞC\$#\"AChVb\n6T2ew\nf6m	!1'c;*eLRn\rG\$2S\$0a'l6&~Ad\$J\$s ȃB4j.RC̔Qj\"7\nXs!6=BȀ}");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':̢i11	4Q6a&:OAIe:NFD|!Cym2\"r<̱/C#:DbqSeJ˦Cܺ\n\nǱS\rZH\$RAܞS+XKvtdg:6EvXŞjmҩej2MB&ʮLC3Q0L-x\nDyNaPn:s͐(cL/(5{Qy4g-i4ڃf(bUko7&ä*ACb`.\r\nCh<\r)`إ`7CʒZX<Q1X@0dp9EQfF\r!(h)\np'#ČH(i*r&<#7K~# A:N6l,\rJP3!@2>CrhN](a0M326UE2'!<#3R<XCH7#n+a\$!2P0.wdr:YE!]<j@\\pl_\rZғTͩZs3\"~9jP)QYbݕDYc`zcѨ'#tBOh*2<ŒOfg-Z#8a^+r2b\\~0Wnp!#`Z612@ky9\rB3pޅ6<!pG9no6s#F3bA69Z#6%?s\"|؂)bJc\rNsih8ݟ:;HތuI5@1APaH^\$Hv@ÛL~b9'S?P-0C\nRm4ȓ:Ը24h(k\njI6\"EY#Wr\rG8@tXԓBS\nc0kC I\rʰ<u`A!)2C\0= P1ӢK!!pIs,6di1+k<^	\n20Fԉ_\$)f\0C8E^/3W!א)u*&\$2Y\n]EkDV\$JxTse!RY R`=Lޫ\nl_.!V!\r\nHk\$א`{1	|i<jRrPTG|w4b\r4d,E6<h[Nq@Oi>'ѩ\r;]#}0ASIJdA/Q⸵@t\rUG_G<<y-Iz򄤝\"PB\0q`vAa̡JRʮ)JB.TLyCpp\0(7cYYaM1em4crS)opC!ISb0m(dEH߳X/PyX85\$+֖gdyϝJ lEur,dCX}em]2̽(-zZ;I\\) ,\n>)\rVS\njx*w`ⴷSFid,ZJFM}Њ \\ZP`zZE]dɟOcmԁ] %\"w4\n\$zVSQD:6GwMS0B-s)Zc|^RE8kMsdka)h%\"P0nn/#;g\rd8F<3\$,P);<4`<2\n@w-͗A0LrYhXCa>tL2yto;2Qtfrm:AAN\\\"k5oVɃ=t7r1pAv\\+9{^(if=rut]yޅCgivf+Ø|;]~|\re쿓݂'	\0+Wcow6wd Suj3@0!\n .wm[8x<cM\n9'a1>[dux<\"YcB!iw}5Uk]{IךR=f W~](bea'ubm>)\$P-6R*IGu#ƕUKAXt(`_\"p &UI]YG6P]Ar!b *ЙJoӯv*!~_4B_~RBiK`&J\0N\0\$CK SjZ0pvMJbN`Le/`RO.0P82`	d GxbP-(@ɸ@4H%<&Zp%\0pЄ		/\"J\ns_\rg`!kpX	:v6p\$'RUeZd\$\nLB.dntm>vj)	M\r\0.ʊH\"5*!eZJf(dc(xjg\0\\ Z@|`^r)<()@Ykml3Qyс@ѐfPnTNmRqVmvN֍|ШZȆ(Yp\"4Ǩ&%lP`ĀXx bbdr0Fr5<Cz6he!\rdzK;t\n͠HƋQ\$QEnnn\r#T\$ˈ(ȟѩ|c,-#\rJ{dE\n\$BriT+2PEDBe}&%Rf\n^CZZ RVA,;<\0O1c^\r%\r `n\0y1.\rĂK1M3H\r\"0\0NkXPr{3 }	\nSdڗx.ZRTwS;53 .s4sO3F2S~YFpZs'@ّOqR4\n6q6@Dh67vEl\"^;-(&b**.! \r!#x'G\"͆w\" 2!\"R(vX|\"Dv)@,zmAwT@  \nЫhдIDP\$m>\r&`>4A#*#<w\$T{\$4@dӴRem6-#Dd%EDT\\\$)@WC(t\"M#@TF\r,g\rP8~֣JcĹƂ ʎ\"LZ\r+P4=STA)0\"CDhM\n%Fp|fLNlFtDmH5=H\nļ4\$K6\rbZ\r\"pEQ%wJV0M%l\"hPFAA㌮/G6h6]5\$fSCLiRT?RCHUZYbF/.Z\"\"^y6RG n܌\$\\&O(v^ KUѮam(\r\$_%+KTt.ٖ36\nc:@6 jPAQF/Sk\"<4AgAaU\$'fQO\"k~S;.:k9e]`n-7;+V8W2HUYlBv⯎Ԇ	plm\04B)X\0QqFSq4nFx+pESovGW7owKRW\r4`|cqe7,19uucq\"LCth)\rJ\\W@	|D#S\r%5l!%++^k^ʙ`/7(z*񘋀E{S(W-Xė0V0=a	~fB˕2Qru mCtr(\0Q!K;xNW?b<@`X,`0eƂN'&~tu\"| i B 7R lSu8AdF%(?3@A-oQź@|~K^@xb~D@سTNZC	Wix<\0P|\n\0\n`\"&?st|ïw%mduN^8[t9B\$'\">U~98ÔFf u/)9\0Az\"FWAx\$'jG(\" s%THe,	M7b ǅa ˓ƃ&wYφ3 /\rϖ{\"ݜp{%4b`팤~nE3	93XdՏZ9'@lfQbP*Go`8AB|z	@	bZn_h'ѢF\$f`HdDdH%4\rsAjLR'f9g I,R\\>\nH[\"\rӁL,%FLl8gzL<0ko\$k`KPv@d'V:VM%@6<\rTLENԀS#.[x4a̭LL\n@\0۫tٲ\n^F5` R7lLu(d \rBf/uCf4cҞ B_nL\0 \$aYƦ~Ukve˥˲\0ZaZXأ|Cq/<}سú Z*w\nOz`518cIQ2YsK\n\\\" ðc*B.R1<3+*S[4m쭛:RhITdevIH-Zw\\%n56\nWi\$ōow+r&Jq+}Djd?U%BBe/MNm=τUb\$HRfwb|x d2NiSg@q@>Sv|krx\0{R=F#r8	Zv8*ʳ{2S+;SӨ+yL\$\"_B8\"E%\npp''pwUҪ\"8бI\\ @ʾ LnR#MDqLN\n\\̎\$`~@`\0u~^@l-{5,@bruo[}/y. {6qRp\$+13+O!D)\nu<,=Jd+}d#0ɞc3U3EY\rtj5ҥ7ewׄǡ^q߂9<\$}kRI-+'_Ne?SRhd*X4c}\"@vi>;5>Dn \r)bNuP@YG<6i#PB2A-0d0+gK?nddOci<0\0\\gꡖNTi';imj܈uJ+V~'ol`\",F	{CT aNEۃQp p+?\n>'l* tKάp(YC\n-q̔0\"*ɕ,#7\"%+qB=i.@x7:%GcYI0*Ðkۈ\\Q_{#\r{H[p >7chn.S|&JMǾ8mOh	qJ&aݢ'.bOp\$D@CHB	&ݡ|\$Ԭ-6++ pଡAC\rɓ/0MiZnE͢j*>!Ңu%g0@5}r+3%-mG<T;0DVdg9'lMH F@PuntFB%Mt'G2@2<e;`=LX2X}oc.L+xӎ&DaɫF2\ngLE.\\xSLx;lwD=0_QV,a 5+L+|\$ijZ\nDE,Bt\\'H0R~(\\\":n*(o1wQrEteF\$Sђ]\rLyF\\Bihhd&ᚇh;foB-y`0JlPxao\$Xq,(C*	:/HG\"cCQ\nFԄ#8F:У\0OkD])ϚtT8L𒨔n`|HJ  \"6{?=I<HGc ŤF@,C @j\$L(nEʑPjbnΑW \rLqsPHꉝz\\V\$kҏtr5,l<'\0^S020f -5\"ac\"3Up\"ܘ%\0'Zt\"969_ @Z{0IDZE@Nh`\"`\0ɹ(GHCh If`@ZD\$)K;Z\0/CT>r_R@O`1rTҨIb\0*8h\$_pRĕ\$Ni^ʪP/O).ŹT6\\ٔ@Trą`)T=n\02e+9ʢ\\@>PH1	y#r<aeK/cM@_.\09ˈB0ia\ndea%|S2#nD\$/+Ed_2P\$s,ok#<	Ađr{BA-Q4Ҥ\n\ry!b䱎O@ɬk \"r*݇Y/ȑ a0%.gE~& 89#@M_ 7K䃸J`X)B\$(	:gn*|M6PZHtJtqCx[ڼl=\nU3f\\̔JP	,:}TASYH(\nIٲ!t(2U\"\\X^s	a!\nPr`X3fnbJ&zzQSf t!T?9%(QB}6BkP\0>g&~fhUr, p5HipqɚgVVOgWEJ80Gak@N NMUUxȪSx		K@c1yVlϠC2Q^rP6|I^M,j%d`ܫF\\#%|C7싢GTNiHQOCyB\$%T*>z\rMM Kp J7O۷4%\$p4͂EҪ\"T\0O\0@>	rO]x}^I@ źqn0BbȵI(M/;}RN\nC<bPԵu?=PeCL^'S?}4)S-1\r5SOESFAOR+ޙ+v5&C)ِKSDB߳N|E\rcUYʾV?H)実+sFkLPW-,U:&t{VoJl'We74Xn GF'`Cc%Ilju6vUZ\0*Nԟ#(n-;|4]Xy';Z) s9%R+\$	Q(\"_kX\nM#\"!p~:*\$3O6+\nB{1|HK<[`3#F@ǐ! |؊\0>[nrMM+mO_2Ȇ\0e^	7Z&BJ褓h7QO%rfp΁֞mبÇ4El+ViN SZWt2W[;v\"%\$^-(I\$S@R-&Tzk(	%R8uY\0[9-()E8=^G5#)1Vb\r]Ne;&Y`rIPݱֲ\0@P70H؍Rx\0000C|n=`TT\rEhON'&tcK ܕU5P3\\2\"\0y5V]6>U!@hu(\"E%07B6dHNij';@eMzlSfjKY֍-uhHsmL@\"rjj'l7	(uuEea@+K:ӕ%nzV;[_Vz_E8<Sb6g:c7\n%Q K7ܮBwu50֚yncnKT8ʙsW=+=K\n_[pGC5'D\"M<\":|Mq4fsx	qlͰQPaOYE=6nT떒BthC\0p@nD(aP\"'ZN۬\rLNXg<!w[B))~cxvi¦qa@K7sEQdýk?\"3-\"U||21D>߳]­&\\hTƳ5\0`Tzs -N\"fNLU]n(D(&%\"e\\ONInۿ\0ƕ@V|RMYCTbUHp)Ss qi`Z5vt坉*OO\n(F58!ax@{^P?eh}\\j^2L,6.N	K%uip!?l -5wK\"V\\Is2!\$45v\ngrN};W%D(pWa\0v'6Vƿ0WE4EUl8LDE<kOHDU	`vSL!DTMbnWVCd)Ze蟀:2d8Kބ4-Gb;wQW30\rf\0,`Qhl֍0P0h@\\r8T⛜1`&wX>F?|P*MqZѯ}0k`#իc'[ֱˍ|sIJ\r<OaƼ@WuT:E^!ka\$>5u_KcCQr-ъ'\riC@8SPS_Xgl%	n1r.<w_aɺĳGh4\nWZaBn,\\\0DU\nbbZ'72r¢}Y>/w\\Y`^7JjSS.o%Jg\0GD,>7R036%i\0S^LA\riO<a phv[{\0E^xܼgYzWyGa:(>Ce\0])3yts_a7+BCeTfoP2ECv>wlz*pYqQp\nv[|qҨE[Xi=z(	Mn]7F\rCs4|-} Ŀ(NU?,څq	pq~ F%88靦\$ް[ro!3(gץpJ!qZv?cL76\$mq8l!5C;Q,dsF-OfÈ\$6%UCf\"e(j\rMtFRx;nB\$SSx'G陊M	4ͬ'k~#9eY~뭈;f+jK9pM'X/rt\0\\J%QR\rвO3|寚ϱ4xFs5EԐ;ԒWRJXʶJ\$wzO&ǵzkS\n\nNUP.0bdkP	G6+Bz1ΎhQ>sHvQ٠EpM)\n\\ўPz.s g)a~ȥ!(!Ghr[*բ`~\"!O5G3Ş*qkgB,\$**1c.n	8\$dVSneMiZ7žgA5\n`,2aүmMkʻɯ/-6@?#`)Ԁha)Vc]_=Rz\\VR=ط(-ot\$ܥ\ndSmyfөN\rm(t;Dp2ݶZRl)9M̛,/Yixkя).2@S^ud6!>VB x<Kt06@\nGAP(NbDK\n\"cN\ră.p'2Ldꟲ\\LyA=	Dm3%@8qbSP\"ޢƮ/DzC&O\0007fD^1X/,\nvWx%f)' DdQ@I(ҋ7Y|AQDڠe 8ׇ7k)_ @\"\"%}	(11؍\re?-ɵH&\rL'eۮ0T]C!emNz	UzɈSܜaf7M^CD(_#\"dr5981hfȭa_×tZX\0U{2nn];FR!}>sHiy#?\"Ť>{/?7FY?Aj.U!5`H\$r\0'\n\":.dԂٙƪqRխoh>{1+>tk%-D=9}C@8cmHrWn\0Ď<(RR8YV`pp.Ue_`^쵛n^_R|r΅p7/!M5|\n&FVVzOA~ш|ƛ4NȒՔgyh-\nN\"r\"GcsD'Xo٧O{{Y{E=TeZ{\";HXztw*-Uw-\"<A^OT ]D?:<pq[,)&`{xKII``c0Dy8qCYCFJnk[8:\n^ցT!X*M<5`\06A2oP.aAH#x[▞ 'o@O0^h|P=+)d[X-W!Æ/:\"0k#XǞ<hCGݠ@F(kl&HF0OSzwQ3z|+\r9bT}'ܬwA\rnF!g0lpl1+|hkzi&uD{K\\\$t(;ìHr|BwD3[M!:({Z(|-Hy0^'׽}*NK5KUjM\"w]%{1qz)]Ů[k\0O4UF\0cmZEGtsDQZ)n;7<qhlXxI^V&ͷC`,ɑ%1\"@1|)RkV}S,#!G]ExYT<%Qѿ@mJcBB iGf2cDnէ=JI_'iA&,{c4oV%d2xe#s_UHՉW!  =۷O<(y\0.G'\r57pV(þ:}RRHHy[	 1O\")Ll1+<~	\0s?B@d?n~&LЄ?@:@;yQ>f:\0t+jszK,b^pHX?P\\D?v\"\"& ?t`V?\0JwC1O#Ɛ*	@̿\0Ƈ/#8\"O\"\06Ncä[p@Ch\0{\0	pDOFtH/!h@L;@wI~Cˀ¸)E4+)Eb?]d\$<`o?}8b/Jo#IV,Ac3Xa oxi\"椌CUDkYȊ}\n\r\0,G\0|q .ŊNqpNДjBO\$|Cp}4`\\*4bA+D_X\$@6\n\0\$~ˣ\0Jb݅ UpXiD\"ێlgt' +x<N51e0`B8q\"O- 	C!Қmɵ*f@#6ZЛ9ZRǁ	HZL e99 T n?xX\$0%\0002\ny!e:\$QssAnxKl1'Nz!p.Ṇcp1@)m:@P\01\n(CR5D(P1#	d7+\nBuhaM	a\0>1W\0a4 s-ׂ'jp\nJmQ)");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:A,Iv4ǢꆌP-\nҸ%>(c(P74c8X`X:\r3 KIAHHs\"N8R0HY5GDW(3Ut  P9MVd?4\rCPbؼ2*b3T`nVMsb0]pG%n\\E]8ߋh7E`@PIjVTz\rC+R8\r\0aRؾ70l_2dYAxPZA@yART o^CK~c⊰{}cZ.~!`@C.ޒ.y\nl9wt\\C\$pըp8/媤eyn_H!fwZ%hc5~[H{\$\n\r!4nn6͊cHJ.6|`ӛ;.ް[pWݪ>\\hWZO7PxApUW)!/pi[~X\nR\$8?BEy!cPC5.\nH]=y*\$st`57a\r\05j-g\0ͤ#oA\"p;\nH<m!dÙK>+d=p)pP	#|<)70-(ek9HE9.N䔒J hL>e<ۿC`KxVA aPA9WIy4WjpWdER2ip#)CD?ruxs|ϸAX+?l<H&T#|РQb -\$}Ah:t0PD9!9SmHi\ro}ƪP_Eaxfu{Ӳv<)/#QC*ܪ\0rNirtGNow>MӼ DJCv``Na@](U S5{=9N8z3^<		Xc\n=@s3&ꚠdAj%\ry\\{<#	UgR`^K4l!t{\0W&|-U/7yUCXR6uHVu|IV\nq<鼇*p)&Nq/Rل\nV	83<;}_ph\r ӊpt9#%<2id3Rs\nkOf9pA\n9  IYCc,U2^\00\$NqsJ+d*@1:ukΆ!4;@zZ&d\n3\$ݠC]QBVwp.K\\άԌ\$9i<2Zp:a`US3|T!&P,c=0=Nd뛭6nZyiTTJweSu'nm틸In\r;ݔ*)Ai1yQ\r_8?՞76l1ǽ{cvr{\\.,ۼevkۛe~L^7\n@.s8t}ɘ8C-ѻ-4IdO{sջ8[˵f;}Qs^ݹQ2[(@\nL\n)(Aa\" 	&P@O\n師0(M&}'! 0{6}kʘ@;px6zg|+D+ϤyJL#}~*/}4|Aw<wOX\0~\rڏޏZ*\nϧ\0v0 */hD?O\rnBPFo0\\`0fkrOHphxpq֐PTbOPį8揢POo.0·\0\r	PEK͙\rP)\roTv \rDܯoMA(XhCL&\"h\r,N^qKkb\"	}qy\"R`\0n+\rnqHHL\0V%F: ؎\$\rf鬶јjBmQmG\\蕱nk%\"Vdk@ !2+6% ~Ğ% r.R[ 2?\"̹#\0Ԁw\$U%#!%)\$	\$LmA-W{@ܷ#_&x]\$S'\0\rg@m0`df`G&L\0':xjx*оDL(q,&lNt*\n	 %f(оkZ	%in\".Ļ氮~\0U@d4'r\rn#`2H g6&v'\rrS^\$@Xf>΃k6r7`\\	5V'W5\rdTb@E2`P( B'0/w␑s&r.SVsє9JJx&8v!`z4\$k\0x7pI өA9;\r~4>~'\nPs0PQA+/7`WOG1Fp暴\n|\0PGGtI\"TiGO@FV~G荔2\$%96,7LLSoLhP5ʼУ\0P\r\$=%nUjXUkϋN\0\r)F*h@kB5\$56Lbs|Mo8+8\":G4ONS5#j\"NncJtT%(DUS]Mj\$TK`5o@rYSNR1ER\rEXrNJ7bgTUxM5*0r:3		2i1QkF0YZstec\n:oHFExu#4S#	 	\$t?E(p(R\"|eBX8	4>\r/<\0E,^D.E{5a܆*\rZg|~\r:moc9Jv*B7rT&nlHPV6mDw)m\rCVw\$uSwS`ADLS6qk)Jkl'LhB9h Jimn<\0  <\0[:\0K(~s\0K̒Y'ʈgaO(]v:&!`PxV^wnĹ7\0&g|B\0(*,ľ²d7⛬tzwz\nE\",\0\"fb\$B(h(4ժ5b?΍wq|@Ƙ+؁޶&Ɋ~NⴎחN6<uFxWQ^^;P.#/|Wȃ8k./7K/wQl8~Qψ\\1\\&\"ئWR/)|A5reE@k\0OwK&f\"'Lml@ۄPZ7\r#ox`]b̄NzZ@0NR,x[Pc8zX\r?Ǎ?92x}LF'LPyzð\\ƙǌT ŤiNǀTx%xaucw#l,\"Pb*g#Zud,5\$D3]؛?h~0\nyN7bz\0a5qkpvQ,D[A\\EyKyP#UZk&)E9q\"7![QMd۔uQJ#\$o]jۥgO\nXD6꣢eXZ:E:OUbz]7sDc0`?\\S{ySihzEiij&׫e'kXy f6V-ZWewŊ;G\${SK7	1n>@izzw9{x;\0\nIyk[7{޻8-~w,[lȌ@ϷVԘ+Ӌؿjcؤ\\qǊY'zYݻ˜?aA:Q٭(} \ny#Sy\0[?/]My{ˣ9=PϫOLs\\sWDػ˱|7jN-E˕+`uƼ\rM}~I~iڴ|lv}YL1l>\r9,oY9}Sgg銼:u)ÈCR%~|~w0]|\\yϙy\\ج7йe,mu7(T],wθfU=TRW6<Kֽg;||1\0Qy\"9vb\$5mwΆo\r\0xbkH|ɚ Z\rhWʜ\\Ա.3U\r˽ؘ\r>?2)᩟/=50@ƅH~<нx_/˾3~I+~l~HY{Y^]^ae^h^r+>CbB,2/LR#mRKIK'픕EW1]Fz_]T%4̔\0V=4;\$T 枍{?לּԞ3n\rz X?cp\n?#adX\n:z-^X!`:\0y,DlJ`A)hU+5+~_+<b]<m5~']')ެܺ/Pr4o{_ngHFpBsH1)bb?톼\"[C<U~<0y:G@}脬z޺w)}[ꖞ<8&X\"`BWw{kU.E;=pQɢR)t\0;Լ*JC^ d,+d-~*xpn@A?Qh{䄳'A5P{dX`H+sSkX/E(3=!004\rjłZa>m4?og3xƕJW\$EQ^&\nQEhjqCNƠ,yHβ\$'@\n;\0\\]ϛв(\n6arǩuP/;P#q1\nPB.6`\nFٰ͒W3dbZU֜=xa@=fZ;Bk謀mJNg^prٲ(Ilcp*AOU7\\D<Tf+THϠ`RZq[`of\\\"πx|EfŰP/S\"_8-CF]\"jhF29!Eb[E*Mx\0`9DU_tюq^(j!tX'E_ػMQd^b|,{4\\MXFf-kN`7,BJG5&*1L4	#-`'\nL?\0)|r	X|e\nJ9@ʬȥ6qX\"qE	Pm¢NҖ7}	<I\nA͌juL+F'CZd&RncIl\$\")|74hCvcs}sG0~#feB.rO!<]/d[A\$)JP\0Y%F`&BvMIIP*7֐2&lXo.\0KZBq&<Jp	ei;\r0PBHMLİ=TXc1&y-I6fN|&yRn0r	%VRKRdH AY\n<JĺL'~V \"l!d'`q>Iit3:Lɲ\\s%ͪE@HC\nf\"@ 11 ln͆/X\\DK ^-n|\"\n8@{)P(P(s f y0M@\0&bQX]3	8<#11<.bf*p'<4)1\0)n~cȁTStI11(\0P,d\"=@6\0w\\fzYLn(O}5	W=2Y͖e@Ol܀7INmX\0N:nB\0k|,p>Nxnxh5Θ	Gd'3MS\$H1iN0݀8Mvĝ\0P\\NH\0|9@\0!dHNɥL\nS؞؀*MQu@&7i8򓖜)1\0#Ljr3\\9HKd?hg:	OzvsO|\0F4>ϾpS|<*LBw)<?9@	3+7ϲes\0@Ђy\$\n(#B'Rӫ5CiР4:C о}4D(i<jPQ\0ADf%>L4T@IOXX (&l')}\$eIfN_% 4i\\UhC=Du'@v8dB-%(T%7㖨f\nX\0m@C0I\rɽw<QhS09@I,t')˦\0J7\r\0!ƷW1\0~_\r2\nf܊@QK9\r\rXi{/~2Z_2'*o	Uس\0{e(\$iM4T44}6)mV}A3Q\0l/=@QZ:kN|Q&4JR*iSP5\nt@_)QIMXoޠk19B7=\0ɷ̆l|[aa.Ԩ\n\049Βv@GPO'ZHX'VZ@Tng7>l3cDXZfjY_mX)ʀzG\"P2|\0NjX{\00dTl \nq;߁:bShfy)Q+jSCQyS0Hq`	`FlpT+yrjZKcWmA:y5\0P&zWZ)D	TvDV3VFȭRj֭pv5)'X&@.C@`pTlSw_	#:!/5rrr;F&M@\\C\0\"\$(TX+\$t+r84XfId#&cIPZḻ(lZ6^3|s\\=Er3w+(, c^|:`h[UahtZԶO;qyv\\A^x!j2VդմEd0رְ4HYHz 0+Rjf_kAJj[,U\\jXX=ZDw5uˤ՟n	%'}&p& )qX\0+_9C)Iۊ)R짇`ĵ@/!+UAf\0R=A%r3{\0`%z0\$>Ѹ=h]/64\0i_2Ue;:JNuV|@	GhU=Qh'(T>,n?#tsf=cVvu`U'X)MQpp7פ!aJl0@ZFE=ClJduAJtȪp0WUwƁFa\niݻXJ*o*6k8N[*/uMCUMaJ޲V!U!+Ŭpxh<@B] ;  u_2RL:߈	4.f1@b%\0!{=Mۿ|`x	\nтo!p)_tȾ#pai\\3D.񶕁Y2xFg넞8'(0BJ@bZn	p\"Ee9J0X3b\r; S1[y=(73	Ñ2*l0!VlrZ@<TKmXiF\nU?fT\$i8GS)L\$8BiD!\\B#<4aT+@-7\\x6p?\rN/黰%L+`ht<W>{~(@R06ǞP+{Esö\$*b	&#[X̯&bnSUl,0G~}cUf'dCs<m\r;<*4~ǉoam4]/02cFxwH;Rqﵾ&	kX?AIƠ\">x?,Pbiū)c<\\++^n3ő|N'!+PGN5TBK!1\":2bP,Fy*NÓ<a[&3t閇7\$\\qߔ 2ecInTy2c_	@\nup x+XUq<A.Kʕʎ!2?8fr˗8\r8(p^!!Y=q>\rv-πٗ	1gf,[,e'ZX:2\\Hy<1)[α;D|#H@LS3>;]2Xvj.GEBi+d%,Qr%Ц¶*I5`t-sb8E۾e\0=2/Yq9-eZ1\\^U`&gWJYhK]8W@;p##Bynqĕ\$uY!\$)(rX@/+L8O^ʔp6,Ѱw<%MSS=Z%W\r\nHy/2+e1Eɣ\\Uw	(p\n-ISEZiI@1	`\$448>\0iMӈ4QjYyp#x`m'Zڂ6zaSi&ʒR>z\n{TiP:jZjTtR@:ޭ5hj{\rfr\"x|cx?rkp.r>tqC	k5ha\nU:yxW8k)3!ҋk^t}-x5^B(q@Qd]ƴCr\"kw[&usW:ꕝN@d=+Z9N@m{-%>HR0*7K/<~,jsnP\09.͵Sj\n74ݱ,\$;E-m\0*Ȼv7c;u&vֲ37ءy(tn;JAG4hfR@5)V{[Ymb61pJ6;[.Ŋ[rb9V0\rw݀CwVT&=,hzH)8EsIt<@e+0ynjTƮw~dJσ@)c+h,ث8pL K:QAog1o?IZ.?=~nkF!n%/Et0'̔P<ƵGqP䴓FxAq⃫vn`,cW{9K߇{|+s<4Z+צ6PPL(L=ծjfh>)A혠qpK̆Ҡ~6d0Y#y}tORCS_燜|bHwsO%UwpN򈍜Y]U\"rMt\0jxoWD[[M yT8@9h!̋r`\\/4u{d8Sǡsb\" i;jiǿkj}vi74߽J9=՗540'?(7qg t	_[zӌ\\w_>s_g\0V|\$p-BsX܇.;3gPCDGy1j\0y=M˞;Fm(oD7ykbo=!:.%C%t߿Xm\$6&PbjTu*Tx\nd5Νt^d(S|-q\0(tXYQ!HFk0t4H|oNoN%\\w\"0Bq\$[玙f|q7~EyXqר>| Ob*\nImcEЮe6ev˟LnɩKxx~aǜf)9˟]F!sIiNh~ӔR.GF8/zdCf6-#g|t;4TV)kV/yC907h@).HqEN}K+Yr\nb3@K1 )lA˧=#HiLʄ5oAB>Y@\n1H!+ȣs0GH~^7ـQrI8\0Ì`\nw=0Ay[Q8HOg m#ʮukHB#oufoݐk^!p{}4Iv?x{CY-ICמȒ>0l\r\0|Q15L/j3;Lﴷ^{Un(}bW١+>'{WsC~qM;PRv̢Ɗ:pQG 7a;_z)|:g\0Y*/kė\n>U0xH@-=\"0H^UE+x+#;1kyTh:G&-!qs3^|xW-l!׸FXt]BXY;QL0cIojAQLGG%\$(wҹEhXKaob5sAt/\rݒ`w7<MP*yYh>Pr=zjW01gdliD/}^V\"b>XRnr.0̙9@ ۮȷ;&^2hYXh(b\0؀/\0l:0܂?t%> CG4@@E< h	O0K\0@r[\")AoX4z NR̃`jkP ]Ol2\n*b5Dn2(\$<)Hac:ϋ/8i:n6:0;<1LP\$ أY\$:0jIP\nrL!wN\0>~/`4+\0<^RXU6:\0bN莌*.Npxp_ 8\0XoKb蘖|l\0Ɩ)\0P:<pl\n@ASPPƚ\\ A03\0006 (.pv}9z@N\$ņ?5ㅟi+Av8`y \n;  Vp߀\"jE=x0d\$PV	xXg\\?\0ePaAJ/`pSLЙ	(PYBqОA!.bVs\$	|Pf%gzTAk0l%.l5I+8I+BH*pQ\nG^B	rLPUBqhBnB,b4Y`	|#`.B.B\$6!*s\$#<B%Q*e	NrL\0N1!i+\0Ѥ\"60bCgaN\rPUCq/P\$BNIB,%#-\r+eh&pº/d+PC-BD;DC}<BB:0Ï\rPCPBi1r	'c[\r?P*?³+pA,1Q\0L@qDh.YP`0@6Qb\n\rޕ0\r\$1@=ĺB֔ -tXBC1,+BI%	ֳ(KT\0F@/7X\nD``[ΕpDLDQ\0\0N`3^\n@%	9\0[ 	LMA믤Q2Q8)HWGDb%\np	S(#tDHQq[f]\\'(B@^(CCvV[Ř`(^EZc!7ÑE*Y1mEuY_E\\`Ec,[1e]`E\"䆬86 zq]hŀx@OE\$O6}Qq=!\nŐ<b:QcO'b\nT(|QqFR`&E*1R!L^f``ņc\0^H!yg|F\rbFl<ƐcqeFipFhϖ\0]Qhqbƨ4O #\$=\$gFkFp.<\0k`nƦO(J [qFj1F4\\(3\\TgD-TCA+ \r7Mx	\0Z	R\0005p\r1E\nVI(;R~[>`36rp	%-Ж\0	dCñ(9Ax@2!*`\0002ǲ~8S	PAڏ/ #揩-81nt*\0#O0=0	'\0d	( xG  \$\0H(2\n3fn 7\ñ`7GF@>H.5 >?B><z\$`>0RtY+ FQ΃ l@>\0̅10\$VƴK&\0@0 H>4o\0006q81P=9\n17\0D*<#H\"1|#!K3=~=nmH,#,{I#t~) ֓\r b6I!1gE/r\$)\06̎'0v3g@\\@\0! 3!4HdLf_9r,[xebf HHhpf1~D%,a)0֥%<Nc>& K!K0-;H0&܏ଛ.|#.@3!K\0002\0!07ʿeJ9h\\=dT\\\0QDId\r(II 8DrZ~(;bJ8CU!RH\r 3Iė_AN#321@{@J+#=R}2-~H.!`:T^!K)Jл(\\-\"#L0	tʃ)d/!r]8ы.SKҐ\0H\\wG:)Gʘ5+N	N\rJt0&(\na!Is!!d10D	2:53)WJ%:0˂#Z*H-k״\rR<-|Z2L\0dxKAty2vLA8\0K3+\\{e뼠!ֲ\$gI.O#򝂵)>\$g!P؀6KF#q\nWP2NzS{)|/'(kfQ*JdJ>!02\00Rbr4yJ\r <^H@SdWlT\\TTF;q!MCx!\$9_Ay?z2|I|.2)*cBR+2ԭ`K2\\R˛+B0˙L43d)(G,\"̈Ғ3xS?L3<SAM.t2. !+%8!JH@K%4A3N*d,M4/ſZcO1\r\0\0(M</Q5̭38J75S_=5ܩA-0:)~HRQt͑\0\rsdGsdL.[6@562M̒-/	\0cLΦMe7xq\0003b44`1.j@H46\$W6\0\ri\ny\08h;>Q_<40?RH10G(LfQ5/xXsbL`<8{rSɭ9@B8x6'N\nRQf`8|\n'ԟ6T(2^A*/'0Et*xɇ#dgHRH(BU#`\n\$c\0(#92\r>\n`CrKHP eP7\$8҆6Y6|ThRЄ,4sǊ* K)DsJVԟ5\nMH?/|\0006@.Lh˨>KvL\"!K(\nIOv)I v6Ü3>d!Of/KLv0	T\nؑ,,ܹ6M|Od!'U=C/Jd*ǭF<Ӹ!H;ڂ;љA~^<aSe2֘=O1 9L{9,:9,7-\0`\0` u:1| e1VL#A	Ap\r`7)@,dġ{+5\0b`LhU\nЦe\nSΖ}\0JA!2\0A,u\0006PKQ|3O	PS68\0%@0ɦ\nL5.ə \0',<)@?(P5JgI\rd9\0T̒)BLA\$cb)\rXCO(\$NJqHV `\"M8t\r;03|QC7XLu1}3X:bO4]UMaE?T=%0␂C!TLH`*P8K/\\K6{SY+͐KQ6@6V͑<eIP6CSzO\0Pf>80a\"gI,gmFᙔrId|FR\$ ȋH!2FܦP HR		8a5Ih.QL(@;\rZ3%\0=)@B*H?T\0#I\rJpLJU%eR_I&@:R%&ԪRq+*RY?R\"J*R3JiԬ\",F5&j6.'KE+ԣ&u)TRML)TLD~ԹRESK	ԤK1!L7DcK-34DA/x%T@SVIS^= `\r\n5#0	R2Q8TI#%Swނ|R7Ӝ/E\0~0A/\$ӿ@82L!dtYO|7<a(ʮ64d@\rO;tA?QiIᏐ|&,<w-C\$0ۀ+B1P\"*#\0HEJO5\0\r]O첈^\rxz:^	_(6M'%[-i]F#ғN\0ĕLN4f#i:SX@4%[ʙ =&#eHc\08f  p4\0ag/eD,Aڀ@bE	\$PJj2\0*: .24ࣨ-P@u=)\n=x )\0򔂀=\n`+H()\0#x&=:ki&)H+>UՇChi\0OZ~@+x	\".F?B	BmAC[DmQuFjR/4TuK%TMDcW!B\0EГ`ɏ=&L=cϏB(\n̨[0U\n Oό1EUTu]\rU\\D[\rG`1'XdUT?CHsV3WEcuu!Xu\$,B}e5~UP1.'A:>p èi\nSSE\n1\"T@@#lN1[(ñ:PQUl4D[%lЄ%[XuD5b	kHbDpqW]p@9\0[R8Ŋ(-RN..UpTW%\\*U̦)\\Ⴡ@CtU͟j\"\0<WRc}uuu]v3Qs!]}WX]w.mu<I\\ 5׹rdh^usM+ 9Eu\njWy^UW[_E{҄H>WA~U_:k]xٵ\0b(\\B\$89\\dX4UمaH8W#es^A?+=u\0`ĵ|\0z)upQu)`]xOu@6ew`q9? W@hv#	@m\$X+ <~(f\"jDe1X_=rA=W9\\ 5c=E@l1X̐: ^\0\$=bMsخFVb\$Y	b8WCTs6%Y @(-)Tb/DؑdH؜L`@d	VG=eUvX\neZWF{MMY9eMѲu2GN(-(+b	K_fX#f9dcvnRb%4'-\"\n9\$(JW%fՙ6j@7gvr4d/1g׀[e}Ӈc%cNJ\$aa٬N	Y2dSbQ`\0ŠW\rr,H\rhrQ\"i\nFKK;iP+Viupc3]֚Z`8j\0-Ei+d]\"ىh	VLϼŕf}1j67dM\"XYjW@١A\re%\0jbtY:Zev(ծ6dAZk\riEK6l*<J]hu 6[#lb;bճvdtt7JtAو8A\nlxҖZ&!~Ҙ[OmHմ~<\0mZm,[Gdui-DqZL66[nE ۇej1[l6ޗJ}s/[me#mJvF7n?Jt[R\\6YoLc`5ovmX-6acZsl%C@[Wa [W[Mog\\/\0o \"sbM9dģ58<v#4m,}نV|MlS\\im;ᆞ+YQrEȷ%rj7ۯa}ZMrW\"ܝs3؊(B4q76qCo*+qhsv<oՔW-r7?ܧt\r صt->tH)rJ7\"@w]Ŭ7IYpmҷ7XYt\nG]\rp\rQ\n8\n2ѰTezP\0=vNE#ܽu̗Eiu-Ns^.}Cܕd˂2]1f.gr04x>WvE7.]jU\\k4q!twIF]pwq5w)\0qp\0\"\0_az]^7v][-ܗ<vޖL7c]a7?\$-7;^w5v]=vagv	k\$w;Z!Vql@;V0l\\[v-`X xW_\"n <^uw^ew=ӷ]rup*urZ[]G>é5C̻(0*ɒV0W	(\nՂ[z`)^Zkɱ'#\n\n^()BiW \n\nݦ 7<'@	^:3\0*@\nЏJ&h\n| z\0)_\n=젠_D=h\n5_Z`*\03.(\n'!h'(`«>< -\0{zi /L8`/:IUv@Z]<_{0~=`m{,7E{=+c~l}5W_X&\$Jk1m7O{%8hx`\"'{}7^袍Ѐt@\$z\nVi߱{i&JW|\n	UZw_NW(:_RR3}`&\niAh0\0	|ES_%_2֠7߶8|{8%_Y}pc\0}k_k_s}_~Ώ?`	׻{Lpf8;\0^8\0_E`\"b<wߍ~@	_-Jߣ̀_-:fW_~Mia1~~w=&_?ZouU7|XJaUrbdpZ	ը<wЙ0f#U{~@&_	*Ԁ{zw_3`#\$(0gUPX?Rk`>+\$.8gÆxlIa8[{X8aI\n\rc~aͅWx?\r8&L>!^|ڏt=a`=؍߫ %d	M}x\nW+|- Ux	iaCWa-s߯'f(Z'}צ\"^'b\nxkb=5hdCݏz=6\$C؀&+~%8\0W`'`v&Y\n&0<cͨ<	 !M\0,8bɊ\$ď?EXc\nU&Aha108VF2عeNIbq3>\0V..؀Wɗb#a=BϨ[P*=	*踂`7q+H 	`\$U5k^=Z	b=}Xc.(d_3)_3Cb\nF1O,Qyc.#c	.A`>5LF9:<+uߋ\"V[(=>X%Ҍ=H\nS9axIvE a[ &2dh=PZVU]U#d^\n7FG\"&T&F?\0&Hy)bK9)w;P\n\$d#bˉ&JgvK#=nLX㍓H*ا^ۀ *'Kቍn,`::\0V	)&!|PزVO-ԧ}{b	PEe#OcgP+Zrt(O{rByLN22(&U	\0X぀kMf5]VXUU\\<paH#\0=ZXvW	,R`)f6Ucᄝ0,bըf'`%ᛔe݀^8\0^.\nX__P\0).B@dva9)'NO+~++XA-	j3	MaX]\"f)ـ>y:L\nŅ4VX_p0=-@§zUYb\0ȸx\n&jX&*ɋ_r{R7Ki+q3kw8f9{6]aVlb>jyfy<)(\nkfjԫ@X \0Q~@F8CL0@*\0`^~rxgD6tT|x# >u	e)YϪǝuJky2&eU{M;iUL=u#gX*t+0׾ȁ	 'UY^)5VՓ*X-Ua\"ǆ8`}aוU{gdn-8\0t9<Ldh ,=I0h8\":8	ԣc3h1\0iz86cd81hiֆ'X9|̏_aK)߯Xn9Z05\0ƈx\0<\nX.UWic::	Q&\nZ\r<Yփ9VgR踶bZb*IGkc.rmP\03Y\0\"'2UjIiI9]W`+L>-c<|\0Z煥\0e{󀉎NH=h+&@1dS^hy=fWUa3~XN;B+FOva\"Mwg턆cȀG'Gib)@XCf<\0``ڴ:c<p6<ƊcaX^Yc=-axCRKZ<ƛcf%?n,نg種>h/xH筑VyeYWVZ}l\0-jO8_[0\nY\\Q~#nZ>wy৪Y_[X\r궚ޫ|egUj:Սsˢa\nZ&ȭ\r`.I`{.n冭\nqƖWd.)a`>gX}8򸋀(\n.͛v{T7,3dg~0ؔ	<{<}3\$ϔ)8@R34:䵥]~6U!<@jZ ֺS^ӈB~ 5ɳ,S,(M9p 3X/Zu':Fp\\)|ƣX\r<Y8Xt脕!`6 4.6+ZP۰n<0&bw0>Sr<@6d\nzlOFRlO;H5ڝ*L^x0>g6s/qYe\0@<z=\$Cئ\n`+'S9X8_/ij	h75Y\0&cwa֡EɟXyfub{5ͳvGjgnXd\n{lǫ͙~V	?3W}R	Ch0>R= 79x>S\"ӂ4zҴ0f\"`1:愸x:x;Zd֔eK;@gTML7N3RkN(iF;)Orn:Ӷ\">^#e;n!Q\0/ԆfU\0\"@Rp6Bm0	!Yr/Tt1VeOQzBr9,@9m!t11;\"cmMu,S<ŮW\"yvK)VmV,bk\"1hxF&9t?܄Iq\0g5MK!,?!PSQGe@a:bHd@(: DdFJ1Ḣ 8w&@⍅'iVmL E/[RR˻ZnfՏٴ_GhlbŇl.3%I[c6 3k,IDX%JSoxvKBq[iDanO@۱m/|iK2RjfVrZEJng\0_H;PHDn-iQa))PgL6%lk:sk1SmNFo(SJIe:ԺJ=lF)ﲋ\$xͣ>Æ9Xo<'mHf!D;\0fSAr/;Vl<eػ2JA\$kUY 	d\0׻|pP!fZ\r@O'_x6;\\4%Z6[6tKŰ#u1|2XOo&6~DqO<<:Ӷ|p%%ֳR&\r*oʡx\0C[ʸ#:lpw\$KL;sh`aRnz;ϔ;|8L=OEǥH* )-T/⛲_H._%H7THSD5>S_cr~yE\0*^,͎FS=\0#>@cEMA7o\rRq{Sմ1''m{p0f2/<m:-HƸ%N'[Pwdf\n5<t	<n5F3+b*qedƫ0@S;鞒d:;=>؁=#NR2`Fd\"wQݵUNRutvӡ\r'K#O\0ɰ씑r'rH.|;OK.8L܄HT|sr̃IMr/4<䏦<rƖ05nln,l?Nࢃafܠ!fo~|@2/<%|1~iL	_1 5'}r!16Eo2s. \rr7<2<sn;r5*OlLDF@l[͜;]ͦHaGw75Y̚5H\$A\\<t|ARQD!D\\Iqv@}_lh(SKi)|iwTμO>,a>T4|sd`#y\nu,\rη@As8=tdYw&		NBhR2t %q,TwM[!O=xNHJ@C6F~a\n.Gq\"'(q\r8CvhJ`9\0/|t&w@&+\0]<bt?DqO:</aX!8YEUEl7G=aLt@1^><ЇQX܀	\0}?CwԜ]=EW\rNR+N#]?1oG}.wG}%6Q#@.h;N <P䐠18t⡼uπIM!]tU֨D7q&0ܛTz\0qH؇tI|`6lIeRM^.5ue^M_\"7_'o+0sQ?FH݋uXR+J̢O\\\r7`N|EtHwY_ݻOa#b@GkN0 SUh7=\$_0cx7e2qtDp0umbر*]^蝍%7N?l/PZwO=gnVŝ veթwn1a^]]<p\\ޜ&AzX4#ݯ7د_=k`Ћ}!E^Kطt2_Cط\\IX3طѝ:%՝w/PQ.ęGݬA?[ݓ'wd\n9p)Ƀr7vj[@!w^R1ڤ7[e;qm[wkش/5٢r, ?b']r[\r/5ݰׯr.%UZv-l6~BCGhS ougMp,O?Ddmw?]u! R4V_!xIw^H9_=>}0ނ)=HO_=dء펝 d 3]_6:xDx7BӼ\0]/=vIJ<AX΁,Me;G\0002x|&\ntSc4u}pv]\"9x_Ob'SK(KaDXSmǍ煇3_<;TMM\rHo*_-ޘR'NU:׬Hڪ%\05g-t\rik5\n`Hsͯis~qOo\r^m>\rO/f&?w	r3*}t󵉏<wO\\eV&d%}!.{Jfם&Fx8+R:,x\r^2uV]qOs]x=#CI}e1bҚotJIwP\$v<Fp<yN\\\0=+5Pl\nSȳӾ\\6탿vi9q4g#|ԤvzK޽t//5j_Io%!7ItQk\nMwLMpu!0K\n/W]ڐ[﮴jz)}\\X)O>}S8@\01G{?yUaG//K~K-O_7}*Oa{z%/,Ե\0#S=`7aZL{H^>p7EO\"/{=TN뽏]G.ԠW?]O߿vLVFʝ{JTmio@xO?z/0OY|.Pb|+ۏ\nJaW/+!?\\V_W|=Oʆ\\FhaboC@Oq|\nzO2j=EQIv074͈ͮ7=z2M=)M7[!jJ	}^wmhzx9{ݶMA|>o)0\"Bx}40K(\rmݹykߧ1|OnPt謔{Cqۏ\\d1ҟa.u]t7cnYDEVd5(}	g׽u\r<T\\\$cԫ*T֜;[q{]U}ն	_t5udkmq_޾7K>+y{&a?>N,5Q^}ѡ.}aEr>+̧@n?ce|X}'oce_vo{}-x~S_=wn\0;=|'8']{CÏn?[uIֱ4)~=uM=1]>F\$sRO\rMw{/I]?5N6uRyJ tZ\"ptV_ȩfsۇozfɹ7̫fVAY\$|z[nP;[\0[/eCҝO)wUBVW\\pT]_	G#_v}5^M/\nDdK\0B\$Qzj MD)5đ4!V\"XU\$\\!W:2Oʦp!V\r9bʰ	U1J\$.萧 p@.|\0TY)%؈V\0Jfs\0R%fp4\n\0GVj1Aq\neȢAtm4O)Ay?\r[^tTD@^GyHה@i%\rY8+ʸ_(٠E,dW<@WArH_\$;|	Q2KX-B˵wPCYD2%WT]2soZT@)jurKo-\\L`'Z/\0nwsazznk hlpUaKW6	\r\ni orV9``:z(.h#-<Nl[PtK5EZxdp\n+%\0	@UtixXpj7aOщZh`NUŁ)4ҲÈQk(M Yb-D\"8%@	G.db.\nzpW9g&˰C\nв^gi7-XїV\0\n{ӆ,m5j1Uk\n_`-,5e4y_\nق2й3ɓ@\$lFaߠ2 f\",Ba-0'Fȍ.h-iW~U DҊ`ќ!V84̒\r+I5&L/X3_%{EZ%s(6MQ9qYtfغ&\\M:86\rั_A~X\n\nXM!5̑1p<v-eg5Uk3\0%?<-</d<y@M0-& Vh	\0|c?h6c`+s\r&!0gj_=3P ÃٔCE3P{جB\\&l(7@Q\r'0B'beXlA'N2{m=xc*>	lZg4Gg\r)\0	\0APA%j\0\"Gg	F/:dyyH6kf2dfKr`B=ź{=F~̗baUt}!B	&<̗D2^f[%?F	/c Y/B	\0(AmB?\rt*plȡY\0+4Y!VIB#w'EI\\^&?(M\"ÄzZZ0\0Mj\r-HW!4BC_	 Y;8I%i1a'z];7L	e*霢+la73/_pXAcna}r(:AمU1&&́a'F3nK/`SX9Acu\n1_p1c?\nUa(\0hBcu\n3&2lLG\\4xXa!dj4Vg)Ն	-6з!+	\nk7#Xޯ6LݍZFm2(V\"EuX2\0cUų5&;,X\0Kl`=32VB`gjz4 	x׶*\n~yZh_t5{/`\$*^	Q\"X4dh֤!L<fV@ve[b5!GX^0)<&H/D0 A.7lFT!9K򧑾~L҂\0My\\=*[0.wZቚZke3WfU+8Ud2_W-SPYPF*mH	,+6fRY3a'#<a\nUWB	L=0ɼ\$'Rȭ|TVHIAOzv}L4ن?v4gN%V.\0D;lz`<	؈DKgQR\"s9WQY4lzνthuz&c&\$cD!04^4M!35%WhlbZ]?bZ{'1\">'٣iΕt#\$h@IWZR.ҤYA&ҳ_\nɝEeL.YćH,3NtkZ|'i\"f 90H'z0Z)'ԮLk͏ҲBFa1O\0+ V&	/*\0XfW0][x?M)2F!fiI\nܤ,Ԡۙ<0,X]Λ\$tB#tխSHh~\\\\*J)nDNDѼnTbA	R!{u)^mzE!ntf[{6q֤yFƀ/\n\rB:<I\"\\*MhC[o>f #pn	CK	q<:`6ߎEK4\$,ة@wUQ4T\0mԈ\\ZD1ٸ3%>`J1oq{/|krckj|qoX&aFY%4~+\$>;^|[1w8vzC @7o:	H!Ŕ4`\rJaD|\"MXPpܻ؋NYhXOR25;8){(>0إ*A\n)L-ba/w0JG8.C\"s1m@*T\$w>L!M}6WU,l=1!Qh/-i\n<_6GFFp:b6-܉*7[VqH:G΁FFqJ\nJR-['Ip\$)%ÌdIvd 鉣q@LSɇ/ Ep1ɀHSNydM#F=Yړ&i_Q\$߱ZAddrƼld\"~!;ne{ЎQޠj	qFΌsFrwRͶRqQq**pJnL7 Y'Fn؆,^GF\\({Vs;LۉhRӂKJ5җ#C;>Sv5[#O~TXe@)4ݬV.8LTUFLفcdF|8lciT~6kUqn4|n7jREo2!n)\0!g4@c6',o=6B8^=m20KxF!TȦqXQu!Ndh)?jtB2*(.RAH,Z'QB&\0֛9݆v4çxmʞ:=xnޫA&:[gbUtQtN:Zn1Q^[CvpS(禮I8X(*TQ#ݎg/8\"_iq;G?ҋwn\$c>PmU㽀dqۤxIGy̟i	PQ9Ysd\0]<Ǳ)LcAX/[p%D@Ju|ziA;,u\\|~CB>8`K#ƅSPۉzOQ\0W*M~E\ncǸ#>t1cG	I}Rx5ST*XM\"n;J\\L+\$X¨̭{1kIJ\$\"Z@u8_{uk.tݏ>2	dPS QNgv0sjdx_ov\\mĒ,FQ|v^SY	 c\$|v}m2ǻmZ9&-B.2H\0=<ؐDd3bn&lJm>q# H\\j	4@xCCzSlqI?\r	'6GtG!J\\^Dkŧ@bTu'(ȉ>ܪjR?HQ2˴ڟU']Rl/+1/O֞F%}:iG&Z\0n	`)`a\"fQԋw6~*#18'nx/dc`WQ>Ї#KN\$N!O(@GyE\$)F[{!T #J|AX%o޼w|Q4n`ᑨQceus2#\\gIjGjj+TvׯDcI*x02\$}j?[tq_\"h% ;W\n#Dj&LDtS#F@'NKpEm\$cIQۍ/MR,za4bOR{)Ly`s0E#܊)2?tK|gO`:E&f=h\0RR;uvr۶#o\$9Ig#RKd{]yك^Y.IM;\0'P^<#6*|nGYISXtKN{2HbUD(ޱ3ii!oMID|Rzޑ'wmG 5)O?ZqP+\nF%?W[\"PhW\$I'?TJ,nJGG\$؟@*T`Rs	QG8eF˔T\$y/]^\0R3oi#))F@ne)/Y=#RR+`c7ȆT`?iBFv %'Q8@/*^4ؤz	=\$}\0M<ZO'\$mB0NA\r>\$gJod+Mdr2ۏ(aZS1q9?좉BNMRtʨ@_U8\$BXb?̫aͯ\0>uBU	Wn\0%K >RHN4:I8}\"x!uGI=)	cwÝUe(D}@J4cL1lv?W|T^eBiώPٓ)O.SX-'0ДN .Xkb\r_z|aאּb#v@NXt#%ƃTz[Bpz2VdB!VhuTIJU|xH\0BFBπ@\\\n9FfI X!\\c,Z!-Cte	薸Ԕ	՟(UPҴYjRї+LD\\H\0jզ\\V,ZȢFB2VxxQ7PQC|%-q`Hˋ'r VZ]Kv)_\\)q,6o. uv垊Ww	\\݋%Q˓0,vrm;e.y\\v't^?-9aIit#q2;>{[4+e@^-N^0y`^≯)i28HE-B`c\0N%6{ȘX90il1&p|%	pC61[\"uC\\eVXwl4&2\0XI/2e3\015WAa\0aT6V0a0`YLf0U\\i0rLZXB3`y0z6k ѱИ.NY:0sX3ЈA4 ,eY3(RρL\$,HlkgsR\"I`o\"0]#Cƃ1S4:hp	6eb41eU؍Z3h\"4GZWW(V1V6!YT5A}k+&9D.U};-*i&\$U~q'bPD(ZF1*	=Prq,Y5gzcQ]CdZ&Rv0æV#\rj5eP]CX˰+6	YHH<ajK\"TPX?aA\n\$ę1&i;)7H.2'+iT.\"l\nڡȤVcO36mhD/3n4|>XHR}&soEi\rRׁ+l%!p\$7N0^pM۠OE-zg%1!kGUǧs\0lz9B.K/^=M7fLߵrF|	lї)OZR#7r#L0)'\"^aԕS*S/JMbuq!W	sҔ&FёƝ83(9|fQk*p5	t*ͩ=3w\nZOS\\Q5Nh#B-M+Kӕ+K\$=v69!K[NH'ZXVOD;&MBFnTfoҝK0NU2-D귎Qn\$e%@-\0,\0Չ%-ZYt)f*+>B8f*EwKQ8N<B\\Kv\\;7tM2oLGNe2G@V(@@\0001\0n0\04\0g8@\0pZ8P@\rN\$\0l\0Yǳ+8yǦ\04\0ǳ@NP\0qS'@ml@N6F\0qiӌ@7\0l\0q|Ā@\0007Z9ps=Nr99/799S.Zo8sg?N.\0s9q4\0S'GP:.t|Y'N.\0m8Zo8N:8s@\r6MA:ud3g*NkI9ד'GNg\0`\0gΠ8t03RN8\0d\0rΠ'aN*:ryS'4\0000\0k;:sssg_Nh;vqyӜ,N:Ns`\rрc6\0st#3(Ŝ:jwNǜ9sͳ'8Ρ\0uͳH~i;rYӾN\r:riNa\n\0y\\Yǧ7O	-;wiـ\rgb\0jsTٓg#̞9t\0@N:JryS	ĀN.+8ڀI۝;r@\rN˝:bst	ᓓ'SW9sޓ֧fNC;sڳ0JM=jrsO{6=rI\099z8 'DNܞ9tSOW;|i瓛pE;yl \r'N\0e>sy'Sτk<zxyɳ'Ov<}џg:F|i܀gNa>Jr<iIOO<{IœiN:m<js'n-t9V|Ti䧴N#9g	>qy'9Bw4S3;{Dݳ'T[9y\03'Zc9V~)-NI%>:uiNm<D!O\\:siٳ'6-:v3ߧq%h\0}9'P@<{H\nP4A:y\0˳@dk=t	3gO?NuZ	SQ=yFN?r9sYι>&s9Q}:xڄ%4c};u3t=vMYʳHD\0:JrS/Pi:^߳ͭλ;~z-Ӵ0:q(\$N4U<J93/Oơq=j~	yɳ'LU;<ڄӝrO:*ͳ᧘()>XУ=uZ4&:t\0hSOB\"y˴5'φ9:{\n\0p@sTSg8N-?Vv<ZSΡY@rY3'P|>6\r蓽'oϪWCRzhO\0M9s|ySP\0m?:)ʴ2j@}zN➛9v\n@N?D،	-gP7!@q])̔='P;~e\0s'U؟Brvy'N9by4\n֧n9BZq*Sg7S9-\0I'/Η;9{DS&OWD|Tj\"3רP*a;4'7d83gѓ=2r93hQ%Frs\0tDώaBx	N08-	_K4Y>ޅZ,k(UяD\r0hQE:S\n3X=	(9O;#;rZ\0gЫ'D۔_OhYGj͓,NnO=bx]9TUPQ@6q\$z~I@^	i(Dʀ})4d)PTT4^\r<)>NFΉ-!:4NP.>{(wCI3'&R!cFS}O>*Y\rhΗXq\rZSgN;IE=!3t:PHDUt=V#Mr\rYTK\0ԡo8ySgNWGmTC`P#E~}	ZM>KzCr}\$9sO%9khJQӤgQ/@P#Hʍ\nDPK5F5\0%'Q٠EsOS>Vm;Th^B	-4<Qs)> IͳPB};&NLgDmyt\\K\"vSIiL2@BsE	U:tUT(MCS)k=sE)Y۔bvR:*|3)=ˢ:2|\$'PU=:yi9QL\"\nt((|҂;\"uUsR\0z</mbʱPze1XG/fb7)TYZ'~}^,O:b8JiY	bى5iYL\"V\"5cR@Jl4<)SiMn;nCf:S bl 5/)LB`	U~y@S1%\\8Jla	Z4Z֩1_&:6-=#P^SJ:n\r)^_	y7~Wt]*tf\"mINm4i`lw<]pk4~]PZi4%L2FrD	0&KL,p3V-X->6SV<85Zi312eۃTGQKbJP3ntµQb4DܱWkf+YSaU͋yvp\0¯&;P16.\rjbb;\0\0Iٕ4`ǡT=&Lf͚6\0\0EmDJр)'\$83;,B[`38iS`nٻ\0V\"\0sk1@״Os_Uf/afWG~}5m#يӧJ&\"Hڍ\0aj\rTMPҤjw#ؙ6cC!וּޯ}#M>\n:!SV_RfR]ße3U&Tby`U8OC˖\rLBx3i3f&J2'\nj;i<}\0C'8˧@+J,nC0DW\$ǥ>wVXVS|hM V\"I'ĩ:Vh6֎,/f\n3Val^kMOY-/Z)b\rM<	0&aڣ\0M_?Q'pKCqTŋp ߴvV{TZi5OؗFf!U~CeURCH	\n%ShUU*.EM)ǵCRX5P\$&\r\n0QUK7UJ*/jb',(u?_UWkQj4i<g\nfU8^0XI[]M5SxSJZɰ<UfǪhCRU9ЪDfpMj#46jd`=Y6abV[dUpU7U\\DVUbqMUW1ąsV֭T*ߩTҝK15e2Y&́[PQ&\0CV~SrcQ&%dL.vQd	eX^p!3U\"nBTa}cT\r`ڒx@ZcuTƎ*BWV4/uQL]bZhSIՃUF\nUB|UfXUU{깕WZլfՋ=Vcy*ƌjSoY\n-\nl+d<5a}ewM}Z:ua'bVb07Yefj5ej\"(EW/U* /VY­=ek0ց[VZa}կC0'rc26q ڷYC!f\riգZ·IWug\nlMjͬZZAjUt_WbU3թ6a:v+UU&0kd0\rg\nZYg\nڗV\0&V6\rRj5k쫠{Oxw+aT\n\rB2m<*A1TRÕ؎SFT\rbzxK+xAU:p\nTV3\rocӬ{Zڷ5q:VDEMjqZ\nVQfuY\"U~\\fSudVbeV\";䕠7;0gJ0٫;Fa³YQY%tu\n3euh7U֑hƥif~+֚\rZq|K\"i,	ռVu5kQC\\\\uݪVeFqzʕ+֓]ik,+3[5t:U*C]⶜\n,*SBk[nm5W3yCkqCh6̙|%`}@@\$׺-X:sOv\0pwWFV9\r30JW&]|\rDPH\0V*0昬0*֌`WN܊\r~Wӕ̪R9:5̱Xa~;p-&_8SɈO{Ne{?V\0N\rp\nmaWgO݀\0Lɜ\rg`vx,YY`)5ZΡ~}yY/\0l1fmC38'}_&:913, .N	4@inO@y`XU=XlGaP<<\nhTCOśv̖kBu{} ݬXOfl;Yaګ9=u*X&[ɢ|,@Y+b\">I쪳ay\\)Uu9\nzj&`uLQ,	aUS\nv#lH;b6ՊZXbOձ儦1l\\8~&5Sz޺P042;)~\\Xg~Umu-kX۰caYvPplqXb°V-:Jg%T<tVUf&LO5``H_cSWϨFM؈bcӺv}vs	xrȓ3ڋ5Il\$*Bn@1p'Oa9'lhPm2{64(mOfCVle,zUVuYT?J^+:0\"0'cU(WTh7X>eW}I5eX1jYYzN\r{#vZkA\0\rT5=MɣUŮ^L	%:;Zf\$&HL\n*9Uh9_Սk[a|A[aUhvU\r\"6*TDeRr3s\r@RLJ}5V7Y=eu\n;,ٻ` 7o)Qy\nN2~Fj=}-T^gJ\"@JOZ\nj@i;2+Aܲ*{;ꬳC: L\"k\0+D=[Lճd\rd̉2oe`=wjԬ`2q5BE\nbsR=T:PlEĸ~NKfYYYʦi`{-fblvoc|=t gְALrV+ٿjM;XAY;[H\rpͫ-gYm1Ʊ_Tz9Xaw@+2c^\". \nf`{]cجs`O\03n^ӦJ2mfڂ&ξ[D-Aj-X֎tU5Cjg%Sbcډ1\n;bYV~a1jݝPv08`L햒dw*|i˵EkVY(Ȣ06 @!Mkͬ-\"G\0(PSQW3s@0ŭU~9\$#A:;*Yh*ٛ-n[lsȠ !5 1ɀ.#3ֿE<J\\'0l\"4P̕0?\0001d\0^\nĴg<\0\\TV@Y&4%;\"]m\nlr¼/\0kl	e!K[8Ml)x{g-\08l٨P6[@\0bཇacQ6AT	)Ԑ[XmX7m-Tomnʹe6-hmKnQm[SmKoa{m-Ֆm[DmhYmmA{)\$@mڐIېI!e[k-ۚnJImomIѭۗn\rj-RnV0V-۟nf-IVm]m-\$-[·Qo&܌+u-RnISoV[ڷonލ{7ۄm-qVmmv-K}ȷo]|Э巧oڽ[zopMk{\05|g[pZvE\0[a7oܵev\r'm6 sD˅\0In\\2Yn;y	\0De4Lop59\nr4pf⽿ˁ(Amq*S&[D1p4ۆ7\n%Oo	7-\\O<2n2]q;t2nz\0C&vmɸq8[6hdE mBE{v.L\\?rb]K#n+\\qrrv=W\$g\\r!r(m\\nț-nܫkr:k6.e[_s6-ۘW3nbYo>ܭۏ73nK-Ycm>e{o3q\\ qJ}{78i⹫sE{w8nֹrMzHw8n{qU뜗=vsϫw=\"#\09t0C8vLkS.~,pnitҌۥ(+w<.p:7Lg8\\>*;7HN.ssۧ7A	t.kL.N:t]ӹDuԋ.Not櫫T.odt{V.N?u*{<M9b+Z.VuL⻮w\\.NUi8=k3zu]w`.Nhv1݊Y:Jd.ݒ?vR|˳wf\r(/bdkg\\el˰\$i\0@ivqK&@]&\0ݝkW8]ĜvE͕j\nn]wB5k ]ƻ{s+wpe_>=Y3ٻwnt{ӌn]仏Gj{s7Y.P@vݹw~nҲ_t]Ğx{v(u2Lk^x6l×g\0 Ht{]tVHsGOOx\ru\$:gl^uzX  u\rWnnx뮗]yJT+-ۻyJ,[c/OxFr;wf]yVk.0wի.T< ˷n.Q;x\0=pz&\0v\$;7xV]CczV}Wn\nޚzzTkӗC#w[woG5w}ީ̷'}z e6 psk_]pK]k6Ζ}t9lx[\rl:WWC\0Ou\rsXe0~OA_]2sWCT\rHuX\0Kk']Z\0ض]V{XBu}{f\$xy_JtLjL(Y%[2t7VWgFI!PY]%\nv	*TBZ.Wš):Zf%YUVZ7:VAfh*ClU\\ʅU|ogׄ)\\;{ڵ|okXMĚ7a`\nh\$)or1k_\n{!>{4@\nрDV^K5ReVƥwcp2^05K7a4Wwf-p\na\\ƫWd-!E*_}.-d۪XGɂ8rʲ^0ZJ]7Xp!Tf\rh`͗X|겫+VY\ryk}mmJ1%W>s鷶a1~K۷:Vv+{rdFJ5_0!?*ڬy9ZDo\nPN8[!U筑Yve&`Fo207g,u-KXꇈ!1616Ρj,_CQE{\rچTzL[3k{fBRk ĳr¨d!YnóES'h<fթV\nt`)mlz%Qƣj\$=zii/4[	ŊJj2Z.o<s6E+_wHZ}Ύ0;0-`mޟe#`r<jp٭g6 HP&&\0005q<\\#~	ͥ-3#\$2_`(S\0'8 .Q`pK̇j&0N~a\$*\"Rl0qpP7Ւz\0`3^`}%ۺy`x:\$PUS6x<F`+~=AV\0=6߃{Υu_\"r\0¤lN@(D\rp1+@UF7/Mb.\${C0`L6\$.K;]m@gka`P	w MT6sۻPp6[^p\0/8-N\nl&AE⚺!\$G\n\$#ATL#}v酌Ei0;,,pF,Y@?^[H3ø.JH9_\n*T}HFZpfbajQ 0ڟ t~tXxd;h06EӆlgA-C\r5Oad`'6k\\	x8-FVpabe@ɪoQ0Ef\"B;*nAm*p,;u@a6RqdSL.l=cf,Qf!-g2dͣ&Sw;`iN`v\0\"R va!6eHQOO0>!ݾ4Xb+`{;uwbRȚT;ߎCPV#4)]\r7lcdb|B>ąKHxbď\r@ėlB%,8bYI%Kҍ3Ġ	a/q!q\rh2^&bt\0Q[+8Êpȍ|YN'\0A6aa,x%\$8hAyqnRAM@RqC\"\n}&bwtptvib@Ő|<WBf`?%'tW/dmLObq`H5#]F\r.+*oB8EŨݣ>W~1O+<#\003غ`X\r@00]ypDë`apR[+uP @;:-γ\0f8eclUv0e6\0bܵ=bӇ4х(\$0yG0<d@+#AKo#.H1jPg/QGS\0004");}elseif($_GET["file"]=="logo.png"){header("Content-Type: image/png");echo"PNG\r\n\n\0\0\0\rIHDR\0\0\09\0\0\09\0\0\0~6\0\0\0000PLTE\0\0\0+NvYtssuIJ/.C\0\0\0tRNS\0@f\0\0\0	pHYs\0\0\0\0\0\0\0IDAT8ՔN@El϶p6G.\$=>	w5r}z7>P#\$Kj7ݶ?4mt&~3!00^Af0\",*4oEX(*Y	6	PcOW܊mr0~/L\rXj#mjC]Gm\0}ߑuA9X\n8VY+D#iqnKQ8J1Q6Y0`PbQ\\h~>:pSɀGEQ=I{*327\neLB~/R(\$) HQni6J	<-.wɪjVmm?SHvƩ\0^q)]U92,;Ǎ'p!X˃LD.tæ/wR	wdr2Ƥ4[=E5S+c\0\0\0\0IENDB`";}exit;}if($_GET["script"]=="version"){$p=get_temp_dir()."/adminer.version";@unlink($p);$r=file_open_lock($p);if($r)file_write_unlock($r,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start(NMID);}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$cd);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
lang($v,$Nf=null){if(is_string($v)){$Rg=array_search($v,get_translations("en"));if($Rg!==false)$v=$Rg;}$wa=func_get_args();$wa[0]=Lang::$translations[$v]?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}function
lang_format($hj,$Nf=null){if(is_array($hj)){$Rg=($Nf==1?0:(LANG=='cs'||LANG=='sk'?($Nf&&$Nf<5?1:2):(LANG=='fr'?(!$Nf?0:1):(LANG=='pl'?($Nf%10>1&&$Nf%10<5&&$Nf/10%10!=1?1:2):(LANG=='sl'?($Nf%100==1?0:($Nf%100==2?1:($Nf%100==3||$Nf%100==4?2:3))):(LANG=='lt'?($Nf%10==1&&$Nf%100!=11?0:($Nf%10>1&&$Nf/10%10!=1?1:2)):(LANG=='lv'?($Nf%10==1&&$Nf%100!=11?0:($Nf?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($Nf%10==1&&$Nf%100!=11?0:($Nf%10>1&&$Nf%10<5&&$Nf/10%10!=1?1:2)):1))))))));$hj=$hj[$Rg];}$hj=str_replace("'",'’',$hj);$wa=func_get_args();array_shift($wa);$od=str_replace("%d","%s",$hj);if($od!=$hj)$wa[0]=format_number($Nf);return
vsprintf($od,$wa);}function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hi'=>'हिन्दी','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>","<label>".lang(21).": ".html_select("lang",langs(),LANG,"this.form.submit();")."</label>"," <input type='submit' value='".lang(22)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ja=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$df,PREG_SET_ORDER);foreach($df
as$A)$ja[$A[1]]=(isset($A[3])?$A[3]:1);arsort($ja);foreach($ja
as$y=>$hh){if(idx(langs(),$y)){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ja[$y])&&idx(langs(),$y)){$ba=$y;break;}}}define('Adminer\LANG',$ba);class
Lang{static$translations;}Lang::$translations=(array)$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
2092314303){Lang::$translations=array();$_SESSION["translations_version"]=LANG.
2092314303;}if(!Lang::$translations){Lang::$translations=get_translations(LANG);$_SESSION["translations"]=Lang::$translations;}function
get_translations($Ke){switch($Ke){case"en":$f="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\r1rNQ<ΰC|~\n\$u\rZhsN(fa(L,7&sL \n'CΗt{:Z\rcG 9\0Qf 4N\0;Nl>\"d0!CDFPVG7Efq\nuJ90ar#uDC,/d\n&sSsu9GHMw=l8-PȂ!z9#dɍ.\"f)jJ\nN,\r:0Cp΂L*<(CX#|SFkzc9!L\r\0#O7txk\nO@(C\"1ÛR;cBġ#\0@`@#B3:xKȬ,}BC ^&#pˮ3|ܻ(ơ6[{?\$X:k+x šV=45#(.\\\n젡*,1-odcxؒKB]#lR⫣-+\\/.0H@;7\\U\\`P:U&:30)4Nx;\nTC\"}:8.9`PL2+-`#cofފ\"`@N|7rݫz^egkdJ9r()ِNkP+3-JѸ(6<o:ƴٱ؄뺺)@8T05lMW0v74-;ky0*զ}oK,dLƼA06Lı?z. ؓ3`3P/02hSw\"|9ξu1{h<ܟ\rW\n\r6JdPIn#}\"F`0p8@jR*MJpS*gSOh\"U-/0*?OȝLO\\KcڛqaƢ\\c(Td)ɇI)+aW\$REfj7VO6)RJ\r,_B:6ȐIP \n (@d'(&FX8U\"Zi95dY3l	1(I<CN,s\rr)2#]\"\0Ny:`ཌྷ2P@Xڱ`|Y\rb:Ze(i\") ka`KXI_dDֈD|`]2t%PrA aW	u\$^ȴ*Tړ2BdR#dLCl\rY|<19TO&.\"T\rSjOCb8n&*qfƌ{H\"⊆yHr5\$`#I\nюxG,B\n8U'h'@BD!P\" E	I%OjM7@~+fL'Ah4:x7#a\r<=**G),ʣmE(L	D)|(ÈW52ZUjM7T\0PV/f3I1:ShfCg\r\nBHgkIWb2ۓG>c0\\ci/^[BRy+YD	MpTdfE\"͍M*Z+L+Ne	id&	|d0x+!\\WbIlʺd%uL3Pʍ!at7T0W,9X\0ȉYIXeB:t׵aJfidL5*\0000F&ֽܤ /\0)rȶf D?8	-CfS4E'6wQ3:4]ʻf]<н\0c|Dureߤs|W6bgs	f;ixS1BL(SªqI+`2-d	a2zC{=\\+qf˘8`qIF>N2l)&vlc(N4,^lwq[krӤU\r1m[8,[;vmL\0g{PyfIUJ9]ˀ'N4U6Ƀ7c,ݻ RӂA+m5@БwuvMDSzr73Y¿\\/C]3rolS\n*Azdv9yi{Y/dۨT%Zgx=^1	?{{(FØytݻe+PUo MRxwu bVyKqfd[{88(\naWW\n-7-HC2ʭ~;;؄,|^Mp7ϴGV}壆H@t0;^a@F(O:EoCFK;\n4|mo0>Bn\n\0\0#&fÈ,3\$JzfDN>+F&&n	gW.\n&мK(PE_Еf]PW@\r\rƺf\\\$PcOqŐ',2\nD72 2?PrIq\0-BJPX:v\r~̉9#bqs5hqz/\"q`\\!0p:-\0\r,+4.Ej\r,F0Cfy`/`yÖC/z~U\npuÆ/d\\ҍJ)\0LE : ^p \r #^.UqyF\n9eV/&;J<4(ŰOZ+Y+8Xb\r'+'Ɛ!q)r(TƐE(DZFc,&jG\\ᎆ\0rEi->3kb-\$\$̯X&00J<@pfhBs@F\n*Tkt(Cn`";break;case"ar":$f="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`jR[-sa_Nvf|I7FS	;918+[x]š'\$g)EAxDt\n\"3?C,̅Jٷdj=v=I ,΢A7i6LS:h4NF~.5/LZuJ-xk莿bĔ*xB4:I(FSR2P7\rnH7(9\r@\";\"{9#,d8/i,PB̚R:6rޞG:\n̟h\\ArٰhA\\0b%\\\"BUm	Plp-\"<Aqp*+DM0bL*%6mT\$hBP6eRB,I+X]5NKZm%fW,IL# DA[1Q1n\0cE#VKY\\sC XнD49Ax^;paX4J3(ux\r*(\r#x|[@U*TM=>SAD%UZ34u`U;%vZ	\$P0Cu%H!RK:,ҮK%n&9e4(JSP2\"0:0\n,LR\\i*0kSԔU\nJJS=UsY@V[֔Z%.6m\r蠃7B&|ͤ&pZos]BS/ES:SV[\\ݶM\\)ߴ\rcZbף{g;95'ėN4}kX˩Hd(VO.7Z1Q;f	 \r9%t%k\"ychAp3 \"sD7Ceet7-6,`TlfpNH/3`ر\rB)lW+\0PT\r)EAif`o 9p8aCF@u;9Pd[fqt%X\r٠6b#<!R\$UARD3cAbgbҮj]+B@KK.Fi/ht.ػ^|ur\"8\"3aP\$tCkMӎ!tEfkF|MڇH<R@AYъ(b/16Zpa\r,qso>H a P6Kp\n!'^DJ11bGǞRRG,4\0@\n	)SDt3LG^\r))\rQ-=A\nCtscsq:TxcxQoY\0007z<O@R^RDZ\$b{ϒΪhh4@wxn\nZ0uʷ\0c3\0A@uPP2#,\0C\naH#VjUZi\0'<ǋIhȨڣ2xHT)M~EEIϡ0&DЛ*z\"Ԩc`t܁KNY%7NuKqnPTdHAXs&Yׄ@~a;\\G]zjż(sdLy2<I\\4B\$m~Ka9*A9FpȉrQ:+(p.{Df8a` vA2 @sָF\nB53FWx7:&AfTq[))ndJ1\$*\0PO	*\0BE9l\"PsR\nşR	OG0	\nnlPʨ<̛bHѕKDZM91O>,kI.r1`F;{N&YV1*AZ^ygZILT1\0q\nΚ%+Fqb,fd\"FAݓLq%Ǆ9*I-'M seS\r! SFpCH\n	}Ihtu0V@ٙ^w!@ą[ȁHsf*s!y4ɂ ]2V@Z0E\"R>Ck \n9[yrJ4	t`wZpb\$>2粗رxMBO\0^\0.	J,\0C	\0r_2hUҝSzabo-\0ζ(XuިBam],O3g.veka3G6`-qa=!z.GOeI \\[S0&&J9V?[r\n\"K%BmV%Ie,(B6\"T0R44!v%bB%Cx')AVMc1/%ĺzvpdLz..xM&XVhIMN(gyg7o^oI.ﰏAcL#cNܩPg	V%а2P\rtzPi΂\$fVKD06alNHx&DdOeRMdMLQ>AQzxpư0 Jh&\ro,?NBЩ\0[0׭X\\ܣsJ+TUT!2ɍ4؍nU0G@-xxBթ1(瑚ndq	}\nό(R'yh^Hz@V'n`\\4OvGΤR0)l q(2r\$!O Ρ!s!R*Djjxd~ʆHNIp8!@\"#<eL/0fsB\\%^e/&bn	J181ؔQ%]2G<4	޵XOB[&~6\$# \"άBRpU駂͢#ѥ!к2vϱ U@2d+/2ABrr1/01I2\$1'2ceI'B vw|cvQf@Q>\r1s26{72\n.46Āp30G=9Ƴ\n&{6~'13~u3c<B]<̑s:sb#>sRP0'8;B:@#/XAT8T\"n	d,\rtC4 AT3h%J3%cF\$8>l)>tw@3G4d}1eE6Fr,HH+?-\"\nl(6o2#51@Sch\nq3>@é03^i;F+ۍ\0#IB]	hWJ T\rV\0A,n#̌\$\0&\npS1M 3K ƢK`P	aSzFS uR(Sl1.\0E3epOZ\rN5*\$<n^A\"B&(fhOqAg\0SIy,K0\r\r-W\"`IU%(p:8B 	XnHJad͉g\$pGOu`TGOC-1sjVa~+BIM\r	qSYh6j\$g8vƸc.3d_t`I54k)RZ\"Mj+a\r;tpMT.Bh	\0t	@\n`";break;case"bg":$f="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9\$+JlYhmrF @#e&a9kG:~drUIzay2ƁѢ^ЦGeS2uJ\\nEW&oI\\qՎ=rBz~̲7Fp0bv%6ڰÈk;\rlJK=/\0X+ĺL=\$\n\r\r63L[ʏ;qlq*oYσhA9sr] ˈƹ\0*X7p@2C9&b :#Px9x+P9ȯ&G\$N\\K菸;=J&;GmZ7t\$IBҲ-S<oSƩ`\"%C ˈ>FRJF̦Yl Ě'm^qskR6YY1>ǔki(S:+^Bf6+2\rH*284c0c9C8@0߲ܻ/:\rx냄p8NSy\r\r0C@:td7*Ҹp_dJ|6U3Jl4px!Z3\0W.t,Q\0i(#鮪N\nE7]o=r#\"\n)5,P0Cv\"0Ʒ({Jk~hs6\"^hH.\ròIYPۅ]G&Zҳ1\rr;}qթH]ܒ\n!31Eg'UjsZ1;vuuݮ֋ ֥5%#>Rzr>/vڄyB\\)F!\$甃;qK@!/ZkA! ̣1M\rBܻBK5DOP~p6p}Mo6U1'8G1!+D\0d	IwXPOilP!C[q1X@b9%CV\0m36iuq,=)8CSjG0|ڈf\r!IY4X _JJ>Ca	])a,\$<FzY(G`tNuM)UU0w%y#?Fk1rS\r28EF\"=r-5MNXϑ yL\\ieА.+lͷFE; N39脎v)yg1A@OUG䟔\$R4^N')'x)T;yYd}SH\$qOX*XW=J#\n`\"΍Q%@20@C+'e,b٪_ia3}/%nґȉ1Tng# @1OiV^bi@-ScM\\QJ93\n0\r#TLA2rM%`m`o1@\rT{klDPi{\r30LP	BĻb\0K;`*Pxna7Ci!ޱؙ%s\0`([SuYj̶K#i3jaI4¥RR81:ӋBb40\"e*0\".(؄2XmQ6#\\[s@r#Gcy}@T{U\nw8󠷠p	8#_c*k39b29Y:dP/b))gW,u-IRêPl8>\\Aulp5ڍxТ8-.<\$`/yT3o{4qv'z\\v\rN{ExATDЦ'u2CUDl  \\QvL^R*ZRf{/ 5\".ICP+ d<5hla,-7#^=xbH2t;<\$Ji%4yTX!eūbp>w'/>d!oOg,\\p1R`9lHͽ\$Nй;l0j8Vs_fRbtgwT-(:'J<V9GHtpcaQ/Q7F(AFF\\D5b9O~n)Nv=nh,.y?wS(w||>q(䇰ٮ:ܺ՗d:v:lC;(e&E9A{OE4lbbĬ\rP\"oDf&ECpS'Huf.DAj1n0-@kX` 4Ķ5L\\{C)#gn.B0r#D\r\n@/6&N~~'Jb}'WRO=|(ڈĢ# @\n 	\0@ J_5DMM<X-`\"mJ\$*Hr(@G(D&qLA.BL\0Mvl(ed4NbA-Hmṯ2%Q7:!)ȃ,1-j&g(\$d#11ho\r9Ms%jbr'ebV&1\n6nmxE\"ZEY̬߱zk|okŃ,(>f\$v%!b#|J\$sc	ގa\nN<ƺ|#\$n4ΘpgINPlJ6+ĂdUc͢\"u&'Fu杣|?\"D'\0M&(~⯓*mo*&Z2'.ڰ*g D#\0002LEzGp%>JGϲ>@J5cC\$9\$ ~HG.hmK(8r12g2q\"E0m\rJ.\r\rx0W|\\(>L\n.\\I*r+VP+ӑRi9rcCF+LY,2Sh\$,ӿ\r-csQ̈?9+3BhS&-D++4>O&J+#)8!\"8\rE(!?u?MBMA#CǁDADQU4P@T0)1&\\>.;c[\ryEAǽBԅ=r@+CC%u%vHdaFMlK>>\rw:gBsMC˼*3B\\Ѓ	)zc3tJ\\-*\\[P7R\\|0P\$Pn~H/>T(A9?ʚVK.#<k-@%QoOrs79\nkI#qX'75g,sꔌUYʘ}4#IhOS\\UV\\o]g٥26~s#{z\$@@pJ*h\"odti,WHZaHFtVVJu16+a/\\	\\tcIRyPy\"nC>5XD	vRT'E%f	avi2N.\"BHZhU(Yl̋CIb:0uiQ/US<\\'3֜ܖ{ccGc<llukv2VY9+WuglRtvMejRgg,s	֫Pfz_smst+mtk0Stugt%n0vjYG\rLWU{*7yw\\VXey0[sK;z\$]4|^PպKyIonZ2EH~,M~d~{z\$ K-h\"h:*P+.GCG}\n-Bq,x-I)vc5Ƀm]5G2RG%ZP|pQs;gyZMTSm>r}4ɇtzufi\rV-c#H/w;mZ#Y#Rb*=O4Wqf\0\np˩>8WHyeDGҌ5B!B֛<y/%E/D*edUg~'r)*yT+AЉ/dfW.Ol\nR(aTQ~'kG9FDp֕.U2ޣGkL>F+ْ4)Qң.ٯn٘XCi}OgJ\$mD˛xFWN;_ĪmAX3COЎ{{aPҍ7Zs_Wkɺo7hȺ8'0)H!|Z[0#ouMf̋JzO㱓doH-hT4(ro)|rGDSxĨUXVKw Ò";break;case"bn":$f="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHWβt|,G8rgu\$)k2~\n\$g#)eӫf\nVUN(]>uL]	q:jtZut*#w=vp=L˨\r?JtH;:B6cz*\n(:O-*X#ps{BPB/j{BZ-INJGED!QY\$IMV.<SPw@H<ٗxm^&Hۼ4Ě6ش|/\"AjU<#'˒*Io>)2,p,6IQI4ϻAQU8\$XGKp\n[+l\\OjxIH<OJK,ƒ9uhCVx3x+u	,7b5VIuk\\9\\;MSB/vBK[ܻe>SzAT\n4Қ\$[cBa*Adި7	F4dNucD{Dݑvbn)uhPqSI.N2Yg:\n-A-}P# 4(`Vch<i\n|.oCfs X@480z\r8a^\\0\rp^88ØΌxDȌ=G5xf:EZAh1\nj7ӿ3?/8ZA:DdVT1&ˋ]9U&QD50J2}8O?[K{\\PDJ&Ҍ({/}'1Tہ+*|\"FHq|=P\"OE\\%(~t'	Zk]	Pػ.f f	dOl,@Brt@[l|)¨8\r\0	Ne*}ނc\0B`-J1X\"ƊARM*9(2nHt3iޢ,z˵EbM<|{N/4O\$JeXOXZ2Ddlr>Б>Eli͜4F}VeA:+U\rf!Y<>>Ny'R/wcVRJƓ!sGQ-I)e\rʍٺnqX=)s헟U\\ZKzi|]ph2i'2㒷I#n\\S]5HYG0e-:<	cRސ_n4%St6b/_\\4\\)o+4@jaoRJ\$ÙVdI\rUc9հ\\誉B7+kYf.-¸eEv!PT\\@dn}WVZpuVb֗\r>_1vЖV4m}]4.LVq{?l*_C^s%L+q.-Ƹ\"ܨwre'8::C{uaֵ^k#.WZHv%Y)댌%HLkϼ3\\M\"it[Sr)bZuK#[1/aTs\npq`dE(\rb%(/F&)(,׳)YA&	\\VaKEDiɭbW҄B\"_ҚR@U:z,<vO1*5nMI[=97oQ ]pd@) atbdbXp;X=1e[V)z'Ata+jӫvTq='Ri=iATMt5ֿwH۳+=`;GxznF\nޫ'bJލ]0;}beܾa:%Im\0T#mmX8A9\$|g9R5E9AhTMf nnF7EJ6*dzmd\nw&jcLװH>T5r:]X:=q\n+2RczhZvfd7:RštSiuT/Id\\4&eN_,2* 6}}bꬽ,;r2VHB=yyj`,խ-O^{||nEXľxoWg5FæD;r8K3W{k{|L}\0\"ӓp-n4'CxM%M]J>`eDm>BC ̌j&7)+5%Pj.c@e)êΏ쾅ialή4|y\0D/'H	/TS>+kPF*IjIfJ抴)dhNdF6d&b6\"07CtZj/|(mceDG\0+nNad\n&#>cz(e,iHOG:²NFeJq\0:))J-`/al%N%1X|8 l@Ҽ@KFKKʒ\np\$V`B ]Tb0nZk\n`6l\0dn@'OfZlPtSi\0^K^4!a	JB1Ql`dLk?O>\"N<N+ @=r3H2P#%˃\$\$%\raVe'\$OH#YPF|p\0ir(_R5L??(rKs \$'&gq\" A+P+\0șK'E)H	C\$ЈMxHB㞪B0U(,oT'FA%ʠ?\$	~`\nNT>ZpЅ4T\$eDg7|+@ig6ƶ٭&-e0x>	r;'2ZW}>	C%H1}em;g;'u6m0G0E:=EdGR,]JG%\nlhJ,\r-S_3<CSK@ғA	AQBl>rͫBL	Ct;SS8t	ZO>FE\"P7+Dddf#CzT*4*Xe?jQ sFu:@B+\0+cT4PV@Q0Ё/2/63 k\r,tST	45<ƒCEg̰DwC(ƴDW/\rSD!C;Q*i@cSu_/`OPoAA@ΖczUD;IWt̰MWK\00KSOÕxH4藫H'?5(\$86QEʒR4U'&1Z[	<u[[\\4\\qJ5Ε0%=iT5LtQu`.TzQEBaV\0^`DQDZ&jc/(EuށŧU\0i\"GQ+go'|N-R5Ċ-5KOpEdjieɴYU<ik]\r\"GvJn;bŤtGԖ6?,v&NA,\r)BCDbVZs©aav3#c\rN{nF1QQWbjnGY]7<G&q5GqwQcÝrѻeWJS0Au1D7rsDtVFNO\nVLif>oqz~̣LP~7`Џsbe]1v]6bw;|\\S4¶%b]\rJyd%UYd/51|AGGr8/rw@O`\"oJv3V|tWuwG4p-nG-4IdXxUqM5tu9BwbuMcYppo=gDMNxSI6ف8x1qffT38~px}WshW^#>mQG)CeHsxQqH2h\r[Wۈݑ334˒}9GUy9/87h+t&T!\${|wc΃9}!hxLao\r<)\ra7_9)#pWޅXdLȥ7]b{!(dBw_\\F*T-߀Y	Ѹ6y~vZKF،'wJ'?_rTuњWRN}WmgÑIL&`m\rnSN\npcf\n_oVlϣn2gnڛy(K\n#zۖA9A#*b'R.%W)\\wsLWFy5ӥǬ \$]v⇯L72;(6Fzt4ai0bW84\n(̭Ư6lʍdX>+hGCΎ#FEj?zk#\ngOr~YZA	uӂ*#68U}PoK5pVQEʾRSH.T9ۑh\rvgmE,wP>%@lka</\$UFNO\$uD\n,x'm-8tD(EXFEpXٱWGM\$p6;2t)6*JI0T/Btmbf%'yuord}67.v-.\\Q;3!L9pKhbݓxμR+@";break;case"bs":$f="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4(o9Nqi :igcH* A\"PCIrDqe0	>m7ݤSqA9!PtBaX.	B2w1{=biTe:Eo;i&a1l2̧;F8pȐ3c{1cMYd2wT/cg̒d9\r;P1,&)BM5Қ֍[;\09K(7n\"9X:8;\"@&H\rprҹht*7:8\n0rO㈦)ʃ? :k8찡mx*\"jk>/x&)|0B87㤱4\nk\$6кJ9A\nƚ-	Zpl4\n{s-Ir R9%Qq*#i%4P鷕\$R9qhXHпD49Ax^;فpL\\{TX9xDB26H7x\$MҬ2[*Tl0:r:24#S2Xp++T^5NBdrM\$hc-Pk^7H:m)H26E\rb^M\$.ì\"1o\0KF4CJ<&=7(p:sM\"s@:ߩʌR^5NZnhj6CbiB(؄X薬 R6q}5x0	t\$2 sQC`)A%=t۲Vyh#H-#)ZMG.+Ӆ+pviʀumx0\n5d007mސW\0u˫#NC,F?@X1:@C\rʥu2@i	ݛ:CxfФV̥o1ˠ73êUNMи0\0:g0RH\0nI\0V_*cd\rd!]HaIf4~պ[X<Qs7a,ER9h)ׂJ\n弸K9:?CB<9!EPG,1A̳䁚 P+@ATuAJBLXT0\\CIpG<\0VGLKMx /M;6)BdL\$4@@P%Sp\nN%E4琒@qIe\05(qLD>anS1C䰗Y_,WceSICppgmu5AbK?41=~YS\nAGS	9xI\\]\nJ\rY%UE	y-@	3;@ɼ!s:8S2FjaMFc&U-RK3Ae(H2A!aO.n \\K]dd1+JE.)i8)*zU\0`:gWXMӑ#hym\njD;d֏O	*\0BE\0JGÙ%fR &[zjMV[HղrL6C)R)H/\r<A*\$(&VIgmPh\n\nmuXw*D;:iwsP0-5'\\\ntEhC*,/jq/G)bw.\0@bb	9mO*ߛJ1/kw\n72<cDCh%1mP+>31HGD#Cp'	PpKn540eyM%:݋\n'4(b;6<y\nks,m`c|P`O,8<x~<;_&DTI*|!5F,[z\"2@@ =D'%oNz`\0ͳ+60lnE`FsJ1]|F)\r^eNw=GٌAEӥqޚK:y\\ۛv\$8w(Y_N@ɒOy榯dnw:'w]Wn{L>	Yr}t4\r܂{NH<=;dX1zD.7,T5p@tǏ(e=		8\rLj5BJAw9=ONPɓIK2gJy6H]R\rN`&Eo/NH?Ͳ\rĠR'F贄N-\"C Vqp:?`/U,x&\n\\ZM\0\rT,#N@.0FH]e\nk8QoOlx,~d1.	G6Ǭo&\$0\n\ro 1O0\"VyX%clİ'\"1#9XȮv\",c1&no(̭Fۋ1k&Α/\0zB)#j_F`fB\\BF7-#)-iBs%1mQr%04ȓɟ8\"zQDXͣׇX-fd`J\${1bNkqR\$Lrbky\rP(g\"#_'\"% \nsaCo#!Kr/\"LX&`HBa\"7\"垔0IiT8lxQ o43]\rR\$/ڍ&o.aaC\rOF<hjr,	3*r+Cp- xE\"	.N()#\$Rb\",z2Tzf3.\$\$\n\$<-ƈ'\01.-7+#\\34\0003s33c4ʰ	G)4-7qM#R-ԭ1o185F\"3N5d#mBD(};\"r@F*@	;)|	x{-\$B\rx3c\0'xs+? (f `8fBF;Nc/T4.\$(<\"MMh;brszl@\"4EJ\np GTΦJln]%B#44JTѾ.tu`\r`0R)-AV4#z1?84eIݯt\r\r\nOoOff)cFg\0gFi;DzRJpL:1hJ.ȦePTS/\0m5S!5YVRH}F'qGM{Y0'1#G	\nH`J5VC :&\"h2hĲߧCdCWN{K̝P	^BC\\1mdx?0\$L@'hp&KB";break;case"ca":$f="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(i8hTC`uADZs2Χ!c9L7)I&ZMQ)B>MΒc:N!i3M`(Q4D9pEΦ\r\$0߯Q5M]YbscL<7N	]WcEY!,\nNxmoF[7n絆^4C8)llމ-ޙB26#r*Z;93(0h7\n;hH;\"H)KS`@:pNȏ\n4\niŪCJ810((<܈hBDB0<7\"8> )NN97jk>rlr!D3 H4cJN ap=<4Jj0#\"ST1<R7t(ElQ:#IČ ]rQ2GN40#0z\r8a^\\U\\|(]2\r dɡ^0Ѻ62t̚ҀPQr0NC08;n52N60߉N*N_+z @1*DѬBDNK0.M\\z\\̌o0q[7əOX3IPi\\\$6/ގ\r`ߦ\\ܧCv7'OaMV&I:85fPZ،/\rV20!\0(P.j#8=*\"WX*V202;ڎ9ɕ%N]lMP 4SD8P3@Ԫ\"\\w~r\"]ܸ4(B{ÎPPDPa+~G\rx)I+9RL4nYRJ!4T((lN(0DxfQTRnj3*LkPOcfy?(;\"	LW\0\n)pf 9\"8gBaRdRͫ0eTfJk0(,VVZems\$ksRZM]|&bk^hS,I)vh\0jr%tQ#4#?\$* eXnL1	reee3GY\\Fn&),9Hwȁ8&\nA4%*I)ONjEB	JP	A>FAF%\r+.x]3#4λ.W	+hD[oJXNWi(nĹ\n71])HqiF&@sRA(4U\n^pxU!ІF?PRP\\!\$\0B0}F}syA-ZKɊ5 `Z9'(Đ\$0r#.EJu*`]T#A*FizmJJ*N;\0¡TtNEm\nSIޕtdԠ *&-A#3u& U-s#<ȒF:y R~*\\LUEa)sG\nh*@aMP*W5y E	k[{:ghʑbt00EV惃] 3N\0>)8Tư7 8 ޚ^2抦RXV*\$wYNL#`\rǌ^;	,:\nAXgUXV\$S\"R\nЊ/I?\n3@\r苢DrawRDd]T!Q\$tCUQ\$\"+5f\0UC\"A\$DDJ %ˣt@H@[ܩjPGCF@AXc8\r\\>Vdf#ʳYC5\\x`8`[\"\$g^\r:\rP6ԹFT 'JF^ȌczEQM*3bej_.h~_Q7,\0͗q糡'*L XUH<4JC\n!|{cʈ,㼻d*e629!,ӈs|9C:!Sםsñ9_|]D܄cX\0wdL]c?\"qW[6_YD\0*NΎD8䞲\" !1dІ\" V)UxފݤUUvHRn.Za{Hˠc/m|ܯN2crE\n\\\\fDDЌv/L\nt3@\n0O&pScH58&:Eb6֡Zgl'Mp >hrghRp>qCk0T',djE5B8BoƊDk_bRlf,0^X'xvxz&P]\n\n3a24n<мDni\r_\rD\r;LfmCZ˺4pУofP gk&<45G\\2Le?c2- G8J}>FCPc\$EL5L\\P0*>¦3+q\rF}Lcg\$XCؑ\\D@\"m,ZcE\n-wQd0P{g\n0,Q	\r|uQUP|-Fd7 5ǊQN	<N1pz#O81#֏-c8ǰrNbvv6 1#MC`M>Q~Fq\"/()2	r**Qe9)*5&}++ѶR-R-0-U,\r--`9sVM/\nzH./KɬM\"bŠN4#aS,C-;381.M\n[ -*ne6A}7`\$0i'\$UkFmU\n\$FbVf`'D@Wb!I`nFxf.4b3ss;hT(Md\rVe0Wjh2@ZnBHǖ~\$\nZ4nWl>N8=CD_CCĺ,/jk*Sy6lO'BCHLh1l6i@# °&k\\^':;ڸ.@6x%nPV>(D@ wf5cLc*i<O	δ;t<46]MHJ΃(CX9C3\"R\$l,>f`Of4Kq\"!\np{5<aP6~F1xBj̘ftHL'TUFBBhr. wM@HvXQMOD\0&	P|`h`eV	\0@	t\n`";break;case"cs":$f="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8Ua:Nf@t< ya;Qhybƨ9:-P2l= bqa27GɌ1Wa1M̈vNBɲ:[t7Ie!;ɲZ-SDκfUFcga;da1l^ߐB͘e64\$\nch=-\0P#[h<KfIcD 0B\"##&7!R(\02hD(IX6n5-*#7(c@,2a)ڨʑbY T=&Ə#0)02X1P4@))J(62cz 9&۬H	b!+CC2h4@s(@0!Ԣ2o2\rD!#\$O'%ZF#H@1W*\0x\"(C@:t㽤5ET8^1ax.c@21ElM2Ai`x!D+.#\rrj\nx6cs-XaXc!42r0,QB%v0\0NS]Y`8*. P9cFLB2h^8RY!L|YH:\\ɤxL5~CX\"&+4ڭ3Z9D&\$o\"<f~R#S%<-d(2d#7#dٵC{n8^_B=>].-'#aIv#GgvEL\r[z;A\r\"9/@3lD5*Jx:>BHb(AD#xywҪj8@6az'H4pL9h(Had%dHG̩G(=ZCU)-\$tCm.azDxf 7\nEˊr`_\rDdN+RjURłr9:\ndzyzG4\0K\"95\r*&\"b1TExD]}#2u\rlfVQ\$y_pQPbQ0TP/!&ݝo\rظ\nTM.#2KI`=ER儬.ʒX儱zY+-f֬bOlTHn!rw	t\r5@5ӡ/PQ`:A\")P)NNl4.S&XQRHWaշ\"nȩ]0r\rFFB\$AHj%bTȹ``NjI4BHM\n\r2xY)٦GʵVA\0P	B~&i0((\"'jbC=Njt8Th\$3hO)%/4ūVXB1Jy\"Y`؄uAHE4舋L\0C\naH#L~L	2G+9?&bᙏd!\"1=cJ/ۺl/\0It!s	;L5CrcidZ\"*y,	\\\nmuu*Md6iBsVO\naQ!@RG.B\0_\n9f}8`xa=4\nYl.\n@ܡ1*\nH#4,6T<P	퀠CcTيbLYÖ@\nb-#K\$1N2hLCsk[C@slt@\",gPqiE#WuH]gB`axƵ_+}]՟ H#F)'g*:'QVUJ}=X2(*5hT\r^l 2ѓ\0v\rYsd䝓BOA,:'wav#M:gMD=17z\$-)N\nՇ2Qd9|( '4[xxLUӑK	F!F͇ KCBL'k@偱jGIt_xg*l<BReߊc[#bʡIeq^0C	:*Qg!k!LM#o\rlwY;8 '|:mkƏq,mJAiF/ѡYVT˫/3`G~[i\$iePrnsu\"nH\neԿa<Io|	|׈y+_<P?BP/@%5ck7RFDܘ*\"9OFJ2XdhO S/j6(\$2BM`*,Q\0'@N=:{6\0<G<(dl1d9gDBcȃDߠ\"*EcB~\\&ú&pf#l< `m\$a/L9	pp̨f= ,\nƦjJk.<B/aN'*e'D=hQsyp9(hjb`\rNrf{!Rp,&(UXl\$Mѐ	xge@ԝP}ep/Qxx1}voF\"1a\n#.Q\"3(0/bA'yL#d2d!o&bF9ѼR+ aOo*)1.q1OSlJ팀NPF8\n!PZ=)!/!4&h06gB 1MgLjP|+_:\"ngc~^%#fށd1e\r\"yΐ@&*F=R6̆:rJ\0z\r,(&xgmr3p-?&!\$ ^ncg{I#05ǲs1S	@|\"\"\r_36h2#AƆD|	bǲjbH\rjj\nQ S6\ngǗ7'06z>.>6'3a9'9bp&h->zf]ss\"Sw<g<%/3)<2S2Ӑ\"SH#:q?>Q)!aE@2?=ʁ>ӝ'-3;Tdb30а\$SJs>#CQ/+9.#neBnjN.sgQER@bUtD_,F-nPSn{E.~J\$,S2{e'E,tPfkIbIoG1\$P\rn-y8f(2p\"udn`@q0MǛN	TQ9X4\"49T3/&HƄ\"dA&^q8COa78,\$rSr91SV5\0ASOsUJ5f\rV?to,P<?!vX&\nOLC(\0\"s.(j٦\nZh{Xu<ծƭOUi[- )UZ!\"\nN~e}.6:4Fv.N6`XQ\"-ڋlkI#nG2G\nAJrSL2d@E2KEv?':1NO	Cռ~m3O@fHflr6pvXdvnmJj}i@sg^y\\meC-tC0P#P'u1fvҘQ,p\nbcBn Bz7j0x=BD6\"Ij.\0007fm,3,MLu1ZRsAh6pQn~hVKb\nD";break;case"da":$f="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9GS<y8MDYCQ\$cf2 )RN17&sIl36Me#)bl51#lg6rY&331@a\rI-	rɺ6G2A]	!τĝ4z]Nw?t\"3ob)t3˭YESq7\nn5P2˒2\r(?戎@8.CČڴ61ij(0ɢn.1	9@\0:0\ncdGs;I[70\"*3)y;\r0ދCBcBnءCs(2\rjAЀ	B1pr@741AA\04@:c/c44&C0z\r\r9Ax^;r+>Mk3\0_p8I|6([31-L7^0ج\rBHè:C8n+WʅH;@P0Lh΂ @1^C(~\n\n%蛐\n=*G\r1˃@(0c;1㬓i֨#!f>\"7c}H{4H*7IXjCJaZ̖\$6C\$H:J&ah1R &\\:AI\n̮r8]6][ P[0PJj9\0]\nTK\\D7&E6£U:om*(	MQXME	<ւ7af#=2F023>[_a(r(/>dQK(3ں6*\r<DQC6Bj#?	yZ)\n)|0JPt#iq^_V%\\@DRd(ɲpʇH~E\\B@\\UT:*ZՊq[ܮ^@\$1`, Nwb`'d9/8XQOx(W<z!I,oHT7F1b!q2\\u!Ԡh\$9\"Ǝ9&1ܷ\\I~\ngE-%݂\0-TPNL 7VȐ蒣\\He+ѠM@tPZ9	B\$YH@Q/1J`WupCOy7'5~psR:Pa1Н&/P!\$#*o13f2ޗ!23,Z&'Dl\$0rUL&D*\r(!:]\$~[qw,\$ӄ9 k^M0&H\rY\\'YY/HJ>K^Sl`Ҧ0T\n	\09Ɖ	t`Ld=B3@7g<'\0 A\n[PB`Ei'ZXB}1P[HV1d]P=6/)35\"Cnt)\nMb3(	\"UԽI`룂I.7:U}0{5-̻%rg+?\rP*6(Tijϳa\r!\$794EL\rrZ5ӂ'H\\D.r/ua4-87Ss\"<	de\0d32I\nd3՘vGPC.\$P˟agLItRa29uJd\0SbP\0ƥ#8ek'Q s+0b?%@@ 6@P*C2}_*c_k5B05a1gR``xKT(Ր.`hr!hvw;ogґ.t\${\rjƧ,KZ߻\\m]ځt퀖F\\jiI`AI/65b	iWʥ(]/&\$P צAm B'3A!	yҭG~lHR/!8УߎB}@fRtp\rd_1K*pdJO.y9yt-%)H舒\$xre<Ҍ+Qn71X@PAZJ'Aj\rI\$돠Va׵v|aS`\"Ǧ\\]zH۷{?.	/Sp[.\rs4pI2u\rnS\r;ПhO3Ϯ\0KS\0+PFu\0Ϻn ̀ʄʭJ\r̸ @D d=8T	`|cЫv,ކ@\r@< T&D7\\(BgP\$:\\ndѠ^]O`t̬^.BfAo\r,A7R*g1\rt\rEĈbccL	[,\\FHGN6q4%ֿ3p>\n3\\Y`Q\"\nc8\\<aĈ(g'7rH1m]n?)&amKa#pKbH>8^,-w/A.D(ʃ48	1'\r\0+K18#L0!QJG0r4LHpC+D<dм!qJct4F:iB'G5bJ#% +^n֠/0nr)P, (C)1*mm'\r\0d\rV\rdI0j`37ÌV'pp?_B6ۍ\$'F1CXȱB]9.(1Bf`Gd;J:JL ZjҌ%8㐏N3K[Bdi\"@4BTbf!pd,0N^nF̶139:'^NJ:A;&lӫ9r;c=+L6\$Hr=h zРPcp/V	T?@撴/%Bcos1,@#430b:cLL,J@䗉%0К`H@!@";break;case"de":$f="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9S]\r3jPpv >9M(n1\$\$NқbqX8@a1Gc\\Z\n'X(7[sSa\$NF(X\n\"ڌ5MR\r6e]ͤ<#(@dDM^|z:gCܮvܧDSuﵗ6-l\"䇾*,7m+\râ50 P:c.\"\rc\n\"26J:2<T5q`䠷*A\0D,c>!?ɛh{,?KJB02lr!(H-1#nlrM6s:?DR@P25B87D216Ip,2<c-9B`3@U3MC	66OGcz=(Hj-3 cꁺ?\rCS!H*\n.[3:t!S8^ㅚxD('/31Ȓ|ƬA2:C:R̛.h+B;%&7C(C*=Bd7>JC,aj {;D-ÃMBPe,xZl:cKW?(H҂7AH\$ϣ4hΜ:+5/p1&\02mS1b+\r\03B:\r;lz7D#8Px3f.5r(hEC ߽p(\r4c9]ۯ}];=c*T:N729?ZۈnSTCűG<{!»r[Z+!.]k6Aj^@@ P؁a\0#`ӆ؀ee`P:Y0m;=ҠoIA\\eQ'T\\RGc.H̼P@\0lV\$ %\no<08l\riQ*@Bm3Oon<O{9	BA--D6M'OjhԐ#\0rPz3?daZ9\"1v'9^IpA9E~L&h7f\"9,^KIE&AAucIA2d,)YVam-żw\\X亗c!/%sO{NUA\0MOdK_pD#	Sp\$Z#y(ɼI@\$\0Z8s@	-HȟCøinAG;r\$9.9#M\$s#5{NA,?5bPI\\B)B5fհGZPju]DCci`\"#8lˣjcPH:a-Ɂ2nC)K%KRH_&RTKp'ܸ3VԿZS?iQ/5VE C\naH#s%t3huјF_aԅv\n{Y1Bod\$ڊ)>	9)%ua**S),h\$nE3fD8,.\r轥C*3Gh 6kuW\"Oj.p@fq\r(G0c7P(GdP\\IO\naPz]g8\r.)6e'{V9Jߘ	Q 8؅}K*΋dV\n%`W`' P(Bk:ȨB줮qHxf/{!Thp \n@\"r40\"XaP5Nhΐڅ(y	 |?9Po+F3ckFv!Hr=F'&QxJyFTm,j! :lIL,:dS[Sգ(zebނ0b2/<(N\nE!5G)ea(!M4\r8\0دi0Snv5\0z(AGsqP6㗒X}%7!#4Rjc;w`**\nb6ES9ya| 飍L\\)lP*s:G,Ŀ,]CyQ,̭,)jPV_RoT!\$?C]Oj.D;b/hqlVrY[8.t=9>4SSѫ*,UD	{ω0^x,RE,M{\r5VOxQ?|\\6;3|ϴ!ڐsM=МoFmfe\$UXiPa~(\r-imHZr\\BsHT:AA0<UZc6cce`@'T`l@\0/@Bɶed8>t1j-6\$D|H*rp.PGgxr\$\0P<IRQ =xQ-2#m'~2B/1Te\nF%{MpYϒℸCȠ1\r g6dGb\$;\rӤqp\$vVM#ȍ8xm=5ԑB;>zZWal3q*;%0ϒC\"Xb\nG1ŗok&/&6*F1Xy_QbAD'pǌ@C\n%.OS1G'ѭPQ>\"\$dZHULП2\"MHB#,8D5SNĨY氐Z2i\$\rdɑ\r!Qʒ'QF&np.ZAncp)I%AmBfcaq%.'uǱ'qz(3F3z('ң)rǩ)R(#B@\r\nd>og}&3{RIqgB&'tcR\r̓d+F0ms+LRS h'<~H	gzP#)pR'!CN?5w93Zp3\nd4i25Yw0pw1-2hrv/IS&S3V36nnp3?2:d8R}=38|?3 N\07(,/<2nH-<ӧa@35R30/\"\nIg3k	\0CjCB4Ȥo&r4F?r9Y/,= a`S<60Ę#~~\np\0քJj'C1Sp.Qj8q&L'w8#@ND6:M&0tN,!lԈgT?\$t-\$^\rC\\e#`%Ϋ?Pv&!T\0000(0Q\$c\"w9^ڭ+TCVOM[<B\0ȑ@U`U}CV_Tl&zb|H5F@|V-\$'\r'.K*I\$8D8Rsb⼢VQ;:EbTU81G43f.*a.'N\r7!'s6xb*zWd5\"";break;case"el":$f="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqnFWBWPckx2V'\\Is4ADqe0̶3/tfOj,Q#rDIjI\rQe^DAJuC\"\nΕӗMs7>|w2U:RJ.(E,Z7O\" (b<K42LNpR8:8<,rZ\$39q!j|RbʒZ\rCMrGnS1˔>̂j ĚdڨQo(!r{Lqvg%|<B5x7(9\rl\"#15-X7AD 8B85#H9@)/=k%\rsA.	Y(	\\JZȳ.bڭnZjvĺϢ庞Xs>N14h2\n!Nvi8Vk|23BdX]HgNSŢJ2q0Ċ0N}RIȴAx^)b38☇WQF\$ h7Q7N}B9u(P#Nzx:+K!\04@:P9U`X(ӌD49Ax^;pæp]Hx79xDm\"5\"6ңH7x<]}`8H1AtP`WA}!-ܢ×Qx+.j\\0gw_'ϭb9\r\n\0<(}߅;	0׈Ìrav	_uP'-dqA(μpE?8A7bϹihEt1\$PxfNR !)&6pHF)7P2\$#Oʽ픒R	:9(ꛢ+bgQV;L ѡ-jlU\nG91EʬI\0#\$P\0b1,Br*Pdl	,z\0#\$E(@h5:&С\n#B`vx.;-cZ%#bJ\rI'\$R]#+&;,HA#u, \n,6P[˜4:ȣ8r!Ժm8C>n39C,ư4XHsR͵\"CuzͰnl.#.(\n\r92w:T3f2AgY@gE*iOCk5P?oU,<(4ˁ<gISa33mA*LLI:vUFkUj1vSuOx5J)jFEgH*;\nFbߥڃKLjC8H2I!d\"ZlIu\$,[I)3!e2\"o\r7\0#q8Ơr>7(l=I^!G>2W*%PųYT𔆑c\"-\\c	K(Uz\"\\nٸJ)ItzpcѼg	(^`\r[]F6q\n9 _ha9*&0u7yh mbp@iCa6QQȁu{H\".<wpd0[OD֤ @@P\0m\nga\$WI6a<6t\r9h g\rS)ZQX֬VDXV<\$\0+@(sU\r~~wCpnJUHc\rr{8C?3x2xVNҭcRg0BLݮDu?av,┺RZ=*\$Id:)Y{\0H4!Ey-V6>rz5Zp;Tȣ%dL[{'BF+I\0@uϴUK\rEݡ-D{m`E`UѹUkTHBa@'0k4F`\nbfx(X\"'KD\rRNw\$Bhqׂvˈ,ֵ-Q&I\0F\n,_+ǒa*HeUZd[}K9,/6V+\0Pc\r}ҺuAA\"s	,B!#!	KNi34!ֱ1/<\$'i;aQS.);Iz=z\r|\",=pt\$~\"+yD˶<gB=*҂䮔\"\0NįV]E£*uvGi\0\$\")H,PWȮ	L!'@&<3\r2ʢJtXM*5v|JO#\$ @y@\"JN	6ȶEdȚ'JI\"J)݃u(<F\0ΰN	qm\0l@lr`m ͎\"ԓ	<pr\$!0R{Dgx6UG\\40РSR\0`Ǡ8zi\$l(wCv\reaP1t1qXoFD=E`HdB*@\0\rb\ncNRV@#<F\$8h <,	#m}ﾾM*Ȟª#kBi|'\rjVňd( \n`\0j5e@TEHT(ghV6)~^	}?~r\\Zaw\$\\OP{X`\"J-\04	%.GB&d)+%=N2y&b҉()bҚb@\nZ*[YKbb0C&\$Ru*&~c++R+BXM/&b+0R))p(s>,jF^I)pʗR?Ț-8G\n\$zJ+oMloź+ԫ\r3nc/m@S5jzZ\r-N:--(2BQ{o!(Cϋ;\n0A3/,_>\"\0\\FH	)E'N8*04@8n^'1AAkA+Aૃ9C\"&\nT4.GTFyI,NdcD4X ?DDǃ L+F|?Eɜ Ȃ6\r#PYreR\05~hS^ /~p\"I=pm1)þEydsF`&N@\rR&\rG\n`\r\"΅Ô\\\rtT7d-ν)N5S+TGɒ>Tf.Tc1vC[ArXQSTHEWN6.UUYOp1\ntVqwNkS279&Gi3,#()ZK	);*[[O'0d+5ғ\\%-2a'l-LH217BŨ(v\0`o)`'Yt\\\$8\"Lv&6G1 Y/GޣJ2EĘG<2Ql'/@6ED\"`tcOa~޿#bs/OjP2nG)bo`i:.c]fCV!lfCd#u`e4ynI!	aQ'hYF=[ {'z\$9Foe5_g#pa4Eu]p+NU6KGcP.c6L'p,x:!I6SW]u43<sHwW3akuOdEssXeKwVcɍsVab-uIs:Pq)#FFF77Y.\$dz\"2(?[)YltK+t]WqZ7u~V#uXXׇv7S݀utJP#*3la HhFyy엂H8g]f8OGhǈ0סu}rՓIfwsKHXo)dk.Ve	Vx5txwCwxutqhDu}qsxx	)HɎCx8fq\0\05,BrfJFU9<@ˑLŒ?!ŌvDXu{aWaY2yHFxHۉ8׍9E%!I7;c^&vw|xrr~ٯ&!Nx#PYÍUy}Y+}ocC=BN#OhhvI1,I\"}K1*KAT0FW.\"^sLyN(,!E.\n110ʶ}3\r1Jk\\uI,u2BWfNr3 `\rsXK݄֯CwhƻD663xgkXiӞk\0@\nZl,(]C*C&YT:\$D\$/rlK\" 鑇I8>uE矎\$PPt:c1'!G5j2pD{=z76-v\$4Mͻ5b-\$Z: wY@9(/&.d%'fM& gJ6Q{U:nV\\6secO;A)5\n]DNx{Z[4M\rYM,w)3Uo1xs2C#7 Fm>?Gj2R&fpg<XFQ2qI-/f&rZN4Q	.\$>kg\rV}nOYRFϣ-]3˷6oV穳ֶ`Ô*45 \0\rQ;u=U\\ ]>bE\$SP@&r";break;case"es":$f="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AECL653MƓ\$:o9FS,i7K_2Χ#xI7FS\rA<MӔia	r8MNfDl4̆gMjE*p2iiN@	:.O~ir2,dQCO&p9H3,0gKvIyfG{[ <\rℶ8ܲJӪP0Β4kR݉-ޔNj,KoǬL*&ʴcc{;;\"F(-\0\n-bsʽZסùi#¤\nbF'e2@P24-!)P\nN{2(9el:'Ѡ \nۚbAI\\!FLgGP7t\n#1K9S 4:(Ds#1H̛T4u ,H;PxC@:t㽼N-8^ x\nj|C4M\\׬jHt;l\r-Mnܣ09	èʜϭC֖c(9`A)-46l!-\0;#l.R,:@;5X*S؍&\n޷KM@x K,38P*S&M#SC2`7Uk& UM%0)\"`λ-V7x!TmGHkx#8@!}g]9(n'v/OR*5`6RC<9Pfh+^7b(N}ؽ-v}Ag'-2k,ߍ}}\$`m\n`3	\$e4L\rLUnBbaeMUKtJ_2f[ x!EUYb5ʫ倎AdLsQ\$jJ\$jO2u<*1RLQC!N,'VQH D	mYHQ3\n\nu @JOI|8a4ZւZYl-VqU;D.ȓF)\n&tlYHaq`'CCoE6({KIF|ĢaT!HЯaxV\$5&ƕsx`ÙbI8,s%\$-'fR3\n芪rXjK	P	@#h( (L!FИ!xƖcv,-@4ieK@cYqCrXJ%M~_\n;ԐJ(P3튥@C\naH#yYƱ@*#/ԯIF1h\rQ!NJ'XKɉ)TiBhX)	rBZZLK4lej-49iV.s|(nLxS\nQGBA-z\"VBC9s'ZGY4`X&` M7\0F\nV'\nm)BHJR(9\$\nOmm	!h #yrBO\nAJg!G#Z2X*cdA<86.o\ryDfՓ?8!VúxsJT2jhR\"N(e9g{@Bl;*P[a\nKF7:NTS1mJPΩO0qz0a<5Lyq\neAM!)0ڒe3	bel8U3R6b\n\$N;:@Q~BRSs<iOX\r	А_h\nb5wRʅֹIs\nYb`=ɆI;=V`[=>[yKA\rڬFfI n'^P9FiR5\nv dg! @{E~WsWJie(#;2=>5ىɧ5CĥI\\t228f'	yb>a(ZcBɔG&P6dPP<7#F~0ϧ>BKOb[(vûҺTBC`˥ 1%IڻAan	B\nJ-(-H\$&\"vZ~Oe/U\0.Y\naX\$xo؎E2	MPLFi+Ecv? 2zDDSU^u'P_X/%H2c#Q`y.xdk-hm<G{Һ-t\" L&ng)Gp#B/0f|m#?lRtVƬnbL!c(BFȧv5/dLҧn\rjƈooj	%#vNrnN|\$Z.ĿFnDDJVKpиN00\"V\r4·3C)L2dTB6\"f|IBjÆL(Țv\"i`\"j#pC-NxfMPE'%	Vܼ\rNO|6L=-NML<0PhLf4xGF_\\tMq`1hBl\$,DCx#l\$*5ЍGǍYwxQ~qrujl!o2g\"k蜀쩭Ny'e1I(\r\$Up=bByRU\"B&Jy#N2} &oLqڅ')J3A)\"j\rċp--1&`O(ofbR\r+.2+cI\"b)S[-]/3-J0O50*xzk7fdj<TF		+dr3Kǳ(:zF4b4h	n\$NC5i\$~ʄe\rVF\"Ʈ-D\0'6Kr:S,@Z\nSbc;5t,l,ob)d Rèx#ciȹ2sv(`RENf:B%,Atjd.\$?CE{3`e,s%dBСaD1&GJ6o2^\"3f`ʇt:4Ccd!cfTBbP]4 '\0	,2b\$\"(\nW/@lLWg,&ΐCF-I7oDL@W	jSg\rÑSHD`dܰv'8g6m.@	\0t	@\n`";break;case"et":$f="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(a&	\r1Lj:e2\rq!?M3ϦV(6byeWhsygD̀nZhB\n%( i4sYm4'SRNY7D	4n7hI8'S:4ܜ>NSozZW<,5!Z 6N~ޓ0~3?r3̾!Ϋ'\n3R%b52C, 8#<8+ƳH:lD<\r#+_\0	!/1>#*V91\$p6Lrf@c2ϓ6\"CHNL9BB9\ra\0P<B87@4b_:\n,7T)\rҸ7\"HBH=&{ 5oؔ<:m'J3\r0>8D01hX\0\rdĳp4.0zFC9Ax^;r(As3_q4PI|6031j4^08\ru*́BsȢ.n5ɵ&/ˡH\$:	(jP+	\"(8	3ⵎCS+tcL9Ap?^\n:I3ӍhFҠ\"릣[%a	eF,y*BxMюk;HȸZ#-G#Hъr#X֜K8kè1#Ø40&)Čo{*\0s=ִX˃b'vHX5haDִb\"SN8j9=sP+p)HPwt&jbI⩰ͨ\n'g\0ºFF+\"C_e.aC3.H#@Fd@Մ9AxnlPȓTXjd711\n#0M@)a\\2\0!uV35s9aN<0ra60j\$2\$I\$j'][/C\nYaEd\"@؋\"88C)'%'mU.Ex\rnjZ+MjuJ[7.`]O8 ND7^\$DhAy,vllRYבG(υFޮC9yrN0cIS\\T6H@Ήə:Z9\$2gF\0E\nۉ!f` \n (OjaMDx/,sg\$qN9nHxw ][	hufDcqDk+A1ɛ	\ry`@Rb8ԃB\"Q,^DDx[`rU/ IdU3O..RNHy7(d\\i|:e#̄h *~a(WDCIO\naPfFL(4Fū]#瑷iͳ\$H}[hV@pCo`ܙ9\0SrZ0T. nRB\0=tMhe)\nF̘O	*\0BEm7\"Pp\negFu\nN/\\9_dl}OU8yu|ks#ɳbe+!2 h,R*bIԦ>%Z0pL~ةu<5!7z\\,aMf`NT3b0,]Z|NT{;Pk>!C,[G?|J\rr92\r29\"*tnuS<7kDߵ+ECe_C2M)9иݡ-uJFT1q\$,6^.tT2y<yÖQ9L)7\"j\nH\$pB\r E,[3DՎ2_eNQX+\0@@ 8CUzndR<ѳ`^ i1rkHhrk 6VG:s>i6EvlҸzq:	HfǨQqjnǥjBA܂#Rɂj9(dA>aHzè&J<4]BƦ5jl)ۛq/NH\\*ҙ*6㙉>xETs\n~eP;>};)b㯱NÒsC';z(w{=Xf\\(@VOR@eOdF4\$pR,,fjl=ka>(\"Hcʏ\$<&Vg1x.Ӊ&p	ϰ*@ጄ#>,,kd<!UL,x/O|E\0Ovzz*ʯJNgv-ϒe~&ДrL	pnCn,P#Npp}Ά,N'C>LjK!p	pK	\0Pk-aj̋(j%d7 @Hɒ<F)>+p+x!&Y\$(?.2̕H>bVp8ġ+p6103Dc^Hq\n-4dHt>g_f8MF@d@S4/##F>d&G,QqϧH1{*짼W҄1M tLK`\"\"r|N\r@#F	CR	(F<#rK!'[pHұyzqRy&(1<&\\{&N )\n'2(2QIzgk)2>2!?-1F>Mp2-3,*0Ƃ;7b2lC/?11s2i s,M/8\"8\rg\$-Q(܈xL+g50r*3zpj_)*y5\rޭ%&Kq \"A=!q'PESm);s-ӰFL점c\0P	mNf,wVƌl挰VsbTr?	o\r0BQ\rseT,NX{crd\rV\rbJxB!'˫!\$<@\nZP.ijsj (ff!HʯL5	zP`#FNJDcX',T#=zئwL*?<?x\n\r9&Ư@tq\0pYdbeRTİL\$!U	J]lQR;OBr7}4C\rg\".յ%Scmm/-E58X+:#P.-zXp0D.bj\rdum5R\"xC\nN:!G~\$~m _PVć<x5GB50bP1ÞRb5OI+`¾2`	\0t	@\n`";break;case"fa":$f="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6ѶmkvᶹBhHA9!d+anپ<W-l'Dqe0̳\nXvC-*UeKY\$v⬅5NWf+PdFZ\\aT綷Jė\\VLã#u\r#He)nZ4Į>N(N죂ͺ猪j(l4{\\)#7lX\$d˨)SCB5x7(9\r^\"#12,7A 8lz82#YC:ȱdKd.J	TBL!E2Z)j:[nӥmT댾λEtl(~C..!hl)N98r\"NrYIJQ2(2t\"Q#hN2'crSs}nS\"6PA1q9G1#3\rq@;#7A\"r4410z\r8a^\\0v,]x7E9xDlZ4Z6#H7x5Nt!SH#HS;tTMBLA1Q%S\0!ih+#k(Xj\r5f樮\";El4B빋0 |!mK;.,;*N50tP/Ká&nB5΢l*͔%?\\PSG{WCsoU\0(*͏>;E X>f制^IGrW0޶`VR{[\"ƾtJ!+X@mzCgJrs߮vI7L3WZ!\0PDJi=\n&@6PWs1:Hr!厱_C>ll3C,%P CHsFa4ZCt;0ZlʐgDaK@6\$C \$4.0\0ګ|U_S雈EC&܏5Cb x(FY\nxlKJ\n5\$cy)9yox- T7f]6(Ъ!쐬9%C~s)DlD_:.gV`)yGEMԦEcj	0KI%ڻ׊^|\rȨ0F\"<I\r-0RICU>dCN`ⰰ,RUP'#HBVNѨ9DK\nɭ ƑB\r#&SA2HrGMj`K`op. @:SVIlJ5ssqCRNʡȐ\"}a\n (KjJ@J3Xd\ne)Q6^BE>|+\rӬ1t!QzACMW:BGPe-Vr4l2Ü+\$mYeXF:[A\"-Hj*EsTh\r!4AH\\ii!0``BR 5rh:ƠL\"19*&yF!:'/QJ)ueD+D~_'AexS\n@XᥧzⲆ<8TrC2,\ra,INB(uT{t%2ة%nαeAdF.qx>+gCϙJBĞN!K	Fv.Oɱ(QN\$&c2GX%c9\n7`[o!Au|g/Ls\nlbU\$49Xq-z TGp \n@\"t>&]skB5n_Sm=[c\$3m t {B!x<z [e<!gBk'oD׊߉ƻ'a!G_-؈KegC;PoIkNR]S|z޿ex-CV9ĨWX&VZ&\r>#OS^r\0&N)j}mw6E% oڨT&dlySbR10=_m)r.dU9s\0׳fpc)%۸xRIx_Z蠑R6U'W͟H:HYf=;x{|Td\$~w\"dyt.}а#,k,mZmEeRC	\0LY!Y2rTESf\$y\\91*>ScaeeNO_ٖRm{6EyM盶Ɍm\\6\\f>=1ќti%IS&*\r0tPu6MGϨq)N/<{bP͊*\0qyNy\"MJD&gm2XhJT'J&(\$GMh&&\0#,<Ύmx058sb@um`Mfl\rVX((;N\"8Q܏Ӥ\rbc\"to\0S.ȸKZ\\ V@H\n0\0@\\*Q-.MWym<!ϳM̏o><-\nSHPpiy:m\nz1uGB{i\nj(BBP&)eѶNR&/D|,p'֑mQlsaib1Owc:2\0CДy:\"r@c!`v|(:d%Ctp\n&ރBըJg NP_âQ\nB&N!G()R)e'*lNFk(r|&tkAUdQ\nMkC\rأJ'қmiҙbK*	*RS+f7**6ӥ+(N0*7m1JT@?\$Rk{!0\r(K/0s/+O5!SG\ng4ћ'A2g\r`@\r\"+Φ88SGJ\\ʢ/lӛ8s:,49`\rrO)rHSU!Џq(sY	i=6>2CPTskF17b@c @2H0TzR|!CHd2j%e/W%jUv%SB/Jfhc:/!Q\nJsִQL~m\n@l6sn4z(ȸ45 \npb̿@B ]H/MG	FC;BnLdd9HhTP\$Iv<Bs	/t2-QK	F=&!B\$t;otRS}dTUbN	n:PZυXGV&~|dTב]WgtpWpQ|u\$/\rWRUUpxyY[\"GPef6ģXOFptcX>.54ͨVޘVU{)NI[i+,TQgA-g{?Nnt-e.n5kPc5 T,LOs4 ";break;case"fi":$f="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 [\rHyWUy8N|=NFI7FS	 ѧ4y0&~AHk!22p2p(MSQRM:\rf(i9׫hCcRJJrTf!7Y4֣I7uz^\r2ÛO 6ybkOd{%zMs24*6Z݊::cД B[P:>/7{\09<è9n!`+TêJ9FPBC.cj&/5(2tҊz(ޒsj%+Ó\rkv(#\nF\r ҕEqS)ZAӰ:\$#ZǏ#\rcM\$+ڈ##N:o1<'lH&LMHf:i899mVxнD4&xmVЅx38^cqxDҼ6;A^0HK@t%@.k2M#\0ܯ\rcP:	EWܠG;NQe.jJ7.|& @ʫbݎ.HC~X@\riĢ :3LLa\rP,Pvp-)8\"2aZ}5P-#\\%%Bem>ax]rccdGG\"9)9J_{B7]9ȏZsփ6<`q5Ih0ufJ@!`x/iSk<Sf3\r#:Z2nF<Tbac@,gb\r<\rq\rEz&fJ\0f2pY\\TFJcTBͳSa\nAP1\"dT*<K3t_cAm &h\0na\\-)pRC#\rN7X7CIMy\ntDBxDNTI,2IQQA0hLPJBL4B>DjMJL9/`9z9LIA&RQ{@gU֪[+l;TcC\\k7.P^9਍q~(\0~,C!ي\$	\"i5T)X+͌@@\0sL<DpZ/CH.őSC҂,Ge@~4rӴxxX	2*2R \n (#.hz\0](J,\"鮙jENiς44#`ฉH\nj)&GP率1B@P#`á,SAJt|eMQ8ϗҢC䙣00-mq'\\a^C	C%%pôSI5.Oy&pD͂\0_Pi9rKs,v#S@V.Ax\rn-@e+XKO\naP>)\rO \0ˣvڲn}j\\!\nV\0A.y\nn:2vL0T\n\0<\"zi? TL%^X ֖-d[p \n@\"q\0 &\\N,&\n%&h3PI7ə)0Z ?CKQ/ ?\ry!9HxΡD朮mBP/Ѧ MMik ebB\0oOΑTu\rg(p^PkbR=UBgxu\nZkl/fs692j9/ ̽*gxr-e5'\"1F,nb_O<V@6p(ykaLDp\rp4n=mMD\"xTᄲiBh2zcA<n0C:oivy-D\$ NPHѠoAOLTP 0y02@p\$\\jX%Sf2x z]I7a/Wi	Lnܽ@tKLNSTt^o;0>x..t\$ieW\r{MS^~rU<KQnI^I)Qds,5!I1\"HzHyEO|N\n\nwqu;^[%	|2+Ҧ-a CD\n7fGFêV4^QȜ}v>^Ht7gM̻5MNCPpգ@^3p\\цB(-d̅p..\"\$j--pLtƠ\0D/\r`2ͼ-Fpg@\rڧ5`wo\"X gԘLVBo0vuƋH\0\$Jb&VYbIvГ\n1	%0=ж9GjvIf^'h\r\rΩ/4-rl0\r	B݊UP@\$P˘H:Jzܨf\"'\0,TT8Tf<Q-+lb\"\$Fj\$*\$=+X\$%pX#,l)\"vOaILEF\na\rnѪ1C,yMQ;瀇wx1M@xQ'eQlyqU&d\n	,\nf%CF\rd8#|PCϫ*v#e0C`jD!+1\$ӱ%B%ZP#%H!JPr\rgvwЁ'c	C(wb(Hwҧ(\nz1~+{*'iXݠJr!\"R rJ142-r\rr֭S8\r0-#1#* H)C^s*<'G4N\0004KQ1B\$b#(6\n?=Sp?0d>)\r%\na*D\$vehf:cA1Vw1 &(',dKsA\rEγ=0e3Ts	 N cZ1Hl6~ic,V@ pb'HCUiiϮL4zO,dtC`st=G\"^K_@fjcP;#˘0iLl#T|4eJ4v.fpxC^|2#´9,K(Ƽd=1	#0CJ(,'YMJKʞR/pVʠ\r6ǢQqP ˆ<πv\"(6\"Y#8pE\$<*v̢V.Z%UT&v-58#\$KFuB̬ƮD-BHEʞnUDiZ[[	t\\!LE^.Z/I~ \\";break;case"fr":$f="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AECj :%f0u9hZvMqM0Pecqe0:N+MޏR5Mj;g*L'S\$yy=W3Rt\"pv2LndNhM@m2)@jF~-N\$\"s93N78-L?O\n77eKzT7@<o0½)03 P\rcr\"L;?t\0Ѥ\0Ģ	\"ɍlנhъ(ꕡҵH2A̦F'\rhà\"܈ACDÁB0es^M@:BPN,✑BeCJ.EdOu'1@P2\$y5KL#5cf(ջ(Is^P6ĀHh1#&>1):pGUte %TȅP2\0x8CC8a^\\0Kx7@xDÀ:ۈ3\"t\n7x\$:3Dwo)U\nNM`XlKI;bYjK\0\n6CCT\"c(\rZϣxX\"ͮJU>	,+T!:N,ɔ##LS-42#^̟ɠϵOCRgrJ@0~qiBb(Xc'n LUq2҈\rbC.aVx(\"ή8>kV*fi猠ml4|,{K{B:;%tϓ\nJɂnlQ\"M5@0}×7!\rz(BUbyE\0zae;Cyc,lB#Ȑ0|L\"4>h\$*\rȀ\$v,81.')4WYAZ&C8My0@P+d&ў0T|Im'E`T\"+5.17u#ReB;c9FH4!c1r\0!S-2&SR>ԏm-twZM1/\\	^2ת_!}`M16;i|F8mRQB@G:#7FV9)JZ(bs\"1R+'³ fbZMnT`	!ϙtI/-ǲuȄL0IZS\ntw%wKfe\n (\$E\0((晢BCq\r=䔓Ҫ˗;Np`')I9JM*QRH\$%\$%Z5:O- &O3%5ND8F{b*aS\nA\$RMQJd>OBEbB!ӑ;伊P'gԈPg,:veStx>	LFWI2Dv|G˚\0¡(Ů\"hc.'_l>̐ĵo\$|}Y֘:(:4_ZvI;0޿-)أ4cx*SKnYgitcK*x֎gk1N\\AL`FCI\$P*\\ E	&kMk̓+'\"ΥBWVTO]ĞwhPUO0DQRÐiem g#r\nPy.*eIijP4yfQ2(\$0< PAd4v\$bg\nq+us3Rr	:[`UVz_ DJ9qm0? 0ˑ,d'dkCc~nR PJHZx\".M0s#J}oYm\$67H\0.*ȝ8Si&34Ȋg#Rڔ^45Y\nS̓Dxb\0YNm=0ן90f]Je*}0yv`O6rpg[mp-\nnu0*azji՝:-u\\SđZSE!A(ug֥]-gɤɍg\n(-_GzI!z[-<yIφ>cA	2zĿMo{^vOK=yt#/Jɧ-[gPˌ33O`(#&Xrƀ+P@ç<\$Zb2nb\"2E638ΜD3/	4C<Dɀģ\rFm\$\$Ӎs#hT'X/BKni)aRAd\n%~[i/S1	PpOdhw©\nPr09	}аgf!Fo(\n^-MJ3~;HˬwN0L.n4m.GB<8bHlDrbNT JWNB&\rFDl.,kF`G-rӰa	DUb~b<0~\rSŭJ6mqT\$F\nM({}0ć0x(}pOqx\$ho\$Jo)bLpoR\$kgp\0/]OP{BpRNtǁPQ%j*= Lvѹrr\n\"SB?2Pc*b஄[x5\nU2G\\;H6VGc\n9DnRL\"dd?AFD[p8x%Mjr'ǹ\0h|S(_#Quqzgͳ !BO-r##ՆJ!-pz3p-qPW-0\0S31p;3SiR3S1,\\B\n_O>\$S0nk\"Y2#0iJqSou/2b\nbJGޢf@f`:pә3ӤO2T=0A02su-@3.y.SخG9=h+:<юk70)@B=Ѫ6ovd2hlsT箊\rl&;	,\$|.F4# CRGC+0;DB(50\nnGR#-ѬG&#sALtpo2IԁI?4d.H27E.I1u	?GKTtw11TNAS*\$CQ3}- Fx\":\rntxpu(S'P3l2crk)nR0\rPhmMvFSj2t`)l\r(:C;l;úz\$m(ÏRq*{%0j\nZs2lX\no&\npZqoҕGDԇePrvx'z̀WbDGx\$C(;j/+\$G#N[HDȐg>#*+8--O,1[S[K2g{\\E[0roL!\"jMmcQXv@?^eyf4!mcr@^tY\nn4dD-b\nx'&rldV:zN4uQLj\"	B8qȬt&@\rdRrL7)\r.,elІzmUV(&<m\"J.A\0Dm&H\r";break;case"gl":$f="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9\r0  7Q!y<u9cfx(Ys~\n\$g#)	1s|dc4pMBysB02jn0 SvݣF]ɨ9b\rga8ɲ5EA5iÊvUXلA:^Z:n<oU,KVƍPQ<\r/!26	0B	p֪J~I@0C(*ڪ 8#c*2%*#~\"n5Kj8l6)J>);Jʶ9#j~Q:4C+mKPC*p(/V-%P\n+\r?!76BV)DF\r(ƍ8\"~#~hE4篢Ƞ([2/QhjұM&;S0[!t\0x\r`C@:t㽴55b~28^scxDk+\r3*h@x!QAc0<P07t6EM7-\r88<0!*Ȝ6(J29^[Z:ҵfGNQLK2a隇RBcpS5#3ӆ#;33\0pR6CQ?m&Oj&Xr]SIr94=RJ8yT\0(SH;\$\0BL})L3:C\0݅)tOP7 1CK۴ư<z٣-0\\?s@)a\0ڼF6]<#\$<Qa0H! Q24Nl-hD@s%TSpN-LVTѣ#<5He%ғ	^Y(\r&nE\n 6)*ƐHD88zh8nDa \$z!(\nSĈ7Ey**-ujX\\e¬\n?V\$D?T\$QؐӊQlTRP\\bZIj-eUh\roxIbP.v0FI *\"O\rnl סeQ\rSF1I\$*3	XEL9pr;ᘭBf(xh%s9\rHc		y0Up\$cpgģp(A{ՠ\0\nB!ļ2P	CWn<D<FX+iúr\0(/\n&. \r9bfil\$f0ӼѺ\"Ng 0*G`;HgZLN|\r!05Kp@Cu>?2@6&P5R7%Կ+6RU>PGG;?K?\"*J<ƙRH[<|Hţכ\\O\naPb\r42=8@y6t:q.1@;GԼj\rk(BAHL @b'L0^GR#(e\"x(S+EIS<<Ym(IM]LU,EDTBT\n&B1	8PTT R@.*¤wX<\"<L4I|(A9vplHXx@Sz6a/*5\"uX.Cw-ReNos)@d̓ C[]w>i{\n-O錤`ޮN8-PI-Z%OMʠ3)JA[6-5.u@Rq3L\r9@T=O<*^\\L#xlyug	g8!0X`u}.vzJ;y\rSMEa*PnN(aHYcD(VpvXEe5'=GTY#aV'\ri\rxT7#]J,e)JwoԲa<xT ;~VHҢބ4\0d1e2A_{Sv4U5!d.wSS}\$)q9\"v6|c\$ц[pewy~5ffG;7xO+Sg/v+֒RRWw`|qeyC*`f+LRDLc؆d63ER	G4Gd\"zfHJ-L=\r&0'H\0g\"bVN\0\$7rre`cicN@ʛΉ\$2\$,#0B6cz;Q6i99~Έ2bOnEɘg)C~TPv# fͲg(<FC\"bZ\$Xύb6-\"(;B\0Dp{0l<7=\rZEGWvb\r{CF]0 x`4OQ%04\nL\",\rXa\rqcn/06	LBH~b8&\$\\]Vg'	K\"B	\0Or|a.L\0@Yyd-ь\r\$ZgP*ц\rzRol\0C @c5   Ur\"*&`qm#(C<Ѓ#DzCB'NT	!i<hP0x\$5\$/(z+kgAM(\$nk蒩'q*!(6-Ą9 1疥#p-^tr.R70RҰn/\"\0000'B!#q!1zD醈`pG2S@26)2G4(hdPҀC3q0Zo\$Pn%7lK)xlгzh!\$I6r.j883/3	\$`1@R8\$HMjfRb>\r':=>\"k.*æV#bnf@/\$A2.tjQd\rVcNjJrXhNCP.#w*<KmXJ\np.*6.y<!B-*\"jVW;\rjN*3D8C04jԢDDM1hȿG<\n`wlKhMC&\0qf`d6\"y,!l\0bP*.#25\rh0P7(.mQ~*1QP\$ \nl`+u0 oMڕ^qpnSv\0ޢ\"RXt\$850C{Rd\$T8 6BdCbxBlTcduYyÂc~\0#Cp#(pl*";break;case"he":$f="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r4-\$L#@'b0T#LIRQ\$c9L'3,.N(	\\aMGXk1UPtfOn1[	SVqClql{Q/CQD#) g+n^U¤VnBi'̱k\"1hDAb;9QӉuvGJ]/)\$Q)\n*fy7L\00Ľ 2a: 8@ཎc20D\$C:ziJ\$k/3\$)j:αFMv!DDIz82ۡܬKHS(3)0K#бHL9kތI,DNBåI|a*# 4AB\np09B13\rAP`@;#7A\rp><4/#0z\r8a^\\0D@8^2}YWC ^'/@\r@7^0\n1\$N2%H965&΅0Kd#M\"9\r\nRNrO6ƹ\$3j\$֒(TH4!O<`\rs9%l:_&0^M{T192JzĦRO?!ƴ\$PeB%!H&%)8Ĝފ2^!\0(KMku1LT~h6M\\ۼ)-ף`\n:,mx%*FH	72ϲJ %?NkʑXpZ'\0:pej#S9#r0w\04AD/09Cb\0p܌fSW)i{҃b'e	IH-N	)mOLK4<H(=8LS{\"\$'^	7fޛKi9DVdh	!rw\nzj%䴕CQ?>D+ @*W\n^+倰\"Q(d_xn~+5j<NE\rR%p)5\"M8Òd\$I>8k\")LF	i AP4,T6\0_C[a6VC3HUKdl\r*EL1}|t<\$a\r͵IcY\"&5\rqFH\n\0Sdz!D9 t\r9_gʭ?yHnӳ)89F#\nB*x90T8\r1t̖/1xQ%a +1jE\"\$@aa*G0s̣:Ȩ\"FC0hԴ! j&SƉ-PiE'v\$)%D0X~{IIpqDDXZEľ=\n[hP	L*S\$ERnȵG\"UTwZSɴ.la*0W\0&Y%!Z9#eE!19T|9Im\"E#(:7<GA3bX%bvݹFR;9nB1g	\n]8Y%Y4|Ca=Rh^7+yE,fCyS]P8HT~.=h%p\\ܹ/Ǚ3.#А9\0[^f6g Ǽ/cQHoޱ'p\rVF TĦV姴0X@Ü*Ah0^D]lD3 0k<\$vhz.G3Q-ߋFE֢V3hc\rd!_hheGx[~k^lU,A|l3nD1Cv|GnRtl\"*@CUdX\n4,zĲ\$hD\"=IQQ0bC!J\r%H3<R\"|6qg}vPu4=̈D,OhЊZ\\g2{TI㣘)3܌JD0Т2l^ߓ/ED0	7j[MrvAeT{?4(cy/`XVTF7!עmM7~u'9e\"]4EŒ.EIm\"vgSd\"2)D̟;zmdy:KJ=E%5u|\0\n!3EJ3;a#fw	OaR{HEq!VWOS{ϣ_C}f6^eø/IId7vN;[Ǻغuw.@Q,l\rM.祢ӷ3wj!;>	Vcyb[p\$u\n9D\"_,N%%朥KʃL>%ϠsưEK*ńrilbuL\$ON:--BKZfc\"Յ.:t\"JvƗEePN\rf,DА\"ξtHObJhdG)\"Dse\$1JD/w\n>pDXo\0I#NL<\$r0b\$B;=L\"Kc//Ё\n1Ii_q?0FЖOvb\r\rh/j\$YI2D1\rIDqB1?liD鄂ұBƭФNO1t<|(* f!/,djR hHng3\r:w\r\"Zk#e͔hLfvrH\"OX\$#II*hƋ(Od>P9Nb\$p8.ނs|RZ0krL9ls\nHˮ\n<52V s0 >ERvdB@gJ6!8\n@5OV\"Gv'dVs,PI,_D\$2/H!HS2Kh%s4l<>x\"sh9Kbť4I}-fsД̽1Ƨ'\0ƌ&P \nMZ.CBsrbh'Nr&,Ӳ\"S0bvkO!o<c@-FiK?";break;case"hi":$f="%pRX*\n\nAUpUYAX*\n\"baTBtA4!RO_IQ@q*`j:\n	Nd(O)!\"5)RW	|`Rő*?RTDyKR!\nDJ\"cU|\nԳu%g\$I-=a<fHQHAԴ%[M._Dqe0̵GYHsz.K`RC3ue\"#IrU쒮IB#RE#ɿ҆>+Iڧ5)\\/bHhjڥOMh\n+;Ⱥ)HP4J*\rj-O4@#M-H!&1|H\",LD'H?Dz1Ӹ20c+2s50!H(Rj-ȓH K;\n}'4'2/GSmIC55?DL(+sXK4'!5Uh+\$I/E@H/R\$-&OķK2[rɉ5X2{94OXI޲Vrx\"MKyGoh3_i-Tj::KWa'UHRay#E%Ae3F-KV*},:.ngH-պ\$iSU.ӯCT=&U\rdj-S	Du	<^`@!\0D49Ax^;p2\rH2Ap9x7ヒ9XJ}2+*@KS^0tNڐ͸ѷ>M)6\"2\$J=FcbJ:ݹ3]թy\"mN)'a Oޤ\\@AtGѤ۴0aG	zE}KX\nCnSE}MIE#6!w93vD\$uI*;m&0uZaRl;8:	GlA|k\\c>*xUMÃvhL~%\0()\"*l'wYLf}Ku`ɞfq\r`[KOX	6>hVdu1ܞ0nnR\")Db\">ph(`mLFcY{&u]*BDJYiQ![SeȨrl	_EԨsH*vhͺ|e¡: Hӵ)ۧ2X+NNAaIdLj㘲	,3`:ME;؊m_:2`AHbSfȶ;WlȞ`A_x5PxR'6NCo2)Rrh >͹s%O\\F	QPuB b2\$uL0MK0qOgR9Pj\"lv08)tYWl;nV{U\$+l|U\0v~Vj^_]j񞚴g-e;`j\0R\";\r7F|o\0;'Cq9Pxs\r!9·Lqi?&C;jO\$^Yt\r]-qAʬ4Num.r}NL43U7v6,W[S_\"QFW*(B]Yםt#sU*fҫ)a@\$34STr`옗2ڱsAwZZ7BPs\\TFELQG\rE;릊D8p04a21eHڇ;NrXъ:ʫ	+lh+\0C\naH#EUڌK1M]k]&)z׺|tU3tg'P^4&uΌ*\":/ԲRF  KC'`d]cwRn#S\\'U.\\i\0¡1.ڌ9)ԠAg=|_ӝH5GR.SE[L;IhA7ǦK.e-uUgd}s流7ǨGH+1E[nsdMD<4iFv<`ME	UtaՅ42d6)j׆܄0Gפc;\nyےߩ楜6kimsE=,uSi4m;߸)2]#(tf23 MARiE_îМ*Kd|Ǚ۰a֔O7/NH^!<z}j#֍LF ;d=oy|?VlSxNü2t(y{`XԯfC}kh`o){P\"Iޖ!𨤑j2x\"(hE\0Ĉ/[戄(֢L;ئ#kRhГ\"p{O-Y'̪)ҝlQ\r\r+p{/*K.Mn-J^}0t4#`uexDfg}f\0003MpH@α&\\KdEkM\rȨFR\0ʂ{A	\nG{,G\n=Uvdګ8\"6<: ?1\$ }^P\"H\rJj@bm5+1REQV^*^@dR6тjLҳɌ(Fפ(qS	jPcɐBbuxpd5j4YQ@[Qq\$@Y~bGDd^KoIj>Bե+C|	h*HIh^cգ4C'DT)VLwMR/\$6)#%҅>!oyg(ONy2\$|])#RNNSrO\\)H.%Ld(%s,Je6C03#1+lHJ i/_b́pGa8G5Q` ˢ`-57)ݫ2o\$p*;/Q%P'Ț~N`h\$8Iƫʒ)Ze\0v\rжN0R'-.To>dӃ>fM0 ]k3-/s\r/?SD>@pg5RK,羳,C0]D}?%4M>Γzm%JT1QpsEj/1jR2;7@y{4@bHq[PHK3NCDPσIpOE	_03()KLta	05nIָ(UM?:b\"IbA)IMoPrn3K)i[*e#\\%ƿK	@7Ki3RO/1dnP̍B3-wB-\rZ4uIȋE7YDd	A/-Mխ	/  J)t7L2OZ_LDCNtM_`2^hʐ 65eOS(/U7R*'FKoIY\\dsFӑ%'ZvY[e4Zf%B(J'eHcXFݶw]jQu[v')TElh[CSZUc~.gu[Χ6M)_Q>Zl6cH*ov]H+hӭlTiN}j}1y^\rqreIqSlWmŵsp,gHSwM\\S+rV}tE_6y>7tWYlŵw_wFnglfkw-Yv#Bg36yaI	xO)wpj2I`,Zmrn^	ȯN׍qW`ZXY~TvW[b〽eP'qIVQx	58rVuc,u@qqQT+]NM@h#'cx-]%RkcGKO9ŵG\$޼/@l0ǖ=+9l`xNsKO#`@\nZQ1\0fYTunǆQJh5Tل˃qUtm)TRX032R^Eg,m\"cem7yuP\"|?XA;delǸKy0׌7?P孊e7OuMÒ(+ӈOWq-;zELEO(~Q\0dJr\$a.EuXvL󛄹3NTK(ӛׄsXYF袼#J9ۛ^ǔx9P~sQ37g^5Pl@쌯S>uZNĆ4(AS[%'Q'\")R\006p1ەp6\0) 3PaF<PMyd_wm--t\rD9xc}PgɨnEKxg4n[a	\ne)E{*2.";break;case"hu":$f="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n#FQis'jbRI;g:ڊlƣjl&虦7CIiMc*)-q֞kC2Q\rZt4Oh97eEyAc;`i;e:؟Pp2i3D&aҙeD67{ɭWăc>O]\rO@,j).3B:9)lr<C\$,2\np9\rT\"<OC\"㦞n9hȕD*ΙA)P=,@5*pݵϠ¨42*\nԠh\" Ȣ%\r##/E\n.R;	AYO#xB:H25(cڬ#b#NŘ%#Pm%A<T)CCB(S\nVdh7|qG1@3qb1Fc49IrH4'c0z\r8a^\\0ՊD]z@P2~\rk?C\r#x|\n\r:C֎6,4\$mG\0cT)@M\rH\rP\$0ZN:9d晵455z˂|=v3-4 :*+z0\"0:a\$6(%DCL13֕:v3>b49XHB@iKǊ[X7Mc\\Z-|77.zf)cH?H@9l(Pܹ2\\tcec˶@B|Ki݈x	۾8(:23#㷊Zk@7Y<x9*c\r(5{KdPc EJI@;6d݉-g.vE2d9 W%P490iԝ|EN(n\nCN\r}@	DlڜÜoT\n/sR9V35;Y <0aL)f4\n)5E\$,S=m5^R	\rDvdT,z\"RuK% I;Hk5gV[kt;Cr\\sCA%b%!2Nu\0ZkQ:2+\nc~\$2y#_!&\0fa)E'\"		B[5Af%وaJ-+f`+C]x /l!N4;%\$]\n624k3UH\n4P\n	M}ARPBr5ً&7>ù%CD(\n*NK(\$A\0pI&9q0L^a#%Yw<4HDg\\MmT:QI2) HxNY@\r9I\nsH`0Ji/&\$̚ph^\$&sT#L׫3I:EIGVNCNËad3\"\$bP1Wm>\0٘P	L*TA\0Cq(9\n'0=\$jRCWP7PIN^#JFdى0~[iQA|3\\hx:'[h]َqšS>M\0SY9E#.Hpm NTp;FP?k6uP.>\\SdС(54-\r<y\$5LeC+<\0PV-60@T'2\r\\GG0EihE\"iH3.mܗ13y4(~:0HNz5Rey<JTbvC(wc\"& PJ\$ްbg/l<tFE9؝{m'	Լ,(cO!3Ypf\0@˾n\$3)ȯ7hģyC`8Ʉ5{&WbD)𜉽3`T\n!Anxq܉YPy6C^vf 3b1%ѢܔO@e*;r!%ѡ49k9:9NRӯIc'_ԻgTouC_#J=m28,T4\$vd:j=\n\r0H;\0MNN1ѱ(!N)\n1ona1?,.cB@ip&Nԃp	)A,`Q\r[>Pj(aejF*Kk(dtâa\$]}\n4FND6Ch̯\"l\0L.Ƹal쭜~\$<n#L&#K,c5X/``Fm~T4\r,vufhlL1T%eN4\rJdσKͮL-P ZXdă\rvu.sCJ)	kL4ؼ LO+Ǡ)G-\rw0 %(\0w̧')wksC7<{d:1@+KqJ.P:TZ2_LpOȱ;l*P%Q1ݱ1(K\r@N&ƛ @.V\rvD隷\n\0bu i	\re\$#|\n	b>CW2L~edXQ\0\"\r#5?Q4g,o&NL.cX,'#\$6-[Y%*#1ZͅN\0vl%1y(rg|ҩ@R'Lgx	b4	\$`##vpFB1BY-\\102\0{ɩ-Ȳ/mp***@031G1Ȣ\$J/ľEAR5<|%RiFR%S:|sTx-0w32rc-2]p7&4̳|jR3phf'yQ֩`Hp,B>J[;;Bj<Nq	\$\0w+ aU15>n/+\n>8?6Ӗc\rMr DBdNe#(\$4!?D,+rT\$&C2B0jb?CN\\Φ)Td4hmFaGTf7	b:lp#(fHc^f14|f4t\00044\rVx	\$l)|^0J\"Tv(R\nZbbWo9G3}&U~B \"B(\"\$\"dl&\$BI# 5P4@C.?Bd'FUZ>R\nT2728ybT	`WȅXW`?ce&?f*ROIpޓRzcI4FMH{LPGrLb!\\ BBf&0S2j˙^C]&\"m\rS`5F.j	5,Vu5\n`\0D`sA-4Oe#DB&,*O%\\mv*]D\r^\"̶e}]4L&\r)\rOe MA\"mt\r";break;case"id":$f="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n%D2ÄL7ADt&[\nDqegQBe\$i63yiR!s\r6Hqj<PSN|L'f1Ir\"ɼ 4N#q@p9NƓa%kIt4V-K7eLxn5b#q)53򍼈e_Kb)\0AuR`Q-\nmipCx{{p֢v8@H9c2\$Oh\$485mjTJ4\$K Ώz6;Dزj+\r((މHlC1k.cC̺^iެBj@:`T!jȚ2\r;c|)1`̍K\"l'\n`@1B3:xQ8pa}C ^'.I0*87x\$Bh4S &Yz	!,*(ǌcjht+s\"7E,BX6I´N--Z}LA\0:I\n\"0:0ʺ@#/34!\"ȳ9:L:Kk^5GJ4N,?gCKl\r(܉kB&Cб;j'4[i5ʫ:޺\rضm\nNjax[\$pBֿgZ!lኁI\"\"kec̓a\\u46.ak0@q(;M+NCx30D%;*\rt<?#6:j9R0_Wv)2SMKkN\$Rڒ~}ƂI\"Mf*.Ë-aIU.TڝSQuJJVxUV8UJP\rw0FFR#DrĀC1\"\nƯGpבv*/;\0<^( a\"@EzXtcRsJ\090/ \0POLv3:ܜby7&CmMz%	ؽYFyIDJDbC'\\ބV ;FgSd3 <J\rp04)2\0Mm{'<3Xd2A4\0Hu\r2`QARnfML  CHp2nI&:,g8E8\$S70TLRpעEqT\0P	L*3`O)\$k2tϓ!9Z7VLKxk(5'IKa?4cv	9]uɽ%1*Hr\"\n*\$\"&#-OI	8PT*\0B`E@('FZ}l9\r:]Y:xHԷ9DGAc&=&ҵ@x߱&&,V*ں\$m5k>XCPh\nk];PTxx?MINwesJ`Zlm9A鉺ҹdy::B\nipͻ6ce4#0(a\"6a;sˆ-EDKYefd[<iz5-A e`KukոWqx.K,\$*^kbF>*@@ <AAZGՈ,w5wA!_HؗR49Ԗ%I)&3&VWh&,LLHB_Vm&f'R C?e2WIdY̼kPSŭdo0O<uņR\r(7rwA2kI(yW#Y~ƚX7CV5qor\"7\r!jīYi<X,xt~~B\"̵3*fH-ߏv5Íy' 'qL3g&<eKg0,a3%b!R8IlLo2/+=i߅m_?Vǩ}ӁWٻ/T.̕Ϸ3\".Kq2vWͦƈ@\rw	uI.㹫+'8i伧kkhם^A;ӉIe'Sj^bzF5n\$#}gyx'1-\0{9	Jfo5άFr[ȑp>ONÇfoO\"\0\0a,\"K=ƌi\r>;l%#GV\0&nPJJf#G\"5vPpKh21el8OJB00#(o0nL\nn\0n!.c	갹\0\0tln@BCc\rRF !g.ƌFN0r\r,vQ\\HĶBp.D0YKN(U#*֣bG#`p-%Dgg`[@}zϯ\rV!e~Fb#~zhQBDʠ\nV\nZf-\"DO@Qx^pMQ̐\nEL@A͸2,)6Hɒ2J!c\"]Bxe\$@%VXYR>'C=xN\08\$f\"6p/ze~F&qft2zrm.D\"jP(\r(҆\\Z?&@ϪbŴ	9.	@e,j,7-\$L,K~iԱrb8.>b2f\":4/y'r2py#r1R9#y\rb7Ē~[Fd,~CNTH#Z";break;case"it":$f="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AECI7!li((\n:Q\$c9fq	\"1s0Co&5:bb14߆,&DiG3R>i3dx_!'iH@p҈&|C)yNȃ2bclD8&uLrs<Ix(l̙\nC9.NBD:7Hj:< 	;\"M\0-jRӘ%꾾\"tjh@ef:H\"1 @</{4-\nC*(ކOKsJ;4%89z1/`P!=%r&\r<IܶL ɸ(&:°R0cVs΂!SR4/#0z\r8a^(\\0S28^7~+t2c3 MPx!L+0=QȓY\rb4ىJ9-C3n-\nR):\"3Slڶ @1*h|wꔃ\rb:+j!׋\n3 7C*&xX8@-@/-Bm+EvR'\$Hr'<?ܖ&5<je s3)e٬9\\aȈb-P;?rt {̂r\$!6x;m3(ݷ@7S䭙\rs,!@6Ó2|o/Nv6: nγΌ.~\rJ5mH@aة5-[r./=|x;Ź?O7«l4☶Ô=8=:BglSb\\4J~xc!-B)`	7 \\B+pA/&\r)De}#r>_PNsC(f)m#ӶR\rb|iX/vتPaR48#kw=!%ܮP@0L7:@!JS}P5J:MʭV(x-h7+UnÁ0P<^C]\"J3E:ti\\44NF<5EDw`yCy6CX@P\0azD?hBuOWx=hF^M=\"J)Ih%F\0PJJ\0POI*r(IP*tMߡv0ɒ(H\$jΓgii)2ȜJdh֑\"V	:&\r\$dnstPt\$y#Rxk!!0t\r-^*&o	L04+T(WtG	\0<4;\rm?RSH*9Ap]R&r\$\nNT@W	L*Q6\\af+\"ڡY;1;`,\n,퐅r`gjB4BeC!`2XҼqESim;MP*Pg\0D0\"SR`Oʈ@\r2[N*f>cǐB5\$@PR%q#F딓y&c6Afo-z)\$j\"ǦYzcL0gpp+j4ns#5ys1:\"\nH(\r:9JnA)dJZ<+1Q΃S4iGy0črUӘXWvUlvWy6zk Rf<̀gK94JRvɖ}/Nd\\搉݉\0PFWBzmP 0rNY	)S9liM|Ϧ\r.n`\0\0\0dC\n_FE\"9\0ìD xKRB=_mN'e`OԚك,zPL6\nXdMfyXIW2yzk4[QJd+k%K~ڒ &QIՅ崭ulH\0|ˑ=c\r؟>NrCA8s 11\"}NxfI7Lᵵ`LV<.9qmb˦6d!d\\rԼwpLxC=Ť3 \n+S+^\nA3k\r'n,cGnD|y1.})wߵmt'U!f8!TmèE6ql/;G\0wWGwn\rFY3˱w:_2A~EΐL,7MJL-\"b?M]^9\raC=B&K\n<2l\06g\0mYbp;L~<!:>Z#Ep<H2ǯx/Oqq/JpPP\n\"v+4n^`p@L\"`J:Ppppz:PdFfSpX&(\"[kIB##pcpcY@l|N%Jp.<`ԅ.0b,0	Lv+-zFP3e1іQl9X\r6ǂ:\n&cK(&e&Cȯ#_=Â80΢2,On!Rd  {hKĴ耫\$Q 	fHڥ:]D` P4&GwD_HB\"2##FidZ5P#b/^*P;*W*`^6(=`?#ؕ\rZJFA4\n\n\0Z\r%i1)kz\"@:§RJ@W*?\02J\\ÐfB\"20\r%tSb[KR%c.ƞ\"#M+ G,)ZF@ؿI*#S(:({3	:z[:33sӖn<S;:h;iB#Pe\\<dJm.\$+^ktO?I\rG\"	o>1p;@iepˤc9h<3xK.KL\ns`sj`P\n,ELƊqcy#";break;case"ja":$f="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp9 b:W&K<^\n2&(z>\n\$g#)eu@xn胐 Qt\"ʊ\\q4\nqCi\"VηT:Shiz1~BAXMWe[WPqI9kG2YaA\"ʅK2zė:\0T9S3P41y_yA	A\$#L+DOHU1z_QiL	T+DR\$MA_*cƆ6-RHI^ӵ%YW)~NCD8hBHc|E%qEjs,^g\$fi@G%Br;:4aK+\n+bsKJs)sC)P!/rDT0AW\\!WIU^2L%ɲQrsqP(b}'oƸvZ񜤁ʄbAdRa'#2O}^Aiy`\\B951D{'WȂ2\rH2SMrKԴD5me6Bs, /L18o@420z\r8a^\\0V\rp^82Ø奈xDARY`|ݖY~\\b9lZ<\\tj6	VAQ%o{t!V!siLr\$PEF!pݑơ6'\\GI\0QgG[@EgI\\Tbt8Xu^Bx:Q@vs~>[F%U?\rT>@E87MB[I7LuOVIHb\"줌 ]!W^	TзF^H=mؿN'}J!t2\"+mg3}ˋ<nJ\r\$VJ\$'Hoe-E H\0#jݻb\n1kBTFB%6\$!\\CJF4 sM\"RDjmexPCh=H|%9TGB{3)	*܀&(*eBrm(9PP4S^Z4WIN\$X̧M3M,3Ô_!kZRH9+%͡\"\nj-rʓ!\\tAH &9>}I\"\"z˙-.K+oI>I7I-h	!b	6j;gvXXri\r)4Ma7\"ABA|\"L \n\\S.(iy6d4К,eRTvJKK	CŻH86%a\"aJ0f)i)G*vO	>GIP\n\n ('1fB{1 RabƎ2T\r Lg\"E6!1LO<#\"#ҽ5F\\X\"9VaXuC&qrf#}+%]=IqR.81pOt[,LT|r*eW&kv>aL)kfMH\0'Hy3y@@%u_n\"hSc<-+ɧ(c{Wi0K;	\$1EC\"\\1q9E\0\\3D j}BI=~d(Jʃ3K9YeOAo\"I'X%pyK89׍.æx\\FPՉHk#SFĢD8]' 0\"Kahun1exNT(@.A\"	tp4JܮJ, i9`Q3a_sYr\$|C o(YTLckN+31ȱqk҃.k0xL3sU)`PcDE`хO)^sKR1N# (·O~03+wND+Etx9¹ۢ}X J<;skjdGI\\`/TVV\rGKp+o;[H4LasʹDZsyK7FCmx#H!Nػ1,%\na \"0D>hޘ^^ܾlȆjKAu|_Cq&vz̷Qv=7p/䞹dK+v;l)H#[g8\0^6sm%+&70(o!Hh\0\nV(?(;A7\0P!BIKC\n:aBH(:po\"d4N[Ax#^V3nQPbH,>lb(MA~(&%FlvG\0NaX89bquf&.0\\Ȅ o=2Gq#g\$:1+Ďm~b!^/\"UR. <.'\$sgqp~j_'hvp)11C14rEeE(|!*gnEi􌰅gf~ױ4'N\"yJ) ݥ0% :!aln7\\ܡ\"KbBQ@;\"(TcN;%p/[e&NbQwP|&r6w'Q'0#Npa#J}@,\"M\$r5,`ؒB2w-}zn\$Yol⯰*x\n2Wb7<0/jrGF!)*'\nJ1\$5DR2\nZ3&?u.hXK%Os0/~O-,ң(}-҅9К\$pR.i:2^r3:rc9¥<%,[;JG3q;ȹ/=r=ZN0\rVAC^\nF\"Qȸ@.7+Q%-B=SChwC`3?^DJ^.kVpG;J^WFSnJQޛbmvHN+:Q)=H+)THȁC9sC*J8.^4J!%^%*\\/<tKL./)3/T/.OO^WOBD!QOϠQ9CsJ%Q+JOQox'RMDPUUCԫUc8_OU[COU3Ei;䋮\$^>RuPsTg9N5FJ2ϼCʼav^>pa7c	0{G.I@3S֎!뢉[!J@qq6=q;/ uXSF\$Ta~NMi>\"`\np)4\$A-lmŐ/,)KugZ<,h\nHa&cSP@+}h5N,c1ck\n\0Fell!K3PY	p:aT#\$!~4`%c@cjAj(*f|6v}_Vm7ph\0\ro]IRiqpƧt/7v\"BH37I6yC\"Pue4euo6I	Eyk!L'*>hP\0 \rrs\rǚ?n@2B/go@sL%n&pWw~\r!77=F<!&cUTUQ\n\$\0";break;case"ka":$f="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fT+U	]MJH^x894\${]&?M3s2Ԏuiz3`̞*Z%\"xܢoJitҵTA=D+I? y12EQ~\rux.ue}2T?rNSzhĬ	ZԸH:\0'i.o.ķIă[2Hָ3Ђ\0[W-o:\rp\$H<C'or.+(dɒ.׽\\3)VD+&Ji01Vn\n4-c+(V@OPS-P2D.:2ֶL\n-KaB<ʺe+Ҡbdq-ULC:zExLSk9=~\\tϓbԵAίL#1IRʦNsfrc75dv_;(7j*QWCNiZ1P# 4(Bn0'M[k.\\ݨ=B׉L_i!\0ΌD49Ax^;pÉb\\7C8^2xώc21x?	<\$i;_ =djպ)Lđ%uao6L.aji>VzA-+q+hǹWNTk(ձ.JMkkbENO6gR9o\n'IlM\\Ҹo/5|' w>,ceqJHu?@5/Aղi~.)UWn(AtBkgY(Ⱥ6D(0lE\"bIQpoqÿFs~sc)}¾ZEJʇba}\rbߠ!D\rY2/(wS0i e:d;pݺ\"fV bZY,\0Ce|j{lp\0CtCnIyk|o\r4y d>4@\$o4őTIҁ]h|}%jP&T̖f+˙&'&+1X:M'PLIN\$e>TrƪlcW,KiM&u,]LTWdᄯTd>M1\0[\"%m֚r|Y]HX#N\$uDfc<e϶`̙6g3DbɣC(x09DZ'=e?K1J1IўY,\"3BH+	\"ͨ?4\\ШK:((i\nMեjxTK;NR6@E2&Ҋ4iP)wүJ\n`eׂp>nT9m|wxc LETR͆vy\"rWS8l.'R2x&SYG5s>\\tb<#B2\"5iF*9pFO#cEUA) 0Sb}H]*\\EwxkMӍv[-1mF\0M`Z(|\"pr3\\J\0h|hĖ{=ҿmב^\n;P_;!Tg/+s;LBO\naPl\\I\"};~-f*J3|CNѱYJXcCXDAB.<\"] cP|a*0oM:蕉*n8/??snYN[;;P]J6lmt&&wA	DP5cD\n-TbE7M정ȱ)pcX46efQ^qn/:NY=+W&V>%xU]ty	]6b(z7d\n|ViO*`U\0rn5r1*w+uWT MLumWGH-v'l{|y	+)MИes!6P(s3<C~?bVq׼e6AK+iO.\nfC\r!9\0xmdtvԏ% C>~^F:sީK>KNc\rd!V\0c!pR{Xw#w|/l<U2@C0>kC&NtFfDKFzdիDE0,5&0u	\"mkF \n`cȑM¼Mg(⼸OFVLN̄΅9ޠ(|W5Xb~5&Gl5b2^G2.8>%ŏYDL1F@Kn֯A	`pdxF*L\"}5g4PNH%0h36Niz*^1\$q)'\"KBhmqxE0PḒjr\"~x9eDć\n\rÓ)IHXF.ڲdIаc@\$Ν,PT(!@ϘNn&\r.¾L襮4C01t\$װ\"\n\"\$+V/PvpCn!H/z0FGF\rif\rt/\r pprHs㞔 f܈vAq*^AQ,Zq(13-i)'.1\\1RiHO)12J\r*A|tw0QeT&~.9,g#4r3N@3r0^с46qx1ϐOd]v\0svK\ndOq#.(3Jx\nK0G>6-\"\"&5o|dؓUg 2b&8Ý&J\"F\$J+b[sGJ<I#ϻ1kCgS,е6.p.t8rrD&0(DI743\\{PMO,'o\rq4!(e76GPa7HmH݋]&TGJ.#>S'8\n=T)='KT߭h*S/5\"HSOn~5dCOYD\$<kQt&cJy#4no\$3OKNyy[?J2bSdHUT<U+H)! u\"#PeIv	QQ3{G38Ո5WItUY%5VE=u{Xƅt;EI4EX4UWwX\"('\\UruB1QBt;uLd\0Fd3@O(@\0&5__\0i&-`a _ka\$obRz`/tTӯ5%%Od.T4Pp{U&muYEUKԜ|~rH2RIVYPpj/pf0LH	u	2\rUWD'r'5PrhH;ma¤N V	3lsB;d(\"/^g>2ʂ\n^ei\rWgG dR4P3St-t#1Z+\n\np4	U0D?6%똊ۥi\$^zWM>^lN?*P{;r6F*vsr*m{{T\"al~XP%@\"eq6g[vS%8x#MֶF)	ׅˊ`Qx1(d\"^	E)#\\[ظ7\n>5rAˈTr-kt庀Uv]\r/tgtj巆(TL'GGFU#w(0UoRmU%OȂut7@K*Z&WtÆ-XzW>RRLvsEx1x?|Aqm#F,`˓'p\rpx4'y|\$l~\"bjN3M^G7#G'S\"rfjfrgfzghyxhƐiFȔO*kא6ō \\";break;case"ko":$f="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4(s2Cs;jGjYJӑiRAU\"K`I7FS\rzsaV/|XTSɇZvHS^+v&kCi=#qA/iHXElKȤ;Fv(=v!ȉVWj)qss])Kq{fv!松i<Ro@Y.H (u3 P0H3kN.\$zKXvEJ7\rcp;9\rV\"#11(@2\rxA\0:c h;#\"LsLJ^ G4T(izO4[M3AVQV7 D**>d\"5/\"p\nm!InӸBZCE%.S/DLArBl<D]LnyNS*u:L	Zev(E# -1z9|!Ȳ8@0c9=ƱrH4\r㬂0H%ɡ`@`C3:x\rpFQp_`I|61,3F#lj4px!W^St춂A	15'h\nxv/2׶.Y{?e)%Sb.RR\0PJ2@僪Z;a/4Q%K<dy2 @B 3# :6!Q:NHq2dLUY@V.\$4DCڥ\ruePܐصdt9c	\n\"dU\"esЯ?SUOu.5	AYND|Һ}wvA_^R_2Dm9I3ʟ- j9Y(\\ZnL\0lk\0ShPƄ'ksM\rR@CsH,!C-zK9 Y9%p9C0i\0002Đ|бFa9u\r.\ry)lCtd+V*Hraȸa%DYgJb@ :䆻Wxfr@6΅EbYnp/\n)gk@	Y {@'ZTUtB\nXmFKxJ9s.KbV- +	65H2.4Ka=6*ûca<hR92&SBHm86_aI̃[.IN\rDRβ]K⤍*Ix	̕@Ў`t4ǖnL9OC4HAH09\$䬗E}N(2I\\n@s.	H\n\n (A>'Erg&\" M搨BzMO\rӰ1Ҥ.Z@pA\nSX\nG\\qr\\i3ftω	_\$ˤłI]Y\\`)*l7@Hc\r3AL*2:z02أ8gaL)b4!;bxI)&[W6P}2J\$8\" #\$Țb6KIp!f/%pR:3șXI a~Bd4.C\\:@V-Vy9*c݄I5\0¢|/X8!	@:^p]iJ_)BN;+(dB蘮!7F/&*moy9-s.D\\\n uLLֻjȸb>ˤ읡g%Dc=i7\0! S`Eà&X1p5Ie	PzZЊ\\:^CxocV#KP\\=֏Vkħ_\$\0׷IV.{ĚeLTc<I6hi.\"@49\r@0jWjQ@f?N\\<@4zoYFwvmPLNP?	Jې؝4'_{:\"\\k_иػqc#~>lY5jl\r!!P#C\\07\"wO߯ŭa!pˀC1hv`BF'8g+;1&57@ciK|-vѹIqXP66\$DJ<mhVT\n!AHiGБ}5kd{`7 Ȅ.>e}\\A1v)\\剬l\"Ճt\\#q(ȹٿ{	/3舟>x`K ˋ}rU,M-(B\\/.ש|xFDx)J\$jGrOC.<3Z\$tg:lTU2㭂l̖\$ \"hMa08#ϊ6z\rؐ萆:k	Ce3֘\nFVTjƣZB\$q`0c\r&t0p&-ҰH\nlPRf\0b_@Ȟrڑ,J\"mX|PQ0x-&onz4o֬\nUpey0nHb%\r}7Q31gDPpW#zhH1znL#G͂Ց҆uرQdY5CX\"ja\"\"lp2%zTaD0F! Yr\"\rƚ)\"/D0\nnGPqXQp9vƱ2'qbm0|gan'(we<ΨOҔ\0<7B&RTEn.!2?\"4c{ޘ1!2/y+r/0\ra6s&ΪL+R,s!rj\n\$\"d!Q/+*/h.\rC0LNQ4%C'5Pw1?5%.R0l.3W0R2Uj6a:|@\01^BGp-ĝN;Srɪ3;\0<=*oUtSǏ}8?f}2@ӕ@rsA2.Oa`UMdJpGӋ9(PSi~YCH3/+Mp	3\0ȻDΌFns&ͲZ7fg J- И4n)025j:&t-T!+T\"gi6\rVS=j^g*rtn_BVZGHpK` \np@OD.%t#C(04#k:P\0͚hC.\">v&>v7L6\0NBvG#}qm>}!΋DYJ6A 7H*\0}U\\dī&c]*D]CR/5\\Ш:0!UjKSi8rD\n\\u>@@\rE_D)X?\$I\\GPuCYKDxvO]\"\"Ds8@D5H\"&cܵ0!\nYu.KJ8@֎\nC]4Ĩ:.kеڑ4Cpҹj9\"'iMZH̄0Q";break;case"lt":$f="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 t7\rLU+	4Y2?M3te>\"K\$s5Ms:o9LtuY),#)gALEuy&C\\MQp7Cj|eVS{/^4L+R:I'S=fPkʼLnx\nO4DXi:zE?FĲC\n錎*[r;\09LB:\",,\n9K7#DDc\rﻎ޲Rؼ\"s2h(֌hҌP\nh̖*B  2C+\n&5x2lĨڂ2'/(**#)#\nbz_.spܺ\nm+OT 6X7F8D@0c0uzYx@;Cg5DU\0x\rhC@:t㽬5J9@}C ^&.`\$7x#\0\roD(C>%:ߦ)V9?LТ̣,\0V\0쌏C#*P++ A	4yv`:+ڄ6İ4\0P6*PԶNL2)\$_WD#0CXIζ\$79b ӈI%\rI:cc	c,KO1sʲu\0\rc0آ&8t\$@T24Ó/bZF_\":?B}mĺQN޲Xղd2aP\n)^H6ղ\"?L2}\nhi'DKt҄UP0`!0be\"M09R\$c\\%;2..GE6X<_!Б)Dy\$<8`UXɆ*|Lr\r42\nHJaDS(d9f\"+eBJpyi]Ʋ8G¦\\h	|LXe,ŜZl-x\r˂Xc*D|騙h7SptW̸B\$_Q:m%\$&]HJi,PE\n<dB#bxc^HE^9V^\\r]72nQE7,F⺻W!̆di)<6C3T%̒:G4!@\ra<\"ܣqBLqdM(QؗGHn'hrnubPrQ%#aLd)7dIKPyaQߖ!	VPzzAh)\\;\0RΛ5͒pʋ<0e!091'8KQ3.Qu %sGB4r\0DI	1(2B\$]R3@3a!T/%\$@ɳ%ee%8EШm\n1*itegC VGB3RC*6\07|UQVP4!-W@;V\r\$33SB6Ub1W1ϑs|ƒx R4	Ӈ\$sLdHyILi=}8Vh117f(WHlqIG9{ȑ\"::4A55Z{eT`ay]eJInYt|S:ˮ-1W!c6(CzvBQBcY00̪\"ugbM<Sǀ\$%xL~te茉M:3%Ԏ7X h}9YYi!:g殥;F8g.btd~	@f;v}XɌܭȂQ@IhC\$)hZ[!e~d2\\eg!4Xw;+&_vgA\\8z\n3m/\nQ֡x	X+G @BH!yiQrUgtd5hC4d9[YR湞WDI9\"[0H݄Pع\0һ.ݐi\r\n	}`v;\"k;F3TvJ&WC\$3O#<s!uo/Üz~lf_=]aXHh*DHT;rTCk/#9u'	?[S*4o0bXa;<dT5r3KN10&њ]sK2Xv!Q,*C.* -b.\rV/FpyZ\$p\"/Mq//,ll&'B.\"IC<F\nJ?c@GġpGt!L\\G\$3D܇*9fh,dIt\r@\rL\r`udL.P B%J,y \$\0츹L\rd0&y0\rPǈpp\"I\0M\nq5\0EXul{kQ*G	1.32oZduPG/:Xðc!0hg\$l/1qy^qc#,F9H	\"Ä!\"*C\rr2gF\$eD`(Ph8)BB~(& CQ_,m1 bPQ/	 1,txb.*\\\01r4cI.^m?G!{\$Pr^>?h1o\"V\"]RB(E\"[+@.\$@b&6u=&1`2dk2;g+R2RPt\".l&?ReR{(A=l%9,=`a\n\n&|u+1rҘ.'%kNC,dQ1F#=\$z#-.+\0O6\0'\"Xh\$Z\\6SdU(Bjj.5w7o\nҟ\\+&1%3o#ӦO0#hg4&-(sV'(@J&OndOÄ:SO,p+SIQ\0CB1G,xM.l*d4Fh7r:K_c!A^:B-AiBCT'n^ffn*	ƛCt\"2qF3Fn]Fo(e\rVb`@^elƴ\0P&+_7\nZNt0b;GF\",q(jT\"  d5'p	8\n@/Cc	/<T3<bC!3A*Qc=P׋]j8	z`RNP\$E\"KVj\n}PՆ^qo,8LM5W0DOgYU+hFClK龷\0PGoZQk6|&P!Cd/ \ns&z%iZچ*\0[IVt`1a,W`u`XzR'M2z*@U\r20i,ED5hLC<@";break;case"lv":$f="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(:T|i8AEh2q1M~\n\$g#)e\$:bq[8zLL4r4wa:LP\\@n0=))L\\逆X,Pm@n2e6Sm'2	i ǛfS0ƁM3{q[ܾH=q#\n2\rc7;0\0P֒c~\rx02M!Y^\\&KV@LBC%À9\rR\$I7K:s	k\r9Ĩb &pr#J^-Q(N8-cH5H(\r4(*XF!D2h:4\"郾\$\n5 gRO\0 H\"H`7-B6I#^l^.hPEXpD49Ax^;؁pO#\\όx79J|;#5#pϦ\n\"z:xFI2BmMj3C:D8&VG8M@-H%/RrK![-A(EB8>R*-(:{I\r5ݏ	|:m^cUŸzT\rw;\rI ·k:zH2C[ۧ	kôN7A\nP3rMz((#pD]6&U#(90k~9уX]5MbGXU4O~0%ßhIsXS).3l[DƔɂoR5k(1L֒\0006<\"^	02:j=Nw?!:1(i~ֶԎO\\e+wC\r4s` >1+& pw3g`:,gQst\nOA̡:GHRN1;Hr\"扑>ҩ}U#niA&'TSa%\r0PK>2#Ē aDI58˙-`\0Ɓ'#Z[78DTPQR<Eh~w%C5qLYB B\\CJKьZʲs.5yTtīJN -\n0לR\\ .V\\+xXc,bZN	/qXb\$w\$BɺBs@DI:#ذS+əe2ʕ#pb\09S6#xĹHoEW_\n^Q3%\$fFwRRxaH#ȔAی@\$^ve\rjfrxEI@0S3M:G4âM.gŔ5}^摙D@̖tuAn*1P`{J@5~YD=6r R`_(Y4Hsq(\\WP\"ABh9mMfIlf-+\$hM%(rp&X*I͹ۑ\" Sl+38̺6\"u|<)IALs6d1:HK405Hͽ;4\rmX;ZљP@b1# r`>HI%\$v\rb	rkk\n6XyBBo\n\$/٫0'SrWAB;9(':_\$V[\"c&8eIOa:7Ci 2LwET2 a\n_)k|Pב}gBIqEVi%;q}=\"IBIqCPNGS}QI|\"CQ)N4l55l݁g\$2>p\n~h+?9.dz;P`\\\r9GAy(u	4ocMPi\r24n!e5;&^siL;-- 'ԛyNNu\"&cLkMf3\\pV{䜘CA	Yy\r+A|fEzڡ#!P*&VnyU\n%-\",\0溝nl&ZqЛ18\0vqQ\r\" ;as꿻>tg4Q {}ԄZǋﰲRZCaCd|5rS-^IIi(t]K*\\L~GW,mb0.dbq͸@B 0|2;H}a)d\n\"{uZȽ0~7#v.?|8AxE0FCP8,j\0Mr|*װ8?m~mZ),lC,~ͦi0n\rjfAp<1\"<&\"TfjDjgɰ\\zPrg9DC*8g%&\r`(#ڜpk3	CJҁdu1,HLw6hF\"?DS~.0w%D@0:A>,B\\'r*-؆l\"yaVɂ\0P \ryKT*_1J1R&LZ5\n*B]\$Q:1/eN]L\rQ+p2J*&\"*IEf06޾iZ`F#j#.\0J5őnB.vNN3fJ0\"\r(uo[.zDK:vHS\$̟#D簑Fe\$\nef5\r'H>OQ`7F\n#Iw)QJ#R_)H`2]!&&Ǡ&+r&=+k,.r*%&\"@azd)R-r;E/ %2z\$vQ>e/NgSg2&pW#e&0da)-7\rnB\0:eZYFt%.054SH#,I5sA54b!4<6phް(e09s942g9&@fi\$,B\n.0\"PPs1%32<`g)2B(Rb3#6o\ng7)%M\"&tnd\nRn\"/b0n.d\"qȾvB/DmDo9;Ӝab>tGThd\r@b\"c*M.I:@@A&\nZØ|IU\0t7d3KP#c3As*OY!CrƬ 	\0#{C4bthjf\na`O(2j`2l*MQF@ԤngZc\\4iJ2?X3Lrb!CbTVSUB	'Ԉ-4B>̧\n*DrDd\"̾BM'&,ʵr2\nE&6Wc:.B55UC@sL[*JKvQ\nb4pG˪jjW%vW~X%XEY^}`,[\0|'Ѝ\"";break;case"ms":$f="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7AD 8Ls0A7Nl~\n\$g#->9`\\64Ԭ\r pa(bAS\\݌Z*fjSi*4\rfZe;fSsW,[\rfv\$d8NJpƹiɺa6Ӯ`&s=2#*L=<Cm(5x=c9#\"\"02\r*O(8AhS9cI)\0:z9#i~#J	{H5@#CH?.\$|ŊL2j38=-#P2iS>';,0	؄>s\n'#&\rkS͡j6, =it+\ré1\"X|\"H4\r1-F 4.0z\r8a^\\PcsAc8^D9xDl4x| &\rm;̋&]	p:\"KԔ4c+*X @1/P~,	c|+*/ɰO\rPK\n,S#;i\$\"ˢ+93%+0V\":a+72Ibl\$k:Fŉ.Lcz㲋8&Nj\$>?SiC;k)KZYN&ڤtϊTg-hܮ\rl:89Ju9`!#[8[N~=UMd.3GڸjZN93\r+\"ÔF`PBba(1xь7\$b6H:BNZ73]#3e.!8Qs0K1:o*i\"ꐒ\"gfg6\$䝒d\"SO4֏2DcbzRiQjz1i(tǠpĄBܚptʕSVUzVj;ubW_\"dbbvx>|\"*3ִBD\$Kr\r!akD)DɌmYۯPr GHlN)7\rc/.2BdQI1=g0(JL0 \0D5(Ű|Ħ/(\0rQ72bLJs1t\nP9 \r䵢D\$h\r!0Ϋ`X aL)iC;9Ș\"(I?wBcBtKlؘE1sَIx!(Vj%rRTyE	iA(!'O#v<Ɨ'\$]I=)ɡL\nG\r\$krIY\"S6!*JsmyMfİWK-Y&H3|A<'\0 A\nPB`Eli0&I\$4,(w؛Ch-:&\nJD[6d9Tw3\$cO('mOnjVtL\rEXn\\rʂ6XpAQk*- X~J+ey?O/;\0fi()R+\"i1@)GV[]j\0KW12,ExY85\$OSUu^ZclM	pb'2SE|3 \\dIle\n#G3Zq=\rv\$ؖÉcBxm\$!B&kR)zAmi~_o8cb[8_2K[I˦2ƀ\0PQ<~/dKYj:9x -%]E5422VHZ`U)F5z\n\"؄E[gU6.͎q\$`s\\w^=ܩ<yǊqh jG!#8Tmn!gk*!%@٣D69:\\QJ%sGn#<`Qv.0c [ϳSXEb]IPvƺ·\"8tWJX\$ ΂h?tsgl1qi%toE\r=ܤz8k\"a!7yTL:kɆaNVhMнA	9wo!|\rlJ,c=oD۱fov	[7)?dvew&ņ7\"nkM{;[©2{5~X2acF%^=)ϪϮI'PC>\n8G]0o;˳dK[,K],d(hof^nqPrV#.Fp?8LP{C v +ǰ\0H5g-KJ\0I)Ě0:{PpPOsF1pi:g[\0dЎ,9a\nM\nP.pX0j0=Sm+mhkâ\\N\0+.Fp\n j-2 AD63\\0&)'I81_`ʟ)8HdpmLLG\rLq Pq3DY>r<i~LQ&Q0hҤ>1cNE\0`\rN(	i\$3BHjBD=\n	>1fSNPo\"\rVc!n\nXˠF6R\r\nZ2mz\0r~PfD&Ψ\"k!Kj{;b3A+_%O<5er-C'cb9h('̽D'	ʐ3DEζ*۲\"}(:0')Pf歿//%Λ\rX|΀@l\$9\$hg:&\\&spk`@A4ibF4 נ\nP	1\"?!7	N'B1sq/j {輦36>g@H=S)HBCr";break;case"nl":$f="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7ADs)u4̧)іDf4Xj\\2y8DEs->8 4_F[Q~\n\$g#))UYv?!hv,c4mF\$r47e5čʰ*wEI}Na#fuVlnSoгi@t\r2a1hl -湓6FG5!uYq|P+-c1\"̴7H:\$0:(r6A:;@;C-t@;;h9Øtl(:f1t\"\r`@̺Pݰl#Kh܂{,Th)oh,J9+1\\[-c<(چ\$OHR6cAPhH!r^3:\\:IQE|Xӌ`@,3T:<^h\\r48^9őp^(&0(x!J*IǶ5ij,:[[O-r:#J5CkcA.0\0JC4h<	cz?=\n!t\re&\r<V#]g% P^+y(^C|0O{̏(l2/5iTh훮16 bQ D:7YCP݆>A<00=5.Q+? P2\0kv\0O(3(6j9kSpܼ!O|[\rz*-p䚻<wjKaX7.?O\">+BGQsm7~Z⒉tD}`tO\"WY%kJL\0` B`ׂg\$_xD{9L@_d ǪH2` *(DHbe¢hIBun9\$UTF7-mpC`xl\$,\r'DJD]\\\$`V:Yk4;>VrZa/ Uvdy<24Z  .-I@˱DANT\n<ImbS9B DZUj*D7*#~q)i	R̆bBљ-3^N%TG\"H\na4hJgPRIP rD^U:\\\r!4CT_QqE3D`L\"Ĕ7悁D.j\$(QPﮗ&EQ^32dӇD\nfԂ\0F%	E0%Asc\$ZzZԉ҆ik)\"@f\\mtOłcҨETԯ#gT4U#gPTĊRNX!`\r0!XE#[UL2X3)L5A>\r&\$ȹ#Ă_`@35GlQi>6i)&;<lT 8PTL@-hlta\0H;i	tPɑU\0l\rO/3.I8CtObcw\rL%ϮrDU*WCp۩ER\nFCW\02ˠMۿJG#|JIjza\02v&[B`uDϤ%áT͸ʖL]!O>w&j'Ē p4*=3,\0OD%H}}5ȹV2>m3fr[5aDgFyA@Fhn7AUW9)@!\r1\nP 0Vq̜\$4Q!28ErgO8icf-zxK꯷zm#M\\zQ&e\rmY%8wczr	18&E=/\0R!d6Rm2xbuqS|F<9'#_;ߋ%\rPI搋UUP9J{(L \"D^bq\nr`\$7~*l	a<ۻlȊ_iF>V[#\r!Hzf\\gB/9Gjh:Cx>\nx.HNăBzı3|SNPڕyۤp~KXW'B7q/\rCZ1;rcܩq@3=:nt1\r\0DttV\$\\Doo\$ ιm:k\n8cl\0ZJj&\rk\r\\r^p&0`ؙCf#i^\r|=NC2./Z\0pSc3[\"C5NM&6\"@b)lfN?8\0a0F0\$A\r\rǏ\ru\"\rDJ>\"0/^Q\0*`pVfv -nkP\nFL`\r&2LF6P\$O\0\$[gEh\$1W&s6TO`#/oWSJL:(X#q@',&R/0Uf7qhDԭD\"BoG\0/-'A&'o0j1c\n^Sb\nZq4M#,TQx7\$\"TN1٥TR0RT3&\$E#K`7\$n1(0d(vu\"\0qp&*d42tݢ0F,nFbD(r; @kF\0J22:7#j	\nc*\0\nq<A2V<&C\$!a|w/c+\03B \"m(^ұsdlRtF\" z\r`NTr:Q!؍*\n.\"dRw:D͔DDdhd\"`-bl8b/̕==#ӾK>c3\$\0)3?k>1S=L2`L%F(SGAS= (j,Vr\\g/Nf̾/dD@8g<nz9OK:!+羀FL PNy0#CZ\03&bL*CIv+@0jE4LϽ\0#h<o2@ZBF";break;case"no":$f="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8G#<t<'\0,uCkQ\$cġsn,p&=&%GHi3&m'0te2b,e3,	hG#	*\n\"Z\rRs3\r,o&wÜg ahf\$A29:ta3\\TϾͳ3}u8h韡B>\n)%˂kW?Sq7p900+zꋰ8c2#7\rB&Oӆ#Z8l'C%Ld	(ڱ<82>\r҂+KنS:Bs::#:þʎ6	Ģjp7E#p(CQAI:('\rZ7<cȽB6jH|#	P1prDE<1Ac:\rx!.90XЙD4%cxY-\0As3_O#I|6Z30ZP7^0h댓`+(#t\"40K%ʅH;˺ҁB9\r΂\$H<M(7NH*,#*Gs4޽i\":5(0c;1c\r8#!	h3cۈ>	43n6i8)«nů2!ZŃ;L	\r`c]`Z9mc(h׈jxPS7:8Ø5X'#׻&\n=1+M/{85#rmq(\$JEp2m@q|5~7\$GRͅġ5Bd06|!q}2,ߨ>޷چ<\"hFb\\&Z4&ˤ,]*376z?NȄ!%3!	ĹFn%5n((`P iJ&<k<l6\0yh s('z\rjCe\\a\"U\nVE\\VU]%x+(\$h,E}(.y\"tv1z04Y:GF)|:VBi-p8\$t*5kfIO؎axX HliHpIpsfD,LZ7-ƈ)if=smE!@\$\0[-.6S)o9:Hc%\nA)PBnP`<2 _J>K&^a8uN4.^YA8)<4)\0gUHI띳03\r C8q!ÊptFG\"\$ 6L/K!=\"@3+s\"3,dI)44MBBY&o۬/4Gj.\\\$XR(*Fpq&rHN31{>C2LPiJ0Ԃ\0K,.螳iKN`qt-9?RHI΍p\n6ó\0U\n @\0D0\"fSeLU0LHL+Uv2נ\$@\n\nw_=4/tHLs>DRۻpWJ&N|{\0nB	\\.=дbLi.+;\"n1*Lb~O/r\r!<Cc^)S:\n	[S,rѵ[#<Wz]*d[җ7XLH]\"3͐b6i10xL	bcd2K(xel,ÿґA\$u\$gpb):tPZiBLVP䳜;:1@C	\0tQѡVum:Elc/)Fc	f.Q)O8O	jnXr)Whr!6@ [pesa#6vfJI;/æ&;%e\$;uЗ	\$j\\\nO8#B	lOxWͥCW(\"ٴFJncC0˹MJt3Dr0॔P9I>r&wnReQNR37рmk	7G񛮺fY\$V\"_3(&ؚ\nF'?#ف9ǋs<#ݍMS\\yP6vpNS`\rsL}'8]Ke0B/=ze@'wo~:igo됟;NK>Ƿ'^rhp8<&o\r\r-ZolgM|`ѢFN]hOffѐ&/bH)l)0RifDv,EF`AIn(Bύ-0Z\rFH*ҙf~;<)f7bgp&<Eu<-:mŸ]\no,C<P\$=Fbs :p5'f&:o3l2^ʃ	d K\$dpD2\0\"2e;0~FGV#qt3j&3rH1sO\rPBlsB\"}FaP.\0~<ҭ\$1.\r5B\$xdB#pa  r-6\nHQ81\"<7q\rCu\"G\$C\njCLN\"+2[&Q\\릪cfcNaI]N\0000%(i%E\0E7\r/)@)\$S*	fFGlc)(cM\n7@`D\"#M7|nP1t p}?ޣ;,\$gN-,N'3 Np|)l:e#dQ//&=rk	'\0Zj(ҍ8R9å]f9FGb[St}\0+trTzОd,4343RlF(x.ڿ9l(Bo%,Ӯ%VD'7<Db\n\nj\"u#5ttܾĊ&ʱ>ϠoOȼ2.=Ӥc<#X>f<b\rP\"\$ϊ0R!@";break;case"pl":$f="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AEC :'Ik0geň\$y;¨\rfwS)3	1iz=M0Q\nkr!c:DCyêI#,d	CA2eӘFաњd	B7N^ qR yW~Xzqu&p7v\nBBR\rh01!	`?(.ǌ=%s1\n*7C.:J4110Cě.C(3+d==,2a9J ԰:p6OT&藹ZHޑ3J\\92P&P293`PÎx\rbPĲLk8\$Ep;`?c4t9O`23L\$]EN,f:>蛌O-Y!`@%Ch3:xg\rI3HAp9zmEkxD˱2183Z[4x(CzЏH9X:.ʈ.ԈKm18kx9\r;tƯ	LZ:9&L9, P7\\pp V0~FJJ0I銛'0ڋij8^\n>è5O8ðCׁC8=!ؘUIX1&\r,\r-pܚ͢T0z/:=>qE`&Cx;8AOck=CF\n8@KPW֯]pb֋e\r,l^,k*Ϙ2`\n3k56ݴrMtBH۬iH\"u`B4bm꥕a\\;#Թ8a\$@1u\"\\L`ҊC#_Lk}/P1\"`̂>\r\0=\$(zu8vbs@}ĴR12I)B80ET`71vH C풪V]p	:lռb396c>7RTv<q=D12HE',9CduL*I<ST%0'@Køyl_!ȪyԲ5Px98Wd\\r.n\\s0A@*X!e,ŜZ]lHnRMq.CHygyB3n142ȍI4E~N\na%%\"[f-(:*JhZ9p(IY\rB9*I.O	\n%bR6KITr%6A\"m54^|aݙgN]#)<<QРX\$&mP\n!z6`g`D QEq'ঌQ4ܖ\nnL[jJ\$1Ȣ!\rٮ֚\r\$A.c.\rOXTi_δՑxCH8DHC-\r6<Kx aL)i*.cL/Szq4>,\r&D1L#iuĶ@DD[0A6sTs2e|*9Be\rd,S}S2퇢+Ed#5j\"{財-:V	潆d8	a;\0l5^ZA'\$D:`H܄p[HR*drx7y@Ci\$	lֱQe?	vblHCA	]̄NHNCf3Flvm1MOR(rk\nGzih>qd]\0i	n-	,2S<ҿcJzZ-YSx5۫xRb\r9eW[_+)n4m`Oԍ4Bm\nxnl(-|!A.\rl*&ӾfP!<1AbqZukhxwh5sA=`T!c}<\"IRWAC.EMi7i)_n;5A1`֚\$gm\$d/G@Ѭ]D˞~卾ݢJr0:5eìIx!vtGFIfGA\nP 0A'A%1ʁyOeLep2fmW\0ypcly5?jK\"7/X1Ծoy)FOR\\C=%ԗo1>_㗱dM4nxc^\nKq+S/ωD?)|[8p\0pO>cLǨ0\$.BbHz@RDèNb%c1\nn`'`B2|Fk%<bf#0F1J;`N\$~No`=).\njjL\"ncJJաEX\r.8;BH\nPP	\nˣ	oE8F0^ćH\rp%[\r b^a&\ri8if&0UM\$kG~.`iG:?GC|Όi2QNi\r.\rdfpnL. GgFj\rKxPob(R2E\$BՐoMMQQTpp,VZP\roxJmboKQQqbH\n&\rg9Upσ\r\0%2|I,3Oy!qV\"2\"`\00%4h!J0\$NQ?2_'cpNv K\\]\$ΆfZl+bF#*|Jx'|kb#`IMpLpj)fLe)t(ŮCh*I6G<!HFBlZ)n22c---n9H'Q/\$bLΒEp3s(?\r%xna8&(}~#,h2DGzsz˓o53fJ'3!N2#q\$d<#o!@P;9jg2Hg{ 'ssG\$25R=%2ї8Ѿxk֋38?\0=5@A sS*l+}\0}C?&C@3O(sCE?34\\}l59Ǌ}4^=ED\r(Q8FCIftiDR+>tJ鮫J'KKPHFꎞ=0.3gJԆAN0?1M\"XFMNGCN\$-d}#e{8#AH4	\0Pg\"2y32}Q.Qu.:w <?{Tz#,Df7NBVb: c!h,#pg:%V7t~T1`W<cs1r7%o{##թ%O\\r\rV\rbtaIB*1)=\"z0\"nCZXb-\np\$6,=#4񦿖~lT(a7eauVn(\0QHDH!2\"BvnG^R'9'c]ؿqj01\n\"\\9r\nZC_ddfM,A}bӥb%R?bk	Q\"sB6qYl:Akl0C7s\rk2E&@<f\nV\r;#2s:;g\$=56Tlt^cTr7+Ph\rG|?\0^̾JƨMo'&gtg]uTKШkYƉfL(OEj-,#fgC~\\`P#Ǳn	瞴R#`";break;case"pt":$f="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTiC,i؎hQi6OFTe6\"PDqe0̴m,5=.ǋo;]2yg4&6ZiC	-MCNf;7bh<&1N^p|BRY7DV\n8if)b:[NL,hlI]bo7[2XOԸI2>\$P#8\"#kR߉-ޖB<\np7\r܌I8䔈jıi˾뎈 821ĎcJ2%\"Jά:A\0ꖬlK8&k*\"Rf\nRCjQkh&kK5MJf\rP\rM5O\n<`ɫL#k\r>Qr.-=QB+5.jҏP2BrIqrk#Rkh1P11\n400z\r8a^\\U\\Ҍz2~J|R34jx%\",2cKӓ#tP7<f7ꍩX7T< Pp΂ @1*6\r`+~q1?302\n\rkx:(:CO7k2U;n(\$ߎ/xٶ`1`P-ɢk<<ij^!J0\nkb/_&7grr\nb63;=CI4*C}\"#НdcV4hcQ2mh%eS\n **̌|r߈Ǿv=_(	˳\"\rDkg]8rCy_+씿\$.0|c'JyNVSRs`G:AZv:H1qUĤ*Z}LQ@AP7\\RQ0r5f'C8a50D2Z[((`~S,T7<ܼUtBGLhaHu	11#Ŕˣi&?f֪[+mnu\rJ\\7.gFa]ƀ tLK4ZZ!ؗ4rRK9\"MˑRyEp:rLŖ#	/A>FhȼJk9|g|0cMi\r	nIBKx	:rh@PF| PPAK\nl2YȨl%0\$7*~9;hٔKVe\"Y`o78Lˉ䆄x?	}T[G;F\r:՘XŷDTIPo!04<Fϩ ^P(K=@\n'nL6xWVh34!Hcq'Dht=÷	9yUkDNےI<TWՌ%*:j%D'pK=N ]7][kBr.1w8%\r@`<2ʠbU8r\"6B*X;Ѽ%.v	*\0BE@\"Po13< P#QJ4Iq0n63x\rQ;#YRn}MEa^\r!:rovSQ@Z\r)F0Pn\\US#i(L!yE2jLȩ}М_( GN4?](i<\np1Eʹo3HAfRd̫%f;P\\	2aE07\\K ɂ`c8Ǩ7.#a;c`۳{}&,2u\nb6&nX\"z]7cLwjeb:T~=#Kٌ\0005Wlb\n|\$5~w\$[(p5nfV*MNAL9gڃDyI棯T!\$i-]J.QI\n5G!5TySf6]?\n׋v\0[U̟T.4&raYl˹o Ӥ4vctKoi8q\"ݵsy*<{u	cԹ7U4Ei։KedjIù{PxB!\n8J5KS4{Dx;Pcxw'Mt\n  |>U2\r3OD!3xd3;Ɤuײ7A~Pڛ|nv1Y15HW|?~(,j*3;)0F\$	8p1Ǵd^1-6<@A[.yN9r3&t ,p1mv H<킁&t\rN\$?NlduoZ4BR62O=(ŉc3u0Jw4\"π-2wĘmPp/p^قX7hjlN<vz9\"PnGΕ	.tNX^ʃ?::͞ePa͚K\rpt	`>t5Lh~##,؉j6CV;n6p\0Y\rAD!aZ\"0r3)TV,#&1\rH,q4؇N~l >gK|o1vc~QSqxBgihc'z1>{vC\"frlMDxQr!L`.ǚ{(g_Cy1#ƾ)Op`FgH!1Q{\0+1cQgzGFzlbz`zU\rh2\nTSr \0&#2M!71>gѓ(m:d6-d)*jC*\rrh*4ۍ4'^\n#~.U #\rkA/\n*bpʍ3RmHrS23.@1 N?D֠yf,SU!<\\кf fHCh57hpb6\\pc	\0Ok \r&`Df\0^\"jJ*~6Ȩ\nZ&ixeN	VI\n.xj\"c\$C',(D%NǓ/oPf-23\r\0He,\$NѨ+7CB'&hMaF&J;ͤ7KAcFv*0ʋT,TlHJ%dQxc,P+C/IɑHў4ԙDBӱ*1f86\n\nm*Pg^)\$FNpVx굥	\0ml}v2p 0`9\nIfL,LbET5S.<.r7t%pXŌ<|A@/4 UC4TH.tM@";break;case"pt-br":$f="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rAscIEGSbr4EcyUz0Dqe0̢\n<miiQb4(&!Nod?S4L<ي-L,ݒq`S 쪧(o:\r>yxs-s8kjFI{Ct6}c3ܡ\rê:8lܛɭ@ҏ;cp͸K7`P85x7#9\$ ޲,nâ:t82#83\$.ꕭ,8k2R)Rb*NCj|C;MKh΂KjBʵB8Ck)-#iJЦ`Pn	{e'XȠ\r7Ltǭt0l*#9[҃ c410z\r8a^\\U	\\z22&x@͂V?^0ϔ41#tPBP[`ܴ6*L HJ7ӥ	/B:B(J29>SP7\0Ѯ3ԈP`	X:뚌~6lو\n(:\$MEU\rh	22-Y¿(:R&<cZ؋1\nb4H?/)t%JG7a<B!](CB(WL=FdѰ\$JM\0002:D0C/>(8B870!uWO>8@6Օu%\\07}`τ|eAmܟ&CoN*TҠs_̓rXa:d01U'0Py, UjyCfi+!˕B9HDk)7h3Zy<fRJK#Ղ>Ofn&2D9\\VZYEiUCTo.#0H.b\0>46KA|a5~O>HY	h-GtôiI&*Bע,W%I{W!3ma5J:d2f0<8 9/	H2I)Mdׁ\0P	AZZAG\$`yP\"XS,ĒԞ9t	hUâbiB-1W.ܚ炴AbѰcBBA9P:іt4%+|E) -LB\r4FHUPQ@S92`L`*P͉\nN)ir*@-%\r{qlU\$CԕȰ1?1Or@<'0L٠%pI\0Φ9W	2SG{|%~\$k[\$H\r`*\rXI3\"Lip`9	c(&w]r\"*Z%-<PO	*\0BEml\"PoQ&3d\nta\$	A*%֎_z}1fLɫcZUrb'krԒ-JXPuD vnU͂5B=ۡ Ij`si&\$Tܽ6>c\$(258g\0JvCMrqGKLDY3hT zj,D&dKXY?٬6rA]8f荆P^Q97*Pq5vCFpҭ[#OSjiI*:6>.7\\Pe420׌~0cbykz=MO6,	04-Ą3/HɀB<˰/*@@ lAڬ/M\\tS	e48M*{`U\$\r`\\xLAdxe8!Š0Luf-IǓ;ycbCZ^3F}\n*t]k''#%'_Һ9pzm@A^Z@ffz*\$%Nx;PŖw-@il~~m6t54ÁHnaZmB}L\$PZ7\$r/K5F\"UDΣ{\\CM#Tb36sَ#N^sx\n&cB@P } 33ễ U:Pi{6ԍZG	p%Jp\nX&b6~\rtf83k4/OgML.n.v,T@ÌLà#%\0CdODPF*Sj&'\\0GPdPOkP}Obj׋8|xCZbFV06p鐪WhJ)Mvנ@E6PJ5	û\rXpps (@-_Db#\$4\0o*0cDbj00Y	F2cpb<p8SCCh4\rfE\$!N*'2_d\rP@hCg4-u&\0#O	P\rvolP~nMoap\rqQ`qfGS1&{hfHKB/sK&wlѝ	!!%Pf#d*ֲ6!Obi#xi/P!*ig6RxaTxr.w(\0'Ry)RB2Rzi?)8_S'((Fs/Mxؠ֔7`G,-Hs--,)Τ*ͯ#|˲\n)P13/+C1KN\rp=227fs਒C4m/3R5\r+N	\"\r\"\$eVτas}\$b#D706e.`eX<66|+9GӉ;)60nkNpd\$\rVl\r]&L5`Zm\"O|7pZ018d,萮vn;PS<%ު5!B! \"I\"حtMo@O#~@\$\nh<DO>LH&q=s䂠޶Ev6tA.\nbSatah£ꬼD\nCmj-BpBFlq)T4K8\r6<B\rRؠ\nf_MdqM(BDtM.yN8 ,H`&p{\$3n1UlDm\"%5DIETp>K`l!V8`jsbĬfR`T<\"]\r8SMvM";break;case"ro":$f="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9\r0ӑ@dC&It7AE3ed&3IrE#Q&(r2NrjEDj9M 4ݤ'LqL&V< 1my1&A.Ś2ȦCMeyS\"Dbg3BiMASM7,kYF\\S>t4N;g竔sgA@1B:޲IйlKp9<P6 P\"5xפ#╈{|6{8.*@c2%b0̺ͯN#^8CJƥR`*	P.F)CJD(0pʰmT9BM P2h::˜2Pí%>KbܸQ)% PJ-nҎ@7J9&cpʻ9\nrФ+<tG JE\0k4bń4;vR\"HÐ4410z\r8a^\\'U.#8_]nxDj4#2♎L\n|nW\"h#\0޷bFdY ӓ@UFΣ<C+sB3(\rF/'B7#s#2H먱(u#b 3lb;5c.4;Z,K\r:ʺ­ҍTlKΛ1/J['.C##r(\0Cƌo99,ضkE{㝭1TndE0\n~Rf6C*=񼼾#(ȿͼh#WE^*1#r2E\"DaCjL\"e)!7L[u8\\ Qa` #^HHrcA1\"V#R\rpJ<40c	Wp\\ڻ/9FQnQh+`1lWD\$>Bo<*<Co.rZ8fW9V8#QYb\$ŗꗖP	跮d\"	%+cRg&>GKR,\$2#k\\u޼CW|\"[L:\\00L>HBz#=1l0\nfP5ԠeAԐI\0G	2hE@\"e-d߫v1	~?F(#43ZgpΫfU:gbBZKA<IE YAK@&A@h7IfS3\r'O oYA͇w̛YxJ8BCFAP@ߣ4E40CRܔARd_WI\$U?AsR.g\r((&t7\"HLɩxDHR@hUʈ಩<Et50^ ap)\r#FD-_/UUMxcIĆyF!\0¥3̓3]e'E<!\"Rrxtq#\$GlB!JN 4N{VxNR4LOL8p(\nnsF0T\n&њMH֬\"Rڋ,(4	QrK\n&ˈˁ©wڊq:2z+Rڙn9T43z/N`Md̰3n(MǸ䉂*APPjmp-dtaPaPkx9aAmrE37K\n\ntR^dz|Kh(P4x4*P|FUA+;)fj֤nD8\n!Vd2A\\tB[=\$T%LۖSV[gD[K\npgYC<jD䖀.A&km@e;.8@*nƬ~alpԕ	|wF7A53@Z-U#9,N_j'j#ӁIJ෧_m<Ty @BHuTyhQA92!4^:+G̴Δt1AEEҡ t\\\r7y9@':DVvY%6	1\r\"}?i-໧s>_BZF@A/iVUᘢ\nk02便oKp:a3	@<|A>lq2#U s3G#T)ӟ\nQC/XOֆf4Æ'poyr0b\"ӋcN\n	h;0o?[):w_\$@Ss&P3BFŦk,F4+m\$db0\"MDԇ@hM00f|df0ͺ,NO>ư&-*\nsP>2jFT\rFT\$U\"TTUˣ(VɌ{bw\0\rw\nP/+p{dxgМb\noD2>0nA,(cNN\n|A#!\"p{JH<A0#V1HBB)B4\\a\0ƦpR)b\0QP(>,0.1L\n\\\rd Nmjt[\$j혩.WlLIQMkG1CMi 31W\n\r 0ly\0fR!v9o; L04hRDq&'V蓒Bf &o2@3\rh%Hpw/|pw|d=\r*0cR=Rr%+my	}d2be*&4}b(Rɱ/,bbo1gWb'*qT/H~0x1-w1S~70w+2rf%16\".d334\"/\rDd\nE&\r66 o\\iP1JWb.2IG7ú'8CVPS77vD>\0,\"I!L3Us3%/5r3iO<e97=E8F\$8@aD˓Z-jzT%t?==	zMM+?`.\"VFeOCѦ GCO-b6WF5ϔ5n,4\\W+NqUE\$>뎠ZRkdeOt&l\$Es2I#ʂ0f\nZ:\"CNh䰆oM'&C!K!zbHg\0cXܧdQM0K|ÊpJjΒ6):@hj`x=)TƇ+5@\$f&b¦FbVBeme\$H0\0+Uz8SHh0\\ٕYKn5}Y3XCZ';5fXN@R-W8\"xlhӦj&as1̵QOboB>.dt	8g.o<@\\G&fE(Im,4^TM-(9\0C/wb\"m),eF .\r{cE3GfN1B`@	t\n`";break;case"ru":$f="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4Ըh/	4&Y9ڡLQcQ\$c9L'3-hKclqu0hʮsizxr#^3KB!A%X֡PTB/G\n>#=Ii\\\"\"\$=i9*JQI`=I3(@n:4<){)h4@F:PD0\r\",fƨIo#4cA%!1c)x%\$*J)G1ۧF딿Ɓ^\00Ŀ̂8@+hڢ-*IO2=L9R+!',' A02!\r5=!q+HNȹ&삔\"]hlK-<.H1(Ռ(ғ-qg3lJCDP2<(3bhHhFT@ ū@,FBSR%k9NMLF<-3\0'ξ\rvB6#p9R84LBt<X=1S<[TG\0x0Cb3:x﭅Oap9x7f9K(}TDe\n2T&C'x!Γ\r4/D.ݱ!oˣ̯#*z@lZ'9Et1it.c^!(ɞ.	0x\nL85Bϱ~Kb@Ilu}bIkcVaWIQ\\JGNqWE!\"%43@V>^PcO:~#]\n'Rһl\nU9Ը,T4@dWc.+x9Ȁ4QhAL(Z)\"zHDZw'ɕ*\nr)86|UO8tm9g חchitYN1!U،W 3R94\"\$S&Iq!*!>D	;<e3]GUz< 0d[pa>l#DQ8JUN啈HTuPanG,e&J]RrBeI\$b19AB&ش1FTP\"J)#jB+eN[a:\$fB\"h !v9Wbđ)LufodŵRCf/G/\"\0A[T\"!\"3DxmrN p	Ғ e-%!:d2T{S&uil}pR5J5Mdl<\\U.HªR1UeYBUM+&IuV	OeBƸ\n*Uv'ydQr/	UQ	mW:`ժ	ltƒ93nUI\\TH?<v.GZ	MD'e֞ZUjevPrlM6ga7ۙ4FG\r'*/h4b5we1˘񠫋^^\nZ!Yp	5pkїF=-2+@T--ۇ8LqQ~k;@.ZB΄%rJ144x2~-ZPW]\"0&љۍaAe%44h򣇍/?`Zu0-~UDSa >SC\n\$DoJ81C`1-\\#<4R-<etwv3(&i_XMB߳hGḥ^RSO>ia*eeEamy)Y#Z1D<.l)gFqlVQ-)/V)sHkB2fQxmӱVdlȵuMRwD:O\naR'ց N6f\n@\"(m~ڏxp\rSȌ[7~GҀVɓRb2|	RhLlNTV\"dN8*\0<ejez(;ԹA>H\nw0VIJڮYe|ԝa/iȾQ#JR؎\"`-158}bGd&7\\\\fm}?Ldڎr\rW;M\"n\nZ=-3\$_df1	]0ddTAP bj ;8PVbN\njB	\0ىVLuh0,.[tKG@t60hJоLȑ*n3oBB#:H4_QńzOqcr\"#v\$E~ώ+b@6\0ʽ@\r\r3m أ8Hޏ\nv'E9C (|Ā>Q};f0z#܈\0\\\rV\r `@\rr^whm\nfstԑ#e>K*B~^LڌztdY8ObV	\0_j\$fbzc{Bځ#qP%]~&Z\rQ~@\0F,<.+Nj>P~WF|L[		3O|\$\rFJ\n 	v.\$FZyfLBj\$hEhGxn[\" yA\"q#*q\r	.zD.j#\n}\"N&v/*B\$쾌\$B5.y2\\!q&2AG&M%)'FLfb\r4\\ws%fRD/\n(\",&dlM,S-&	\r-,,`UK?.C,ЅH3#e	<7X-%dh_do3BtWCW\rNd#fϤH4f1VmrPNP~-FꪳpPjl{Fc05Ĕ1s|X.3XAgf~D/(^GSoC;.#;iШuC-,,c;\0Z3.Rw%SɌE*\0چMOVH=\$1\"=Av~\\~f`sHT25x+L2\\ z\$lO^FoɜqhE=3tOs2rq 'p \r\r\n<b:AbJ4\r\r+Mt??b-?%21BsLoLM\"eO4LR?PG*?\r>S\r1EF\"pVfELqTE@E/`gI(t\"-d@\$}NM%5@ʤ5Q.BUs3\0005^vbg/sd4\"j[WUE/5{WXSMUX)Uu)<pX^5:\$ȫr]5C's]C\\]4\nhH*m;\$F\\P\nF@D27`}j+b\n!{=+uLR!`z@V̃T.ń}k`_𣎼Eb?BBSI1t}-mQm}SNU)r\\qdZo<kjPu\$3\rk&V_-lmWjv*<vMS/)]oYQ5kSnouRl''pn.\0(ԠpǨ날>\"'t*/A(nnxdm	'[\$1[#	S͒iX+@3W7	%wtWyXmmlQIig64Wwwhr+y8w-9vi*(I/hT!HI<rŌQE*oGXu2P\0@duV<`0#	X'8	~8\rf~o%y^RW7~侕r=uW7oHW=PE.}=x/xO6vOgw8\nP?!t	mpItAEA]6`_]9e!1Cً\$űFZWs7O7.x'ˍKYUo@TzǑ_\"e\0U`	i)]|wU2q-\n[2c㉖(<Vt)Ո6ǗCқ-Y5@R}:rHɄMWVى>|i*	ǜywٓYUk3j!@a1D\\\nZ*F\$m؍{6pXW.蔖56DY@3m\0\nzb(,:::gqqI&:ae_Y1؎}GIe\r&hEqD=u6V'QQG!'~`yfUP[Xr8,7u2bFm1}A	)uF;e\0a\0b26no=:A45SG=圴g/ݲ3(ҡ5?֐?yϳ{OEP2EȮ9c˴׶J~1\"dΦAhBiAs.ZLϜ肨VIGpD&SF8Z^ܥ!y;q`Sx\r{9p8^U\0E\0|K((vx#ֆ?mYs,XMB¢;@ZwאOf#¥3A\"Kb}@S(	jjkklfl^ L&ng֯P	";break;case"sk":$f="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8U\rZv0&㙭'(a7&(n1!%iAD9ϡf?BKe|i3fRSzi0\"	75d%Stiы&KuqmNemB~Q%b	a6ORj5#'MnqoI{<q\"7)RPcC(p7G)B,CXԦcCh½7\"T6<m1#Ȝ2M4@1KZ/Jj\$2\"J\r(\$\",jiJ',(Ǎj(椲Hb4*ʐb\"PHsBʏcMP9\"3܈(6*6Jj9B:2е&P#\0TbQ/!\r#@ؔpL,\nQ\rCQ,+# I1'Vˣ\"hQDyL!`@!3:xoMnAr3h^80xD͸1\r̅.|˜X<.-\r\$7!\n1@18\rc.(Л+(OPȫB(KYl<j0bC1%;փ/Qȗ&\rx{;r#pbQdeRCX2)k2=tȘ\r#5,Z⧼Cir4\"q`ʘ\rMc\\.&WÒ͕@Vė\"70@XB=cpT\r`a\r1_sNk#sɊjnb(*#J6<p<}1O+aXhu*+<0CT\rP9!Z!\0u0P@%e::v)\nWP7s,Q\nE!6PؠD\r3 HBxdTJ\$\"vPq4-gŎ3(sJT2B\nDjhjWR[Rd*r2Zx\\Hd-FDԍmuQGkȔu2܋Gdc`9q8\"%+	.fLTDdʣPIGʖ\$sj͋2XgRjFHF0ITG\n8\$R	Zam-ż\\0ܡ1y/@	*G2\0HA(8և}1%j	Ud[jfjy'i.wHtiEѐsaHSZACzЌ^yvhi4tER\$&W2l41ˣë-ޜ\"Ѻ9e^SO}A`RH(p*nL=S%',Q3	Ci!>Sn!S@IGX2N-\"ȢG_SDw\0005@RZ\$RJ\"PXɆHB/G8/`\$\$ĠO\$}T+kޫ25ьFTLTpk5܂Iqn*&NٌZ;IQQjmf'N*XP	L*0\r:_u	*W*5T؊\nQ\r\\!bBZut΢+R\0Keoj<`}-ʰ\"D![eY7!\0U'b\nTPSvn\r W*-84/W]u@(\$	,1U@E	AeB	0Y9t	{9#J\"2zi\$i?U\"w6~XԂ^z4c7c5tC('\$F8b\n\$ʁ^`O'\\P£<r,ǐ܄wp5IӗjC+3І\nڴs9bCwCDv\\1h&V2@ȣC{uded{ Eȹ dHa3y) 1cIIeGեeK˫x(ǕI';l~\\gj0PϳICGBcٲ&\rTX (#/ΦSxHRZblH~@BH]Bq2t塡y,H\ng 3Q[=2/N\\nu*U[)Zg(uYf31Nۻձ!8\\l?RгB_M]1ew}df=[<A2p2Pӣp[kc+~bw0>5>xt?	|Ds\"J-ūpch##j2\"b%TI&<)LNR0\"LK(D*#d\",EY\$0a:\"x\r&kF.Ke`,|r6lA A'. eB\$\$4/CFH/r0%:\n0Gh=C9\nPG%\r6PM;	0ⰿ	JP9	&Hc#*cgHBA\rkc68f2?\"//&`Is9nRlB\"o\r#.h>F< ح.4\r\rQ -Ƃp84w\r+SgtF1\nm*q\r0M'IGP%yWv\nqOsBC	dB:/FBkeNMb\$&4qR\0Hx\$ P!Ԫ R\$\rȫ,ĠNvP,%I!&2NT>[&0@\rFN.mo(̄J!4'T%lBFN%fg)A}+*\\f\\#\"wnN)r6b{k*\n Kb>?'No%.t\\-fN0b7f'hƐQ\$gr'%22N'MNn\"|m?03|C5q!qd|yC(3b?n'6iG?37C,-#磢i\0#|{j@EP/D>\"!k%_Ƴ\"#3- Rcs\rVx\n'*ԳJ? ?#@֗<\0#*rQ {1<7=\0{cByC4'Cj!=?=?0B|\r8Et\ni%/(QOFo=7B.E\"iѿ5яH6CId\r;4S1dԢ,EsF4xUr['4!I>rJ΢sv.LdDMs5n \$K_4tR.R}L-L%O\n-sAC\0#C.A\":=-ц7/&Ӹr6J5E;km\"\r/#5F\rK\$4\0I0+>'%\n\\=O	co:9zˈ\rP@d\$\r 1Ö:k'%T.NCG ĳ*Q-c2j-N\nZ`BL}*|uWuǒ`R\n#u`:\$o\r!t\"-alvP7Hb6.q0;hl\"nIO5.f@/gMȐeN\nsel\rnZs6D~3b<:\0Ѵ\n\rƥ>61cT\"ClP6D@5\nRVΟ2n3&a@Dc@Tnۂq6qr1R)jV|<D8ܶ\$̮&\nnJ27%`7ItP7\nzZQ&M7mRɣc,E`\r	:D ";break;case"sl":$f="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n*!fPsSYPaDqa9Ύr\"tDgNfoBAoB&sL@Vdk1:0v9L&9du2hyr4\rS9 դh4Ε܈h9\\,xAcFQ =ptgtfYyS=bX,ģ)^+Nĳ\npǎ`9HZ|2\rjn;c\"D(A6\"C%cxȌH`;	#IP#';z\n?Pʌ#	b)+(6J⛒<D_+\\\0D(.h0R<H4M\"	;\nԈ6g## q,#Dp%n,\",45D[2D49Ax^;sG\\{ã?v!Hc3!cj64^0h´\0P7H0=1\r:ֆޢ0:݌0^t\nO ,f1\$*4+8*\r#%s9>HP21;:|6}\0P:;C :*%0֜I\\MC87uFq 9@1\nbFKh93-|Cɺ܂z| G6!^(=N#MI88,K:>.\0Ō;\rJ<W!t4ܚjvAXhd+Td6z|!3&:}u\$9<!ay2܉A{vA(Y6	T`K!\"	@y[A<'TҜ#(Jb0܌ u#9Fn	+z,1+E6@	'\r褭cxGYʵgsVD1ZurX+\rH,er:\0GHmGFG\r@ulҶx	Yy0KUb0ݻl~*:%@ȹT67ZZI\$ Sk:Lv18x9efḋaBc3\\嬋i3} (\0PNI#\n!  n(HEn-J](%(oRZJ!ud%rUCl˲eC2K=W*S沏ጐB#Ѡ9G	aL)hºEUֈA`EBI)!\"Cl')9+Xqay\"8DtKc\$5@ɯ#!rǡ08iQHȒFo?/gH:#y!xS\n-AX*95O9>5Z-lܑl;S\0\"\$vJS\$&SIHB\r!+Rnf܈A\"LY#Vfoy4jynypL88B/ѐ'E\$7FiM76vS<uŴf߄he2:]JOndj*>0:w8璮OSn\$_S KC|\n,&]&쾪(;TL0'`('2LPZ@gT4n;Nϒ=C\$)#-0B`o;S=XNA\\:l@\$[QTR#ְ9YOH҃c\\s鹂0eYkΉH\$J.!%=%:i7b;)mF|9^nйm\"2U7.5PKD9g--6WBڣT!\$\nڹPB8!HB%eY/)`wj[˿7ݳ	E,=NwDTStJ%fzoVRJkHxHoP\"\nB9<Y2Tp&%ʉg,\$<؃\"|401RL✯{0\\;sޓ9&^V/.܇)cnzV\r#;|vA*~w%K3oQtDuy&DSa/nEnáɭ6p8oQ,˭vR	/-Q0tZA)K}f2K_Q30Ej!KRāy;<}'4G1l~CxiW<`C`u5佄A}]cFn%u#b,\$p.'N3B\$LO1ΠZ=pLQؿEN<i\0B\" \$c1[o 7Ύ^@.G>O9JLP\nR\\%=@f^#n1./˛ nx<%n*n\rQ.Md^Q%KKI1Q6N>+	#BQ\rP+nh`w2R!)N.:Tl`,	~)1\\>LjCo<n*(%Q+fAcL21p-V9o.xK&Qe,`yf0O2!Q\nn+\r2p#j#!q9\$I20qrFI#RR##(&^1u,\rc`\r\"g]K\"\$) 3\$U*=\"\\`0fP.K3*xG\rfmre,/ 2p1ed\rghp?R/.=ыf1pRs3.k,/^Y}2rWZÁ.3:eԲJ6C~_ij0eDԍX6\"𣩠\"(G5M6J-&R-V2dF+Ml]p%R.ә803,NM83@M#e&²Ӝ09z3VN2pQ{=>.?3R.ˢ`4^ʜ̂p\n!fȫq\$}4 s#lt7\"4-l \$P1\0(:;%'t\$*nCOL.]+sQSFϲt-C)3CYAn#J\rVDu}bD^z\nZ1@S:wFN0wkWC'H\\5nOrCP#Vn?pN4\03e2P\0v44@JgKCjO2BaJT\$LµBd U_McMG\nˠ<c7DM\0P U7n_	Yt/X\"2CZ'7d6P=0\"u[ZJ`F,k\nCm ,\r\0lV%`zE_+zM >)B S IlyR~,2(l-c,\$ Glϡd*@p#±\$e\r!Ĝp\$\$";break;case"sr":$f="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9C\nD?!G: 'a%e|Dqe0̢\nm=c/\"mF:D\"Uj8k:]\nHƖHr9a (h_(әHY7D	Fn7#Il2̧1: :4c41?\n+ʆ4I(k+<F\$70)pE0k/쒎x)H3Σ˩ChH2xKʾ\$1*[;\09Cxдc @5\r;\"N5hS^\"((9\"))96[xQj)R1)-)HȋM\$P(#R|NHNUFlĚ4Fr\"BU\0;qQk\"R?GJ[&Ԗ1wR!tOJ^\nCbB`P2\rLD6p5#q71L\04NNS2\0yC@:t\\7/8^2|9s^+/4q/\r7^0Κwr\\LhȪ\\+]U/	H,@\$r&G;YI{W\r2Hn7aH(J2\".(<?o\nh/J:tUYgjˠă,MҾ!GG\n(0d;#`2:H1I	#)6Sť7atD/Yؼ\".\"&Zzi2t9DGF'wF쒐wYFtalY%D)eBHێ\naD&'Vj*|d<1mP8IZ+-v78HRIn\"C\"񸊂5!3S7K\"W\rY<'܃\nNq^00\$rN!|X7#ʶJ-<bNcT%m\"\"\r[يqhui>ae ZsP%90i2Ȑ|i>	 &^KAO8(e706X#zXa!3i^P7 :f \r3Cr!35&r\r\nJs%ebf+qm#5̚6eYn]RP% #hj͌_%4Р@q8> dL2Tpwf7%\\Y9RW3#BHm6%5b G*pKs'wĹ\r5fFFyEpPey.\nѰP\r#FGTCdgBM9XXh?pje4`wQNK=LPJ!(b~RR'-QzKxn|O>\$&Ow3L;\"L\n2Wk,NeZ0X8 H9(=clI:C;&7hh9HT04Q\0Ban\$A	\rI)[hȌMМR|-7:/R,ه\0幎Tp@̸/D?|82]\r{%wcfT~R(9G0Tr412MiAHh+vˏ-*ɳ\"ɺa~`QGad0cQdܷ=W,	nb@	Y#'ϳ\rRφqvoI hKY=|0Dɖ)W%#v\"'@BD!P\"JR;jh;0p +^\0B`E؛3lU8]\$(>x%sdcX.ſhM;\rIX^`aqtOrh׋w8Ohgy䁇eG4.A}w}ZS[Ac-yn*\rCR\\S.=D\"DqG!(冟]=f9RDIkJjvϛE\"a%'9'i~3}s(4y#wL2i`H`&coiu9p@o\"8㇚P/3>;(͆\r&qC?	GY&-Z5\nup1\n4w2Ri)Qv+rjߠG@U\$ieH%NCb&|N/` 	\0@Ǥ\r\$pCF\0`O+gD.VBPTrq^qrCa芧;PfDc\"h.z\"cmpnÈ#N6\0\\( 2	\"ZΆСH^p+Cгj	м,0	I\rP\\PD>%'lOn)h	z!j%Т60	б,o127	q	6SL\"eP1@\r%Md\n B\\z,'A/]-R#Acސ g!(D\r{mUPkk~'c,(>t%2\\Qa\")\"0\":ŤFՄB&n4#\"\"Qb;s4oP<+o摏\nr*o#%ڎ[\">EY%Rh6b4b%)m޴FgBYa\n9x,LO7PJC	03Q2,O).@gL,O1	@sb\rKiw@ڕ\$e,f[>NC\"qe2,0r\\/4,('\$A93B#u'P~4.36R'&H²\\js;sn's(?9&ë7Xॴod:Q\$C*\r3R10\\qF\roS5sF;<0BsղOS`P3AMb\$A\"lBӔ)v#PF\$?6d09 h2!f;E\"FXq`CCHӲ|S1.a1.+;7F#×GcC]C*)\"CGJ!r߯Jn38Q3C2BNC<oQ6x҄dE>pnONQ܋1Ct.7QǱR3u\rDu\$pCRȶB0\\UQnSR/0EE0B\rH*#q<#'1AXY3:S=IIn QTwK%B)DfsEE5xlolāsu)UvBYt[(^[4%6\"HS/Z]bO_REgHP%/=cBfp_f/fc?frˍgfn/g`vV;3?jEt1SVTC'mdJvB/l\$V ؀SPG1 8¶/RaAuk+dp6dtElTB/X՚Cܹ슄E5#\$1FciDx<&>d\$:SJ۷NI?[u 6\"~ZOUnlelBQ4@	7x \r\n:'#3q<ï n+o*q+\"+X4&b\\vMj̻D\nZ	F`dPhF\r7TE'0ToCtYFL/tW\$( j'+\$r\0i2XtP؊-60w)#6\"Y\"A0 46Erp%r\$'5KfDoz3OC'\\5ɋ#gB+we%1&2X|܆ƧXNT\$l4u\$cMCn¥n&'}WuKNS4UEM:UA6'^`j;D8͒hq*.Hg'.t3+Db'0e{9;UC\rT@QlD}KB*SnE`";break;case"sv":$f="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7ADqzn\na!CzkDqe0t\n<pō9=N7'L	n%#)HrL×3|+f-5/2p9N\\C*ĝ!7K\\ 2Qч9g6fs+ϦuCS7OenTޝ0֭	Zb0kʌ \"0/Crp2\$Ⲿ64r)\0\0@1J:e#b9&(\$D\rH@)0'hڳ dlcưP1~3#|'\r/H򖌣kҳK+:E2j6P\$܋cT̢\0P\rJd\n6\r`&p16tD/(]&E3\r\0x\rCC8a^\\уs`zJ;axDm\$ԎT\n`7^0z6\rNDӊHIè::Ұ8:]c#;1/70JC\$ XLN\0PXTA\"\r3/Av DMF`PInFs6 :s?Tʍ=6˛+ABZ}í9w3Ø☢&\\@zK#%؎S4O3L;s+\0N3rݤ)S4j)\\Ȃ/7+	#h5P<tk){w4fXhC\rFMpk[	=WfvD3#/FJR!CެN!Hgw殌qx;#0W<HFܐ0Gb\r13R35dl\0'hdE\$#@@	R25\nrA6y^)`Ai\rŵL\n:f(Jt7\"pFz脓dTAP\nTΫ[+t.X7,&ICKYK1Иʠ3|//\r !GFbʴT:EAgbS2!МR@@rQjbg(\\R(f8tB+!w&|\$(f	,/N]CyK'SH\n\0i\nGڈ:B\n_}mhE`IS,M@n\rѼ\r&\\a\"sHR Iyh&Jcf@XiFdpA	HfyKCLd91JS2B[\"@u	\$d04\rX`iZ\"*%j!9Lь4ed\$3؍#U,*Ö-3	x,ت-3\$JaQnDAEb)A)9\"S3,#9̐\$m\0 -SKbM\0 	AIRu_!5\0H&96E=P(\$%\$5Ȃ&̏3ŀXFK;jFRB  \n@(@(R	!8#xR\nP pv\na0Н{QU/D_tz	{g >\"Hp@p\n\$C2t}-6ɝ X+[Tq#;RKaI3#Wpd\nOzC6\0(^#KqC	FnaQ'4N	R,Ž/؀y,I7.`) (9` @oJJ	'	2U?%:\n*;x˜[KEmHbn>=p>@:!|\r+a'K&/sZoi`?Ʌ|DP%?T:-&q'֢8XC)[a![[+pg'<NJSQW\0Ax \\F	\ryg^K	pUYCL-p}-[\\|*IsV\$y\\%߸\n\$,eW;)&T-/M)9&^tpzL-P4E'3KK(㦜3ÇJVbAЀq:KF*u;ur4aӇQ'нηޜCnr~I5fK+/z\$ aQ#3ϖ.'1-]4we\r߼XPA\rDoYj9\rP\r#9q-#<qG(J	}/aoQgqaM|/0׳ӝ%vr!ƹnnHFra\0+I\0(N,2BFԈXN/\rE+ohkfMҠZ\n؛Fnh[\\*-\$j.عDW`dU?,-AHp\\.,pl\r4nptSa0&R^ڥt><AE\r\08sO(`S_`Bd\r#89pp (!0C1Q\r6\\f\r8brfLLpqE-MpL4K6)Q'1uPRb&3qp\na@+ϝ\"^bl ʁ,Sr#F\$CiPh0B3tmb?ր'2.צ.mg\$\r#ck7My#-|1%4aėMd\$D@7bL8}pMDx*r\$D'R' Z\0/#h@q[& ~s#N`lXPmVX|	enG%Ƃg,Ҿ\"!(|C/6*)m0md\rV\rd@0LA*FbVK\nr\r\$\$\n\r+puO+06	4eIN[`u̪1o:c)DCO(dM9cBXjx\$~kb̘Hb[x\"Ģ\nd4%Q8vqD3l`ҠRmB5sl#jm@sfS@	Aފa7O?B=HvP4HG[+FNN\nNvIz#d	B4¸2=D>\"%ESo`aTu`qxΆ}V\\\".(`@e|\r@";break;case"ta":$f="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8UUɼ_ArªZ.(qg+S\\+5~\n\$g#)eGKN@r|,F,u]FdXGiSTrP+_5ȕʙa^i6OCq)Jj^E.Q@+W@J,W(I{\$#x\r\rx@8CH4(2a\0\$ :74#1EH%!p#%9nҗ@P#x;j\"r\\K<<2Jj2t81Pd2Nx)CH3(Q*ڒŢ2(7L(\npp@2C9)\$o7J: 8Ql9\04xq\$Қ~Bp7bJ29#xܖIp,37k,)u*L@dr2R\n8㘨934NE_Xa(P)M\n2	Q>a>\\ʻ+OekԼ87.*<2\\&Ճc\r03AZ3e{Tc*M\\3H45\"Ɍ\"Fа]P a0t5-^L{8l. mP][W#f9V1<mN1U!\04P+2\0y΍\rC@:t|%|PPp_[utK`|6m3Tclol^0ҳܨY*лB}JnQ<اKVW_\"`?CWÃR徑jJJ)D iˁ´˗rLoܯ(CnPAPKs)&C%cmG@[\$JDfc9U#r2m\0C0aX`e/LIGAR[v3ѕ_9mm4dN)I^¹ORlݘ'bť2Yc=#7~MNE\nY[zGCb2G贂0Q	\\όiBJItBFpӺă\nA|λ	cA9&F4o3R-Fy{~A;>83\\5ͣ~μކ/ak1dAk6l\r(Ҵ<r8:e(psvuT+ۛd,9ȹ%OT\0JU;В\\thBk0IMfP\$AsD ؜t47}0\n3Vm\rmu.qOBC|!׽ 0i2 |nA7*K3p\rX[FBSD=!?\n\ro68vZe*@މn 60f`uk7sX(j8yW8e &Q0m\\ȉqIJBbܮQy!+\nbSEze2\$8\"fg0)4#kP8h* vN;twx%ŪGUy6I=(7J`=/\$:^*+!a\$ۤU/QWq9OUlh7Z7-D%b7P=axaXۇnN#,A52Lxb0G\\DX笇̔^OA@\$]d\\q	gCZtAAl\$]sqDPb.ϨZ#x{;Ԅ-\\+>&i	WqSe@jX<n'<Vc\rֽ;`AՌ2F%ǌS(wj%eSEM9M~,:38%AER?z!rɘf+Z,VăʏHi9<?TN+xR=Qc֗=WCX\nK'x@I a8܁\rhc\rdʈ6fS|ղ/7i8IT'!@'0g;8S{u7.9wزf>g<M1׊Z82Ttt|@Ϋ-%Ysנ@ 2Ќ4ᦜ+K;4 =DkYxfĘَS1'@BD!P\" E	Cy6ʶRBkPNJ\nP&lT\r)k/a)NCɐfR*|<K'j7Qc(a52^h\\npNcə.em0cL>_(ڂ0S2=I*\nk>	ihlKF}J\0*0ƙm\nY)sԏiN@R5k	%J\nPF4Q2SD|&Gҹ%bAK\0GEDm(ăr&G؃䤞J\nH6\r'oъ\\cnXn\r J@Zln)Od	fbQK~@όF\r\rrI)X\rKo'ZbJLV+L\0V(&l6bDRb ڪP\$6,[\$(K\$Ũ)HI>JEOU&Dozl` 6nR\rj&\$\r_-?*+O(242TH`*LІ!`?S\\\"d5p>,\0{\$nКIF^J0`` 	\0@U@`\$V|B`(`4 Oj>,ӏp\$o50+X+BNBuk72X1RPn^i71P}83Nf7L:z3R~9kP\r	9).0v:M-M:B73[@sN?t<(P8>7:ԃӝ=泼=S9T;=iHD7֛n^8I(SJbL%g%.{\r3+T3AdE;K>..bAT\"vGApB\\Cp+Ɍ*4JZBMRVdu3	DB&\0EPhNBJʔ)KL?D)ET@K4G?n[\ng;UV0WdƈP;J3WW:4D(U/uZYFYZqaXUW[U]75&s+Qu\\G\\+7mEBW5b^BY/\"J貋jt`.*JI\$<Dr5{7PYbt0/Q61D\0Ӓ*]0Vcp\$JEb^eKR#;t^\r%S>l\0@\n̆0 Ft#\0Z\n4.tseF˩qUC'0Ugw[	C2kO\r6s;6w9FmEI`j`D5ny<262`o՛\\ܠvqFuDV~5e\$XUUoJJW	uV\\t4\\w/phpBY*20\\htdI4Lvl>KfHw*{\\6pt[3©W*9UjyJUuw0⼢qzudv<ף2oԙ~=\ny[^wf-8\nB[wxv7I\"jpWWaqS7rvm)攨~wq22\$0+&QaW0oF2͞6MfS2wFgo`t\n҉\0:I?9ņqwSa#`׌t_~x%,2l0#7&i \n\0y5lK8'xKRh\"mqB2xIgX_zg)Ω	{uks\"37&GrH@\\8*XwUugi\"puuE何}c0̓)s-V4`iDlZ?5ߙ5aڥY+slfu,x9Qw+8K-7y~K=Y_	R\r]J\ny5u5Ph-dp&͏:F.qM:+xb|r|E}wZ_gxx/7[mwyym֍8U9JIuR]iL9t4&ueREQ7(dyWfw9zˢYZxϯT&vIY>8iu:Xh;2[zZ'[Tu3bJym7Vzc)u+YFOؚDly'blWmO*F,źHOr;L*{i R,ʲu%WKұ:ZrgEuzp5,;ݒO9ٿ	8IAdn0<9kN	Oy[9܇'}#wϷ1\n5s };_Xs\0nйYI[_vY~	l@ɦGyf`ʁKT<?wXfDJO㢓Y\nF5[aym#y5(:v+Xӊ1n7aQ1\"i.[OQ&*?@ZpWDsokp9-{^<_]45; bn\r;;FK`\rFftbƪV\rа@\npO:e)K{QN%r9\\{<9C8U.7ڽ9e}=je8{Z\\#L0ۇdAzPMBF	t\r=yV=73\$OCCw{eQEaإ|%o[[jgvבOM^9hR|1%ljz<G=P{0B\r^.LzP}y)m<]<I*lGY^Z6'+㾷%|\"Rdiyvqoź{bD\$Ge<\r!~~_T>[wޞ{\r__A]_@qsm0r({[T|\06ų6&#IZإ	Hj[)n#_VBk)VBi<:a\r0[s*\nҦh18Î󶵙АBQhYj)@#ojqǲdt*s,*RuU|\04	:";break;case"th":$f="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=G\nASZg\\Zsf{2q4\rvuTq,..+h(n1s6t9K'vK֗!AvyOS.lUشt.}pTkp+nC퓴>>Bi\"X *~-h+#\0,@4#7\r\09\r#689R: :8à4ƃ1FK=\n[;I쎷+c:lִp,,C셗\$450=9s?B.jQ@o뚑B`P#pΞϓ.(cOs̅B57In#2\rA\0%b88RKf-Z-R66\$9#O=ր@ldsg ٫	3ֶ7(00	wڨ,s{j3F+m\$L+A\rY'CCgH:j KoC>,lľcݥ{cj~VJk(8Nx)iMӳ,ҏ+KRB{?\nTˮʓor3e5QlH)g>Ù0zFN# D!YWVi[1c3P1UA\04\rb0Uv9`@sC3:xׅT p_\\uxK|6Ԏ53Tlv4px!09ܼm*E~9e?#F\r0&=e?Ջ\\vعl6u?S[X܎r\r,9J!?D=RdjHB)F3wD=]\$yhpN1vwA|EY{JIZ\0C0aX`ec5\$Ҏ|KbX)sM9PrPM3\"ԥfK[[l7l䞡^d^؞nlfBrm9>AFO[#gmEB4K\r!dnPܧEҢQ	;ZR2 \\jH7BG_I!8h(v+ØcSP)ͩܓ-='1,AI(\\	M_+0bFl~㾟)M qgo^u3Ƶ\$4.4ޚ*3v]\0mXpuNOCz\$0|hf\r!Zd8 Q+#\$	JqTH(xG<Ӑ ;hd *&\$>\\)3`Jz넏+T\rTĆh`o\$9aᆡ8/HTHuG9Gaᙟtlu^.?Iw1O%^lٵGU[vYE k\$/OiG̻7*p\r'	^B+u.ֺ]nT ;uTjUwOmw!ҟ`6!5enk_RN`ZGX8XOp:Z\$b8P|a-W{_j}ɣka@P|LOT~9|[TZ*k ,@\$\0@\n)[31\"-NU8\r׋\n8jQZ-E\"l\r\\6XLj =R\raB񑣘jT%>0nJ8ڲӂ54a#04D'VAZYxBW.e,rd1n[kB>i\$&sFR\n	,l\r۬4;ᬓk\0d\r0aP~Q48S̨h o-\\08<em)}Њ7.mmqԟQw0,nME[|3x_lOWWYqY)m\\ DROhbrY\nu)sS+J0o{r{+%B,Kɐ/X\\rsl_\nA<'\0 A\nPB`Epd1ؼ\"5Еb]{4( !;R90G[Y	nBj~/	\\EEF3V2\\j+]{?93\$N5b/dKΊx}{@kc\rFH<<\\*ʶ[\08h݄ tpiI.>b~l8`el#U>b~7\r4\r'>9k2%0L\0?<\n`H޲H`l	vL\0h*#w \rIi>zN2C˒lrt\\'h/7EF\rړg\")|Q؏o;':B/ohnr\"dcxJ,Қ@\rh*cGmS@'Yv,,FXdT'(Π0;\"7\0tbo1jľ%z[c6>eh\n`E\\\$NgjDxWV[\\-},\0^0~\0(faF:bd(Kf`E]2i8-Z@1PBl(fc\"k5!\"%y .!-*\n4 Ó\$B2U	eF*gdN烪QdAnmF HJ\nCNֆ.I2)On5&lm`9ԭH9J<a\n.F2{!>&Izd~d'̑/Fi'!O'mlx\$ϑ-8] +4[2fmHf'N9%nNZsO1¢3H|/ʵM863N#gC)##O̯{QdNmQ\\O~=LFzc\\'S'+Mo):)d7?:`ZQ gi*đ#9k:A\"\rT(\r\rOTp1 My§i\"49~<<go-:!'S;QpT3f:tuAH;0I/7i\n]3/IK)Km{4GyTFԙT=3w0\r@MQ\$b5@tj2\"\"&#g ti&0oOÓ+L)eS1LtNnU(m%O4NNT3RnRMfڑB'EdXs5/)f@f?̕GA@l^訪镢-UA.ftbIHwSO0:o5NoMR5\0*_5/\r@XfQ1	1gWڄ-fНcmT\n%UJV90ґug6oHV8ToW`Saj)6/eneke^T)b*'fh柳Dg2VE]gV%Tg:H`CseLhVlNhON[Kc#?B/ƌ9E0\nG,oO97vVg6gv'ipVkiL @#EUIrrV\r{j;rʹ_VFEEGtwJ~&mC0&U&fqkcYwҶCqfww7h_brUdypgPxy4yw CXj+c3v fA||GK3vFvtm~~H;& dF8LroÑqUhX&Ix\$Obx(o`\no7Svg\nwWjs~#poVur7s{_sT&?%Hk6Ynd9%qNȘ'8y{عX}8@Px|x	\r\nK.	bf,nGP%s/Vbߑ*cq[5282v.OhP]4g\"7QرSf]`n\"\r8dmg1|dBxҾJI-,Z\n`E%(Jz	V#`CrGh\rsV|\"d	\r D4)nNm7x@&XQ;Q7|G'4(ssGwp'DtH@yQcE\$B<)Ό\rg(YSsgu1P_eK壒r@-sZaqGTSTzmojhDM8&\r¦e\\v?\rSlXc(:-t\$)?څ\\\"<<\rcHbe?BqB>+u\0p&YpPB7[ú+	j(a=\0000`lC5aFHfhB6fnPS<zZ:p/IJeII'./Yo@\0On7-v]@YQ5x>g\"܅ 	\0t	@\n`";break;case"tr":$f="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9Φal1N5+b(Bi=Dqe0̳U18t5hZM,4&`(a1\rɮ}d=Iⶓ^a<~xB3|2u2\"SXS8|Ii1gQ̑̚\r;Mno+\$#ӆҙAE>yFqH7ҵ\\Y;H'd1/.2aՎc8#MX༎c42#@:J+j2+`҉\0֭ܿ(B:\$&Ԗ1+,0cC;OȈR<čH  P2\ncH\rX7*+ɢXB7PXbzN2o8#\"։(\\(95c1p3\\Q!\04@ޣ!pa`@!cB3:x]\rAr438_SUI|6KB3#Cl4A^0扠+#H\rm/R2&JB>\\M6[z^5\rSDJ2%@xh,W\"4:\"x,H&9Sy]SB35!	wro 478\")1&\r(&Px&(a>\".@<=bK)7NFI=2bȶS^{pA:ރ3llX͈Aݢ6HRZ@Bz<H:#^ȃ&䈜|q|n2\"@WkK\rU6rIS\"<͵n#e!C03//Df7|p7-H6K`Q!OG0W5G!h =8Xņv[DX !\r-2YPt2],;h!\"gPBÙF01CAUPl,3#abzOsR8_c)AbEK,KQ18:@ibj')b` UX+%hºWCCr~Dȕ='GB2Ůw+\rZ8HF\\\"ʨ\\Rha3b&<X/q(x!\"N&ETEdp*܈ܡ 2X<HH\no/RHH\"Ǧ;(ȾQ0c22RҒf5H'^ZĬI3ȹ	]Շ\"xm(ZK`Gh\"KI.cO8eRh#pάa{T%}<`G(\"T\\FÞ(rxE2~㚡Ėo>% J)1!( 	N*41%El\"dfkɓ1((Y\n	J\"H^5Dɔ&[Yd7@'0tHnUT<x(e,!(-gtI5Kp^\"N	HW=#*N:mൗd^K&R(,!B)DKl`QhnO\"}\"\$&;*^P*Zt|@+|oהK} E	oe&.E.	lUBDowS8j0CYe:C`DLAӐa/JnȤ ÐVwZG\"ɢ\$₹B݇~R\\\r&`2w-J>AQ]m>Ϋ\0)F/h:/NǍI:: vy\r\"qlE؝R4,jKv׵@pN,C|̨L\r\rDex%2Dsj\rC8Yk).#}4\\u\"\"aD֬4t{l90R9O\"koXŲod3\0(! 7w\0]ec!S͡AJT?:\"m,XanɜbS\nP 0xm[EvDP!XaG؈/)Eua)6WD8voZ3,JLD(	輧˸}҅?L&uVa8_,ӴſF5VgP=r]K}/c:~>{=ֵ5@+06&41(۸s+	\n>e=F(	\nc5\0E\ncswUCE7]``Qb.l{ڛNAe 6fm_6{'e('Hâ.LnlL4`!Ep_lVm)/]\"-Qpɞ2~\$cJih2BL'D@)&P<C^,\$Ϧtj|cϫ&t+hFf/	8w̀	wOP̊4YC).&n̲'=\r\r?!b5nf\"/܄Mm4f^r,n\")DL/HHj=6%Lq\\r@R(ȕ*MĎح>p%q10%GJtQ5'1c \"@D% &tmdP;q\r&;q5fb[P<\\bL\nBfCfrD!%\\!ȋqR\$D<3{\$҄^҃,vf1r4bTr\rzP\$Mj%Bc#m+S'd8ލ+b\$r֍--hf߭7\"\"\r)?7D 'L58F(д2\nl(s03+*8	 m.\\5C(au4H(5sj\"[7\0N&>Par8Sf0O/\n0j\$:Eb7\$CEd\rVJe*\"\nZ!q:|LuxK7c}@E3@Ԧ=0F#ĢO]BN<48\"QBv\n\0'\$^㫄 !h&˪4`I>/\$5&x&-)r dJ%vGԐd\" n8ĈI2Kk^G+n.l\"3]<]欜	NZfbͰ\" \0dӨo\nc	^/`9=G!_cFkRug5Q\nBjm.LGK\rC`JF쫲P\$@";break;case"uk":$f="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9(;Au\r*u`Cd-|EX~\n\$g#)exZ9 G\"HESXj8R9ֽ|_b#rk:-HB!PńRDiyA	ǖx]5KOcJvf[5{ftk,TIjh0'\rz~8ȋ\$\ry*.#΋4nNƃ4ê*0(r}48죎'plA\rDn<@#)یF^ƭs	X ?V	/傼Hʹ,)\nZ\$,\n\$÷H,,F#M!d|#eEMj)Dm+)Z+;QH1(1;Eҟ/!Y&X⢪z_\r(hn?!T1CW\"6Nh14\$f1>)B[l`H1GbtwNH1rh\n# 4(:E!s2ԠM0#{&#3SApx0C83:xbAp9x7<9XJ}-w<ITndT^0rjX˒\$֒r4Ȳy*,*euon6yK\n6ShfI_#hyz*Cj/)!̄^IdV=GT=oS\rv#s'v#kY^i!b^ԋkξFrv]Ͳm#7\\֑\\n\n_*șB\ru*6w\$FA3PU}e\0Gqh-\"'X=t(B|pJj::dBNqAL(ǹ	( ^)\$FSJ=\"BM}|g *< h\nLE\$F>B8G#n\"x\"rz_(tSG \nt\n1N`aM}cu/	R!Z]tCxsгaa!I8|on(|̟Z%ىmMJBR8oEB',%aR>rl_̪yTǎ8DwQ\n(^-%T.T*E,U\n^S*qzۊDC|p@2'h%7Y4xGI \\F'a)t)X8Hrb:J\0ɌzB;?W).\n <D:/FOeg]FIN4vy	H\${UL΅-'Кaiun%Q:{ED]DwΪNMR|)TG+]-Hnzk\"(9Q'4*URH\\Jr;shέ,\\^6\"vfY9gl+Gb!ɥ4Ɯ(x<9̷\\%#6mh3CaM,*IfNKs&@%Ba(2%|pE\n*%a&\0*\n~]Kmo<D2ҋhS,G&Q]߮G1ٯ6Qy ^c@٩PBH\n\0@(+@QQN(b:eFb0ɕ>8Ǐe&dV?y+W\"V6\rEvk^9T!Tr0ɕʍGKrEV}ܣ(Y^+6C](w<`vb)KjRBS\nA\ne)M|LasѺ'. KcWD2\"+SLT-^v\nptgrֈ!QIˎt&1#LoGIH*=i;o>h՘@'0#:r.=l=Buͽ#԰P1@~/?iM;2n/KmZ<& {VSA\r!^T4X#@42呋>'UH#ԍL̿ų)u4C\rƇa4L+4Б#VJaK#?5{cԼ]i;܋4:K]Bt`vCQU+-5(Й(BMkr3>4堜R\"%GMK&H>Lz|も6b<QNW߫DZl1V,P3cb6#HKT-.,nidh%bc\"Kj'ԯmFP\$gQG(c6x\r\08_,<H	>9&Dcf#LN,#Brh*@.\03 b@\rڐv\\\"g\\ݐ(X[VcVEt LFoJ\$NU._014T\$0)ʊ(.^)&HFHrrWfS.bk3\0u (XhZIeLh#\0\"hNXx	*H\"?LEna\n`ۋDDlzHڤұ<Eu^-~ZgLatvCgxodF9dwv[(bhƾA\rĉ0dQWf'PqA0Hڈ=B'8<Qƿ'b 1=J<2*d2@;u2۱!QddEh#HQL!Xvr]#C&%2)\$Ĩl(0cL5EjD\nTYeLlP`E©+@mN8DPHd\r,qe*l%z\"P::K#FCrN,͸/`wQW2E_2x)3*2i,O+.q8\$5PB43\"zhZ\nQN#5K4^&n%FPl{n!,| *D´2!4O%VW0<ċ9IEcI:l\n9)57fw(?c 	\r\r\n83B`^zesq6g6S@MN*Rh1mDȓEES:)GeF/Ri4t7@@3RԣIt/(Pk%Et3R	|W͂:J@!HK%sԥIy5*=M3\$wڥoh#t'\0OBH%oPT͔Fa,L@S@4+trtHE\rrUTTQuALuZ2UHѐPUQK	He@pC9\0rgM/~)%T`.f\rI&T 긽&uqY-Hf&j1a,=#ּޝ⚬}XER-(3Tu_WL%ֈ6n[9\npJ0Cccޟ|iLTbzWuS6)uXV=T\0<KQ`g'c5}2]Lifmf?cg%SgteT5vSrgHy eҿ\nZe>{DGe|0ZlSUfmCmm77vpE5/nH5eUa#*a}~'\n/nm֙\rqiu8.vr@kFY7^CFCEG4_]f8dVLup,Spoa	wwZoGw5eykUo@Agv4t7huwUmh_ZW'D\\<bdU0W50s|S~m8vSXWi7ݢk={E~F1gXXx{s6|\r\\Wgk%\$E6f׵HQT8vo5[gg2sKb6Sj!muK5<qI_i	l'&REqĨ3ǋgF M7:R*+wEW1Hvo'KʋSьgx{j%_~Ć'nېS,i\rW`/uJg[M6{xTc^FAuevt@\np%&ϙwf!t1RdiVVo#yHXHkJ6}49x	GF|4F;UK/Ҳ5?DWMss)#\\C,咣|mF0)W6'd :1w8'5)%|qp1SÃ-G4WaHSEH˂SkXnHW[H&O}}u7Nt,r?څSYeu\nAfQ9OWBE\0b-ZC]\"`NpsQI9\n(7ѩY㪅߀PgV.L=;;ll&8\$&MFH`<}փe}'5JʂVcGtyk(O.-i\0gWNfgtg|hhifi^~ Dkc\$F\0\\";break;case"uz":$f="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8!\"n:far Io7X&9 5瑃Hq9L'3(}Aap-rLfqJ֘lX*MF\n%mRp(+7NY>|B:\rY.3\r4Asҙuzah@ti8[-:KZaO7;|kul7*'֊+ɜӉh@<6`5(0L8#ޅ!,6\"#ZB0*8\r{9\$R'ɪ8ȎNp)3C%ct\$o45M P2Ir<3j쑻#(;O\\+@7/KXs\$>7GMCֈzF4+.ӈ#\"x7OQ\rJ	!D2eO=cC}\"fȌr!ь0z\rH9Ax^;r5Qsb3(;# ^'PUx!;VUԋ|L4:IÒTXd9=P{QwaQN֋.2(mLbx7\n/ PJch.\n7_c=dP;zE|+`@8ӈ-h4#;\r(j'#j2I˪9Ah!z(>k!* 7 _<4\$7[v23I(ԍ+(<8NZ;ml=V)O#=u8^OقtwM r#j^Rk(ȳB\\Z]5˂@ލS8863f+ݲW	hWñ&W*\\Mx;d8ʃ'4#C>aaa	҂5\$6\\Q:M0%\nG)cy\rtXpJ)sXCf&1<5\\Y؉n-)֘H3 Z\n\\|\"A&{B:Z#xY)19;\"=#D%hh\$}yCWIy``z@GZG`Q6YdY#*E4OLCF4hCsh,#`V2YK1g-\0sZ]l\$EqVdqnIa)Z/WH^bɁ2I.\"i?@GB	\$\"z)e~0D#V\")x+3՜,FQЖ>HښD5ix @@PHT%\"v#AA>'029ZYF)(ׂd||*EY4['%\$'`FgB-PFWii䗙\"hY\"ƆÒAF\"2'TYdꄤF!) OIaLnQ!,z'RW@}@IzAЍ@Q#12\0y^Crc|Vr:QjRzH24UhI6A8Gh	\\\n<)IŎw.v˦m7`dF\r4}.ܟ\0	7u*Qc#\"J՛\$tͥ]!tf^\nK2BpG	!3|\n\$pN\0)u@Rm|:5O0zpHlgLM>wMY67>Ô[6VkОK֐OQץRJđ/:<x6X<2tܙ<rc06hPZ#PꢲWTjĈA/FhDw9:\03~Kz`>D`BA:\r(\$ pP+	dSNLYA\\c03(<Qryn0׮F玦Ml1o&\0dUL3oA3BZl;	vNF*I;3B[oCD\\M\$KgAS|)j?%s!޸흦~Q )L:NO1A9󛲴g!ݻ!P*)giE=M&;\nlPc19I.s'y1##z)6lSqr8zu3\"Ϊ2i+θŏi#vEi';fΆfc{Gz.<;=eXe\ri6v\n%G`)1heFW@\0177=YkkB9ud/ѐ3e06Hxpj̉!5G`\">f>9{@o3YAʙQޝqo{|<r.'-n3L,\nfb&K# D'I8f>gq.\$d4Blft nO\n\\,gb`\r\rFdVB LXB,QHf?@.wNDwbDcЎpV@؏PжvaolgRyf؏rig0L0y0>O6P̼,\$\nˑωq\n\"mľ>2\"48lpGړR	CfH1>QDf9b\"Bnp*9&hʐ\0mq5:8lN٭8p5Ȓ8p\rL`{dw U1z-uqad1TAh*tpyRHyRM/%0!j`j!\$\rmj\"R5]\$a^kb֠:z'CrNzMr`Gr2D2%y*7'+(*q@,4,.R4\$-R!\0߲(02.XT1'0&T2NOls2ţLrPD,ĬS\"GnHAM5&' q55\r3\$v	e:2s%F6|5oCcf.!;,͌3x<ذ3xG9\"c+&c<Ϯ2i63nI[@Ġb*>\"\nZLPG#{AT\"iIUo_*E2#m&D8\"\"P<}e7i;>Ì&Cf\$IJAKe@~Dlrnp@:&\r5G7<\r:O/3l\"4:q8ȑL4bCL?-M}K ;N#8;͕\$ODR^Zl'X9,vxQQQp5e 4NGN0ώ4D4\$6A&'\$4('&	\"qPL\nxhra͚7M5:H-8hL+O.";break;case"vi":$f="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn810Lthb*L QCH1b	,Q^cM3s2Nr=v8]&-.c\rF 1XE)C	nz477JqmU`-M@daH9[׵\rH!y i=Yd\$IXWxmmtWjYoqwD:<6\nc4`P7e'@@#hߢ,*X7@9Cx䐈0K2\r(	:M;#@\\j LäJޔ)l\")qvOƎc0I~lK&B#%\0A:0 K P5\rhA98*\rs)'BB~MPvSh򐅥(;%re&llK!\nK!v\rAIhCbTrԡJu4#p lgÜqQ1q!Ep@;(p:z9XоD49Ax^;plq<L3(w2t\r30\r#x|,[W\$WK8JFt6o5Vڄ\n`eeۿP0Cu؂#0<(P93:<j@N]3(1\r0fLD'dh*ư*j0\0@R TD6e^<b9/\$-*P\"~iE\n#T0a@3;BD\r)\"`<pcEd.!b'ۯԂ\$l\rlJB%\0v!뙱tPR^mPeNm9w	UW A>)O蘒#eo}@CsFZ Z	>f`̉<`!C<@ @(\n0 `a&iEe\r7.\\`\$ÆC\n+\"2\r([Am)FaRHt&\\Zu^R,%Bw!]춹W!I\nMK`˃9!\nOa@9?%ˤ~\$2e\"[\$*C1P6v0&C\na9v\$\$La1ƣsdQ,ۡrI1Q'Xrn4\$1teSH\"UEI0+\n2C`l38\"6Rhek36B֍ޞJB!ĜB]dcPQGNPYsJ,DT(t-ѰP	@a\"\\tatpPƇGi@|3%ќ\\F\nDOdMGn:3&Rs'\r|/|vFtLF\03/\0JD _fLBpM0r\n7\":W0*z.\0YpEأF	i ]\"h]\$4yg)Ŝ+8][@RHBI12(pnk:ӬfDl-M.0Uڊ)'b>O\naRL Z.xvW,	1\\-htnvAC{E\$+s]AZHJdBK1*UCja6X4(fש;j)`*s,nȽS5Uf\0A-j2nyBʀ \nW<5sSB5D}3XGݱ+ <g\"pAy ҳ]90M>5,E/:O{6/	54\"!r4Ӿ`\$6JF<vdA[%M\"CT<\0%dsnLDI1	(%X`9AZY]ψ*C'[9<\$3h\npȚfyErrݴB8i%Po7Fd|!ݻwD\n>r8nr!yi?(C/^n|u%)hs9n8LצL5͚\$h	}X4TX)k#a^XJS-pC	c(\\Ѻ9Gu7.	q%H/\0**\$.\$ۉZŬ	^/QAfoKyFzI.>rM19JD!bP)w9pҶ%KZTPzT#Sn7Ч0[.Y(9wEX4jǧ8Ͷ,)bj,l\$*2\n\$*P~'}P0x\"fF'&ɢ=8?DBbd.D6'@~BvAbA)vtBbn'(2d	L-ee<KCӐFpJj<nhPC\" .\r6\r\rPtzGvP0ZȚE9@A2:)zұƇUgfWz''g\"AeE0Z\$J__(\"Rir7lk\\	tL&2H>\$\"qD1Ćͤ4ZY1TƚEc\rJ+12pC\$@JѺ\"	I\rNi0CСgL l_Qh!!|3Q!jR!1:9U\" Z.샦{Qi%Q%q&nZo&,I&@plN<ζ=䢕bU\0P\"?Ɔ_ȁ\"2\nK&[r]\"^	+q+`i%~|~iFSb0F/x7R\nb\";/H5r42\$,1I]ɔR,G8 NR|34#I-&4k'2x1w3VUl\rk/6cC:HGlh|fM)\00}68jp/Μ\$0ؤzRVQт2NE:)SM\$p\r5SR<\"Z&R{:eQr3'>eDI1PT?rL'\0J#cQlF%;%((@MbjOol1r@\$,\"@񆼨jg3	ĐCM4JJ46O0hM>}%2d\"@d4:`ЄR)\0\nqg,7clfԷS^0S&Q5YkHFG49cpE!3ZgNTZ-ņdmGz겔2MQD\0M/?%#\$F!R\r0%#0m%Sʷ\"SBpi:jg+&u̢gOJM0!^(MĔu4'/\0}iKԎ'&@|`DB	pA&ϴ	\0A-b0VVCVjpb&eDKDFplpكZ=ʧР";break;case"zh":$f="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4)ΔT9w:vO\"%CBrixM3s2bV}\n%[L`*9>S؜%yP⣎uYоHQ)\":VdjdK:tRd(t/0Vc5_hIG*\\?M[h9ͣQpCqH\nt+ծB_cS>R\$2{T-&ġ^s	W9@@nr?JHkIRr\$M'\rz哸@łK*<OĹltV9XS!%]	6r^.88J|rYn(\$QBr%B+EHd)(֜RL*E0Pb6#p9%0dBW6L'\nRY=\$F@4.0z\r8a^\\0tm\rp^8.`xDωLsd)SCx)I\0ڑeIR#|sӦISr^mS|usmkV)\"EA(FAJº(fT[xaCG)T=mU#I!@Us\\{eDH Nċg1i^YKr/A˲Z5vM!(JYQJ!PD[b!g)xK|\$>|rsYy~qYO>AG1LA::R s\\j8xG)]=|qu|ru*;Zg\0:cAT:Cp@0C9#yo97Hj0B+DW?aK}4PJ6YE2eBrR:u@H,G@GBʚ!Th!H1@G-++ME	WyH\"\"hc^!+Xn/:;'jU^UV;zXKcP(s\r/mg-4Q:)|@	g,ĩ'DAa`. F	g/(%|H?\rAD׊H9m~hVȄ?%`spbuµCr%`F(eC#H\n\0P	@KR9D|D\"b	A\$\\<9pJsm8\0QPDA!E,dF.`b^A0yfbmxŢ\"LJ#E5\" 00 \"j6F<H\"LfG(\$pte \$DD04D\"u'\r\$:*tqdXt@hv9IB4)\$tN\"xS\nRB)=6nG!\"_hS:D+Ji҉FI0H\0\$`&EOIyѨɡ&ڄ\\\"K 9kP*[Ki E	֤1/LEsN\0A0KtʄOi䕇|N.Qw<E\")4-ڸGR2>5p4r|tD	u0(*(T \rqax#(+(K*^b1)3-(N_zLI'#W#,='ea6PΣps.0P;_x/|q\rG0r\rᴫ4&-Qe:.VjpPwGE_B(BTa2c\0 y5Gbn	kq#rTY[\0L`EM&/ιZVi-w'slB6*1>5zk_]z,5A#QJXZD`\nlB#&\0Lr\\lM|n\rWF6Wfby/vv[e6&rQ}%Ȁ'6)XHp+([a\$._K\r#l9D\r@]Vn@0G/07?+z*q1{ޛq[-80v]>Rc9)%(ٍ=#q^>;?m`1ǦlɗF^,_V\rqcPlX:(Oh7Lws8n	OGbC^</R\r{\\?dX3Pt{t{|ܛoncsb쾯:'Q%(s]r	W.6vO	BJݯ|,*_ÛXAp<;1%D̐df8LtN_Ϟ=6KϮp>M̘ZRtu2R_HB`Pf'e%RՐxl2]lL^q\\!lhH\"\$9!NlogFe\nj0jaZ'E\\fHgbpg\rX80a<B\ntFb^AslM7L#\nP\rUbxy@@d/3`&Б8VXMЏ5mm%ъmMrQfn,H\n(o&+q#	ʀsаjcn1tڣI܃n6bJ# BqLQ)AAz;BKh>pEoΓC\nZO\r-I4LRfR>.\00(\$f2Z;#C%I8@@04fan72v+Rjĥ)P#-<m\$b!\n5+aXRAIm/qs\0B\"(3\$2c(Ì~̒\$+l̮3K)H\$\\h Ɉ\n`ژ:r?^,\"BN.a/!\nc/>LB77kA10-QH/";break;case"zh-tw":$f="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/WtЀBT)*yX^%ӕ\\r|I7FS	99STB\$rNuMТUP)&9G'ܪ{;ds'.̖L9ho^^+ieD:=.RFR%F{A,\\{Xs&֚u\0rzM6U!TDǇEtl6N_'zV~NZRZRGATO\$DЭ8UJt|R)N|rEZsiZy	V+Lr>[!kg1')T'9jB0,1/:8Dp.R\$LGI,Ii.JJő[e|kzDYYrQbB%B<\\gA2EyD^ONv`\\\nsT h7P	|\\DTZ\$EQJ3wH	)	O*F@4/c0z\r8a^\\05]Z\rp^8/pxDARd)SnRQ!^0Q@b RW!u%39As;,W-\r_QetV)\"EA(C2R\$݅,k*ΑgANQ=tEUdҘ\nI^d1H N&k9]g1G9{q%kijCA\0Q7z\n(:I*[ą2=+\$<B~Gb&Q{1IK;)cD/Oo_K;%x|g5}'O:(APEtG]?lC1=ܜ-xTxXV	e@6d:Cp@09#`!Hg~\0Y0CS+0Ort Ȗ	d!Jyd6@` b	!RSoeL8!	TK&icfNYz8äHa|#HS!KTTd0Øi΄DQYV)C.F	F7	>OVJY=h5w[kuV%\"p7FNH0XX!Tt\n&[ҟT\"hc̈t\nHk&bX9c	YBMq |	0E!	u,W|[eI#nN8l<+g6- \n (B		0. Aա\$\$\n6)Q&Q(!\nb!aM!\":l2%q\n)VRhݣ9Jc`W1::,WhD29DHJBLS\nA@)=Q*Axu	XW\"lXDJ\$&a+Cd8 	2ĎI2M2S!'>M<TbMab q1/x\"tQT\0R+bO[&t]B+\rx	p%/ll@	P%f<	AÑBqʢivbKA}h0bP4p \n@\"@U\"y:HHsIYk`qI3jm?QvV S2'\r8dLR8AX]>vE[wGo2%G8EBVEqJ E!K<b Њ&&yOI'(0auT6^L9RRhEEf>0Dz1	nV^`u9^*a7BQ*2{Z9DHxc*cphi3 H@Me<A~]pZ]q.d`.p5wZ]kϡf\rh4SsP{ju\0rY٘<b4^%xyYkl#=i2~Vw`BHiyY7L4'J	8ReZ{^\nxKXNot/EXL\$]mӁ\nhk#Iq	sr8sBa`71CumӲ5<au2VV\"<X[\ru# MÅA˔ZW%q_8GDFF9/d\"{˲ZGR%<<*ъ[ORx؋z_[bB5XZ30\05f}d{j-XYY>PA\rp Ѫ .y\rU8G2j(bJ?`PMp\n]/@/xP0&ѧnOW|0-Ryo28FPNYO `+P0nؐt*p0v2^G!CaP;^>v	|X+\n'pJ\n!pX26Rf(M˵MxөJ:#n9MiD<;\r&9Wmm5\n10myxDlIc礎{\0ǐbgl^ki-\"^C(,(!GgѠ\\jvE^%qkQ_%`<\"pDgsPNyQƱ#L1͑@AqQTr- !Ybf\r~0R\" \"`\"[#`#\"G\$%\rf`0Of`\rhMm۲xQ1'M<(0-(\rLD)2_'s**dk+b)@/@̈9DiƖ\0PRc IJBaz!pk\n.H&H:GA6bch\\\r3C?n%j؛I+P\nZFz>	\"!`ӱaK&#BpCbMؓV2>ޓS޳\$,?t|4GloF/MA##\0ODs0t?fr1,nPl<Ot!2\rYCBP, I\n`ڟӾ+#@.N:-|!R{S>,*\$vPAs03^&3<)-Lo";break;}$ij=array();foreach(explode("\n",lzw_decompress($f))as$X)$ij[]=(strpos($X,"\t")?explode("\t",$X):$X);return$ij;}abstract
class
SqlDb{static$instance;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($N,$V,$F);abstract
function
quote($Q);abstract
function
select_db($Pb);abstract
function
query($H,$sj=false);function
multi_query($H){return$this->multi=$this->query($H);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($pc,$V,$F,array$fg=array()){$fg[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$fg[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($pc,$V,$F,$fg);}catch(\Exception$Jc){return$Jc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($Q){return$this->pdo->quote($Q);}function
query($H,$sj=false){$I=$this->pdo->query($H);$this->error="";if(!$I){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(23);return
false;}$this->store_result($I);return$I;}function
store_result($I=null){if(!$I){$I=$this->multi;if(!$I)return
false;}if($I->columnCount()){$I->num_rows=$I->rowCount();return$I;}$this->affected_rows=$I->rowCount();return
true;}function
next_result(){$I=$this->multi;if(!is_object($I))return
false;$I->_offset=0;return@$I->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch_array(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch_array(\PDO::FETCH_NUM);}private
function
fetch_array($xf){$J=$this->fetch($xf);return($J?array_map(array($this,'unresource'),$J):$J);}private
function
unresource($X){return(is_resource($X)?stream_get_contents($X):$X);}function
fetch_field(){$K=(object)$this->getColumnMeta($this->_offset++);$U=$K->pdo_type;$K->type=($U==\PDO::PARAM_INT?0:15);$K->charsetnr=($U==\PDO::PARAM_LOB||(isset($K->flags)&&in_array("blob",(array)$K->flags))?63:0);return$K;}function
seek($C){for($t=0;$t<$C;$t++)$this->fetch();}}}function
add_driver($u,$B){SqlDriver::$drivers[$u]=$B;}function
get_driver($u){return
SqlDriver::$drivers[$u];}abstract
class
SqlDriver{static$instance;static$drivers=array();static$extensions=array();static$jush;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$partitionBy=array();var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($N,$V,$F){$g=new
Db;return($g->attach($N,$V,$F)?:$g);}function
__construct(Db$g){$this->conn=$g;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$n){}function
unconvertFunction(array$n){}function
select($R,array$M,array$Z,array$yd,array$hg=array(),$z=1,$D=0,$ah=false){$we=(count($yd)<count($M));$H=adminer()->selectQueryBuild($M,$Z,$yd,$hg,$z,$D);if(!$H)$H="SELECT".limit(($_GET["page"]!="last"&&$z&&$yd&&$we&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$M)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($yd&&$we?"\nGROUP BY ".implode(", ",$yd):"").($hg?"\nORDER BY ".implode(", ",$hg):""),$z,($D?$z*$D:0),"\n");$si=microtime(true);$J=$this->conn->query($H);if($ah)echo
adminer()->selectQuery($H,$si,!$J);return$J;}function
delete($R,$jh,$z=0){$H="FROM ".table($R);return
queries("DELETE".($z?limit1($R,$H,$jh):" $H$jh"));}function
update($R,array$O,$jh,$z=0,$Vh="\n"){$Mj=array();foreach($O
as$y=>$X)$Mj[]="$y = $X";$H=table($R)." SET$Vh".implode(",$Vh",$Mj);return
queries("UPDATE".($z?limit1($R,$H,$jh,$Vh):" $H$jh"));}function
insert($R,array$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$L,array$G){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($H,$Ui){}function
convertSearch($v,array$X,array$n){return$v;}function
value($X,array$n){return(method_exists($this->conn,'value')?$this->conn->value($X,$n):$X);}function
quoteBinary($Hh){return
q($Hh);}function
warnings(){}function
tableHelp($B,$_e=false){}function
inheritsFrom($R){return
array();}function
inheritedTables($R){return
array();}function
partitionsInfo($R){return
array();}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
indexAlgorithms(array$Bi){return
array();}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$J=array();if(DB!=""){foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$K){$K["null"]=($K["nullable"]=="YES");$J[$K["tab"]][]=$K;}}return$J;}}add_driver("sqlite","SQLite");if(isset($_GET["sqlite"])){define('Adminer\DRIVER',"sqlite");if(class_exists("SQLite3")&&$_GET["ext"]!="pdo"){abstract
class
SqliteDb
extends
SqlDb{var$extension="SQLite3";private$link;function
attach($p,$V,$F){$this->link=new
\SQLite3($p);$Pj=$this->link->version();$this->server_info=$Pj["versionString"];return'';}function
query($H,$sj=false){$I=@$this->link->query($H);$this->error="";if(!$I){$this->errno=$this->link->lastErrorCode();$this->error=$this->link->lastErrorMsg();return
false;}elseif($I->numColumns())return
new
Result($I);$this->affected_rows=$this->link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->link->escapeString($Q)."'":"x'".first(unpack('H*',$Q))."'");}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;}function
fetch_assoc(){return$this->result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->offset++;$U=$this->result->columnType($d);return(object)array("name"=>$this->result->columnName($d),"type"=>($U==SQLITE3_TEXT?15:0),"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__destruct(){$this->result->finalize();}}}elseif(extension_loaded("pdo_sqlite")){abstract
class
SqliteDb
extends
PdoDb{var$extension="PDO_SQLite";function
attach($p,$V,$F){return$this->dsn(DRIVER.":$p","","");}}}if(class_exists('Adminer\SqliteDb')){class
Db
extends
SqliteDb{function
attach($p,$V,$F){parent::attach($p,$V,$F);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}function
select_db($p){if(is_readable($p)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$p)?$p:dirname($_SERVER["SCRIPT_FILENAME"])."/$p")." AS a"))return!self::attach($p,'','');return
false;}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLite3","PDO_SQLite");static$jush="sqlite";protected$types=array(array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0));var$insertFunctions=array();var$editFunctions=array("integer|real|numeric"=>"+/-","text"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("hex","length","lower","round","unixepoch","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){if($F!="")return
lang(24);return
parent::connect(":memory:","","");}function
__construct(Db$g){parent::__construct($g);if(min_version(3.31,0,$g))$this->generated=array("STORED","VIRTUAL");}function
structuredTypes(){return
array_keys($this->types[0]);}function
insertUpdate($R,array$L,array$G){$Mj=array();foreach($L
as$O)$Mj[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($L))).") VALUES\n".implode(",\n",$Mj));}function
tableHelp($B,$_e=false){if($B=="sqlite_sequence")return"fileformat2.html#seqtab";if($B=="sqlite_master")return"fileformat2.html#$B";}function
checkConstraints($R){preg_match_all('~ CHECK *(\( *(((?>[^()]*[^() ])|(?1))*) *\))~',get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$this->conn),$df);return
array_combine($df[2],$df[2]);}function
allFields(){$J=array();foreach(tables_list()as$R=>$U){foreach(fields($R)as$n)$J[$R][]=$n;}return$J;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
array();}function
limit($H,$Z,$z,$C=0,$Vh=" "){return" $H$Z".($z?$Vh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Vh="\n"){return(preg_match('~^INTO~',$H)||get_val("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($H,$Z,1,0,$Vh):" $H WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$Vh."LIMIT 1)");}function
db_collation($k,$lb){return
get_val("PRAGMA encoding");}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($B=""){$J=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K){$K["Rows"]=get_val("SELECT COUNT(*) FROM ".idf_escape($K["Name"]));$J[$K["Name"]]=$K;}foreach(get_rows("SELECT * FROM sqlite_sequence".($B!=""?" WHERE name = ".q($B):""),null,"")as$K)$J[$K["name"]]["Auto_increment"]=$K["seq"];return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return!get_val("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){$J=array();$G="";foreach(get_rows("PRAGMA table_".(min_version(3.31)?"x":"")."info(".table($R).")")as$K){$B=$K["name"];$U=strtolower($K["type"]);$l=$K["dflt_value"];$J[$B]=array("field"=>$B,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~^'(.*)'$~",$l,$A)?str_replace("''","'",$A[1]):($l=="NULL"?null:$l)),"null"=>!$K["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["pk"],);if($K["pk"]){if($G!="")$J[$G]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$J[$B]["auto_increment"]=true;$G=$B;}}$mi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));$v='(("[^"]*+")+|[a-z0-9_]+)';preg_match_all('~'.$v.'\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$mi,$df,PREG_SET_ORDER);foreach($df
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));if($J[$B])$J[$B]["collation"]=trim($A[3],"'");}preg_match_all('~'.$v.'\s.*GENERATED ALWAYS AS \((.+)\) (STORED|VIRTUAL)~i',$mi,$df,PREG_SET_ORDER);foreach($df
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));$J[$B]["default"]=$A[3];$J[$B]["generated"]=strtoupper($A[4]);}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$mi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$h);if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$mi,$A)){$J[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$A[1],$df,PREG_SET_ORDER);foreach($df
as$A){$J[""]["columns"][]=idf_unescape($A[2]).$A[4];$J[""]["descs"][]=(preg_match('~DESC~i',$A[5])?'1':null);}}if(!$J){foreach(fields($R)as$B=>$n){if($n["primary"])$J[""]=array("type"=>"PRIMARY","columns"=>array($B),"lengths"=>array(),"descs"=>array(null));}}$qi=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$h);foreach(get_rows("PRAGMA index_list(".table($R).")",$h)as$K){$B=$K["name"];$w=array("type"=>($K["unique"]?"UNIQUE":"INDEX"));$w["lengths"]=array();$w["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($B).")",$h)as$Gh){$w["columns"][]=$Gh["name"];$w["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($B).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$qi[$B],$uh)){preg_match_all('/("[^"]*+")+( DESC)?/',$uh[2],$df);foreach($df[2]as$y=>$X){if($X)$w["descs"][$y]='1';}}if(!$J[""]||$w["type"]!="UNIQUE"||$w["columns"]!=$J[""]["columns"]||$w["descs"]!=$J[""]["descs"]||!preg_match("~^sqlite_~",$B))$J[$B]=$w;}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$K){$q=&$J[$K["id"]];if(!$q)$q=$K;$q["source"][]=$K["from"];$q["target"][]=$K["to"];}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',get_val("SELECT sql FROM sqlite_master WHERE type = 'view' AND name = ".q($B))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
error(){return
h(connection()->error);}function
check_sqlite_name($B){$Rc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Rc)\$~",$B)){connection()->error=lang(25,str_replace("|",", ",$Rc));return
false;}return
true;}function
create_database($k,$c){if(file_exists($k)){connection()->error=lang(26);return
false;}if(!check_sqlite_name($k))return
false;try{$_=new
Db();$_->attach($k,'','');}catch(\Exception$Jc){connection()->error=$Jc->getMessage();return
false;}$_->query('PRAGMA encoding = "UTF-8"');$_->query('CREATE TABLE adminer (i)');$_->query('DROP TABLE adminer');return
true;}function
drop_databases($j){connection()->attach(":memory:",'','');foreach($j
as$k){if(!@unlink($k)){connection()->error=lang(26);return
false;}}return
true;}function
rename_database($B,$c){if(!check_sqlite_name($B))return
false;connection()->attach(":memory:",'','');connection()->error=lang(26);return@rename(DB,$B);}function
auto_increment(){return" PRIMARY KEY AUTOINCREMENT";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$Fj=($R==""||$ld);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$Fj=true;break;}}$b=array();$sg=array();foreach($o
as$n){if($n[1]){$b[]=($Fj?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$sg[$n[0]]=$n[1][0];}}if(!$Fj){foreach($b
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$B&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)))return
false;}elseif(!recreate_table($R,$B,$b,$sg,$ld,$Ba))return
false;if($Ba){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));if(!connection()->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($B).", $Ba)");queries("COMMIT");}return
true;}function
recreate_table($R,$B,array$o,array$sg,array$ld,$Ba="",$x=array(),$lc="",$la=""){if($R!=""){if(!$o){foreach(fields($R)as$y=>$n){if($x)$n["auto_increment"]=0;$o[]=process_field($n,$n);$sg[$y]=idf_escape($y);}}$Zg=false;foreach($o
as$n){if($n[6])$Zg=true;}$nc=array();foreach($x
as$y=>$X){if($X[2]=="DROP"){$nc[$X[1]]=true;unset($x[$y]);}}foreach(indexes($R)as$De=>$w){$e=array();foreach($w["columns"]as$y=>$d){if(!$sg[$d])continue
2;$e[]=$sg[$d].($w["descs"][$y]?" DESC":"");}if(!$nc[$De]){if($w["type"]!="PRIMARY"||!$Zg)$x[]=array($w["type"],$De,$e);}}foreach($x
as$y=>$X){if($X[0]=="PRIMARY"){unset($x[$y]);$ld[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$De=>$q){foreach($q["source"]as$y=>$d){if(!$sg[$d])continue
2;$q["source"][$y]=idf_unescape($sg[$d]);}if(!isset($ld[" $De"]))$ld[]=" ".format_foreign_key($q);}queries("BEGIN");}$Wa=array();foreach($o
as$n){if(preg_match('~GENERATED~',$n[3]))unset($sg[array_search($n[0],$sg)]);$Wa[]="  ".implode($n);}$Wa=array_merge($Wa,array_filter($ld));foreach(driver()->checkConstraints($R)as$Ya){if($Ya!=$lc)$Wa[]="  CHECK ($Ya)";}if($la)$Wa[]="  CHECK ($la)";$Oi=($R==$B?"adminer_$B":$B);if(!queries("CREATE TABLE ".table($Oi)." (\n".implode(",\n",$Wa)."\n)"))return
false;if($R!=""){if($sg&&!queries("INSERT INTO ".table($Oi)." (".implode(", ",$sg).") SELECT ".implode(", ",array_map('Adminer\idf_escape',array_keys($sg)))." FROM ".table($R)))return
false;$oj=array();foreach(triggers($R)as$mj=>$Vi){$lj=trigger($mj,$R);$oj[]="CREATE TRIGGER ".idf_escape($mj)." ".implode(" ",$Vi)." ON ".table($B)."\n$lj[Statement]";}$Ba=$Ba?"":get_val("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$B&&!queries("ALTER TABLE ".table($Oi)." RENAME TO ".table($B)))||!alter_indexes($B,$x))return
false;if($Ba)queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));foreach($oj
as$lj){if(!queries($lj))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$B,$e){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($B!=""?$B:uniqid($R."_"))." ON ".table($R)." $e";}function
alter_indexes($R,$b){foreach($b
as$G){if($G[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),"",$b);}foreach(array_reverse($b)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($Rj){return
apply_queries("DROP VIEW",$Rj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$Rj,$Mi){return
false;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$v='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$nj=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$v\\s*(".implode("|",$nj["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($v))?\\s+ON\\s*$v\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",get_val("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($B)),$A);$Pf=$A[3];return
array("Timing"=>strtoupper($A[1]),"Event"=>strtoupper($A[2]).($Pf?" OF":""),"Of"=>idf_unescape($Pf),"Trigger"=>$B,"Statement"=>$A[4],);}function
triggers($R){$J=array();$nj=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$K){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$nj["Timing"]).')\s*(.*?)\s+ON\b~i',$K["sql"],$A);$J[$K["name"]]=array($A[1],$A[2]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id($I){return
get_val("SELECT LAST_INSERT_ROWID()");}function
explain($g,$H){return$g->query("EXPLAIN QUERY PLAN $H");}function
found_rows($S,$Z){}function
types(){return
array();}function
create_sql($R,$Ba,$wi){$J=get_val("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$B=>$w){if($B=='')continue;$J
.=";\n\n".index_sql($R,$w['type'],$B,"(".implode(", ",array_map('Adminer\idf_escape',$w['columns'])).")");}return$J;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($Pb,$wi=""){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){$J=array();foreach(get_rows("PRAGMA pragma_list")as$K){$B=$K["name"];if($B!="pragma_list"&&$B!="compile_options"){$J[$B]=array($B,'');foreach(get_rows("PRAGMA $B")as$K)$J[$B][1].=implode(", ",$K)."\n";}}return$J;}function
show_status(){$J=array();foreach(get_vals("PRAGMA compile_options")as$eg)$J[]=explode("=",$eg,2)+array('','');return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(check|columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Wc);}}add_driver("pgsql","PostgreSQL");if(isset($_GET["pgsql"])){define('Adminer\DRIVER',"pgsql");if(extension_loaded("pgsql")&&$_GET["ext"]!="pdo"){class
PgsqlDb
extends
SqlDb{var$extension="PgSQL";var$timeout=0;private$link,$string,$database=true;function
_error($Ec,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$k=adminer()->database();set_error_handler(array($this,'_error'));list($Od,$Qg)=host_port(addcslashes($N,"'\\"));$this->string="host='$Od'".($Qg?" port='$Qg'":"")." user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$ri=adminer()->connectSsl();if(isset($ri["mode"]))$this->string
.=" sslmode='".$ri["mode"]."'";$this->link=@pg_connect("$this->string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->link&&$k!=""){$this->database=false;$this->link=@pg_connect("$this->string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->link)pg_set_client_encoding($this->link,"UTF8");return($this->link?'':$this->error);}function
quote($Q){return(function_exists('pg_escape_literal')?pg_escape_literal($this->link,$Q):"'".pg_escape_string($this->link,$Q)."'");}function
value($X,array$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
select_db($Pb){if($Pb==adminer()->database())return$this->database;$J=@pg_connect("$this->string dbname='".addcslashes($Pb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($J)$this->link=$J;return$J;}function
close(){$this->link=@pg_connect("$this->string dbname='postgres'");}function
query($H,$sj=false){$I=@pg_query($this->link,$H);$this->error="";if(!$I){$this->error=pg_last_error($this->link);$J=false;}elseif(!pg_num_fields($I)){$this->affected_rows=pg_affected_rows($I);$J=true;}else$J=new
Result($I);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$J;}function
warnings(){return
h(pg_last_notice($this->link));}function
copyFrom($R,array$L){$this->error='';set_error_handler(function($Ec,$m){$this->error=(ini_bool('html_errors')?html_entity_decode($m):$m);return
true;});$J=pg_copy_from($this->link,$R,$L);restore_error_handler();return$J;}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=pg_num_rows($I);}function
fetch_assoc(){return
pg_fetch_assoc($this->result);}function
fetch_row(){return
pg_fetch_row($this->result);}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->orgtable=pg_field_table($this->result,$d);$J->name=pg_field_name($this->result,$d);$U=pg_field_type($this->result,$d);$J->type=(preg_match(number_type(),$U)?0:15);$J->charsetnr=($U=="bytea"?63:0);return$J;}function
__destruct(){pg_free_result($this->result);}}}elseif(extension_loaded("pdo_pgsql")){class
PgsqlDb
extends
PdoDb{var$extension="PDO_PgSQL";var$timeout=0;function
attach($N,$V,$F){$k=adminer()->database();list($Od,$Qg)=host_port(addcslashes($N,"'\\"));$pc="pgsql:host='$Od'".($Qg?" port='$Qg'":"")." client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'";$ri=adminer()->connectSsl();if(isset($ri["mode"]))$pc
.=" sslmode='".$ri["mode"]."'";return$this->dsn($pc,$V,$F);}function
select_db($Pb){return(adminer()->database()==$Pb);}function
query($H,$sj=false){$J=parent::query($H,$sj);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$J;}function
warnings(){}function
copyFrom($R,array$L){$J=$this->pdo->pgsqlCopyFromArray($R,$L);$this->error=idx($this->pdo->errorInfo(),2)?:'';return$J;}function
close(){}}}if(class_exists('Adminer\PgsqlDb')){class
Db
extends
PgsqlDb{function
multi_query($H){if(preg_match('~\bCOPY\s+(.+?)\s+FROM\s+stdin;\n?(.*)\n\\\\\.$~is',str_replace("\r\n","\n",$H),$A)){$L=explode("\n",$A[2]);$this->affected_rows=count($L);return$this->copyFrom($A[1],$L);}return
parent::multi_query($H);}}}class
Driver
extends
SqlDriver{static$extensions=array("PgSQL","PDO_PgSQL");static$jush="pgsql";var$operators=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT ILIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","lower","round","to_hex","to_timestamp","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$nsOid="(SELECT oid FROM pg_namespace WHERE nspname = current_schema())";static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g))return$g;$Pj=get_val("SELECT version()",0,$g);$g->flavor=(preg_match('~CockroachDB~',$Pj)?'cockroach':'');$g->server_info=preg_replace('~^\D*([\d.]+[-\w]*).*~','\1',$Pj);if(min_version(9,0,$g))$g->query("SET application_name = 'Adminer'");if($g->flavor=='cockroach')add_driver(DRIVER,"CockroachDB");return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(29)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(30)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(31)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0),lang(32)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),);if(min_version(9.2,0,$g)){$this->types[lang(29)]["json"]=4294967295;if(min_version(9.4,0,$g))$this->types[lang(29)]["jsonb"]=4294967295;}$this->insertFunctions=array("char"=>"md5","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",);if(min_version(12,0,$g))$this->generated=array("STORED");$this->partitionBy=array("RANGE","LIST");if(!$g->flavor)$this->partitionBy[]="HASH";}function
enumLength(array$n){$Ac=$this->types[lang(6)][$n["type"]];return($Ac?type_values($Ac):"");}function
setUserTypes($rj){$this->types[lang(6)]=array_flip($rj);}function
insertReturning($R){$Ba=array_filter(fields($R),function($n){return$n['auto_increment'];});return(count($Ba)==1?" RETURNING ".idf_escape(key($Ba)):"");}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$_j=array();$Z=array();foreach($O
as$y=>$X){$_j[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$_j)." WHERE ".implode(" AND ",$Z))&&$this->conn->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($H,$Ui){$this->conn->query("SET statement_timeout = ".(1000*$Ui));$this->conn->timeout=1000*$Ui;return$H;}function
convertSearch($v,array$X,array$n){$Ri="char|text";if(strpos($X["op"],"LIKE")===false)$Ri
.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$Ri~",$n["type"])?$v:"CAST($v AS text)");}function
quoteBinary($Hh){return"'\\x".bin2hex($Hh)."'";}function
warnings(){return$this->conn->warnings();}function
tableHelp($B,$_e=false){$Ve=array("information_schema"=>"infoschema","pg_catalog"=>($_e?"view":"catalog"),);$_=$Ve[$_GET["ns"]];if($_)return"$_-".str_replace("_","-",$B).".html";}function
inheritsFrom($R){return
get_vals("SELECT relname FROM pg_class JOIN pg_inherits ON inhparent = oid WHERE inhrelid = ".$this->tableOid($R)." ORDER BY 1");}function
inheritedTables($R){return
get_vals("SELECT relname FROM pg_inherits JOIN pg_class ON inhrelid = oid WHERE inhparent = ".$this->tableOid($R)." ORDER BY 1");}function
partitionsInfo($R){$K=(min_version(10)?$this->conn->query("SELECT * FROM pg_partitioned_table WHERE partrelid = ".$this->tableOid($R))->fetch_assoc():null);if($K){$_a=get_vals("SELECT attname FROM pg_attribute WHERE attrelid = $K[partrelid] AND attnum IN (".str_replace(" ",", ",$K["partattrs"]).")");$Qa=array('h'=>'HASH','l'=>'LIST','r'=>'RANGE');return
array("partition_by"=>$Qa[$K["partstrat"]],"partition"=>implode(", ",array_map('Adminer\idf_escape',$_a)),);}return
array();}function
tableOid($R){return"(SELECT oid FROM pg_class WHERE relnamespace = $this->nsOid AND relname = ".q($R)." AND relkind IN ('r', 'm', 'v', 'f', 'p'))";}function
indexAlgorithms(array$Bi){static$J=array();if(!$J)$J=get_vals("SELECT amname FROM pg_am".(min_version(9.6)?" WHERE amtype = 'i'":"")." ORDER BY amname = '".($this->conn->flavor=='cockroach'?"prefix":"btree")."' DESC, amname");return$J;}function
supportsIndex(array$S){return$S["Engine"]!="view";}function
hasCStyleEscapes(){static$Sa;if($Sa===null)$Sa=(get_val("SHOW standard_conforming_strings",0,$this->conn)=="off");return$Sa;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT datname FROM pg_database
WHERE datallowconn = TRUE AND has_database_privilege(datname, 'CONNECT')
ORDER BY datname");}function
limit($H,$Z,$z,$C=0,$Vh=" "){return" $H$Z".($z?$Vh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Vh="\n"){return(preg_match('~^INTO~',$H)?limit($H,$Z,1,0,$Vh):" $H".(is_view(table_status1($R))?$Z:$Vh."WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$Vh."LIMIT 1)"));}function
db_collation($k,$lb){return
get_val("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
logged_user(){return
get_val("SELECT user");}function
tables_list(){$H="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$H
.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$H
.="
ORDER BY 1";return
get_key_vals($H);}function
count_tables($j){$J=array();foreach($j
as$k){if(connection()->select_db($k))$J[$k]=count(tables_list());}return$J;}function
table_status($B=""){static$Hd;if($Hd===null)$Hd=get_val("SELECT 'pg_table_size'::regproc");$J=array();foreach(get_rows("SELECT
	relname AS \"Name\",
	CASE relkind WHEN 'v' THEN 'view' WHEN 'm' THEN 'materialized view' ELSE 'table' END AS \"Engine\"".($Hd?",
	pg_table_size(c.oid) AS \"Data_length\",
	pg_indexes_size(c.oid) AS \"Index_length\"":"").",
	obj_description(c.oid, 'pg_class') AS \"Comment\",
	".(min_version(12)?"''":"CASE WHEN relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	reltuples AS \"Rows\",
	".(min_version(10)?"relispartition::int AS partition,":"")."
	current_schema() AS nspname
FROM pg_class c
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
AND relnamespace = ".driver()->nsOid."
".($B!=""?"AND relname = ".q($B):"ORDER BY relname"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$J=array();$ta=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT
	a.attname AS field,
	format_type(a.atttypid, a.atttypmod) AS full_type,
	pg_get_expr(d.adbin, d.adrelid) AS default,
	a.attnotnull::int,
	col_description(a.attrelid, a.attnum) AS comment".(min_version(10)?",
	a.attidentity".(min_version(12)?",
	a.attgenerated":""):"")."
FROM pg_attribute a
LEFT JOIN pg_attrdef d ON a.attrelid = d.adrelid AND a.attnum = d.adnum
WHERE a.attrelid = ".driver()->tableOid($R)."
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$K){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$K["full_type"],$A);list(,$U,$Re,$K["length"],$ma,$xa)=$A;$K["length"].=$xa;$ab=$U.$ma;if(isset($ta[$ab])){$K["type"]=$ta[$ab];$K["full_type"]=$K["type"].$Re.$xa;}else{$K["type"]=$U;$K["full_type"]=$K["type"].$Re.$ma.$xa;}if(in_array($K['attidentity'],array('a','d')))$K['default']='GENERATED '.($K['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$K["generated"]=($K["attgenerated"]=="s"?"STORED":"");$K["null"]=!$K["attnotnull"];$K["auto_increment"]=$K['attidentity']||preg_match('~^nextval\(~i',$K["default"])||preg_match('~^unique_rowid\(~',$K["default"]);$K["privileges"]=array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$K["default"],$A))$K["default"]=($A[1]=="NULL"?null:idf_unescape($A[1]).$A[2]);$J[$K["field"]]=$K;}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$Ei=driver()->tableOid($R);$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Ei AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, amname, pg_get_expr(indpred, indrelid, true) AS partial, pg_get_expr(indexprs, indrelid) AS indexpr
FROM pg_index
JOIN pg_class ON indexrelid = oid
JOIN pg_am ON pg_am.oid = pg_class.relam
WHERE indrelid = $Ei
ORDER BY indisprimary DESC, indisunique DESC",$h)as$K){$vh=$K["relname"];$J[$vh]["type"]=($K["partial"]?"INDEX":($K["indisprimary"]?"PRIMARY":($K["indisunique"]?"UNIQUE":"INDEX")));$J[$vh]["columns"]=array();$J[$vh]["descs"]=array();$J[$vh]["algorithm"]=$K["amname"];$J[$vh]["partial"]=$K["partial"];$ge=preg_split('~(?<=\)), (?=\()~',$K["indexpr"]);foreach(explode(" ",$K["indkey"])as$he)$J[$vh]["columns"][]=($he?$e[$he]:array_shift($ge));foreach(explode(" ",$K["indoption"])as$ie)$J[$vh]["descs"][]=(intval($ie)&1?'1':null);$J[$vh]["lengths"]=array();}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = ".driver()->tableOid($R)."
AND contype = 'f'::char
ORDER BY conkey, conname")as$K){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$K['definition'],$A)){$K['source']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$A[2],$bf)){$K['ns']=idf_unescape($bf[2]);$K['table']=idf_unescape($bf[4]);}$K['target']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[3])));$K['on_delete']=(preg_match("~ON DELETE (".driver()->onActions.")~",$A[4],$bf)?$bf[1]:'NO ACTION');$K['on_update']=(preg_match("~ON UPDATE (".driver()->onActions.")~",$A[4],$bf)?$bf[1]:'NO ACTION');$J[$K['conname']]=$K;}}return$J;}function
view($B){return
array("select"=>trim(get_val("SELECT pg_get_viewdef(".driver()->tableOid($B).")")));}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="information_schema";}function
error(){$J=h(connection()->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$J,$A))$J=$A[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($A[3]).'})(.*)~','\1<b>\2</b>',$A[2]).$A[4];return
nl_br($J);}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" ENCODING ".idf_escape($c):""));}function
drop_databases($j){connection()->close();return
apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');}function
rename_database($B,$c){connection()->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($B));}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$b=array();$ih=array();if($R!=""&&$R!=$B)$ih[]="ALTER TABLE ".table($R)." RENAME TO ".table($B);$Wh="";foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b[]="DROP $d";else{$Lj=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$b[]=($R!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$b[]=($R!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$ih[]="ALTER TABLE ".table($B)." RENAME $d TO $X[0]";$b[]="ALTER $d TYPE$X[1]";$Xh=$R."_".idf_unescape($X[0])."_seq";$b[]="ALTER $d ".($X[3]?"SET".preg_replace('~GENERATED ALWAYS(.*) STORED~','EXPRESSION\1',$X[3]):(isset($X[6])?"SET DEFAULT nextval(".q($Xh).")":"DROP DEFAULT"));if(isset($X[6]))$Wh="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($Xh)." OWNED BY ".idf_escape($R).".$X[0]";$b[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($n[0]!=""||$Lj!="")$ih[]="COMMENT ON COLUMN ".table($B).".$X[0] IS ".($Lj!=""?substr($Lj,9):"''");}}$b=array_merge($b,$ld);if($R==""){$P="";if($E){$gb=(connection()->flavor=='cockroach');$P=" PARTITION BY $E[partition_by]($E[partition])";if($E["partition_by"]=='HASH'){$Gg=+$E["partitions"];for($t=0;$t<$Gg;$t++)$ih[]="CREATE TABLE ".idf_escape($B."_$t")." PARTITION OF ".idf_escape($B)." FOR VALUES WITH (MODULUS $Gg, REMAINDER $t)";}else{$Yg="MINVALUE";foreach($E["partition_names"]as$t=>$X){$Y=$E["partition_values"][$t];$Cg=" VALUES ".($E["partition_by"]=='LIST'?"IN ($Y)":"FROM ($Yg) TO ($Y)");if($gb)$P
.=($t?",":" (")."\n  PARTITION ".(preg_match('~^DEFAULT$~i',$X)?$X:idf_escape($X))."$Cg";else$ih[]="CREATE TABLE ".idf_escape($B."_$X")." PARTITION OF ".idf_escape($B)." FOR$Cg";$Yg=$Y;}$P
.=($gb?"\n)":"");}}array_unshift($ih,"CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");}elseif($b)array_unshift($ih,"ALTER TABLE ".table($R)."\n".implode(",\n",$b));if($Wh)array_unshift($ih,$Wh);if($qb!==null)$ih[]="COMMENT ON TABLE ".table($B)." IS ".q($qb);foreach($ih
as$H){if(!queries($H))return
false;}return
true;}function
alter_indexes($R,$b){$i=array();$kc=array();$ih=array();foreach($b
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$ih[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R).($X[3]?" USING $X[3]":"")." (".implode(", ",$X[2]).")".($X[4]?" WHERE $X[4]":"");}if($i)array_unshift($ih,"ALTER TABLE ".table($R).implode(",",$i));if($kc)array_unshift($ih,"DROP INDEX ".implode(", ",$kc));foreach($ih
as$H){if(!queries($H))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('Adminer\table',$T)));}function
drop_views($Rj){return
drop_tables($Rj);}function
drop_tables($T){foreach($T
as$R){$P=table_status1($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$Rj,$Mi){foreach(array_merge($T,$Rj)as$R){$P=table_status1($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($Mi)))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($R)." AND trigger_name = ".q($B);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$K)$e[]=$K["event_object_column"];$J=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement"
FROM information_schema.triggers'."
$Z
ORDER BY event_manipulation DESC")as$K){if($e&&$K["Event"]=="UPDATE")$K["Event"].=" OF";$K["Of"]=implode(", ",$e);if($J)$K["Event"].=" OR $J[Event]";$J=$K;}return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($R))as$K){$lj=trigger($K["trigger_name"],$R);$J[$lj["Trigger"]]=array($lj["Timing"],$lj["Event"]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($B,$U){$L=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($B));$J=idx($L,0,array());$J["returns"]=array("type"=>$J["type_udt_name"]);$J["fields"]=get_rows('SELECT COALESCE(parameter_name, ordinal_position::text) AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($B).'
ORDER BY ordinal_position');return$J;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($B,$K){$J=array();foreach($K["fields"]as$n){$Re=$n["length"];$J[]=$n["type"].($Re?"($Re)":"");}return
idf_escape($B)."(".implode(", ",$J).")";}function
last_id($I){$K=(is_object($I)?$I->fetch_row():array());return($K?$K[0]:0);}function
explain($g,$H){return$g->query("EXPLAIN $H");}function
found_rows($S,$Z){if(preg_match("~ rows=([0-9]+)~",get_val("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$uh))return$uh[1];}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = ".driver()->nsOid."
AND typtype IN ('b','d','e')
AND typelem = 0");}function
type_values($u){$Dc=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = $u ORDER BY enumsortorder");return($Dc?"'".implode("', '",array_map('addslashes',$Dc))."'":"");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){return
get_val("SELECT current_schema()");}function
set_schema($Jh,$h=null){if(!$h)$h=connection();$J=$h->query("SET search_path TO ".idf_escape($Jh));driver()->setUserTypes(types());return$J;}function
foreign_keys_sql($R){$J="";$P=table_status1($R);$hd=foreign_keys($R);ksort($hd);foreach($hd
as$gd=>$fd)$J
.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($gd)." $fd[definition] ".($fd['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($J?"$J\n":$J);}function
create_sql($R,$Ba,$wi){$_h=array();$Yh=array();$P=table_status1($R);if(is_view($P)){$Qj=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $Qj[select]",";");}$o=fields($R);if(count($P)<2||empty($o))return
false;$J="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($o
as$n){$Ag=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['null']?"":" NOT NULL");$_h[]=$Ag;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$df)){$Xh=$df[1];$li=first(get_rows((min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($Xh)):"SELECT * FROM $Xh"),null,"-- "));$Yh[]=($wi=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $Xh;\n":"")."CREATE SEQUENCE $Xh INCREMENT $li[increment_by] MINVALUE $li[min_value] MAXVALUE $li[max_value]".($Ba&&$li['last_value']?" START ".($li["last_value"]+1):"")." CACHE $li[cache_value];";}}if(!empty($Yh))$J=implode("\n\n",$Yh)."\n\n$J";$G="";foreach(indexes($R)as$ee=>$w){if($w['type']=='PRIMARY'){$G=$ee;$_h[]="CONSTRAINT ".idf_escape($ee)." PRIMARY KEY (".implode(', ',array_map('Adminer\idf_escape',$w['columns'])).")";}}foreach(driver()->checkConstraints($R)as$wb=>$yb)$_h[]="CONSTRAINT ".idf_escape($wb)." CHECK $yb";$J
.=implode(",\n    ",$_h)."\n)";$Cg=driver()->partitionsInfo($P['Name']);if($Cg)$J
.="\nPARTITION BY $Cg[partition_by]($Cg[partition])";$J
.="\nWITH (oids = ".($P['Oid']?'true':'false').");";if($P['Comment'])$J
.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($o
as$Yc=>$n){if($n['comment'])$J
.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Yc)." IS ".q($n['comment']).";";}foreach(get_rows("SELECT indexdef FROM pg_catalog.pg_indexes WHERE schemaname = current_schema() AND tablename = ".q($R).($G?" AND indexname != ".q($G):""),null,"-- ")as$K)$J
.="\n\n$K[indexdef];";return
rtrim($J,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status1($R);$J="";foreach(triggers($R)as$kj=>$jj){$lj=trigger($kj,$P['Name']);$J
.="\nCREATE TRIGGER ".idf_escape($lj['Trigger'])." $lj[Timing] $lj[Event] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $lj[Type] $lj[Statement];;\n";}return$J;}function
use_sql($Pb,$wi=""){$B=idf_escape($Pb);$J="";if(preg_match('~CREATE~',$wi)){if($wi=="DROP+CREATE")$J="DROP DATABASE IF EXISTS $B;\n";$J
.="CREATE DATABASE $B;\n";}return"$J\\connect $B";}function
show_variables(){return
get_rows("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(check|columns|comment|database|drop_col|dump|descidx|indexes|kill|partial_indexes|routine|scheme|sequence|sql|table|trigger|type|variables|view'.(min_version(9.3)?'|materializedview':'').(min_version(11)?'|procedure':'').(connection()->flavor=='cockroach'?'':'|processlist').')$~',$Wc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){return
get_val("SHOW max_connections");}}add_driver("oracle","Oracle (beta)");if(isset($_GET["oracle"])){define('Adminer\DRIVER',"oracle");if(extension_loaded("oci8")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="oci8";var$_current_db;private$link;function
_error($Ec,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$this->link=@oci_new_connect($V,$F,$N,"AL32UTF8");if($this->link){$this->server_info=oci_server_version($this->link);return'';}$m=oci_error();return$m["message"];}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($Pb){$this->_current_db=$Pb;return
true;}function
query($H,$sj=false){$I=oci_parse($this->link,$H);$this->error="";if(!$I){$m=oci_error($this->link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$J=@oci_execute($I);restore_error_handler();if($J){if(oci_num_fields($I))return
new
Result($I);$this->affected_rows=oci_num_rows($I);oci_free_statement($I);}return$J;}function
timeout($yf){return
oci_set_call_timeout($this->link,$yf);}}class
Result{var$num_rows;private$result,$offset=1;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'OCILob')||is_a($X,'OCI-Lob'))$K[$y]=$X->load();}return$K;}function
fetch_assoc(){return$this->convert(oci_fetch_assoc($this->result));}function
fetch_row(){return$this->convert(oci_fetch_row($this->result));}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->name=oci_field_name($this->result,$d);$J->type=oci_field_type($this->result,$d);$J->charsetnr=(preg_match("~raw|blob|bfile~",$J->type)?63:0);return$J;}function
__destruct(){oci_free_statement($this->result);}}}elseif(extension_loaded("pdo_oci")){class
Db
extends
PdoDb{var$extension="PDO_OCI";var$_current_db;function
attach($N,$V,$F){return$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$F);}function
select_db($Pb){$this->_current_db=$Pb;return
true;}}}class
Driver
extends
SqlDriver{static$extensions=array("OCI8","PDO_OCI");static$jush="oracle";var$insertFunctions=array("date"=>"current_date","timestamp"=>"current_timestamp",);var$editFunctions=array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("length","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(29)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(30)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),);}function
begin(){return
true;}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$_j=array();$Z=array();foreach($O
as$y=>$X){$_j[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$_j)." WHERE ".implode(" AND ",$Z))&&$this->conn->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($H,$Z,$z,$C=0,$Vh=" "){return($C?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $H$Z) t WHERE rownum <= ".($z+$C).") WHERE rnum > $C":($z?" * FROM (SELECT $H$Z) WHERE rownum <= ".($z+$C):" $H$Z"));}function
limit1($R,$H,$Z,$Vh="\n"){return" $H$Z";}function
db_collation($k,$lb){return
get_val("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
logged_user(){return
get_val("SELECT USER FROM DUAL");}function
get_current_db(){$k=connection()->_current_db?:DB;unset(connection()->_current_db);return$k;}function
where_owner($Wg,$vg="owner"){if(!$_GET["ns"])return'';return"$Wg$vg = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$vg=where_owner('');return"(SELECT $e FROM all_views WHERE ".($vg?:"rownum < 0").")";}function
tables_list(){$Qj=views_table("view_name");$vg=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$vg
UNION SELECT view_name, 'view' FROM $Qj
ORDER BY 1");}function
count_tables($j){$J=array();foreach($j
as$k)$J[$k]=get_val("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$J;}function
table_status($B=""){$J=array();$Oh=q($B);$k=get_current_db();$Qj=views_table("view_name");$vg=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$vg.($B!=""?" AND table_name = $Oh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $Qj".($B!=""?" WHERE view_name = $Oh":"")."
ORDER BY 1")as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$J=array();$vg=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)."$vg ORDER BY column_id")as$K){$U=$K["DATA_TYPE"];$Re="$K[DATA_PRECISION],$K[DATA_SCALE]";if($Re==",")$Re=$K["CHAR_COL_DECL_LENGTH"];$J[$K["COLUMN_NAME"]]=array("field"=>$K["COLUMN_NAME"],"full_type"=>$U.($Re?"($Re)":""),"type"=>strtolower($U),"length"=>$Re,"default"=>$K["DATA_DEFAULT"],"null"=>($K["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),);}return$J;}function
indexes($R,$h=null){$J=array();$vg=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($R)."$vg
ORDER BY ac.constraint_type, aic.column_position",$h)as$K){$ee=$K["INDEX_NAME"];$nb=$K["DATA_DEFAULT"];$nb=($nb?trim($nb,'"'):$K["COLUMN_NAME"]);$J[$ee]["type"]=($K["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($K["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$J[$ee]["columns"][]=$nb;$J[$ee]["lengths"][]=($K["CHAR_LENGTH"]&&$K["CHAR_LENGTH"]!=$K["COLUMN_LENGTH"]?$K["CHAR_LENGTH"]:null);$J[$ee]["descs"][]=($K["DESCEND"]&&$K["DESCEND"]=="DESC"?'1':null);}return$J;}function
view($B){$Qj=views_table("view_name, text");$L=get_rows('SELECT text "select" FROM '.$Qj.' WHERE view_name = '.q($B));return
reset($L);}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
h(connection()->error);}function
explain($g,$H){$g->query("EXPLAIN PLAN FOR $H");return$g->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$b=$kc=array();$og=($R?fields($R):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$ng=$og[$n[0]];if($X&&$ng){$Rf=process_field($ng,$ng);if($X[2]==$Rf[2])$X[2]="";}if($X)$b[]=($R!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$kc[]=idf_escape($n[0]);}if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)");return(!$b||queries("ALTER TABLE ".table($R)."\n".implode("\n",$b)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$kc).")"))&&($R==$B||queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)));}function
alter_indexes($R,$b){$kc=array();$ih=array();foreach($b
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($ih,"ALTER TABLE ".table($R).$i);}elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$ih[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($kc)array_unshift($ih,"DROP INDEX ".implode(", ",$kc));foreach($ih
as$H){if(!queries($H))return
false;}return
true;}function
foreign_keys($R){$J=array();$H="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($H)as$K)$J[$K['NAME']]=array("db"=>$K['DEST_DB'],"table"=>$K['DEST_TABLE'],"source"=>array($K['SRC_COLUMN']),"target"=>array($K['DEST_COLUMN']),"on_delete"=>$K['ON_DELETE'],"on_update"=>null,);return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Rj){return
apply_queries("DROP VIEW",$Rj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id($I){return
0;}function
schemas(){$J=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($J?:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){return
get_val("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($Lh,$h=null){if(!$h)$h=connection();return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($Lh));}function
show_variables(){return
get_rows('SELECT name, display_value FROM v$parameter');}function
show_status(){$J=array();$L=get_rows('SELECT * FROM v$instance');foreach(reset($L)as$y=>$X)$J[]=array($y,$X);return$J;}function
process_list(){return
get_rows('SELECT
	sess.process AS "process",
	sess.username AS "user",
	sess.schemaname AS "schema",
	sess.status AS "status",
	sess.wait_class AS "wait_class",
	sess.seconds_in_wait AS "seconds_in_wait",
	sql.sql_text AS "sql_text",
	sess.machine AS "machine",
	sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Wc);}}add_driver("mssql","MS SQL");if(isset($_GET["mssql"])){define('Adminer\DRIVER',"mssql");if(extension_loaded("sqlsrv")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="sqlsrv";private$link,$result;private
function
get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error
.="$m[message]\n";}$this->error=rtrim($this->error);}function
attach($N,$V,$F){$xb=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");$ri=adminer()->connectSsl();if(isset($ri["Encrypt"]))$xb["Encrypt"]=$ri["Encrypt"];if(isset($ri["TrustServerCertificate"]))$xb["TrustServerCertificate"]=$ri["TrustServerCertificate"];$k=adminer()->database();if($k!="")$xb["Database"]=$k;list($Od,$Qg)=host_port($N);$this->link=@sqlsrv_connect($Od.($Qg?",$Qg":""),$xb);if($this->link){$je=sqlsrv_server_info($this->link);$this->server_info=$je['SQLServerVersion'];}else$this->get_error();return($this->link?'':$this->error);}function
quote($Q){$tj=strlen($Q)!=strlen(utf8_decode($Q));return($tj?"N":"")."'".str_replace("'","''",$Q)."'";}function
select_db($Pb){return$this->query(use_sql($Pb));}function
query($H,$sj=false){$I=sqlsrv_query($this->link,$H);$this->error="";if(!$I){$this->get_error();return
false;}return$this->store_result($I);}function
multi_query($H){$this->result=sqlsrv_query($this->link,$H);$this->error="";if(!$this->result){$this->get_error();return
false;}return
true;}function
store_result($I=null){if(!$I)$I=$this->result;if(!$I)return
false;if(sqlsrv_field_metadata($I))return
new
Result($I);$this->affected_rows=sqlsrv_rows_affected($I);return
true;}function
next_result(){return$this->result?!!sqlsrv_next_result($this->result):false;}}class
Result{var$num_rows;private$result,$offset=0,$fields;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'DateTime'))$K[$y]=$X->format("Y-m-d H:i:s");}return$K;}function
fetch_assoc(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->fields)$this->fields=sqlsrv_field_metadata($this->result);$n=$this->fields[$this->offset++];$J=new
\stdClass;$J->name=$n["Name"];$J->type=($n["Type"]==1?254:15);$J->charsetnr=0;return$J;}function
seek($C){for($t=0;$t<$C;$t++)sqlsrv_fetch($this->result);}function
__destruct(){sqlsrv_free_stmt($this->result);}}function
last_id($I){return
get_val("SELECT SCOPE_IDENTITY()");}function
explain($g,$H){$g->query("SET SHOWPLAN_ALL ON");$J=$g->query($H);$g->query("SET SHOWPLAN_ALL OFF");return$J;}}else{abstract
class
MssqlDb
extends
PdoDb{function
select_db($Pb){return$this->query(use_sql($Pb));}function
lastInsertId(){return$this->pdo->lastInsertId();}}function
last_id($I){return
connection()->lastInsertId();}function
explain($g,$H){}if(extension_loaded("pdo_sqlsrv")){class
Db
extends
MssqlDb{var$extension="PDO_SQLSRV";function
attach($N,$V,$F){list($Od,$Qg)=host_port($N);return$this->dsn("sqlsrv:Server=$Od".($Qg?",$Qg":""),$V,$F);}}}elseif(extension_loaded("pdo_dblib")){class
Db
extends
MssqlDb{var$extension="PDO_DBLIB";function
attach($N,$V,$F){list($Od,$Qg)=host_port($N);return$this->dsn("dblib:charset=utf8;host=$Od".($Qg?(is_numeric($Qg)?";port=":";unix_socket=").$Qg:""),$V,$F);}}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLSRV","PDO_SQLSRV","PDO_DBLIB");static$jush="mssql";var$insertFunctions=array("date|time"=>"getdate");var$editFunctions=array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("len","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$generated=array("PERSISTED","VIRTUAL");var$onActions="NO ACTION|CASCADE|SET NULL|SET DEFAULT";static
function
connect($N,$V,$F){if($N=="")$N="localhost:1433";return
parent::connect($N,$V,$F);}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(29)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(30)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),);}function
insertUpdate($R,array$L,array$G){$o=fields($R);$_j=array();$Z=array();$O=reset($L);$e="c".implode(", c",range(1,count($O)));$Ra=0;$pe=array();foreach($O
as$y=>$X){$Ra++;$B=idf_unescape($y);if(!$o[$B]["auto_increment"])$pe[$y]="c$Ra";if(isset($G[$B]))$Z[]="$y = c$Ra";else$_j[]="$y = c$Ra";}$Mj=array();foreach($L
as$O)$Mj[]="(".implode(", ",$O).")";if($Z){$Td=queries("SET IDENTITY_INSERT ".table($R)." ON");$J=queries("MERGE ".table($R)." USING (VALUES\n\t".implode(",\n\t",$Mj)."\n) AS source ($e) ON ".implode(" AND ",$Z).($_j?"\nWHEN MATCHED THEN UPDATE SET ".implode(", ",$_j):"")."\nWHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($Td?$O:$pe)).") VALUES (".($Td?$e:implode(", ",$pe)).");");if($Td)queries("SET IDENTITY_INSERT ".table($R)." OFF");}else$J=queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES\n".implode(",\n",$Mj));return$J;}function
begin(){return
queries("BEGIN TRANSACTION");}function
tableHelp($B,$_e=false){$Ve=array("sys"=>"catalog-views/sys-","INFORMATION_SCHEMA"=>"information-schema-views/",);$_=$Ve[get_schema()];if($_)return"relational-databases/system-$_".preg_replace('~_~','-',strtolower($B))."-transact-sql";}}function
idf_escape($v){return"[".str_replace("]","]]",$v)."]";}function
table($v){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($H,$Z,$z,$C=0,$Vh=" "){return($z?" TOP (".($z+$C).")":"")." $H$Z";}function
limit1($R,$H,$Z,$Vh="\n"){return
limit($H,$Z,1,0,$Vh);}function
db_collation($k,$lb){return
get_val("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
logged_user(){return
get_val("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){$J=array();foreach($j
as$k){connection()->select_db($k);$J[$k]=get_val("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$J;}function
table_status($B=""){$J=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment
FROM sys.all_objects AS ao
WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$sb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$J=array();$Ci=get_val("SELECT object_id FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') AND name = ".q($R));foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, d.definition [default], d.name default_constraint, i.is_primary_key
FROM sys.all_columns c
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
LEFT JOIN sys.index_columns ic ON c.object_id = ic.object_id AND c.column_id = ic.column_id
LEFT JOIN sys.indexes i ON ic.object_id = i.object_id AND ic.index_id = i.index_id
WHERE c.object_id = ".q($Ci))as$K){$U=$K["type"];$Re=(preg_match("~char|binary~",$U)?intval($K["max_length"])/($U[0]=='n'?2:1):($U=="decimal"?"$K[precision],$K[scale]":""));$J[$K["name"]]=array("field"=>$K["name"],"full_type"=>$U.($Re?"($Re)":""),"type"=>$U,"length"=>$Re,"default"=>(preg_match("~^\('(.*)'\)$~",$K["default"],$A)?str_replace("''","'",$A[1]):$K["default"]),"default_constraint"=>$K["default_constraint"],"null"=>$K["is_nullable"],"auto_increment"=>$K["is_identity"],"collation"=>$K["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["is_primary_key"],"comment"=>$sb[$K["name"]],);}foreach(get_rows("SELECT * FROM sys.computed_columns WHERE object_id = ".q($Ci))as$K){$J[$K["name"]]["generated"]=($K["is_persisted"]?"PERSISTED":"VIRTUAL");$J[$K["name"]]["default"]=$K["definition"];}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$h)as$K){$B=$K["name"];$J[$B]["type"]=($K["is_primary_key"]?"PRIMARY":($K["is_unique"]?"UNIQUE":"INDEX"));$J[$B]["lengths"]=array();$J[$B]["columns"][$K["key_ordinal"]]=$K["column_name"];$J[$B]["descs"][$K["key_ordinal"]]=($K["is_descending_key"]?'1':null);}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',get_val("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($B))));}function
collations(){$J=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$c)$J[preg_replace('~_.*~','',$c)][]=$c;return$J;}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',connection()->error)));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$c)?" COLLATE $c":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('Adminer\idf_escape',$j)));}function
rename_database($B,$c){if(preg_match('~^[a-z0-9_]+$~i',$c))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $c");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($B));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$b=array();$sb=array();$og=fields($R);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$sb[$n[0]]=$X[5];unset($X[5]);if(preg_match('~ AS ~',$X[3]))unset($X[1],$X[2]);if($n[0]=="")$b["ADD"][]="\n  ".implode("",$X).($R==""?substr($ld[$X[0]],16+strlen($X[0])):"");else{$l=$X[3];unset($X[3]);unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($R).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$b["ALTER COLUMN ".implode("",$X)][]="";$ng=$og[$n[0]];if(default_value($ng)!=$l){if($ng["default"]!==null)$b["DROP"][]=" ".idf_escape($ng["default_constraint"]);if($l)$b["ADD"][]="\n $l FOR $d";}}}}if($R=="")return
queries("CREATE TABLE ".table($B)." (".implode(",",(array)$b["ADD"])."\n)");if($R!=$B)queries("EXEC sp_rename ".q(table($R)).", ".q($B));if($ld)$b[""]=$ld;foreach($b
as$y=>$X){if(!queries("ALTER TABLE ".table($B)." $y".implode(",",$X)))return
false;}foreach($sb
as$y=>$X){$qb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($B).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty
@name = N'MS_Description',
@value = $qb,
@level0type = N'Schema',
@level0name = ".q(get_schema()).",
@level1type = N'Table',
@level1name = ".q($B).",
@level2type = N'Column',
@level2name = ".q($y));}return
true;}function
alter_indexes($R,$b){$w=array();$kc=array();foreach($b
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$kc[]=idf_escape($X[1]);else$w[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$w||queries("DROP INDEX ".implode(", ",$w)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$kc)));}function
found_rows($S,$Z){}function
foreign_keys($R){$J=array();$Yf=array("CASCADE","NO ACTION","SET NULL","SET DEFAULT");foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R).", @fktable_owner = ".q(get_schema()))as$K){$q=&$J[$K["FK_NAME"]];$q["db"]=$K["PKTABLE_QUALIFIER"];$q["ns"]=$K["PKTABLE_OWNER"];$q["table"]=$K["PKTABLE_NAME"];$q["on_update"]=$Yf[$K["UPDATE_RULE"]];$q["on_delete"]=$Yf[$K["DELETE_RULE"]];$q["source"][]=$K["FKCOLUMN_NAME"];$q["target"][]=$K["PKCOLUMN_NAME"];}return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Rj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Rj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$Rj,$Mi){return
apply_queries("ALTER SCHEMA ".idf_escape($Mi)." TRANSFER",array_merge($T,$Rj));}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($B));$J=reset($L);if($J)$J["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$J["text"]);return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$K)$J[$K["name"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){if($_GET["ns"]!="")return$_GET["ns"];return
get_val("SELECT SCHEMA_NAME()");}function
set_schema($Jh){$_GET["ns"]=$Jh;return
true;}function
create_sql($R,$Ba,$wi){if(is_view(table_status1($R))){$Qj=view($R);return"CREATE VIEW ".table($R)." AS $Qj[select]";}$o=array();$G=false;foreach(fields($R)as$B=>$n){$X=process_field($n,$n);if($X[6])$G=true;$o[]=implode("",$X);}foreach(indexes($R)as$B=>$w){if(!$G||$w["type"]!="PRIMARY"){$e=array();foreach($w["columns"]as$y=>$X)$e[]=idf_escape($X).($w["descs"][$y]?" DESC":"");$B=idf_escape($B);$o[]=($w["type"]=="INDEX"?"INDEX $B":"CONSTRAINT $B ".($w["type"]=="UNIQUE"?"UNIQUE":"PRIMARY KEY"))." (".implode(", ",$e).")";}}foreach(driver()->checkConstraints($R)as$B=>$Ya)$o[]="CONSTRAINT ".idf_escape($B)." CHECK ($Ya)";return"CREATE TABLE ".table($R)." (\n\t".implode(",\n\t",$o)."\n)";}function
foreign_keys_sql($R){$o=array();foreach(foreign_keys($R)as$ld)$o[]=ltrim(format_foreign_key($ld));return($o?"ALTER TABLE ".table($R)." ADD\n\t".implode(",\n\t",$o).";\n\n":"");}function
truncate_sql($R){return"TRUNCATE TABLE ".table($R);}function
use_sql($Pb,$wi=""){return"USE ".idf_escape($Pb);}function
trigger_sql($R){$J="";foreach(triggers($R)as$B=>$lj)$J
.=create_trigger(" ON ".table($R),trigger($B,$R)).";";return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(check|comment|columns|database|drop_col|dump|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Wc);}}class
Adminer{static$instance;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'><img src='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.1")."' width='24' height='24' alt='' id='logo'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($jd=true){return
get_databases($jd);}function
pluginsLinks(){}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
afterConnect(){}function
headers(){}function
csp(array$Ib){return$Ib;}function
head($Mb=null){return
true;}function
bodyClass(){echo" adminer";}function
css(){$J=array();foreach(array("","-dark")as$xf){$p="adminer$xf.css";if(file_exists($p)){$bd=file_get_contents($p);$J["$p?v=".crc32($bd)]=($xf?"dark":(preg_match('~prefers-color-scheme:\s*dark~',$bd)?'':'light'));}}return$J;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(33).'<td>',html_select("auth[driver]",SqlDriver::$drivers,DRIVER,"loginDriver(this);")),adminer()->loginFormField('server','<tr><th>'.lang(34).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(35).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("const authDriver = qs('#username').form['auth[driver]']; authDriver && authDriver.onchange();")),adminer()->loginFormField('password','<tr><th>'.lang(36).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(37).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(38)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(39))."\n";}function
loginFormField($B,$Jd,$Y){return$Jd.$Y."\n";}function
login($Xe,$F){if($F=="")return
lang(40,target_blank());return
true;}function
tableName(array$Bi){return
h($Bi["Name"]);}function
fieldName(array$n,$hg=0){$U=$n["full_type"];$qb=$n["comment"];return'<span title="'.h($U.($qb!=""?($U?": ":"").$qb:'')).'">'.h($n["field"]).'</span>';}function
selectLinks(array$Bi,$O=""){$B=$Bi["Name"];echo'<p class="links">';$Ve=array("select"=>lang(41));if(support("table")||support("indexes"))$Ve["table"]=lang(42);$_e=false;if(support("table")){$_e=is_view($Bi);if(!$_e)$Ve["create"]=lang(43);elseif(support("view"))$Ve["view"]=lang(44);}if($O!==null)$Ve["edit"]=lang(45);foreach($Ve
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($B).($y=="edit"?$O:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($B,$_e)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$Ai){return
array();}function
backwardKeysPrint(array$Fa,array$K){}function
selectQuery($H,$si,$Uc=false){$J="</p>\n";if(!$Uc&&($Uj=driver()->warnings())){$u="warnings";$J=", <a href='#$u'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$J<div id='$u' class='hidden'>\n$Uj</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$H))."</code> <span class='time'>(".format_time($si).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($H)."'>".lang(12)."</a>":"").$J;}function
sqlCommandQuery($H){return
shorten_utf8(trim($H),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$L,array$md){return$L;}function
selectLink($X,array$n){}function
selectVal($X,$_,array$n,$rg){$J=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":(preg_match('~json~',$n["type"])?"<code class='jush-js'>$X</code>":$X)));if(is_blob($n)&&!is_utf8($X))$J="<i>".lang(47,strlen($rg))."</i>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$J</a>":$J);}function
editVal($X,array$n){return$X;}function
config(){return
array();}function
tableStructurePrint(array$o,$Bi=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(48)."<td>".lang(49).(support("comment")?"<td>".lang(50):"")."</thead>\n";$vi=driver()->structuredTypes();foreach($o
as$n){echo"<tr><th>".h($n["field"]);$U=h($n["full_type"]);$c=h($n["collation"]);echo"<td><span title='$c'>".(in_array($U,(array)$vi[lang(6)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($c&&isset($Bi["Collation"])&&$c!=$Bi["Collation"]?" $c":""))."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(51)."</i>":"");$l=h($n["default"]);echo(isset($n["default"])?" <span title='".lang(52)."'>[<b>".($n["generated"]?"<code class='jush-".JUSH."'>$l</code>":$l)."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x,array$Bi){$Bg=false;foreach($x
as$B=>$w)$Bg|=!!$w["partial"];echo"<table>\n";$Ub=first(driver()->indexAlgorithms($Bi));foreach($x
as$B=>$w){ksort($w["columns"]);$ah=array();foreach($w["columns"]as$y=>$X)$ah[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($B)."'>","<th>$w[type]".($Ub&&$w['algorithm']!=$Ub?" ($w[algorithm])":""),"<td>".implode(", ",$ah);if($Bg)echo"<td>".($w['partial']?"<code class='jush-".JUSH."'>WHERE ".h($w['partial']):"");echo"\n";}echo"</table>\n";}function
selectColumnsPrint(array$M,array$e){print_fieldset("select",lang(53),$M);$t=0;$M[""]=array();foreach($M
as$y=>$X){$X=idx($_GET["columns"],$y,array());$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(54)=>driver()->functions,lang(55)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$e,array$x){print_fieldset("search",lang(56),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h(idx($_GET["fulltext"],$t))."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Va="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(57).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Va),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Va }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$hg,array$e,array$x){print_fieldset("sort",lang(58),$hg);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(59))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(59))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(60)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Si){if($Si!==null)echo"<fieldset><legend>".lang(61)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Si)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(62)."</legend><div>","<input type='submit' value='".lang(53)."'>"," <span id='noindex' title='".lang(63)."'></span>","<script".nonce().">\n","const indexColumns = ";$e=array();foreach($x
as$w){$Lb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$Lb)$e[$Lb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$wc,array$e){}function
selectColumnsProcess(array$e,array$x){$M=array();$yd=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$M[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$yd[]=$M[$y];}}return
array($M,$yd);}function
selectSearchProcess(array$o,array$x){$J=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&idx($_GET["fulltext"],$t)!="")$J[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){$jb=$X["col"];if("$jb$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$ub=array();foreach(($jb!=""?array($jb=>$o[$jb]):$o)as$B=>$n){$Wg="";$tb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Yd=process_length($X["val"]);$tb
.=" ".($Yd!=""?$Yd:"(NULL)");}elseif($X["op"]=="SQL")$tb=" $X[val]";elseif(preg_match('~^(I?LIKE) %%$~',$X["op"],$A))$tb=" $A[1] ".adminer()->processInput($n,"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$Wg="$X[op](".q($X["val"]).", ";$tb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$tb
.=" ".adminer()->processInput($n,$X["val"]);if($jb!=""||(isset($n["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"]))))$ub[]=$Wg.driver()->convertSearch(idf_escape($B),$X,$n).$tb;}$J[]=(count($ub)==1?$ub[0]:($ub?"(".implode(" OR ",$ub).")":"1 = 0"));}}return$J;}function
selectOrderProcess(array$o,array$x){$J=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$J[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$J;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$md){return
false;}function
selectQueryBuild(array$M,array$Z,array$yd,array$hg,$z,$D){return"";}function
messageQuery($H,$Ti,$Uc=false){restart_session();$Ld=&get_session("queries");if(!idx($Ld,$_GET["db"]))$Ld[$_GET["db"]]=array();if(strlen($H)>1e6)$H=preg_replace('~[\x80-\xFF]+$~','',substr($H,0,1e6))."\n…";$Ld[$_GET["db"]][]=array($H,time(),$Ti);$oi="sql-".count($Ld[$_GET["db"]]);$J="<a href='#$oi' class='toggle'>".lang(64)."</a> <a href='' class='jsonly copy'>🗐</a>\n";if(!$Uc&&($Uj=driver()->warnings())){$u="warnings-".count($Ld[$_GET["db"]]);$J="<a href='#$u' class='toggle'>".lang(46)."</a>, $J<div id='$u' class='hidden'>\n$Uj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $J<div id='$oi' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($H,1000)."</code></pre>".($Ti?" <span class='time'>($Ti)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Ld[$_GET["db"]])-1)).'">'.lang(12).'</a>':'').'</div>';}function
editRowPrint($R,array$o,$K,$_j){}function
editFunctions(array$n){$J=($n["null"]?"NULL/":"");$_j=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$y=>$td){if(!$y||(!isset($_GET["call"])&&$_j)){foreach($td
as$Kg=>$X){if(!$Kg||preg_match("~$Kg~",$n["type"]))$J
.="/$X";}}if($y&&$td&&!preg_match('~set|bool~',$n["type"])&&!is_blob($n))$J
.="/SQL";}if($n["auto_increment"]&&!$_j)$J=lang(51);return
explode("/",$J);}function
editInput($R,array$n,$_a,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$_a value='orig' checked><i>".lang(10)."</i></label> ":"").enum_input("radio",$_a,$n,$Y,"NULL");return"";}function
editHint($R,array$n,$Y){return"";}function
processInput(array$n,$Y,$s=""){if($s=="SQL")return$Y;$B=$n["field"];$J=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$J="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$J=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$J=idf_escape($B)." $s $J";elseif(preg_match('~^[+-] interval$~',$s))$J=idf_escape($B)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)&&JUSH!="pgsql"?$Y:$J);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$J="$s(".idf_escape($B).", $J)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$J="$s($J)";return
unconvert_field($n,$J);}function
dumpOutput(){$J=array('text'=>lang(65),'file'=>lang(66));if(function_exists('gzencode'))$J['gz']='gzip';return$J;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($R,$wi,$_e=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($wi)dump_csv(array_keys(fields($R)));}else{if($_e==2){$o=array();foreach(fields($R)as$B=>$n)$o[]=idf_escape($B)." $n[full_type]";$i="CREATE TABLE ".table($R)." (".implode(", ",$o).")";}else$i=create_sql($R,$_POST["auto_increment"],$wi);set_utf8mb4($i);if($wi&&$i){if($wi=="DROP+CREATE"||$_e==1)echo"DROP ".($_e==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($_e==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($R,$wi,$H){if($wi){$hf=(JUSH=="sqlite"?0:1048576);$o=array();$Ud=false;if($_POST["format"]=="sql"){if($wi=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$o=fields($R);if(JUSH=="mssql"){foreach($o
as$n){if($n["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$Ud=true;break;}}}}$I=connection()->query($H,1);if($I){$pe="";$Pa="";$Ee=array();$ud=array();$yi="";$Xc=($R!=''?'fetch_assoc':'fetch_row');$Eb=0;while($K=$I->$Xc()){if(!$Ee){$Mj=array();foreach($K
as$X){$n=$I->fetch_field();if(idx($o[$n->name],'generated')){$ud[$n->name]=true;continue;}$Ee[]=$n->name;$y=idf_escape($n->name);$Mj[]="$y = VALUES($y)";}$yi=($wi=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Mj):"").";\n";}if($_POST["format"]!="sql"){if($wi=="table"){dump_csv($Ee);$wi="INSERT";}dump_csv($K);}else{if(!$pe)$pe="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$Ee)).") VALUES";foreach($K
as$y=>$X){if($ud[$y]){unset($K[$y]);continue;}$n=$o[$y];$K[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Hh=($hf?"\n":" ")."(".implode(",\t",$K).")";if(!$Pa)$Pa=$pe.$Hh;elseif(JUSH=='mssql'?$Eb%1000!=0:strlen($Pa)+4+strlen($Hh)+strlen($yi)<$hf)$Pa
.=",$Hh";else{echo$Pa.$yi;$Pa=$pe.$Hh;}}$Eb++;}if($Pa)echo$Pa.$yi;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($Ud)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($Sd){return
friendly_url($Sd!=""?$Sd:(SERVER?:"localhost"));}function
dumpHeaders($Sd,$_f=false){$ug=$_POST["output"];$Pc=(preg_match('~sql~',$_POST["format"])?"sql":($_f?"tar":"csv"));header("Content-Type: ".($ug=="gz"?"application/x-gzip":($Pc=="tar"?"application/x-tar":($Pc=="sql"||$ug!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($ug=="gz"){ob_start(function($Q){return
gzencode($Q);},1e6);}return$Pc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(67)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(68):lang(69))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(70)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(71)."</a>\n":"");if($_GET["ns"]!=="")echo(support("routine")?"<a href='#routines'>".lang(72)."</a>\n":""),(support("sequence")?"<a href='#sequences'>".lang(73)."</a>\n":""),(support("type")?"<a href='#user-types'>".lang(6)."</a>\n":""),(support("event")?"<a href='#events'>".lang(74)."</a>\n":"");return
true;}function
navigation($wf){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$Hf=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$Hf)<0?h($Hf):"")."</a>","</span></h1>\n";switch_lang();if($wf=="auth"){$ug="";foreach((array)$_SESSION["pwds"]as$Oj=>$ai){foreach($ai
as$N=>$Jj){$B=h(get_setting("vendor-$Oj-$N")?:get_driver($Oj));foreach($Jj
as$V=>$F){if($F!==null){$Sb=$_SESSION["db"][$Oj][$N][$V];foreach(($Sb?array_keys($Sb):array(""))as$k)$ug
.="<li><a href='".h(auth_url($Oj,$N,$V,$k))."'>($B) ".h("$V@".($N!=""?adminer()->serverName($N):"").($k!=""?" - $k":""))."</a>\n";}}}}if($ug)echo"<ul id='logins'>\n$ug</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$wf&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($wf);$ka=array();if(DB==""||!$wf){if(support("sql")){$ka[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(64)."</a>";$ka[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(75)."</a>";}$ka[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(76)."</a>";}$Zd=$_GET["ns"]!==""&&!$wf&&DB!="";if($Zd)$ka[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(77)."</a>";echo($ka?"<p class='links'>\n".implode("\n",$ka)."\n":"");if($Zd){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(11)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.4.1",true);if(support("sql")){echo"<script".nonce().">\n";if($T){$Ve=array();foreach($T
as$R=>$U)$Ve[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.":";json_row(js_escape(ME).(support("table")?"table":"select").'=$&','/\b('.implode('|',$Ve).')\b/g',false);if(support('routine')){foreach(routines()as$K)json_row(js_escape(ME).'function='.urlencode($K["SPECIFIC_NAME"]).'&name=$&','/\b'.preg_quote($K["ROUTINE_NAME"],'/').'(?=["`]?\()/g',false);}json_row('');echo"};\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";if(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"])){$Ii=array_fill_keys(array_keys($T),array());foreach(driver()->allFields()as$R=>$o){foreach($o
as$n)$Ii[$R][]=$n["field"];}echo"addEventListener('DOMContentLoaded', () => { autocompleter = jush.autocompleteSql('".idf_escape("")."', ".json_encode($Ii)."); });\n";}}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."', '".connection()->flavor."');");}function
databasesPrint($wf){$j=adminer()->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Qb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(37)."'>".lang(78).": ".($j?html_select("db",array(""=>"")+$j,DB).$Qb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n")."</label>","<input type='submit' value='".lang(22)."'".($j?" class='hidden'":"").">\n";if(support("scheme")){if($wf!="db"&&DB!=""&&connection()->select_db(DB)){echo"<br><label>".lang(79).": ".html_select("ns",array(""=>"")+adminer()->schemas(),$_GET["ns"])."$Qb</label>";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$R="$R";$B=adminer()->tableName($P);if($B!=""&&!$P["partition"])echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(41)."'>".lang(80)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["check"],$_GET["view"])),(is_view($P)?"view":"structure"))." title='".lang(42)."'>$B</a>":"<span>$B</span>")."\n";}echo"</ul>\n";}function
processList(){return
process_list();}function
killProcess($u){return
kill_process($u);}}class
Plugins{private
static$append=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true,'config'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($Pg){if($Pg===null){$Pg=array();$Ja="adminer-plugins";if(is_dir($Ja)){foreach(glob("$Ja/*.php")as$p)$ae=include_once"./$p";}$Kd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Ja.php")){$ae=include_once"./$Ja.php";if(is_array($ae)){foreach($ae
as$Og)$Pg[get_class($Og)]=$Og;}else$this->error
.=lang(81,"<b>$Ja.php</b>",$Kd)."<br>";}foreach(get_declared_classes()as$fb){if(!$Pg[$fb]&&preg_match('~^Adminer\w~i',$fb)){$sh=new
\ReflectionClass($fb);$zb=$sh->getConstructor();if($zb&&$zb->getNumberOfRequiredParameters())$this->error
.=lang(82,$Kd,"<b>$fb</b>","<b>$Ja.php</b>")."<br>";else$Pg[$fb]=new$fb;}}}$this->plugins=$Pg;$na=new
Adminer;$Pg[]=$na;$sh=new
\ReflectionObject($na);foreach($sh->getMethods()as$uf){foreach($Pg
as$Og){$B=$uf->getName();if(method_exists($Og,$B))$this->hooks[$B][]=$Og;}}}function
__call($B,array$zg){$wa=array();foreach($zg
as$y=>$X)$wa[]=&$zg[$y];$J=null;foreach($this->hooks[$B]as$Og){$Y=call_user_func_array(array($Og,$B),$wa);if($Y!==null){if(!self::$append[$B])return$Y;$J=$Y+(array)$J;}}return$J;}}abstract
class
Plugin{protected$translations=array();function
description(){return$this->lang('');}function
screenshot(){return"";}protected
function
lang($v,$Nf=null){$wa=func_get_args();$wa[0]=idx($this->translations[LANG],$v)?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}}Adminer::$instance=(function_exists('adminer_object')?adminer_object():(is_dir("adminer-plugins")||file_exists("adminer-plugins.php")?new
Plugins(null):new
Adminer));SqlDriver::$drivers=array("server"=>"MySQL / MariaDB")+SqlDriver::$drivers;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$instance;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($N,$V,$F){mysqli_report(MYSQLI_REPORT_OFF);list($Od,$Qg)=host_port($N);$ri=adminer()->connectSsl();if($ri)$this->ssl_set($ri['key'],$ri['cert'],$ri['ca'],'','');$J=@$this->real_connect(($N!=""?$Od:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$F!=""?$F:ini_get("mysqli.default_pw")),null,(is_numeric($Qg)?intval($Qg):ini_get("mysqli.default_port")),(is_numeric($Qg)?null:$Qg),($ri?($ri['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,0);return($J?'':$this->error);}function
set_charset($Xa){if(parent::set_charset($Xa))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Xa");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($N,$V,$F){if(ini_bool("mysql.allow_local_infile"))return
lang(83,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),($N.$V!=""?$V:ini_get("mysql.default_user")),($N.$V.$F!=""?$F:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Xa){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Xa,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Xa");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->link)."'";}function
select_db($Pb){return
mysql_select_db($Pb,$this->link);}function
query($H,$sj=false){$I=@($sj?mysql_unbuffered_query($H,$this->link):mysql_query($H,$this->link));$this->error="";if(!$I){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($I===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($I);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=mysql_num_rows($I);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$J=mysql_fetch_field($this->result,$this->offset++);$J->orgtable=$J->table;$J->charsetnr=($J->blob?63:0);return$J;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($N,$V,$F){$fg=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$ri=adminer()->connectSsl();if($ri){if($ri['key'])$fg[\PDO::MYSQL_ATTR_SSL_KEY]=$ri['key'];if($ri['cert'])$fg[\PDO::MYSQL_ATTR_SSL_CERT]=$ri['cert'];if($ri['ca'])$fg[\PDO::MYSQL_ATTR_SSL_CA]=$ri['ca'];if(isset($ri['verify']))$fg[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$ri['verify'];}list($Od,$Qg)=host_port($N);return$this->dsn("mysql:charset=utf8;host=$Od".($Qg?(is_numeric($Qg)?";port=":";unix_socket=").$Qg:""),$V,$F,$fg);}function
set_charset($Xa){return$this->query("SET NAMES $Xa");}function
select_db($Pb){return$this->query("USE ".idf_escape($Pb));}function
query($H,$sj=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$sj);return
parent::query($H,$sj);}}}class
Driver
extends
SqlDriver{static$extensions=array("MySQLi","MySQL","PDO_MySQL");static$jush="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g)){if(function_exists('iconv')&&!is_utf8($g)&&strlen($Hh=iconv("windows-1250","utf-8",$g))>strlen($g))$g=$Hh;return$g;}$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");$g->flavor=(preg_match('~MariaDB~',$g->server_info)?'maria':'mysql');add_driver(DRIVER,($g->flavor=='maria'?"MariaDB":"MySQL"));return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(29)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(84)=>array("enum"=>65535,"set"=>64),lang(30)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(32)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$g))$this->types[lang(29)]["json"]=4294967295;if(min_version('',10.7,$g)){$this->types[lang(29)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$g)){$this->types[lang(27)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.1,'',$g))$this->partitionBy=array("HASH","LINEAR HASH","KEY","LINEAR KEY","RANGE","LIST");if(min_version(5.7,10.2,$g))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$n){return(preg_match("~binary~",$n["type"])?"<code class='jush-sql'>UNHEX</code>":($n["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$n["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$L,array$G){$e=array_keys(reset($L));$Wg="INSERT INTO ".table($R)." (".implode(", ",$e).") VALUES\n";$Mj=array();foreach($e
as$y)$Mj[$y]="$y = VALUES($y)";$yi="\nON DUPLICATE KEY UPDATE ".implode(", ",$Mj);$Mj=array();$Re=0;foreach($L
as$O){$Y="(".implode(", ",$O).")";if($Mj&&(strlen($Wg)+$Re+strlen($Y)+strlen($yi)>1e6)){if(!queries($Wg.implode(",\n",$Mj).$yi))return
false;$Mj=array();$Re=0;}$Mj[]=$Y;$Re+=strlen($Y)+2;}return
queries($Wg.implode(",\n",$Mj).$yi);}function
slowQuery($H,$Ui){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$Ui FOR $H";elseif(preg_match('~^(SELECT\b)(.+)~is',$H,$A))return"$A[1] /*+ MAX_EXECUTION_TIME(".($Ui*1000).") */ $A[2]";}}function
convertSearch($v,array$X,array$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$I=$this->conn->query("SHOW WARNINGS");if($I&&$I->num_rows){ob_start();print_select_result($I);return
ob_get_clean();}}function
tableHelp($B,$_e=false){$Ze=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($Ze?"$B-table/":str_replace("_","-",$B)."-table.html"));if(DB=="mysql")return($Ze?"mysql$B-table/":"system-schema.html");}function
partitionsInfo($R){$rd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$I=$this->conn->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $rd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$J=array();list($J["partition_by"],$J["partition"],$J["partitions"])=$I->fetch_row();$Gg=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $rd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$J["partition_names"]=array_keys($Gg);$J["partition_values"]=array_values($Gg);return$J;}function
hasCStyleEscapes(){static$Sa;if($Sa===null){$pi=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Sa=(strpos($pi,'NO_BACKSLASH_ESCAPES')===false);}return$Sa;}function
engines(){$J=array();foreach(get_rows("SHOW ENGINES")as$K){if(preg_match("~YES|DEFAULT~",$K["Support"]))$J[]=$K["Engine"];}return$J;}function
indexAlgorithms(array$Bi){return(preg_match('~^(MEMORY|NDB)$~',$Bi["Engine"])?array("HASH","BTREE"):array());}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($jd){$J=get_session("dbs");if($J===null){$H="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$J=($jd?slow_query($H):get_vals($H));restart_session();set_session("dbs",$J);stop_session();}return$J;}function
limit($H,$Z,$z,$C=0,$Vh=" "){return" $H$Z".($z?$Vh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Vh="\n"){return
limit($H,$Z,1,0,$Vh);}function
db_collation($k,array$lb){$J=null;$i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$A))$J=$A[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$A))$J=$lb[$A[1]][-1];return$J;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$j){$J=array();foreach($j
as$k)$J[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$J;}function
table_status($B="",$Vc=false){$J=array();foreach(get_rows($Vc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($B!=""?"AND TABLE_NAME = ".q($B):"ORDER BY Name"):"SHOW TABLE STATUS".($B!=""?" LIKE ".q(addcslashes($B,"%_\\")):""))as$K){if($K["Engine"]=="InnoDB")$K["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$K["Comment"]);if(!isset($K["Engine"]))$K["Comment"]="";if($B!="")$K["Name"]=$B;$J[$K["Name"]]=$K;}return$J;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$Ze=(connection()->flavor=='maria');$J=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$K){$n=$K["COLUMN_NAME"];$U=$K["COLUMN_TYPE"];$vd=$K["GENERATION_EXPRESSION"];$Sc=$K["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Sc,$ud);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$cf);$l=$K["COLUMN_DEFAULT"];if($l!=""){$ze=preg_match('~text|json~',$cf[1]);if(!$Ze&&$ze)$l=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($l));if($Ze||$ze){$l=($l=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($A){return
stripslashes(str_replace("''","'",$A[1]));},$l));}if(!$Ze&&preg_match('~binary~',$cf[1])&&preg_match('~^0x(\w*)$~',$l,$A))$l=pack("H*",$A[1]);}$J[$n]=array("field"=>$n,"full_type"=>$U,"type"=>$cf[1],"length"=>$cf[2],"unsigned"=>ltrim($cf[3].$cf[4]),"default"=>($ud?($Ze?$vd:stripslashes($vd)):$l),"null"=>($K["IS_NULLABLE"]=="YES"),"auto_increment"=>($Sc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Sc,$A)?$A[1]:""),"collation"=>$K["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$K[PRIVILEGES],where,order")),"comment"=>$K["COLUMN_COMMENT"],"primary"=>($K["COLUMN_KEY"]=="PRI"),"generated"=>($ud[1]=="PERSISTENT"?"STORED":$ud[1]),);}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$h)as$K){$B=$K["Key_name"];$J[$B]["type"]=($B=="PRIMARY"?"PRIMARY":($K["Index_type"]=="FULLTEXT"?"FULLTEXT":($K["Non_unique"]?($K["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$J[$B]["columns"][]=$K["Column_name"];$J[$B]["lengths"][]=($K["Index_type"]=="SPATIAL"?null:$K["Sub_part"]);$J[$B]["descs"][]=null;$J[$B]["algorithm"]=$K["Index_type"];}return$J;}function
foreign_keys($R){static$Kg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$J=array();$Fb=get_val("SHOW CREATE TABLE ".table($R),1);if($Fb){preg_match_all("~CONSTRAINT ($Kg) FOREIGN KEY ?\\(((?:$Kg,? ?)+)\\) REFERENCES ($Kg)(?:\\.($Kg))? \\(((?:$Kg,? ?)+)\\)(?: ON DELETE (".driver()->onActions."))?(?: ON UPDATE (".driver()->onActions."))?~",$Fb,$df,PREG_SET_ORDER);foreach($df
as$A){preg_match_all("~$Kg~",$A[2],$ji);preg_match_all("~$Kg~",$A[5],$Mi);$J[idf_unescape($A[1])]=array("db"=>idf_unescape($A[4]!=""?$A[3]:$A[4]),"table"=>idf_unescape($A[4]!=""?$A[4]:$A[3]),"source"=>array_map('Adminer\idf_unescape',$ji[0]),"target"=>array_map('Adminer\idf_unescape',$Mi[0]),"on_delete"=>($A[6]?:"RESTRICT"),"on_update"=>($A[7]?:"RESTRICT"),);}}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($B),1)));}function
collations(){$J=array();foreach(get_rows("SHOW COLLATION")as$K){if($K["Default"])$J[$K["Charset"]][-1]=$K["Collation"];else$J[$K["Charset"]][]=$K["Collation"];}ksort($J);foreach($J
as$y=>$X)sort($J[$y]);return$J;}function
information_schema($k){return($k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" COLLATE ".q($c):""));}function
drop_databases(array$j){$J=apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$J;}function
rename_database($B,$c){$J=false;if(create_database($B,$c)){$T=array();$Rj=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$Rj[]=$R;else$T[]=$R;}$J=(!$T&&!$Rj)||move_tables($T,$Rj,$B);drop_databases($J?array(DB):array());}return$J;}function
auto_increment(){$Ca=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$Ca="";break;}if($w["type"]=="PRIMARY")$Ca=" UNIQUE";}}return" AUTO_INCREMENT$Ca";}function
alter_table($R,$B,array$o,array$ld,$qb,$zc,$c,$Ba,$E){$b=array();foreach($o
as$n){if($n[1]){$l=$n[1][3];if(preg_match('~ GENERATED~',$l)){$n[1][3]=(connection()->flavor=='maria'?"":$n[1][2]);$n[1][2]=$l;}$b[]=($R!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($R!=""?$n[2]:"");}else$b[]="DROP ".idf_escape($n[0]);}$b=array_merge($b,$ld);$P=($qb!==null?" COMMENT=".q($qb):"").($zc?" ENGINE=".q($zc):"").($c?" COLLATE ".q($c):"").($Ba!=""?" AUTO_INCREMENT=$Ba":"");if($E){$Gg=array();if($E["partition_by"]=='RANGE'||$E["partition_by"]=='LIST'){foreach($E["partition_names"]as$y=>$X){$Y=$E["partition_values"][$y];$Gg[]="\n  PARTITION ".idf_escape($X)." VALUES ".($E["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$P
.="\nPARTITION BY $E[partition_by]($E[partition])";if($Gg)$P
.=" (".implode(",",$Gg)."\n)";elseif($E["partitions"])$P
.=" PARTITIONS ".(+$E["partitions"]);}elseif($E===null)$P
.="\nREMOVE PARTITIONING";if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");if($R!=$B)$b[]="RENAME TO ".table($B);if($P)$b[]=ltrim($P);return($b?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$b)):true);}function
alter_indexes($R,$b){$Wa=array();foreach($b
as$X)$Wa[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Wa));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$Rj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Rj)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$Rj,$Mi){$wh=array();foreach($T
as$R)$wh[]=table($R)." TO ".idf_escape($Mi).".".table($R);if(!$wh||queries("RENAME TABLE ".implode(", ",$wh))){$Yb=array();foreach($Rj
as$R)$Yb[table($R)]=view($R);connection()->select_db($Mi);$k=idf_escape(DB);foreach($Yb
as$B=>$Qj){if(!queries("CREATE VIEW $B AS ".str_replace(" $k."," ",$Qj["select"]))||!queries("DROP VIEW $k.$B"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$Rj,$Mi){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$B=($Mi==DB?table("copy_$R"):idf_escape($Mi).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $B"))||!queries("CREATE TABLE $B LIKE ".table($R))||!queries("INSERT INTO $B SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K){$lj=$K["Trigger"];if(!queries("CREATE TRIGGER ".($Mi==DB?idf_escape("copy_$lj"):idf_escape($Mi).".".idf_escape($lj))." $K[Timing] $K[Event] ON $B FOR EACH ROW\n$K[Statement];"))return
false;}}foreach($Rj
as$R){$B=($Mi==DB?table("copy_$R"):idf_escape($Mi).".".table($R));$Qj=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $B"))||!queries("CREATE VIEW $B AS $Qj[select]"))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($B));return
reset($L);}function
triggers($R){$J=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K)$J[$K["Trigger"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($B,$U){$ta=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$ki="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Ac=driver()->enumLength;$qj="((".implode("|",array_merge(array_keys(driver()->types()),$ta)).")\\b(?:\\s*\\(((?:[^'\")]|$Ac)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?(?:\\s*COLLATE\\s*['\"]?[^'\"\\s,]+['\"]?)?";$Kg="$ki*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$qj";$i=get_val("SHOW CREATE $U ".idf_escape($B),2);preg_match("~\\(((?:$Kg\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$qj\\s+":"")."(.*)~is",$i,$A);$o=array();preg_match_all("~$Kg\\s*,?~is",$A[1],$df,PREG_SET_ORDER);foreach($df
as$yg)$o[]=array("field"=>str_replace("``","`",$yg[2]).$yg[3],"type"=>strtolower($yg[5]),"length"=>preg_replace_callback("~$Ac~s",'Adminer\normalize_enum',$yg[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$yg[8] $yg[7]"))),"null"=>true,"full_type"=>$yg[4],"inout"=>strtoupper($yg[1]),"collation"=>strtolower($yg[9]),);return
array("fields"=>$o,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($B)),)+($U!="FUNCTION"?array("definition"=>$A[11]):array("returns"=>array("type"=>$A[12],"length"=>$A[13],"unsigned"=>$A[15],"collation"=>$A[16]),"definition"=>$A[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($B,array$K){return
idf_escape($B);}function
last_id($I){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$g,$H){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$H);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$Ba,$wi){$J=get_val("SHOW CREATE TABLE ".table($R),1);if(!$Ba)$J=preg_replace('~ AUTO_INCREMENT=\d+~','',$J);return$J;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Pb,$wi=""){$B=idf_escape($Pb);$J="";if(preg_match('~CREATE~',$wi)&&($i=get_val("SHOW CREATE DATABASE $B",1))){set_utf8mb4($i);if($wi=="DROP+CREATE")$J="DROP DATABASE IF EXISTS $B;\n";$J
.="$i;\n";}return$J."USE $B";}function
trigger_sql($R){$J="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$K)$J
.="\nCREATE TRIGGER ".idf_escape($K["Trigger"])." $K[Timing] $K[Event] ON ".table($K["Table"])." FOR EACH ROW\n$K[Statement];;\n";return$J;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field(array$n,$J){if(preg_match("~binary~",$n["type"]))$J="UNHEX($J)";if($n["type"]=="bit")$J="CONVERT(b$J, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$Wg=(min_version(8)?"ST_":"");$J=$Wg."GeomFromText($J, $Wg"."SRID($n[field]))";}return$J;}function
support($Wc){return
preg_match('~^(comment|columns|copy|database|drop_col|dump|indexes|kill|privileges|move_col|procedure|processlist|routine|sql|status|table|trigger|variables|view'.(min_version(5.1)?'|event':'').(min_version(8)?'|descidx':'').(min_version('8.0.16','10.2.1')?'|check':'').')$~',$Wc);}function
kill_process($u){return
queries("KILL ".number($u));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Jh,$h=null){return
true;}}define('Adminer\JUSH',Driver::$jush);define('Adminer\SERVER',"".$_GET[DRIVER]);define('Adminer\DB',"$_GET[db]");define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($Wi,$m="",$Oa=array(),$Xi=""){page_headers();if(is_ajax()&&$m){page_messages($m);exit;}if(!ob_get_level())ob_start('ob_gzhandler',4096);$Yi=$Wi.($Xi!=""?": $Xi":"");$Zi=strip_tags($Yi.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(85),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$Zi,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.4.1"),'">
';$Jb=adminer()->css();if(is_int(key($Jb)))$Jb=array_fill_keys($Jb,'light');$Gd=in_array('light',$Jb)||in_array('',$Jb);$Ed=in_array('dark',$Jb)||in_array('',$Jb);$Mb=($Gd?($Ed?null:false):($Ed?:null));$nf=" media='(prefers-color-scheme: dark)'";if($Mb!==false)echo"<link rel='stylesheet'".($Mb?"":$nf)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.4.1")."'>\n";echo"<meta name='color-scheme' content='".($Mb===null?"light dark":($Mb?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.4.1");if(adminer()->head($Mb))echo"<link rel='icon' href='data:image/gif;base64,R0lGODlhEAAQAJEAAAQCBPz+/PwCBAROZCH5BAEAAAAALAAAAAAQABAAAAI2hI+pGO1rmghihiUdvUBnZ3XBQA7f05mOak1RWXrNq5nQWHMKvuoJ37BhVEEfYxQzHjWQ5qIAADs='>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.1")."'>\n";foreach($Jb
as$Dj=>$xf){$_a=($xf=='dark'&&!$Mb?$nf:($xf=='light'&&$Ed?" media='(prefers-color-scheme: light)'":""));echo"<link rel='stylesheet'$_a href='".h($Dj)."'>\n";}echo"\n<body class='".lang(85)." nojs";adminer()->bodyClass();echo"'>\n";$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$Pj=unserialize(file_get_contents($p));$gh="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Pj["version"],base64_decode($Pj["signature"]),$gh)==1)$_COOKIE["adminer_version"]=$Pj["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(86))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Oa!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?:".").'">'.get_driver(DRIVER).'</a> » ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=adminer()->serverName(SERVER);$N=($N!=""?$N:lang(34));if($Oa===false)echo"$N\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$N</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Oa)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Oa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Oa
as$y=>$X){$ac=(is_array($X)?$X[1]:h($X));if($ac!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$ac</a> » ";}}echo"$Wi\n";}}echo"<h2>$Yi</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$Ib){$Id=array();foreach($Ib
as$y=>$X)$Id[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Id));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$Jf;if(!$Jf)$Jf=base64_encode(rand_string());return$Jf;}function
page_messages($m){$Cj=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$tf=idx($_SESSION["messages"],$Cj);if($tf){echo"<div class='message'>".implode("</div>\n<div class='message'>",$tf)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Cj]);}if($m)echo"<div class='error'>$m</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($wf=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($wf);echo"</div>\n";if($wf!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(87),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($Bf){while($Bf>=2147483648)$Bf-=4294967296;while($Bf<=-2147483649)$Bf+=4294967296;return(int)$Bf;}function
long2str(array$W,$Tj){$Hh='';foreach($W
as$X)$Hh
.=pack('V',$X);if($Tj)return
substr($Hh,0,end($W));return$Hh;}function
str2long($Hh,$Tj){$W=array_values(unpack('V*',str_pad($Hh,4*ceil(strlen($Hh)/4),"\0")));if($Tj)$W[]=strlen($Hh);return$W;}function
xxtea_mx($ak,$Zj,$zi,$Ce){return
int32((($ak>>5&0x7FFFFFF)^$Zj<<2)+(($Zj>>3&0x1FFFFFFF)^$ak<<4))^int32(($zi^$Zj)+($Ce^$ak));}function
encrypt_string($ui,$y){if($ui=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($ui,true);$Bf=count($W)-1;$ak=$W[$Bf];$Zj=$W[0];$hh=floor(6+52/($Bf+1));$zi=0;while($hh-->0){$zi=int32($zi+0x9E3779B9);$qc=$zi>>2&3;for($wg=0;$wg<$Bf;$wg++){$Zj=$W[$wg+1];$Af=xxtea_mx($ak,$Zj,$zi,$y[$wg&3^$qc]);$ak=int32($W[$wg]+$Af);$W[$wg]=$ak;}$Zj=$W[0];$Af=xxtea_mx($ak,$Zj,$zi,$y[$wg&3^$qc]);$ak=int32($W[$Bf]+$Af);$W[$Bf]=$ak;}return
long2str($W,false);}function
decrypt_string($ui,$y){if($ui=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($ui,false);$Bf=count($W)-1;$ak=$W[$Bf];$Zj=$W[0];$hh=floor(6+52/($Bf+1));$zi=int32($hh*0x9E3779B9);while($zi){$qc=$zi>>2&3;for($wg=$Bf;$wg>0;$wg--){$ak=$W[$wg-1];$Af=xxtea_mx($ak,$Zj,$zi,$y[$wg&3^$qc]);$Zj=int32($W[$wg]-$Af);$W[$wg]=$Zj;}$ak=$W[$Bf];$Af=xxtea_mx($ak,$Zj,$zi,$y[$wg&3^$qc]);$Zj=int32($W[0]-$Af);$W[0]=$Zj;$zi=int32($zi-0x9E3779B9);}return
long2str($W,true);}$Mg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$Mg[$y]=$X;}}function
add_invalid_login(){$Ha=get_temp_dir()."/adminer.invalid";foreach(glob("$Ha*")?:array($Ha)as$p){$r=file_open_lock($p);if($r)break;}if(!$r)$r=file_open_lock("$Ha-".rand_string());if(!$r)return;$ue=unserialize(stream_get_contents($r));$Ti=time();if($ue){foreach($ue
as$ve=>$X){if($X[0]<$Ti)unset($ue[$ve]);}}$te=&$ue[adminer()->bruteForceKey()];if(!$te)$te=array($Ti+30*60,0);$te[1]++;file_write_unlock($r,serialize($ue));}function
check_invalid_login(array&$Mg){$ue=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$p){$r=file_open_lock($p);if($r){$ue=unserialize(stream_get_contents($r));file_unlock($r);break;}}$te=idx($ue,adminer()->bruteForceKey(),array());$If=($te[1]>29?$te[0]-time():0);if($If>0)auth_error(lang(88,ceil($If/60)),$Mg);}$Aa=$_POST["auth"];if($Aa){$Oj=$Aa["driver"];$N=$Aa["server"];$V=$Aa["username"];$F=(string)$Aa["password"];$k=$Aa["db"];set_password($Oj,$N,$V,$F);$_SESSION["db"][$Oj][$N][$V][$k]=true;if($Aa["permanent"]){$y=implode("-",array_map('base64_encode',array($Oj,$N,$V,$k)));$bh=adminer()->permanentLogin(true);$Mg[$y]="$y:".base64_encode($bh?encrypt_string($F,$bh):"");cookie("adminer_permanent",implode(" ",$Mg));}if(count($_POST)==1||DRIVER!=$Oj||SERVER!=$N||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($Oj,$N,$V,$k));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent($Mg);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(89));}elseif($Mg&&!$_SESSION["pwds"]){$bh=adminer()->permanentLogin();foreach($Mg
as$y=>$X){list(,$eb)=explode(":",$X);list($Oj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));set_password($Oj,$N,$V,decrypt_string(base64_decode($eb),$bh));$_SESSION["db"][$Oj][$N][$V][$k]=true;}}function
unset_permanent(array&$Mg){foreach($Mg
as$y=>$X){list($Oj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));if($Oj==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$k==DB)unset($Mg[$y]);}cookie("adminer_permanent",implode(" ",$Mg));}function
auth_error($m,array&$Mg){$bi=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$bi]||$_GET[$bi])&&!$_SESSION["token"])$m=lang(90);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m
.=($m?'<br>':'').lang(91,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($Mg);}}if(!$_COOKIE[$bi]&&$_GET[$bi]&&ini_bool("session.use_only_cookies"))$m=lang(92);$zg=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$zg["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header('',$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(93)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($Mg);page_header(lang(94),lang(95,implode(", ",Driver::$extensions)),false);page_footer("auth");exit;}$g='';if(isset($_GET["username"])&&is_string(get_password())){list(,$Qg)=host_port(SERVER);if(preg_match('~^\s*([-+]?\d+)~',$Qg,$A)&&($A[1]<1024||$A[1]>65535))auth_error(lang(96),$Mg);check_invalid_login($Mg);$Hb=adminer()->credentials();$g=Driver::connect($Hb[0],$Hb[1],$Hb[2]);if(is_object($g)){Db::$instance=$g;Driver::$instance=new
Driver($g);if($g->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$Xe=null;if(!is_object($g)||($Xe=adminer()->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?nl_br(h($g)):(is_string($Xe)?$Xe:lang(97))).(preg_match('~^ | $~',get_password())?'<br>'.lang(98):'');auth_error($m,$Mg);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(87),lang(99));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($Aa&&$_POST["token"])$_POST["token"]=get_token();$m='';if($_POST){if(!verify_token()){$me="max_input_vars";$lf=ini_get($me);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$lf||$X<$lf)){$me=$y;$lf=$X;}}}$m=(!$_POST["token"]&&$lf?lang(100,"'$me'"):lang(99).' '.lang(101));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(102,"'post_max_size'");if(isset($_GET["sql"]))$m
.=' '.lang(103);}function
print_select_result($I,$h=null,array$lg=array(),$z=0){$Ve=array();$x=array();$e=array();$Ma=array();$rj=array();$J=array();for($t=0;(!$z||$t<$z)&&($K=$I->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($Ae=0;$Ae<count($K);$Ae++){$n=$I->fetch_field();$B=$n->name;$kg=(isset($n->orgtable)?$n->orgtable:"");$jg=(isset($n->orgname)?$n->orgname:$B);if($lg&&JUSH=="sql")$Ve[$Ae]=($B=="table"?"table=":($B=="possible_keys"?"indexes=":null));elseif($kg!=""){if(isset($n->table))$J[$n->table]=$kg;if(!isset($x[$kg])){$x[$kg]=array();foreach(indexes($kg,$h)as$w){if($w["type"]=="PRIMARY"){$x[$kg]=array_flip($w["columns"]);break;}}$e[$kg]=$x[$kg];}if(isset($e[$kg][$jg])){unset($e[$kg][$jg]);$x[$kg][$jg]=$Ae;$Ve[$Ae]=$kg;}}if($n->charsetnr==63)$Ma[$Ae]=true;$rj[$Ae]=$n->type;echo"<th".($kg!=""||$n->name!=$jg?" title='".h(($kg!=""?"$kg.":"").$jg)."'":"").">".h($B).($lg?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($B),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($K
as$y=>$X){$_="";if(isset($Ve[$y])&&!$e[$Ve[$y]]){if($lg&&JUSH=="sql"){$R=$K[array_search("table=",$Ve)];$_=ME.$Ve[$y].urlencode($lg[$R]!=""?$lg[$R]:$R);}else{$_=ME."edit=".urlencode($Ve[$y]);foreach($x[$Ve[$y]]as$jb=>$Ae){if($K[$Ae]===null){$_="";break;}$_
.="&where".urlencode("[".bracket_escape($jb)."]")."=".urlencode($K[$Ae]);}}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ma[$y]&&!is_utf8($X))$X="<i>".lang(47,strlen($X))."</i>";else{$X=h($X);if($rj[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td".($rj[$y]<=9||$rj[$y]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(14))."\n";return$J;}function
referencable_primary($Th){$J=array();foreach(table_status('',true)as$Di=>$R){if($Di!=$Th&&fk_support($R)){foreach(fields($Di)as$n){if($n["primary"]){if($J[$Di]){unset($J[$Di]);break;}$J[$Di]=$n;}}}}return$J;}function
textarea($B,$Y,$L=10,$mb=80){echo"<textarea name='".h($B)."' rows='$L' cols='$mb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($_a,array$fg,$Y="",$Zf="",$Ng=""){$Li=($fg?"select":"input");return"<$Li$_a".($fg?"><option value=''>$Ng".optionlist($fg,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Ng'>").($Zf?script("qsl('$Li').onchange = $Zf;",""):"");}function
json_row($y,$X=null,$Hc=true){static$dd=true;if($dd)echo"{";if($y!=""){echo($dd?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?($Hc?'"'.addcslashes($X,"\r\n\"\\/").'"':$X):'null');$dd=false;}else{echo"\n}\n";$dd=true;}}function
edit_type($y,array$n,array$lb,array$nd=array(),array$Tc=array()){$U=$n["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($nd[$U])&&!in_array($U,$Tc))$Tc[]=$U;$vi=driver()->structuredTypes();if($nd)$vi[lang(104)]=$nd;echo
optionlist(array_merge($Tc,$vi),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($n["length"])."' size='3'".(!$n["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($lb?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($n["collation"])."' placeholder='(".lang(105).")'>":''),(driver()->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(106).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($nd?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(107).")".optionlist(explode("|",driver()->onActions),$n["on_delete"])."</select> ":" ");}function
process_length($Re){$Cc=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$Cc(?:\\s*,\\s*$Cc)*+\\s*\\)?\\s*\$~",$Re)&&preg_match_all("~$Cc~",$Re,$df)?"(".implode(",",$df[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Re)));}function
process_type(array$n,$kb="COLLATE"){return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],driver()->unsigned)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $kb ".(JUSH=="mssql"?$n["collation"]:q($n["collation"])):"");}function
process_field(array$n,array$pj){if($n["on_update"])$n["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$n["on_update"]);return
array(idf_escape(trim($n["field"])),process_type($pj),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value(array$n){$l=$n["default"];$ud=$n["generated"];return($l===null?"":(in_array($ud,driver()->generated)?(JUSH=="mssql"?" AS ($l)".($ud=="VIRTUAL"?"":" $ud")."":" GENERATED ALWAYS AS ($l) $ud"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$l)&&(preg_match('~char|binary|text|json|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$l))?(JUSH=="sql"&&preg_match('~text|json~',$n["type"])?"(".q($l).")":q($l)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($l)":$l)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields(array$o,array$lb,$U="TABLE",array$nd=array()){$o=array_values($o);$Vb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$rb=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(108):lang(109)),"<td id='label-type'>".lang(49)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(110),"<td>".lang(111);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(51)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",)),"<td id='label-default'$Vb>".lang(52),(support("comment")?"<td id='label-comment'$rb>".lang(50):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($o))."]","+",lang(112)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$t=>$n){$t++;$mg=$n[($_POST?"orig":"field")];$gc=(isset($_POST["add"][$t-1])||(isset($n["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$mg=="");echo"<tr".($gc?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$n["inout"]):"")."<th>";if($gc)echo"<input name='fields[$t][field]' value='".h($n["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'".(isset($_POST["add"][$t-1])?" autofocus":"").">";echo
input_hidden("fields[$t][orig]",$mg);edit_type("fields[$t]",$n,$lb,$nd);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$n["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($n["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Vb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$n["generated"])." ":checkbox("fields[$t][generated]",1,$n["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($n["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$rb><input name='fields[$t][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(112))." ".icon("up","up[$t]","↑",lang(113))." ".icon("down","down[$t]","↓",lang(114))." ":""),($mg==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(115)):"");}}function
process_fields(array&$o){$C=0;if($_POST["up"]){$Le=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$Le,0,array($n));break;}if(isset($n["field"]))$Le=$C;$C++;}}elseif($_POST["down"]){$pd=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$pd){unset($o[key($_POST["down"])]);array_splice($o,$C,0,array($pd));break;}if(key($_POST["down"])==$y)$pd=$n;$C++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$A){$X=$A[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($wd,array$dh,$e,$Wf){if(!$dh)return
true;if($dh==array("ALL PRIVILEGES","GRANT OPTION"))return($wd=="GRANT"?queries("$wd ALL PRIVILEGES$Wf WITH GRANT OPTION"):queries("$wd ALL PRIVILEGES$Wf")&&queries("$wd GRANT OPTION$Wf"));return
queries("$wd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$dh).$e).$Wf);}function
drop_create($kc,$i,$mc,$Pi,$oc,$We,$sf,$qf,$rf,$Tf,$Ff){if($_POST["drop"])query_redirect($kc,$We,$sf);elseif($Tf=="")query_redirect($i,$We,$rf);elseif($Tf!=$Ff){$Gb=queries($i);queries_redirect($We,$qf,$Gb&&queries($kc));if($Gb)queries($mc);}else
queries_redirect($We,$qf,queries($Pi)&&queries($oc)&&queries($kc)&&queries($i));}function
create_trigger($Wf,array$K){$Vi=" $K[Timing] $K[Event]".(preg_match('~ OF~',$K["Event"])?" $K[Of]":"");return"CREATE TRIGGER ".idf_escape($K["Trigger"]).(JUSH=="mssql"?$Wf.$Vi:$Vi.$Wf).rtrim(" $K[Type]\n$K[Statement]",";").";";}function
create_routine($Dh,array$K){$O=array();$o=(array)$K["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$O[]=(preg_match("~^(".driver()->inout.")\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$Xb=rtrim($K["definition"],";");return"CREATE $Dh ".idf_escape(trim($K["name"]))." (".implode(", ",$O).")".($Dh=="FUNCTION"?" RETURNS".process_type($K["returns"],"CHARACTER SET"):"").($K["language"]?" LANGUAGE $K[language]":"").(JUSH=="pgsql"?" AS ".q($Xb):"\n$Xb;");}function
remove_definer($H){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$H);}function
format_foreign_key(array$q){$k=$q["db"];$Kf=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$q["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($Kf!=""&&$Kf!=$_GET["ns"]?idf_escape($Kf).".":"").idf_escape($q["table"])." (".implode(", ",array_map('Adminer\idf_escape',$q["target"])).")".(preg_match("~^(".driver()->onActions.")\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^(".driver()->onActions.")\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$aj){$J=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($aj->size),decoct(time()));$db=8*32;for($t=0;$t<strlen($J);$t++)$db+=ord($J[$t]);$J
.=sprintf("%06o",$db)."\0 ";echo$J,str_repeat("\0",512-strlen($J));$aj->send();echo
str_repeat("\0",511-($aj->size+511)%512);}function
doc_link(array$Jg,$Qi="<sup>?</sup>"){$Zh=connection()->server_info;$Pj=preg_replace('~^(\d\.?\d).*~s','\1',$Zh);$Ej=array('sql'=>"https://dev.mysql.com/doc/refman/$Pj/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$Pj)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Zh)."&id=",);if(connection()->flavor=='maria'){$Ej['sql']="https://mariadb.com/kb/en/";$Jg['sql']=(isset($Jg['mariadb'])?$Jg['mariadb']:str_replace(".html","/",$Jg['sql']));}return($Jg[JUSH]?"<a href='".h($Ej[JUSH].$Jg[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$Pj":""))."'".target_blank().">$Qi</a>":"");}function
db_size($k){if(!connection()->select_db($k))return"?";$J=0;foreach(table_status()as$S)$J+=$S["Data_length"]+$S["Index_length"];return
format_number($J);}function
set_utf8mb4($i){static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$i)){$O=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(37).": ".h(DB),lang(116),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(117),drop_databases($_POST["db"]));page_header(lang(118),$m,false);echo"<p class='links'>\n";foreach(array('database'=>lang(119),'privileges'=>lang(71),'processlist'=>lang(120),'variables'=>lang(121),'status'=>lang(122),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(123,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(124,"<b>".h(logged_user())."</b>")."\n";$j=adminer()->databases();if($j){$Lh=support("scheme");$lb=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(37).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(125)."</a>":"")."<td>".lang(126)."<td>".lang(127)."<td>".lang(128)." - <a href='".h(ME)."dbsize=1'>".lang(129)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$T){$Ch=h(ME)."db=".urlencode($k);$u=h("Db-".$k);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$Ch' id='$u'>".h($k)."</a>";$c=h(db_collation($k,$lb));echo"<td>".(support("database")?"<a href='$Ch".($Lh?"&amp;ns=":"")."&amp;database=' title='".lang(67)."'>$c</a>":$c),"<td align='right'><a href='$Ch&amp;schema=' id='tables-".h($k)."' title='".lang(70)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(130)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(131)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}if(!empty(adminer()->plugins)){echo"<div class='plugins'>\n","<h3>".lang(132)."</h3>\n<ul>\n";foreach(adminer()->plugins
as$Og){$bc=(method_exists($Og,'description')?$Og->description():"");if(!$bc){$sh=new
\ReflectionObject($Og);if(preg_match('~^/[\s*]+(.+)~',$sh->getDocComment(),$A))$bc=$A[1];}$Mh=(method_exists($Og,'screenshot')?$Og->screenshot():"");echo"<li><b>".get_class($Og)."</b>".h($bc?": $bc":"").($Mh?" (<a href='".h($Mh)."'".target_blank().">".lang(133)."</a>)":"")."\n";}echo"</ul>\n";adminer()->pluginsLinks();echo"</div>\n";}}page_footer("db");exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(79).": ".h($_GET["ns"]),lang(134),true);page_footer("ns");exit;}}}adminer()->afterConnect();class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Ab){$this->size+=strlen($Ab);fwrite($this->handler,$Ab);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$M=array(idf_escape($_GET["field"]));$I=driver()->select($a,$M,array(where($_GET,$o)),$M);$K=($I?$I->fetch_row():array());echo
driver()->value($K[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error()?:lang(11);$S=table_status1($a);$B=adminer()->tableName($S);page_header(($o&&is_view($S)?$S['Engine']=='materialized view'?lang(135):lang(136):lang(137)).": ".($B!=""?$B:h($a)),$m);$Bh=array();foreach($o
as$y=>$n)$Bh+=$n["privileges"];adminer()->selectLinks($S,(isset($Bh["insert"])||!support("table")?"":null));$qb=$S["Comment"];if($qb!="")echo"<p class='nowrap'>".lang(50).": ".h($qb)."\n";if($o)adminer()->tableStructurePrint($o,$S);function
tables_links(array$T){echo"<ul>\n";foreach($T
as$R)echo"<li><a href='".h(ME."table=".urlencode($R))."'>".h($R)."</a>";echo"</ul>\n";}$le=driver()->inheritsFrom($a);if($le){echo"<h3>".lang(138)."</h3>\n";tables_links($le);}if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(139)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x,$S);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(140)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(104)."</h3>\n";$nd=foreign_keys($a);if($nd){echo"<table>\n","<thead><tr><th>".lang(141)."<td>".lang(142)."<td>".lang(107)."<td>".lang(106)."<td></thead>\n";foreach($nd
as$B=>$q){echo"<tr title='".h($B)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$q["source"]))."</i>";$_=($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME));echo"<td><a href='".h($_."table=".urlencode($q["table"]))."'>".($q["db"]!=""&&$q["db"]!=DB?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""&&$q["ns"]!=$_GET["ns"]?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$q["target"]))."</i>)","<td>".h($q["on_delete"]),"<td>".h($q["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($B)).'">'.lang(143).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(144)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(145)."</h3>\n";$Za=driver()->checkConstraints($a);if($Za){echo"<table>\n";foreach($Za
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(143)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(146)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(147)."</h3>\n";$oj=triggers($a);if($oj){echo"<table>\n";foreach($oj
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(143)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(148)."</a>\n";}$ke=driver()->inheritedTables($a);if($ke){echo"<h3 id='partitions'>".lang(149)."</h3>\n";$Cg=driver()->partitionsInfo($a);if($Cg)echo"<p><code class='jush-".JUSH."'>BY ".h("$Cg[partition_by]($Cg[partition])")."</code>\n";tables_links($ke);}}elseif(isset($_GET["schema"])){page_header(lang(70),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Fi=array();$Gi=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$df,PREG_SET_ORDER);foreach($df
as$t=>$A){$Fi[$A[1]]=array($A[2],$A[3]);$Gi[]="\n\t'".js_escape($A[1])."': [ $A[2], $A[3] ]";}$dj=0;$Ia=-1;$Jh=array();$rh=array();$Pe=array();$ua=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$Rg=0;$Jh[$R]["fields"]=array();foreach($ua[$R]as$n){$Rg+=1.25;$n["pos"]=$Rg;$Jh[$R]["fields"][$n["field"]]=$n;}$Jh[$R]["pos"]=($Fi[$R]?:array($dj,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$Ne=$Ia;if(idx($Fi[$R],1)||idx($Fi[$X["table"]],1))$Ne=min(idx($Fi[$R],1,0),idx($Fi[$X["table"]],1,0))-1;else$Ia-=.1;while($Pe[(string)$Ne])$Ne-=.0001;$Jh[$R]["references"][$X["table"]][(string)$Ne]=array($X["source"],$X["target"]);$rh[$X["table"]][$R][(string)$Ne]=$X["target"];$Pe[(string)$Ne]=true;}}$dj=max($dj,$Jh[$R]["pos"][0]+2.5+$Rg);}echo'<div id="schema" style="height: ',$dj,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$Gi)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$dj,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Jh
as$B=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($B).'"><b>'.h($B)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["type"].($n["length"]?"($n[length])":"").($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$Ni=>$th){foreach($th
as$Ne=>$oh){$Oe=$Ne-idx($Fi[$B],1);$t=0;foreach($oh[0]as$ji)echo"\n<div class='references' title='".h($Ni)."' id='refs$Ne-".($t++)."' style='left: $Oe"."em; top: ".$R["fields"][$ji]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$Oe)."em;'></div></div>";}}foreach((array)$rh[$B]as$Ni=>$th){foreach($th
as$Ne=>$e){$Oe=$Ne-idx($Fi[$B],1);$t=0;foreach($e
as$Mi)echo"\n<div class='references arrow' title='".h($Ni)."' id='refd$Ne-".($t++)."' style='left: $Oe"."em; top: ".$R["fields"][$Mi]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$Oe)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($Jh
as$B=>$R){foreach((array)$R["references"]as$Ni=>$th){foreach($th
as$Ne=>$oh){$vf=$dj;$jf=-10;foreach($oh[0]as$y=>$ji){$Sg=$R["pos"][0]+$R["fields"][$ji]["pos"];$Tg=$Jh[$Ni]["pos"][0]+$Jh[$Ni]["fields"][$oh[1][$y]]["pos"];$vf=min($vf,$Sg,$Tg);$jf=max($jf,$Sg,$Tg);}echo"<div class='references' id='refl$Ne' style='left: $Ne"."em; top: $vf"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($jf-$vf)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(150),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Pc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$ye=preg_match('~sql~',$_POST["format"]);if($ye){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$wi=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){adminer()->dumpDatabase($k);if(connection()->select_db($k)){if($ye){if($wi)echo
use_sql($k,$wi).";\n\n";$tg="";if($_POST["types"]){foreach(types()as$u=>$U){$Dc=type_values($u);if($Dc)$tg
.=($wi!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($Dc);\n\n";else$tg
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$K){$B=$K["ROUTINE_NAME"];$Dh=$K["ROUTINE_TYPE"];$i=create_routine($Dh,array("name"=>$B)+routine($K["SPECIFIC_NAME"],$Dh));set_utf8mb4($i);$tg
.=($wi!='DROP+CREATE'?"DROP $Dh IF EXISTS ".idf_escape($B).";;\n":"")."$i;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$K){$i=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($K["Name"]),3));set_utf8mb4($i);$tg
.=($wi!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($K["Name"]).";;\n":"")."$i;;\n\n";}}echo($tg&&JUSH=='sql'?"DELIMITER ;;\n\n$tg"."DELIMITER ;\n\n":$tg);}if($_POST["table_style"]||$_POST["data_style"]){$Rj=array();foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));$Nb=(DB==""||in_array($B,(array)$_POST["data"]));if($R||$Nb){$aj=null;if($Pc=="tar"){$aj=new
TmpFile;ob_start(array($aj,'write'),1e5);}adminer()->dumpTable($B,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$Rj[]=$B;elseif($Nb){$o=fields($B);adminer()->dumpData($B,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($B));}if($ye&&$_POST["triggers"]&&$R&&($oj=trigger_sql($B)))echo"\nDELIMITER ;;\n$oj\nDELIMITER ;\n";if($Pc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$B.csv",$aj);}elseif($ye)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($B);}}foreach($Rj
as$Qj)adminer()->dumpTable($Qj,$_POST["table_style"],1);if($Pc=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(76),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Rb=array('','USE','DROP+CREATE','CREATE');$Hi=array('','DROP+CREATE','CREATE');$Ob=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Ob[]='INSERT+UPDATE';$K=get_settings("adminer_export");if(!$K)$K=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($K["events"])){$K["routines"]=$K["events"]=($_GET["dump"]=="");$K["triggers"]=$K["table_style"];}echo"<tr><th>".lang(151)."<td>".html_radios("output",adminer()->dumpOutput(),$K["output"])."\n","<tr><th>".lang(152)."<td>".html_radios("format",adminer()->dumpFormat(),$K["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(37)."<td>".html_select('db_style',$Rb,$K["db_style"]).(support("type")?checkbox("types",1,$K["types"],lang(6)):"").(support("routine")?checkbox("routines",1,$K["routines"],lang(72)):"").(support("event")?checkbox("events",1,$K["events"],lang(74)):"")),"<tr><th>".lang(127)."<td>".html_select('table_style',$Hi,$K["table_style"]).checkbox("auto_increment",1,$K["auto_increment"],lang(51)).(support("trigger")?checkbox("triggers",1,$K["triggers"],lang(147)):""),"<tr><th>".lang(153)."<td>".html_select('data_style',$Ob,$K["data_style"]),'</table>
<p><input type="submit" value="',lang(76),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$Xg=array();if(DB!=""){$bb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$bb>".lang(127)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(153)."<input type='checkbox' id='check-data'$bb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$Rj="";$Ji=tables_list();foreach($Ji
as$B=>$U){$Wg=preg_replace('~_.*~','',$B);$bb=($a==""||$a==(substr($a,-1)=="%"?"$Wg%":$B));$ah="<tr><td>".checkbox("tables[]",$B,$bb,$B,"","block");if($U!==null&&!preg_match('~table~i',$U))$Rj
.="$ah\n";else
echo"$ah<td align='right'><label class='block'><span id='Rows-".h($B)."'></span>".checkbox("data[]",$B,$bb)."</label>\n";$Xg[$Wg]++;}echo$Rj;if($Ji)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(37)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=adminer()->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$Wg=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$Wg%",$k,"","block")."\n";$Xg[$Wg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$dd=true;foreach($Xg
as$y=>$X){if($y!=""&&$X>1){echo($dd?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$dd=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(71));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(154)."</a>";$I=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$wd=$I;if(!$I)$I=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($wd?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(35)."<th>".lang(34)."<th></thead>\n";while($K=$I->fetch_assoc())echo'<tr><td>'.h($K["User"])."<td>".h($K["Host"]).'<td><a href="'.h(ME.'user='.urlencode($K["User"]).'&host='.urlencode($K["Host"])).'">'.lang(12)."</a>\n";if(!$wd||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(12)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");if($_POST["format"]=="sql")echo"$_POST[query]\n";else{adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();}exit;}restart_session();$Md=&get_session("queries");$Ld=&$Md[DB];if(!$m&&$_POST["clear"]){$Ld=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(75):lang(64)),$m);$Ue='--'.(JUSH=='sql'?' ':'');if(!$m&&$_POST){$r=false;if(!isset($_GET["import"]))$H=$_POST["query"];elseif($_POST["webfile"]){$ni=adminer()->importServerPath();$r=@fopen((file_exists($ni)?$ni:"compress.zlib://$ni.gz"),"rb");$H=($r?fread($r,1e6):false);}else$H=get_file("sql_file",true,";");if(is_string($H)){if(function_exists('memory_get_usage')&&($of=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($of,strval(2*strlen($H)+memory_get_usage()+8e6)));if($H!=""&&strlen($H)<1e6){$hh=$H.(preg_match("~;[ \t\r\n]*\$~",$H)?"":";");if(!$Ld||first(end($Ld))!=$hh){restart_session();$Ld[]=array($hh,time());set_session("queries",$Md);stop_session();}}$ki="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|$Ue)[^\n]*\n?|--\r?\n)";$Zb=";";$C=0;$yc=true;$h=connect();if($h&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$pb=0;$Fc=array();$_g='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|'.$Ue.'|$'.(JUSH=="pgsql"?'|\$([a-zA-Z]\w*)?\$':'');$ej=microtime(true);$oa=get_settings("adminer_import");while($H!=""){if(!$C&&preg_match("~^$ki*+DELIMITER\\s+(\\S+)~i",$H,$A)){$Zb=preg_quote($A[1]);$H=substr($H,strlen($A[0]));}elseif(!$C&&JUSH=='pgsql'&&preg_match("~^($ki*+COPY\\s+)[^;]+\\s+FROM\\s+stdin;~i",$H,$A)){$Zb="\n\\\\\\.\r?\n";$C=strlen($A[0]);}else{preg_match("($Zb\\s*|$_g)",$H,$A,PREG_OFFSET_CAPTURE,$C);list($pd,$Rg)=$A[0];if(!$pd&&$r&&!feof($r))$H
.=fread($r,1e5);else{if(!$pd&&rtrim($H)=="")break;$C=$Rg+strlen($pd);if($pd&&!preg_match("(^$Zb)",$pd)){$Ta=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($Rg>0&&strtolower($H[$Rg-1])=="e"));$Kg=($pd=='/*'?'\*/':($pd=='['?']':(preg_match("~^$Ue|^#~",$pd)?"\n":preg_quote($pd).($Ta?'|\\\\.':''))));while(preg_match("($Kg|\$)s",$H,$A,PREG_OFFSET_CAPTURE,$C)){$Hh=$A[0][0];if(!$Hh&&$r&&!feof($r))$H
.=fread($r,1e5);else{$C=$A[0][1]+strlen($Hh);if(!$Hh||$Hh[0]!="\\")break;}}}else{$yc=false;$hh=substr($H,0,$Rg+($Zb[0]=="\n"?3:0));$pb++;$ah="<pre id='sql-$pb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($hh)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$ki*+ATTACH\\b~i",$hh,$A)){echo$ah,"<p class='error'>".lang(155)."\n";$Fc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$ah;ob_flush();flush();}$si=microtime(true);if(connection()->multi_query($hh)&&$h&&preg_match("~^$ki*+USE\\b~i",$hh))$h->query($hh);do{$I=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$ah:""),"<p class='error'>".lang(156).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$Fc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break
2;}else{$Ti=" <span class='time'>(".format_time($si).")</span>".(strlen($hh)<1000?" <a href='".h(ME)."sql=".urlencode(trim($hh))."'>".lang(12)."</a>":"");$qa=connection()->affected_rows;$Uj=($_POST["only_errors"]?"":driver()->warnings());$Vj="warnings-$pb";if($Uj)$Ti
.=", <a href='#$Vj'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$Vj');","");$Nc=null;$lg=null;$Oc="explain-$pb";if(is_object($I)){$z=$_POST["limit"];$lg=print_select_result($I,$h,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$Mf=$I->num_rows;echo"<p class='sql-footer'>".($Mf?($z&&$Mf>$z?lang(157,$z):"").lang(158,$Mf):""),$Ti;if($h&&preg_match("~^($ki|\\()*+SELECT\\b~i",$hh)&&($Nc=explain($h,$hh)))echo", <a href='#$Oc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Oc');","");$u="export-$pb";echo", <a href='#$u'>".lang(76)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$oa["output"])." ".html_select("format",adminer()->dumpFormat(),$oa["format"]).input_hidden("query",$hh)."<input type='submit' name='export' value='".lang(76)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$ki*+(CREATE|DROP|ALTER)$ki++(DATABASE|SCHEMA)\\b~i",$hh)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(159,$qa)."$Ti\n";}echo($Uj?"<div id='$Vj' class='hidden'>\n$Uj</div>\n":"");if($Nc){echo"<div id='$Oc' class='hidden explain'>\n";print_select_result($Nc,$h,$lg);echo"</div>\n";}}$si=microtime(true);}while(connection()->next_result());}$H=substr($H,$C);$C=0;}}}}if($yc)echo"<p class='message'>".lang(160)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(161,$pb-count($Fc))," <span class='time'>(".format_time($ej).")</span>\n";elseif($Fc&&$pb>1)echo"<p class='error'>".lang(156).": ".implode("",$Fc)."\n";}else
echo"<p class='error'>".upload_error($H)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Lc="<input type='submit' value='".lang(162)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$hh=$_GET["sql"];if($_POST)$hh=$_POST["query"];elseif($_GET["history"]=="all")$hh=$Ld;elseif($_GET["history"]!="")$hh=idx($Ld[$_GET["history"]],0);echo"<p>";textarea("query",$hh,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$Lc\n",lang(163).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{$Bd=(extension_loaded("zlib")?"[.gz]":"");echo"<fieldset><legend>".lang(164)."</legend><div>",file_input("SQL$Bd: <input type='file' name='sql_file[]' multiple>\n$Lc"),"</div></fieldset>\n";$Xd=adminer()->importServerPath();if($Xd)echo"<fieldset><legend>".lang(165)."</legend><div>",lang(166,"<code>".h($Xd)."$Bd</code>"),' <input type="submit" name="webfile" value="'.lang(167).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(168))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(169))."\n",input_token();if(!isset($_GET["import"])&&$Ld){print_fieldset("history",lang(170),$_GET["history"]!="");for($X=end($Ld);$X;$X=prev($Ld)){$y=key($Ld);list($hh,$Ti,$tc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(12)."</a>"." <span class='time' title='".@date('Y-m-d',$Ti)."'>".@date("H:i:s",$Ti)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace("~^(#|$Ue).*~m",'',$hh)))),80,"</code>").($tc?" <span class='time'>($tc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(171)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(172)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$_j=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$B=>$n){if(!isset($n["privileges"][$_j?"update":"insert"])||adminer()->fieldName($n)==""||$n["generated"])unset($o[$B]);}if($_POST&&!$m&&!isset($_GET["select"])){$We=$_POST["referer"];if($_POST["insert"])$We=($_j?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$We))$We=ME."select=".urlencode($a);$x=indexes($a);$vj=unique_array($_GET["where"],$x);$kh="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($We,lang(173),driver()->delete($a,$kh,$vj?0:1));else{$O=array();foreach($o
as$B=>$n){$X=process_input($n);if($X!==false&&$X!==null)$O[idf_escape($B)]=$X;}if($_j){if(!$O)redirect($We);queries_redirect($We,lang(174),driver()->update($a,$O,$kh,$vj?0:1));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$I=driver()->insert($a,$O);$Me=($I?last_id($I):0);queries_redirect($We,lang(175,($Me?" $Me":"")),$I);}}}$K=null;if($_POST["save"])$K=(array)$_POST["fields"];elseif($Z){$M=array();foreach($o
as$B=>$n){if(isset($n["privileges"]["select"])){$ya=($_POST["clone"]&&$n["auto_increment"]?"''":convert_field($n));$M[]=($ya?"$ya AS ":"").idf_escape($B);}}$K=array();if(!support("table"))$M=array("*");if($M){$I=driver()->select($a,$M,array($Z),$M,array(),(isset($_GET["select"])?2:1));if(!$I)$m=error();else{$K=$I->fetch_assoc();if(!$K)$K=false;}if(isset($_GET["select"])&&(!$K||$I->fetch_assoc()))$K=null;}}if(!support("table")&&!$o){if(!$Z){$I=driver()->select($a,array("*"),array(),array("*"));$K=($I?$I->fetch_assoc():false);if(!$K)$K=array(driver()->primary=>"");}if($K){foreach($K
as$y=>$X){if(!$Z)$K[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=driver()->primary),"auto_increment"=>($y==driver()->primary));}}}edit_form($a,$o,$K,$_j,$m);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Eg=driver()->partitionBy;$Hg=($Eg?driver()->partitionsInfo($a):array());$qh=referencable_primary($a);$nd=array();foreach($qh
as$Di=>$n)$nd[str_replace("`","``",$Di)."`".str_replace("`","``",$n["field"])]=$Di;$og=array();$S=array();if($a!=""){$og=fields($a);$S=table_status1($a);if(count($S)<2)$m=lang(11);}$K=$_POST;$K["fields"]=(array)$K["fields"];if($K["auto_increment_col"])$K["fields"][$K["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($K["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(176),drop_tables(array($a)));else{$o=array();$ua=array();$Fj=false;$ld=array();$ng=reset($og);$sa=" FIRST";foreach($K["fields"]as$y=>$n){$q=$nd[$n["type"]];$pj=($q!==null?$qh[$q]:$n);if($n["field"]!=""){if(!$n["generated"])$n["default"]=null;$fh=process_field($n,$pj);$ua[]=array($n["orig"],$fh,$sa);if(!$ng||$fh!==process_field($ng,$ng)){$o[]=array($n["orig"],$fh,$sa);if($n["orig"]!=""||$sa)$Fj=true;}if($q!==null)$ld[idf_escape($n["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$nd[$n["type"]],'source'=>array($n["field"]),'target'=>array($pj["field"]),'on_delete'=>$n["on_delete"],));$sa=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$Fj=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$ng=next($og);if(!$ng)$sa="";}}$E=array();if(in_array($K["partition_by"],$Eg)){foreach($K
as$y=>$X){if(preg_match('~^partition~',$y))$E[$y]=$X;}foreach($E["partition_names"]as$y=>$B){if($B==""){unset($E["partition_names"][$y]);unset($E["partition_values"][$y]);}}$E["partition_names"]=array_values($E["partition_names"]);$E["partition_values"]=array_values($E["partition_values"]);if($E==$Hg)$E=array();}elseif(preg_match("~partitioned~",$S["Create_options"]))$E=null;$pf=lang(177);if($a==""){cookie("adminer_engine",$K["Engine"]);$pf=lang(178);}$B=trim($K["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($B),$pf,alter_table($a,$B,(JUSH=="sqlite"&&($Fj||$ld)?$ua:$o),$ld,($K["Comment"]!=$S["Comment"]?$K["Comment"]:null),($K["Engine"]&&$K["Engine"]!=$S["Engine"]?$K["Engine"]:""),($K["Collation"]&&$K["Collation"]!=$S["Collation"]?$K["Collation"]:""),($K["Auto_increment"]!=""?number($K["Auto_increment"]):""),$E));}}page_header(($a!=""?lang(43):lang(77)),$m,array("table"=>$a),h($a));if(!$_POST){$rj=driver()->types();$K=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($rj["int"])?"int":(isset($rj["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$K=$S;$K["name"]=$a;$K["fields"]=array();if(!$_GET["auto_increment"])$K["Auto_increment"]="";foreach($og
as$n){$n["generated"]=$n["generated"]?:(isset($n["default"])?"DEFAULT":"");$K["fields"][]=$n;}if($Eg){$K+=$Hg;$K["partition_names"][]="";$K["partition_values"][]="";}}}$lb=collations();if(is_array(reset($lb)))$lb=call_user_func_array('array_merge',array_values($lb));$_c=driver()->engines();foreach($_c
as$zc){if(!strcasecmp($zc,$K["Engine"])){$K["Engine"]=$zc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(179).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($K["name"])."' autocapitalize='off'>\n",($_c?html_select("Engine",array(""=>"(".lang(180).")")+$_c,$K["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($lb)echo"<datalist id='collations'>".optionlist($lb)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($K["Collation"])."' placeholder='(".lang(105).")'>\n");echo"<input type='submit' value='".lang(16)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($K["fields"],$lb,"TABLE",$nd);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(51).": <input type='number' name='Auto_increment' class='size' value='".h($K["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(181),"columnShow(this.checked, 5)","jsonly");$sb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$sb,lang(50),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$K["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($sb?"":" class='hidden'").">".h($K["Comment"])."</textarea>":'<input name="Comment" value="'.h($K["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($sb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(16),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(131),'">',confirm(lang(182,$a));if($Eg&&(JUSH=='sql'||$a=="")){$Fg=preg_match('~RANGE|LIST~',$K["partition_by"]);print_fieldset("partition",lang(183),$K["partition_by"]);echo"<p>".html_select("partition_by",array_merge(array(""),$Eg),$K["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($K["partition"])."'>)\n",lang(184).": <input type='number' name='partitions' class='size".($Fg||!$K["partition_by"]?" hidden":"")."' value='".h($K["partitions"])."'>\n","<table id='partition-table'".($Fg?"":" class='hidden'").">\n","<thead><tr><th>".lang(185)."<th>".lang(186)."</thead>\n";foreach($K["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($K["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($K["partition_values"],$y)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$fe=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);$ce=driver()->indexAlgorithms($S);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="SPATIAL";$x=indexes($a);$o=fields($a);$G=array();if(JUSH=="mongo"){$G=$x["_id_"];unset($fe[0]);unset($x["_id_"]);}$K=$_POST;if($K)save_settings(array("index_options"=>$K["options"]));if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$b=array();foreach($K["indexes"]as$w){$B=$w["name"];if(in_array($w["type"],$fe)){$e=array();$Se=array();$cc=array();$de=(support("partial_indexes")?$w["partial"]:"");$be=(in_array($w["algorithm"],$ce)?$w["algorithm"]:"");$O=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$d){if($d!=""){$Re=idx($w["lengths"],$y);$ac=idx($w["descs"],$y);$O[]=($o[$d]?idf_escape($d):$d).($Re?"(".(+$Re).")":"").($ac?" DESC":"");$e[]=$d;$Se[]=($Re?:null);$cc[]=$ac;}}$Mc=$x[$B];if($Mc){ksort($Mc["columns"]);ksort($Mc["lengths"]);ksort($Mc["descs"]);if($w["type"]==$Mc["type"]&&array_values($Mc["columns"])===$e&&(!$Mc["lengths"]||array_values($Mc["lengths"])===$Se)&&array_values($Mc["descs"])===$cc&&$Mc["partial"]==$de&&(!$ce||$Mc["algorithm"]==$be)){unset($x[$B]);continue;}}if($e)$b[]=array($w["type"],$B,$O,$be,$de);}}foreach($x
as$B=>$Mc)$b[]=array($Mc["type"],$B,"DROP");if(!$b)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(187),alter_indexes($a,$b));}page_header(lang(139),$m,array("table"=>$a),h($a));$ad=array_keys($o);if($_POST["add"]){foreach($K["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$K["indexes"][$y]["columns"][]="";}$w=end($K["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$K["indexes"][]=array("columns"=>array(1=>""));}if(!$K){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$K["indexes"]=$x;}$Se=(JUSH=="sql"||JUSH=="mssql");$ei=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(188);$Vd=" class='idxopts".($ei?"":" hidden")."'";if($ce)echo"<th id='label-algorithm'$Vd>".lang(189).doc_link(array('sql'=>'create-index.html#create-index-storage-engine-index-types','mariadb'=>'storage-engine-index-types/','pgsql'=>'indexes-types.html',));echo'<th><input type="submit" class="wayoff">',lang(190).($Se?"<span$Vd> (".lang(191).")</span>":"");if($Se||support("descidx"))echo
checkbox("options",1,$ei,lang(111),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(192);if(support("partial_indexes"))echo"<th id='label-condition'$Vd>".lang(193);echo'<th><noscript>',icon("plus","add[0]","+",lang(112)),'</noscript>
</thead>
';if($G){echo"<tr><td>PRIMARY<td>";foreach($G["columns"]as$y=>$d)echo
select_input(" disabled",$ad,$d),"<label><input disabled type='checkbox'>".lang(59)."</label> ";echo"<td><td>\n";}$Ae=1;foreach($K["indexes"]as$w){if(!$_POST["drop_col"]||$Ae!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$Ae][type]",array(-1=>"")+$fe,$w["type"],($Ae==count($K["indexes"])?"indexesAddRow.call(this);":""),"label-type");if($ce)echo"<td$Vd>".html_select("indexes[$Ae][algorithm]",array_merge(array(""),$ce),$w['algorithm'],"label-algorithm");echo"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$Ae][columns][$t]' title='".lang(48)."'",($o&&($d==""||$o[$d])?array_combine($ad,$ad):array()),$d,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span$Vd>",($Se?"<input type='number' name='indexes[$Ae][lengths][$t]' class='size' value='".h(idx($w["lengths"],$y))."' title='".lang(110)."'>":""),(support("descidx")?checkbox("indexes[$Ae][descs][$t]",1,idx($w["descs"],$y),lang(59)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$Ae][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n";if(support("partial_indexes"))echo"<td$Vd><input name='indexes[$Ae][partial]' value='".h($w["partial"])."' autocapitalize='off' aria-labelledby='label-condition'>\n";echo"<td>".icon("cross","drop_col[$Ae]","x",lang(115)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$Ae++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(16),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$K=$_POST;if($_POST&&!$m&&!$_POST["add"]){$B=trim($K["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(194),drop_databases(array(DB)));}elseif(DB!==$B){if(DB!=""){$_GET["db"]=$B;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($B),lang(195),rename_database($B,$K["collation"]));}else{$j=explode("\n",str_replace("\r","",$B));$xi=true;$Le="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$K["collation"]))$xi=false;$Le=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($Le),lang(196),$xi);}}else{if(!$K["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($B).(preg_match('~^[a-z0-9_]+$~i',$K["collation"])?" COLLATE $K[collation]":""),substr(ME,0,-1),lang(197));}}page_header(DB!=""?lang(67):lang(119),$m,array(),h(DB));$lb=collations();$B=DB;if($_POST)$B=$K["name"];elseif(DB!="")$K["collation"]=db_collation(DB,$lb);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$wd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$wd,$A)&&$A[1]){$B=stripcslashes(idf_unescape("`$A[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($B,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($B).'</textarea><br>':'<input name="name" autofocus value="'.h($B).'" data-maxlength="64" autocapitalize="off">')."\n".($lb?html_select("collation",array(""=>"(".lang(105).")")+$lb,$K["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",)):""),'<input type="submit" value="',lang(16),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(131)."'>".confirm(lang(182,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(112))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["scheme"])){$K=$_POST;if($_POST&&!$m){$_=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$_,lang(198));else{$B=trim($K["name"]);$_
.=urlencode($B);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($B),$_,lang(199));elseif($_GET["ns"]!=$B)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($B),$_,lang(200));else
redirect($_);}}page_header($_GET["ns"]!=""?lang(68):lang(69),$m);if(!$K)$K["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" autofocus value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(16),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(131)."'>".confirm(lang(182,$_GET["ns"]))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(201).": ".h($ca),$m);$Dh=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Yd=array();$tg=array();foreach($Dh["fields"]as$t=>$n){if(substr($n["inout"],-3)=="OUT"&&JUSH=='sql')$tg[$t]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Yd[]=$t;}if(!$m&&$_POST){$Ua=array();foreach($Dh["fields"]as$y=>$n){$X="";if(in_array($y,$Yd)){$X=process_input($n);if($X===false)$X="''";if(isset($tg[$y]))connection()->query("SET @".idf_escape($n["field"])." = $X");}if(isset($tg[$y]))$Ua[]="@".idf_escape($n["field"]);elseif(in_array($y,$Yd))$Ua[]=$X;}$H=(isset($_GET["callf"])?"SELECT ":"CALL ").($Dh["returns"]["type"]=="record"?"* FROM ":"").table($ca)."(".implode(", ",$Ua).")";$si=microtime(true);$I=connection()->multi_query($H);$qa=connection()->affected_rows;echo
adminer()->selectQuery($H,$si,!$I);if(!$I)echo"<p class='error'>".error()."\n";else{$h=connect();if($h)$h->select_db(DB);do{$I=connection()->store_result();if(is_object($I))print_select_result($I,$h);else
echo"<p class='message'>".lang(202,$qa)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($tg)print_select_result(connection()->query("SELECT ".implode(", ",$tg)));}}echo'
<form action="" method="post">
';if($Yd){echo"<table class='layout'>\n";foreach($Yd
as$y){$n=$Dh["fields"][$y];$B=$n["field"];echo"<tr><th>".adminer()->fieldName($n);$Y=idx($_POST["fields"],$B);if($Y!=""){if($n["type"]=="set")$Y=implode(",",$Y);}input($n,$Y,idx($_POST["function"],$B,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(201),'">
',input_token(),'</form>

<pre>
';function
pre_tr($Hh){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($Hh))));}$R='(\+--[-+]+\+\n)';$K='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$K$R?($K*)$R?~m",function($A){$ed=pre_tr($A[2]);return"<table>\n".($A[1]?"<thead>$ed</thead>\n":$ed).pre_tr($A[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($Dh['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$B=$_GET["name"];$K=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$K["source"]=array_filter($K["source"],'strlen');ksort($K["source"]);$Mi=array();foreach($K["source"]as$y=>$X)$Mi[$y]=$K["target"][$y];$K["target"]=$Mi;}if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(" $B"=>($K["drop"]?"":" ".format_foreign_key($K))));else{$b="ALTER TABLE ".table($a);$I=($B==""||queries("$b DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($B)));if(!$K["drop"])$I=queries("$b ADD".format_foreign_key($K));}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(203):($B!=""?lang(204):lang(205))),$I);if(!$K["drop"])$m=lang(206);}page_header(lang(207),$m,array("table"=>$a),h($a));if($_POST){ksort($K["source"]);if($_POST["add"])$K["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$K["target"]=array();}elseif($B!=""){$nd=foreign_keys($a);$K=$nd[$B];$K["source"][]="";}else{$K["table"]=$a;$K["source"]=array("");}echo'
<form action="" method="post">
';$ji=array_keys(fields($a));if($K["db"]!="")connection()->select_db($K["db"]);if($K["ns"]!=""){$pg=get_schema();set_schema($K["ns"]);}$ph=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$Mi=array_keys(fields(in_array($K["table"],$ph)?$K["table"]:reset($ph)));$Zf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p><label>".lang(208).": ".html_select("table",$ph,$K["table"],$Zf)."</label>\n";if(support("scheme")){$Kh=array_filter(adminer()->schemas(),function($Jh){return!preg_match('~^information_schema$~i',$Jh);});echo"<label>".lang(79).": ".html_select("ns",$Kh,$K["ns"]!=""?$K["ns"]:$_GET["ns"],$Zf)."</label>";if($K["ns"]!="")set_schema($pg);}elseif(JUSH!="sqlite"){$Sb=array();foreach(adminer()->databases()as$k){if(!information_schema($k))$Sb[]=$k;}echo"<label>".lang(78).": ".html_select("db",$Sb,$K["db"]!=""?$K["db"]:$_GET["db"],$Zf)."</label>";}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(209),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(141),'<th id="label-target">',lang(142),'</thead>
';$Ae=0;foreach($K["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$ji,$X,($Ae==count($K["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$Mi,idx($K["target"],$y),"","label-target");$Ae++;}echo'</table>
<p>
<label>',lang(107),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$K["on_delete"]),'</label>
<label>',lang(106),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$K["on_update"]),'</label>
',doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",)),'<p>
<input type="submit" value="',lang(16),'">
<noscript><p><input type="submit" name="add" value="',lang(210),'"></noscript>
';if($B!="")echo'<input type="submit" name="drop" value="',lang(131),'">',confirm(lang(182,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$K=$_POST;$qg="VIEW";if(JUSH=="pgsql"&&$a!=""){$P=table_status1($a);$qg=strtoupper($P["Engine"]);}if($_POST&&!$m){$B=trim($K["name"]);$ya=" AS\n$K[select]";$We=ME."table=".urlencode($B);$pf=lang(211);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$B&&JUSH!="sqlite"&&$U=="VIEW"&&$qg=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($B).$ya,$We,$pf);else{$Oi=$B."_adminer_".uniqid();drop_create("DROP $qg ".table($a),"CREATE $U ".table($B).$ya,"DROP $U ".table($B),"CREATE $U ".table($Oi).$ya,"DROP $U ".table($Oi),($_POST["drop"]?substr(ME,0,-1):$We),lang(212),$pf,lang(213),$a,$B);}}if(!$_POST&&$a!=""){$K=view($a);$K["name"]=$a;$K["materialized"]=($qg!="VIEW");if(!$m)$m=error();}page_header(($a!=""?lang(44):lang(214)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(192),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$K["materialized"],lang(135)):""),'<p>';textarea("select",$K["select"]);echo'<p>
<input type="submit" value="',lang(16),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(131),'">',confirm(lang(182,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$se=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$ti=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$K=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(215));elseif(in_array($K["INTERVAL_FIELD"],$se)&&isset($ti[$K["STATUS"]])){$Ih="\nON SCHEDULE ".($K["INTERVAL_VALUE"]?"EVERY ".q($K["INTERVAL_VALUE"])." $K[INTERVAL_FIELD]".($K["STARTS"]?" STARTS ".q($K["STARTS"]):"").($K["ENDS"]?" ENDS ".q($K["ENDS"]):""):"AT ".q($K["STARTS"]))." ON COMPLETION".($K["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(216):lang(217)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Ih.($aa!=$K["EVENT_NAME"]?"\nRENAME TO ".idf_escape($K["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($K["EVENT_NAME"]).$Ih)."\n".$ti[$K["STATUS"]]." COMMENT ".q($K["EVENT_COMMENT"]).rtrim(" DO\n$K[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(218).": ".h($aa):lang(219)),$m);if(!$K&&$aa!=""){$L=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$K=reset($L);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(192),'<td><input name="EVENT_NAME" value="',h($K["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(220),'<td><input name="STARTS" value="',h("$K[EXECUTE_AT]$K[STARTS]"),'">
<tr><th title="datetime">',lang(221),'<td><input name="ENDS" value="',h($K["ENDS"]),'">
<tr><th>',lang(222),'<td><input type="number" name="INTERVAL_VALUE" value="',h($K["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$se,$K["INTERVAL_FIELD"]),'<tr><th>',lang(122),'<td>',html_select("STATUS",$ti,$K["STATUS"]),'<tr><th>',lang(50),'<td><input name="EVENT_COMMENT" value="',h($K["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$K["ON_COMPLETION"]=="PRESERVE",lang(223)),'</table>
<p>';textarea("EVENT_DEFINITION",$K["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(16),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(131),'">',confirm(lang(182,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$Dh=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$K=$_POST;$K["fields"]=(array)$K["fields"];if($_POST&&!process_fields($K["fields"])&&!$m){$mg=routine($_GET["procedure"],$Dh);$Oi="$K[name]_adminer_".uniqid();foreach($K["fields"]as$y=>$n){if($n["field"]=="")unset($K["fields"][$y]);}drop_create("DROP $Dh ".routine_id($ca,$mg),create_routine($Dh,$K),"DROP $Dh ".routine_id($K["name"],$K),create_routine($Dh,array("name"=>$Oi)+$K),"DROP $Dh ".routine_id($Oi,$K),substr(ME,0,-1),lang(224),lang(225),lang(226),$ca,$K["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(227):lang(228)).": ".h($ca):(isset($_GET["function"])?lang(229):lang(230))),$m);if(!$_POST){if($ca=="")$K["language"]="sql";else{$K=routine($_GET["procedure"],$Dh);$K["name"]=$ca;}}$lb=get_vals("SHOW CHARACTER SET");sort($lb);$Eh=routine_languages();echo($lb?"<datalist id='collations'>".optionlist($lb)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(192),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',($Eh?"<label>".lang(21).": ".html_select("language",$Eh,$K["language"])."</label>\n":""),'<input type="submit" value="',lang(16),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($K["fields"],$lb,$Dh);if(isset($_GET["function"])){echo"<tr><td>".lang(231);edit_type("returns",(array)$K["returns"],$lb,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$K["definition"],20);echo'<p>
<input type="submit" value="',lang(16),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(131),'">',confirm(lang(182,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["sequence"])){$ea=$_GET["sequence"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);$B=trim($K["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($ea),$_,lang(232));elseif($ea=="")query_redirect("CREATE SEQUENCE ".idf_escape($B),$_,lang(233));elseif($ea!=$B)query_redirect("ALTER SEQUENCE ".idf_escape($ea)." RENAME TO ".idf_escape($B),$_,lang(234));else
redirect($_);}page_header($ea!=""?lang(235).": ".h($ea):lang(236),$m);if(!$K)$K["name"]=$ea;echo'
<form action="" method="post">
<p><input name="name" value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(16),'">
';if($ea!="")echo"<input type='submit' name='drop' value='".lang(131)."'>".confirm(lang(182,$ea))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["type"])){$fa=$_GET["type"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($fa),$_,lang(237));else
query_redirect("CREATE TYPE ".idf_escape(trim($K["name"]))." $K[as]",$_,lang(238));}page_header($fa!=""?lang(239).": ".h($fa):lang(240),$m);if(!$K)$K["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($fa!=""){$rj=driver()->types();$Dc=type_values($rj[$fa]);if($Dc)echo"<code class='jush-".JUSH."'>ENUM (".h($Dc).")</code>\n<p>";echo"<input type='submit' name='drop' value='".lang(131)."'>".confirm(lang(182,$fa))."\n";}else{echo
lang(192).": <input name='name' value='".h($K['name'])."' autocapitalize='off'>\n",doc_link(array('pgsql'=>"datatype-enum.html",),"?");textarea("as",$K["as"]);echo"<p><input type='submit' value='".lang(16)."'>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$B=$_GET["name"];$K=$_POST;if($K&&!$m){if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(),"",array(),"$B",($K["drop"]?"":$K["clause"]));else{$I=($B==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($B)));if(!$K["drop"])$I=queries("ALTER TABLE ".table($a)." ADD".($K["name"]!=""?" CONSTRAINT ".idf_escape($K["name"]):"")." CHECK ($K[clause])");}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(241):($B!=""?lang(242):lang(243))),$I);}page_header(($B!=""?lang(244).": ".h($B):lang(146)),$m,array("table"=>$a));if(!$K){$cb=driver()->checkConstraints($a);$K=array("name"=>$B,"clause"=>$cb[$B]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(192).': <input name="name" value="'.h($K["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",'sqlite'=>"lang_createtable.html#check_constraints",),"?"),'<p>';textarea("clause",$K["clause"]);echo'<p><input type="submit" value="',lang(16),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(131),'">',confirm(lang(182,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$B="$_GET[name]";$nj=trigger_options();$K=(array)trigger($B,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$nj["Timing"])&&in_array($_POST["Event"],$nj["Event"])&&in_array($_POST["Type"],$nj["Type"])){$Wf=" ON ".table($a);$kc="DROP TRIGGER ".idf_escape($B).(JUSH=="pgsql"?$Wf:"");$We=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($kc,$We,lang(245));else{if($B!="")queries($kc);queries_redirect($We,($B!=""?lang(246):lang(247)),queries(create_trigger($Wf,$_POST)));if($B!="")queries(create_trigger($Wf,$K+array("Type"=>reset($nj["Type"]))));}}$K=$_POST;}page_header(($B!=""?lang(248).": ".h($B):lang(249)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(250),'<td>',html_select("Timing",$nj["Timing"],$K["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(251),'<td>',html_select("Event",$nj["Event"],$K["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$nj["Event"])?" <input name='Of' value='".h($K["Of"])."' class='hidden'>":""),'<tr><th>',lang(49),'<td>',html_select("Type",$nj["Type"],$K["Type"]),'</table>
<p>',lang(192),': <input name="Trigger" value="',h($K["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$K["Statement"]);echo'<p>
<input type="submit" value="',lang(16),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(131),'">',confirm(lang(182,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ga=$_GET["user"];$dh=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$K){foreach(explode(",",($K["Privilege"]=="Grant option"?"":$K["Context"]))as$Bb)$dh[$Bb][$K["Privilege"]]=$K["Comment"];}$dh["Server Admin"]+=$dh["File access on server"];$dh["Databases"]["Create routine"]=$dh["Procedures"]["Create routine"];unset($dh["Procedures"]["Create routine"]);$dh["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$dh["Columns"][$X]=$dh["Tables"][$X];unset($dh["Server Admin"]["Usage"]);foreach($dh["Tables"]as$y=>$X)unset($dh["Databases"][$y]);$Ef=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$Ef[$X]=(array)$Ef[$X]+idx($_POST["grants"],$y,array());}$xd=array();$Uf="";if(isset($_GET["host"])&&($I=connection()->query("SHOW GRANTS FOR ".q($ga)."@".q($_GET["host"])))){while($K=$I->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$K[0],$A)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$A[1],$df,PREG_SET_ORDER)){foreach($df
as$X){if($X[1]!="USAGE")$xd["$A[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$K[0]))$xd["$A[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$K[0],$A))$Uf=$A[1];}}if($_POST&&!$m){$Vf=(isset($_GET["host"])?q($ga)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $Vf",ME."privileges=",lang(252));else{$Gf=q($_POST["user"])."@".q($_POST["host"]);$Ig=$_POST["pass"];if($Ig!=''&&!$_POST["hashed"]&&!min_version(8)){$Ig=get_val("SELECT PASSWORD(".q($Ig).")");$m=!$Ig;}$Gb=false;if(!$m){if($Vf!=$Gf){$Gb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $Gf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Ig));$m=!$Gb;}elseif($Ig!=$Uf)queries("SET PASSWORD FOR $Gf = ".q($Ig));}if(!$m){$Ah=array();foreach($Ef
as$Of=>$wd){if(isset($_GET["grant"]))$wd=array_filter($wd);$wd=array_keys($wd);if(isset($_GET["grant"]))$Ah=array_diff(array_keys(array_filter($Ef[$Of],'strlen')),$wd);elseif($Vf==$Gf){$Sf=array_keys((array)$xd[$Of]);$Ah=array_diff($Sf,$wd);$wd=array_diff($wd,$Sf);unset($xd[$Of]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$Of,$A)&&(!grant("REVOKE",$Ah,$A[2]," ON $A[1] FROM $Gf")||!grant("GRANT",$wd,$A[2]," ON $A[1] TO $Gf"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($Vf!=$Gf)queries("DROP USER $Vf");elseif(!isset($_GET["grant"])){foreach($xd
as$Of=>$Ah){if(preg_match('~^(.+)(\(.*\))?$~U',$Of,$A))grant("REVOKE",array_keys($Ah),$A[2]," ON $A[1] FROM $Gf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(253):lang(254)),!$m);if($Gb)connection()->query("DROP USER $Gf");}}page_header((isset($_GET["host"])?lang(35).": ".h("$ga@$_GET[host]"):lang(154)),$m,array("privileges"=>array('',lang(71))));$K=$_POST;if($K)$xd=$Ef;else{$K=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$K["pass"]=$Uf;if($Uf!="")$K["hashed"]=true;$xd[(DB==""||$xd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(34),'<td><input name="host" data-maxlength="60" value="',h($K["host"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="user" data-maxlength="80" value="',h($K["user"]),'" autocapitalize="off">
<tr><th>',lang(36),'<td><input name="pass" id="pass" value="',h($K["pass"]),'" autocomplete="new-password">
',($K["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$K["hashed"],lang(255),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(71).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($xd
as$Of=>$wd){echo'<th>'.($Of!="*.*"?"<input name='objects[$t]' value='".h($Of)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(34),"Databases"=>lang(37),"Tables"=>lang(137),"Columns"=>lang(48),"Procedures"=>lang(256),)as$Bb=>$ac){foreach((array)$dh[$Bb]as$ch=>$qb){echo"<tr><td".($ac?">$ac<td":" colspan='2'").' lang="en" title="'.h($qb).'">'.h($ch);$t=0;foreach($xd
as$Of=>$wd){$B="'grants[$t][".h(strtoupper($ch))."]'";$Y=$wd[strtoupper($ch)];if($Bb=="Server Admin"&&$Of!=(isset($xd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$B><option><option value='1'".($Y?" selected":"").">".lang(257)."<option value='0'".($Y=="0"?" selected":"").">".lang(258)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$B value='1'".($Y?" checked":"").($ch=="All privileges"?" id='grants-$t-all'>":">".($ch=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(16),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(131),'">',confirm(lang(182,"$ga@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$Ge=0;foreach((array)$_POST["kill"]as$X){if(adminer()->killProcess($X))$Ge++;}queries_redirect(ME."processlist=",lang(259,$Ge),$Ge||!$_POST["kill"]);}}page_header(lang(120),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(adminer()->processList()as$t=>$K){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($K
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$K[JUSH=="sql"?"Id":"pid"],0):"");foreach($K
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$K["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($K["db"]!=""?"db=".urlencode($K["db"])."&":"")."sql=".urlencode($X)).'">'.lang(260).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(261,max_connections()),"<p><input type='submit' value='".lang(262)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$o=fields($a);$nd=column_foreign_keys($a);$Qf=$S["Oid"];$pa=get_settings("adminer_import");$Bh=array();$e=array();$Ph=array();$ig=array();$Si="";foreach($o
as$y=>$n){$B=adminer()->fieldName($n);$Cf=html_entity_decode(strip_tags($B),ENT_QUOTES);if(isset($n["privileges"]["select"])&&$B!=""){$e[$y]=$Cf;if(is_shortable($n))$Si=adminer()->selectLengthProcess();}if(isset($n["privileges"]["where"])&&$B!="")$Ph[$y]=$Cf;if(isset($n["privileges"]["order"])&&$B!="")$ig[$y]=$Cf;$Bh+=$n["privileges"];}list($M,$yd)=adminer()->selectColumnsProcess($e,$x);$M=array_unique($M);$yd=array_unique($yd);$we=count($yd)<count($M);$Z=adminer()->selectSearchProcess($o,$x);$hg=adminer()->selectOrderProcess($o,$x);$z=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$wj=>$K){$ya=convert_field($o[key($K)]);$M=array($ya?:idf_escape(key($K)));$Z[]=where_check($wj,$o);$J=driver()->select($a,$M,$Z,$M);if($J)echo
first($J->fetch_row());}exit;}$G=$yj=array();foreach($x
as$w){if($w["type"]=="PRIMARY"){$G=array_flip($w["columns"]);$yj=($M?$G:array());foreach($yj
as$y=>$X){if(in_array(idf_escape($y),$M))unset($yj[$y]);}break;}}if($Qf&&!$G){$G=$yj=array($Qf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($Qf));}if($_POST&&!$m){$Xj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$cb=array();foreach($_POST["check"]as$Ya)$cb[]=where_check($Ya,$o);$Xj[]="((".implode(") OR (",$cb)."))";}$Xj=($Xj?"\nWHERE ".implode(" AND ",$Xj):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$rd=($M?implode(", ",$M):"*").convert_fields($e,$o,$M)."\nFROM ".table($a);$_d=($yd&&$we?"\nGROUP BY ".implode(", ",$yd):"").($hg?"\nORDER BY ".implode(", ",$hg):"");$H="SELECT $rd$Xj$_d";if(is_array($_POST["check"])&&!$G){$uj=array();foreach($_POST["check"]as$X)$uj[]="(SELECT".limit($rd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$_d,1).")";$H=implode(" UNION ALL ",$uj);}adminer()->dumpData($a,"table",$H);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$nd)){if($_POST["save"]||$_POST["delete"]){$I=true;$qa=0;$O=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$B=>$X){$X=process_input($o[$B]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($B)]=($X!==false?$X:idf_escape($B));}}if($_POST["delete"]||$O){$H=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a):"");if($_POST["all"]||($G&&is_array($_POST["check"]))||$we){$I=($_POST["delete"]?driver()->delete($a,$Xj):($_POST["clone"]?queries("INSERT $H$Xj".driver()->insertReturning($a)):driver()->update($a,$O,$Xj)));$qa=connection()->affected_rows;if(is_object($I))$qa+=$I->num_rows;}else{foreach((array)$_POST["check"]as$X){$Wj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$I=($_POST["delete"]?driver()->delete($a,$Wj,1):($_POST["clone"]?queries("INSERT".limit1($a,$H,$Wj)):driver()->update($a,$O,$Wj,1)));if(!$I)break;$qa+=connection()->affected_rows;}}}$pf=lang(263,$qa);if($_POST["clone"]&&$I&&$qa==1){$Me=last_id($I);if($Me)$pf=lang(175," $Me");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$pf,$I);if(!$_POST["delete"]){$Ug=(array)$_POST["fields"];edit_form($a,array_intersect_key($o,$Ug),$Ug,!$_POST["clone"],$m);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(264);else{$I=true;$qa=0;foreach($_POST["val"]as$wj=>$K){$O=array();foreach($K
as$y=>$X){$y=bracket_escape($y,true);$O[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?adminer()->processInput($o[$y],$X):"NULL");}$I=driver()->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($wj,$o),($we||$G?0:1)," ");if(!$I)break;$qa+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(263,$qa),$I);}}elseif(!is_string($bd=get_file("csv_file",true)))$m=upload_error($bd);elseif(!preg_match('~~u',$bd))$m=lang(265);else{save_settings(array("output"=>$pa["output"],"format"=>$_POST["separator"]),"adminer_import");$I=true;$mb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$bd,$df);$qa=count($df[0]);driver()->begin();$Vh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$L=array();foreach($df[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$Vh]*)$Vh~",$X.$Vh,$ef);if(!$y&&!array_diff($ef[1],$mb)){$mb=$ef[1];$qa--;}else{$O=array();foreach($ef[1]as$t=>$jb)$O[idf_escape($mb[$t])]=($jb==""&&$o[$mb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$jb)?str_replace('""','"',substr($jb,1,-1)):$jb));$L[]=$O;}}$I=(!$L||driver()->insertUpdate($a,$L,$G));if($I)driver()->commit();queries_redirect(remove_from_uri("page"),lang(266,$qa),$I);driver()->rollback();}}}$Di=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(53).": $Di",$m);$O=null;if(isset($Bh["insert"])||!support("table")){$zg=array();foreach((array)$_GET["where"]as$X){if(isset($nd[$X["col"]])&&count($nd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$zg["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$O=$zg?"&".http_build_query($zg):"";}adminer()->selectLinks($S,$O);if(!$e&&support("table"))echo"<p class='error'>".lang(267).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($M,$e);adminer()->selectSearchPrint($Z,$Ph,$x);adminer()->selectOrderPrint($hg,$ig,$x);adminer()->selectLimitPrint($z);adminer()->selectLengthPrint($Si);adminer()->selectActionPrint($x);echo"</form>\n";$D=$_GET["page"];$qd=null;if($D=="last"){$qd=get_val(count_rows($a,$Z,$we,$yd));$D=floor(max(0,intval($qd)-1)/$z);}$Qh=$M;$zd=$yd;if(!$Qh){$Qh[]="*";$Cb=convert_fields($e,$o,$M);if($Cb)$Qh[]=substr($Cb,2);}foreach($M
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($ya=convert_field($n)))$Qh[$y]="$ya AS $X";}if(!$we&&$yj){foreach($yj
as$y=>$X){$Qh[]=idf_escape($y);if($zd)$zd[]=idf_escape($y);}}$I=driver()->select($a,$Qh,$Z,$zd,$hg,$z,$D,true);if(!$I)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$D)$I->seek($z*$D);$xc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$L=array();while($K=$I->fetch_assoc()){if($D&&JUSH=="oracle")unset($K["RNUM"]);$L[]=$K;}if($_GET["page"]!="last"&&$z&&$yd&&$we&&JUSH=="sql")$qd=get_val(" SELECT FOUND_ROWS()");if(!$L)echo"<p class='message'>".lang(14)."\n";else{$Ga=adminer()->backwardKeys($a,$Di);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$yd&&$M?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(268)."</a>");$Df=array();$td=array();reset($M);$mh=1;foreach($L[0]as$y=>$X){if(!isset($yj[$y])){$X=idx($_GET["columns"],key($M))?:array();$n=$o[$M?($X?$X["col"]:current($M)):$y];$B=($n?adminer()->fieldName($n,$mh):($X["fun"]?"*":h($y)));if($B!=""){$mh++;$Df[$y]=$B;$d=idf_escape($y);$Pd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$ac="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$sd=apply_sql_function($X["fun"],$B);$ii=isset($n["privileges"]["order"])||$sd;echo($ii?"<a href='".h($Pd.($hg[0]==$d||$hg[0]==$y?$ac:''))."'>$sd</a>":$sd),"<span class='column hidden'>";if($ii)echo"<a href='".h($Pd.$ac)."' title='".lang(59)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($n["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(56).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$td[$y]=$X["fun"];next($M);}}$Se=array();if($_GET["modify"]){foreach($L
as$K){foreach($K
as$y=>$X)$Se[$y]=max($Se[$y],min(40,strlen(utf8_decode($X))));}}echo($Ga?"<th>".lang(269):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($L,$nd)as$Bf=>$K){$vj=unique_array($L[$Bf],$x);if(!$vj){$vj=array();reset($M);foreach($L[$Bf]as$y=>$X){if(!preg_match('~^(COUNT|AVG|GROUP_CONCAT|MAX|MIN|SUM)\(~',current($M)))$vj[$y]=$X;next($M);}}$wj="";foreach($vj
as$y=>$X){$n=(array)$o[$y];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$n["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$n["collation"])?$y:"CONVERT($y USING ".charset(connection()).")").")";$X=md5($X);}$wj
.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$yd&&$M?"":"<td>".checkbox("check[]",substr($wj,1),in_array(substr($wj,1),(array)$_POST["check"])).($we||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$wj)."' class='edit'>".lang(270)."</a>"));reset($M);foreach($K
as$y=>$X){if(isset($Df[$y])){$d=current($M);$n=(array)$o[$y];$X=driver()->value($X,$n);if($X!=""&&(!isset($xc[$y])||$xc[$y]!=""))$xc[$y]=(is_mail($X)?$Df[$y]:"");$_="";if(is_blob($n)&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$wj;if(!$_&&$X!==null){foreach((array)$nd[$y]as$q){if(count($nd[$y])==1||end($q["source"])==$y){$_="";foreach($q["source"]as$t=>$ji)$_
.=where_link($t,$q["target"][$t],$L[$Bf][$ji]);$_=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$_;if($q["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$_);if(count($q["source"])==1)break;}}}if($d=="COUNT(*)"){$_=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$vj))$_
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($vj
as$Ce=>$W)$_
.=where_link($t++,$Ce,$W);}$Qd=select_value($X,$_,$n,$Si);$u=h("val[$wj][".bracket_escape($y)."]");$Vg=idx(idx($_POST["val"],$wj),bracket_escape($y));$sc=!is_array($K[$y])&&is_utf8($Qd)&&$L[$Bf][$y]==$K[$y]&&!$td[$y]&&!$n["generated"];$U=(preg_match('~^(AVG|MIN|MAX)\((.+)\)~',$d,$A)?$o[idf_unescape($A[2])]["type"]:$n["type"]);$Qi=preg_match('~text|json|lob~',$U);$xe=preg_match(number_type(),$U)||preg_match('~^(CHAR_LENGTH|ROUND|FLOOR|CEIL|TIME_TO_SEC|COUNT|SUM)\(~',$d);echo"<td id='$u'".($xe&&($X===null||is_numeric(strip_tags($Qd))||$U=="money")?" class='number'":"");if(($_GET["modify"]&&$sc&&$X!==null)||$Vg!==null){$Cd=h($Vg!==null?$Vg:$K[$y]);echo">".($Qi?"<textarea name='$u' cols='30' rows='".(substr_count($K[$y],"\n")+1)."'>$Cd</textarea>":"<input name='$u' value='$Cd' size='$Se[$y]'>");}else{$Ye=strpos($Qd,"<i>…</i>");echo" data-text='".($Ye?2:($Qi?1:0))."'".($sc?"":" data-warning='".h(lang(271))."'").">$Qd";}}next($M);}if($Ga)echo"<td>";adminer()->backwardKeysPrint($Ga,$L[$Bf]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($L||$D){$Kc=true;if($_GET["page"]!="last"){if(!$z||(count($L)<$z&&($L||!$D)))$qd=($D?$D*$z:0)+count($L);elseif(JUSH!="sql"||!$we){$qd=($we?false:found_rows($S,$Z));if(intval($qd)<max(1e4,2*($D+1)*$z))$qd=first(slow_query(count_rows($a,$Z,$we,$yd)));else$Kc=false;}}$xg=($z&&($qd===false||$qd>$z||$D));if($xg)echo(($qd===false?count($L)+1:$qd-$D*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($D+1)).'" class="loadmore">'.lang(272).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $z, '".lang(273)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($xg){$if=($qd===false?$D+(count($L)>=$z?2:1):floor(($qd-1)/$z));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(274)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(274)."', '".($D+1)."')); return false; };"),pagination(0,$D).($D>5?" …":"");for($t=max(1,$D-4);$t<min($if,$D+5);$t++)echo
pagination($t,$D);if($if>0)echo($D+5<$if?" …":""),($Kc&&$qd!==false?pagination($if,$D):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$if'>".lang(275)."</a>");}else
echo"<legend>".lang(274)."</legend>",pagination(0,$D).($D>1?" …":""),($D?pagination($D,$D):""),($if>$D?pagination($D+1,$D).($if>$D+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(276)."</legend>";$hc=($Kc?"":"~ ").$qd;$ag="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$hc' : checked); selectCount('selected2', this.checked || !checked ? '$hc' : checked);";echo
checkbox("all",1,0,($qd!==false?($Kc?"":"~ ").lang(158,$qd):""),$ag)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(268),'</legend><div>
<input type="submit" value="',lang(16),'"',($_GET["modify"]?'':' title="'.lang(264).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(130),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(12),'">
<input type="submit" name="clone" value="',lang(260),'">
<input type="submit" name="delete" value="',lang(20),'">',confirm(),'</div></fieldset>
';$od=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($od['sql']);break;}}if($od){print_fieldset("export",lang(76)." <span id='selected2'></span>");$ug=adminer()->dumpOutput();echo($ug?html_select("output",$ug,$pa["output"])." ":""),html_select("format",$od,$pa["format"])," <input type='submit' name='export' value='".lang(76)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($xc,'strlen'),$e);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<p>","<a href='#import'>".lang(75)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ",file_input("<input type='file' name='csv_file'> ".html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$pa["format"])." <input type='submit' name='import' value='".lang(75)."'>"),"</span>";echo
input_token(),"</form>\n",(!$yd&&$M?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(122):lang(121));$Nj=($P?show_status():show_variables());if(!$Nj)echo"<p class='message'>".lang(14)."\n";else{echo"<table>\n";foreach($Nj
as$K){echo"<tr>";$y=array_shift($K);echo"<th><code class='jush-".JUSH.($P?"status":"set")."'>".h($y)."</code>";foreach($K
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$_i=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$B=>$S){json_row("Comment-$B",h($S["Comment"]));if(!is_view($S)||preg_match('~materialized~i',$S["Engine"])){foreach(array("Engine","Collation")as$y)json_row("$y-$B",h($S[$y]));foreach($_i+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$B",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($_i[$y]))$_i[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$B","?");}}}foreach($_i
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$Ki=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Ki&&!$m&&!$_POST["search"]){$I=true;$pf="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$I=truncate_tables($_POST["tables"]);$pf=lang(277);}elseif($_POST["move"]){$I=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$pf=lang(278);}elseif($_POST["copy"]){$I=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$pf=lang(279);}elseif($_POST["drop"]){if($_POST["views"])$I=drop_views($_POST["views"]);if($I&&$_POST["tables"])$I=drop_tables($_POST["tables"]);$pf=lang(280);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$K)$pf
.="<b>".h($R)."</b>: ".h($K["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$I=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$pf=lang(281);}elseif(!$_POST["tables"])$pf=lang(11);elseif($I=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($K=$I->fetch_assoc())$pf
.="<b>".h($K["Table"])."</b>: ".h($K["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$pf,$I);}page_header(($_GET["ns"]==""?lang(37).": ".h(DB):lang(79).": ".h($_GET["ns"])),$m,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(282)."</h3>\n";$Ji=tables_list();if(!$Ji)echo"<p class='message'>".lang(11)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(283)." <span id='selected2'></span></legend><div>",html_select("op",adminer()->operators(),idx($_POST,"op",JUSH=="elastic"?"should":"LIKE %%"))," <input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(56)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$_POST["op"];search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(137),'<td>'.lang(284).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(126).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(285).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(286).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(287).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(51).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(288).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(50).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$T=0;foreach($Ji
as$B=>$U){$Qj=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$B);echo'<tr><td>'.checkbox(($Qj?"views[]":"tables[]"),$B,in_array("$B",$Ki,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($B)."' title='".lang(42)."' id='$u'>".h($B).'</a>':h($B));if($Qj&&!preg_match('~materialized~i',$U)){$Wi=lang(136);echo'<td colspan="6">'.(support("view")?"<a href='".h(ME)."view=".urlencode($B)."' title='".lang(44)."'>$Wi</a>":$Wi),'<td align="right"><a href="'.h(ME)."select=".urlencode($B).'" title="'.lang(41).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(43)),"Index_length"=>array("indexes",lang(140)),"Data_free"=>array("edit",lang(45)),"Auto_increment"=>array("auto_increment=1&create",lang(43)),"Rows"=>array("select",lang(41)),)as$y=>$_){$u=" id='$y-".h($B)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($B)."'$u title='$_[1]'>?</a>":"<span$u>?</span>"):"<td id='$y-".h($B)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($B)."'>":""),"\n";}echo"<tr><td><th>".lang(261,count($Ji)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n",script("ajaxSetHtml('".js_escape(ME)."script=db');"),"</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Kj="<input type='submit' value='".lang(289)."'> ".on_help("'VACUUM'");$dg="<input type='submit' name='optimize' value='".lang(290)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(130)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$Kj."<input type='submit' name='check' value='".lang(291)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$Kj.$dg:(JUSH=="sql"?"<input type='submit' value='".lang(292)."'> ".on_help("'ANALYZE TABLE'").$dg."<input type='submit' name='check' value='".lang(291)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(293)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(294)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(131)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?adminer()->schemas():adminer()->databases());echo"</div></fieldset>\n";$Nh="";if(count($j)!=1&&JUSH!="sqlite"){echo"<fieldset><legend>".lang(295)." <span id='selected3'></span></legend><div>";$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">'),"</label> <input type='submit' name='move' value='".lang(296)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(297)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(298)):""),"</div></fieldset>\n";$Nh=" selectCount('selected3', formChecked(this, /^(tables|views)\[/));";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")."$Nh }"),input_token(),"</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(77)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(214)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(72)."</h3>\n";$Fh=routines();if($Fh){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(192).'<td>'.lang(49).'<td>'.lang(231)."<td></thead>\n";foreach($Fh
as$K){$B=($K["SPECIFIC_NAME"]==$K["ROUTINE_NAME"]?"":"&name=".urlencode($K["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.h($K["ROUTINE_NAME"]).'</a>','<td>'.h($K["ROUTINE_TYPE"]),'<td>'.h($K["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.lang(143)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(230).'</a>':'').'<a href="'.h(ME).'function=">'.lang(229)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(73)."</h3>\n";$Yh=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($Yh){echo"<table class='odds'>\n","<thead><tr><th>".lang(192)."</thead>\n";foreach($Yh
as$X)echo"<tr><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(236)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(6)."</h3>\n";$Ij=types();if($Ij){echo"<table class='odds'>\n","<thead><tr><th>".lang(192)."</thead>\n";foreach($Ij
as$X)echo"<tr><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(240)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(74)."</h3>\n";$L=get_rows("SHOW EVENTS");if($L){echo"<table>\n","<thead><tr><th>".lang(192)."<td>".lang(299)."<td>".lang(220)."<td>".lang(221)."<td></thead>\n";foreach($L
as$K)echo"<tr>","<th>".h($K["Name"]),"<td>".($K["Execute at"]?lang(300)."<td>".$K["Execute at"]:lang(222)." ".$K["Interval value"]." ".$K["Interval field"]."<td>$K[Starts]"),"<td>$K[Ends]",'<td><a href="'.h(ME).'event='.urlencode($K["Name"]).'">'.lang(143).'</a>';echo"</table>\n";$Ic=get_val("SELECT @@event_scheduler");if($Ic&&$Ic!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Ic)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(219)."</a>\n";}}}}page_footer();