-- Add table "notif_inbox"

CREATE TABLE notiftable_inbox (
   inbox_id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1),
   notif_id INTEGER NOT NULL,
   login VARCHAR(255) NOT NULL,
   notif_dtsent datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
   notif_ontop INTEGER NOT NULL DEFAULT '0',
   notif_isread INTEGER NOT NULL DEFAULT '0',
   notif_dtread datetime DEFAULT NULL,
   notif_tags VARCHAR(255) DEFAULT NULL,
   notif_important INTEGER DEFAULT NULL,
   PRIMARY KEY (inbox_id)
)

-- Add table "notif_pref"

CREATE TABLE notiftable_pref (
  login VARCHAR(255) NOT NULL,
  receive_email INTEGER NOT NULL DEFAULT '0',
  receive_sms INTEGER NOT NULL DEFAULT '0',
  PRIMARY KEY (login)
)

-- Add table "notif_tags"

CREATE TABLE notiftable_tags (
  tag_id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1),
  tag_title VARCHAR(50) NOT NULL,
  login VARCHAR(255) NOT NULL,
  tag_color VARCHAR(100) DEFAULT NULL,
  tag_active INTEGER NOT NULL DEFAULT '1',
  PRIMARY KEY (tag_id)
)

-- Add table "notif_notifications"

CREATE TABLE notiftable_notifications (
   notif_id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1),
   notif_title VARCHAR(255) NOT NULL,
   notif_message CLOB NOT NULL,
   notif_dtcreated datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
   notif_ontop INTEGER NOT NULL DEFAULT '0',
   notif_dtexpire datetime DEFAULT NULL,
   notif_categ VARCHAR(60) DEFAULT NULL,
   notif_login_sender VARCHAR(255) NOT NULL,
   notif_type VARCHAR(60) DEFAULT NULL,
   notif_link VARCHAR(255) DEFAULT NULL,
   deleted_at datetime DEFAULT NULL,
   PRIMARY KEY (notif_id)
)

-- Add table "notif_profiles"

CREATE TABLE notiftable_profiles (
    profile_id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1),
    profile_name VARCHAR(255) NOT NULL,
    profile_users CLOB NULL,
    profile_groups CLOB NULL,
    profile_public INTEGER NOT NULL DEFAULT '0',
    profile_owner VARCHAR(255) NULL,
    PRIMARY KEY (profile_id)
)


-- Add table "notif_user_tags"                                                  #

CREATE TABLE notiftable_user_tags (
    user_tags_id INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1),
    login VARCHAR(255) NOT NULL,
    login_sender VARCHAR(255) NOT NULL,
    tags VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (user_tags_id)
)
