<?php

function generateOutput($nm_config, $nm_db)
{
    /*---------- Gera resumo dos Projetos e exporta Eventos ----------*/
    $rapls     = array();
    $totais    = array();
    $totais['proj']    = 0;
    $totais['apls']    = 0;
    $totais['cmps']    = 0;
    $totais['mets']    = 0;
    $totais['lin_met'] = 0;
    $totais['evts']    = 0;
    $totais['lin_evt'] = 0;
    $ind_proj          = 0;

    $arq_evt = $nm_config['path_scase'] . "tmp/sc_events_info.txt";
    $arq_prj = $nm_config['path_scase'] . "tmp/sc_projets_info.txt";
    $arq_zip = $nm_config['path_scase'] . "tmp/sc_scriptcase_info.zip";

    $arqE = fopen($arq_evt, "w"); //---- Arquivo saida Eventos

    /*---- Acessa lista de Progetos ----*/
    $rprj = $nm_db->execute("SELECT Cod_Prj, Descricao FROM sc_tbprj where Cod_Prj <> 'NetMake' order by Cod_Prj");
    if ($rprj === false) {
        echo "Erro de acesso Projetos. Msg: " . $rprj->ErrorMsg();
        exit;
    }
    elseif ($rprj->EOF) {
        echo "Base de dados n�o tem Projetos.";
        exit;
    }

    /*---- Analisa Conteudo dos Projetos ----*/
    while (!$rprj->EOF)
    {
        $rapls[$ind_proj]['projeto']   = $rprj->fields[0];
        $rapls[$ind_proj]['descricao'] = $rprj->fields[1];
        $totais['proj']++;

        /*--- Aplicacoes ---*/
        $rapl = $nm_db->execute("SELECT count(*) FROM sc_tbapl where  Cod_Prj = '" . $rprj->fields[0] . "'");
        if ($rapl === false) {
            echo "Erro de acesso Aplica��es. Mensagem = " . $rapl->ErrorMsg();
            exit;
        }
        elseif ($rapl->EOF) {
            $rapls[$ind_proj]['qtd_apls'] = 0;
        }
        else {
            $rapls[$ind_proj]['qtd_apls'] = $rapl->fields[0];
            $totais['apls'] += $rapl->fields[0];
        }
        $rapl->Close();

        /*--- Campos ---*/
        $rcmp = $nm_db->execute("SELECT count(*) FROM sc_tbcmp where  Cod_Prj = '" . $rprj->fields[0] . "'");
        if ($rcmp === false) {
            echo "Erro de acesso Campos. Mensagem = " . $rcmp->ErrorMsg();
            exit;
        }
        elseif ($rcmp->EOF) {
            $rapls[$ind_proj]['qtd_campos'] = 0;
        }
        else {
            $rapls[$ind_proj]['qtd_campos'] = $rcmp->fields[0];
            $totais['cmps'] += $rcmp->fields[0];
        }

        /*--- Eventos ---*/
        $evt_qt  = 0;
        $evt_lin = 0;
        $met_qt  = 0;
        $met_lin = 0;
        $revt = $nm_db->execute("SELECT Cod_Apl, Nome, Tipo, Parms, Codigo FROM sc_tbevt where  Cod_Prj = '" . $rprj->fields[0] . "' and Tipo <> 'P' order by Cod_Apl, Tipo, Nome");
        if ($revt === false) {
            echo "Erro de acesso Eventos. Mensagem = " . $revt->ErrorMsg();
            exit;
        }
        while (!$revt->EOF ) {
            $temp_lin = 0;
            if(isset($revt->fields[4]) && !empty($revt->fields[4]))
            {
                $temp_lin = count(explode("\r\n", $revt->fields[4]));
            }
            if ($revt->fields[2] == "E" || $revt->fields[2] == "A") {
                $evt_qt++;
                $evt_lin += $temp_lin;
                $totais['mets']++;
                $totais['lin_met'] += $temp_lin;
            }
            else {
                $met_qt++;
                $met_lin += $temp_lin;
                $totais['evts']++;
                $totais['lin_evt'] += $temp_lin;
            }
            $tp = '';
            if ($revt->fields[2] == "A") {$tp = 'Evento AJAX';}
            if ($revt->fields[2] == "E") {$tp = 'Evento PHP';}
            if ($revt->fields[2] == "J") {$tp = 'Metodo JavaScript';}
            if ($revt->fields[2] == "M") {$tp = 'Metodo PHP';}
            $w_evt  = "<-------> PRJ:" . $rprj->fields[0];
            $w_evt .= " ---> APL:" . $revt->fields[0];
            $w_evt .= " ---> Tipo:" . $tp;
            $w_evt .= " ---> Nome:" . $revt->fields[1];
            $w_evt .= " ---> Parms:" . $revt->fields[3];
            fwrite ($arqE, $w_evt . "\r\n");
            fwrite ($arqE, $revt->fields[4] . "\r\n\r\n");
            $revt->MoveNext();
        }
        $revt->Close();
        $rapls[$ind_proj]['qtd_eventos'] = $evt_qt;
        $rapls[$ind_proj]['lin_eventos'] = $evt_lin;
        $rapls[$ind_proj]['qtd_metodos'] = $met_qt;
        $rapls[$ind_proj]['lin_metodos'] = $met_lin;
        $ind_proj++;
        $rprj->MoveNext();
    }
    $rprj->Close();
    fclose ($arqE);

    /*--- Grava analise dos Projetos ---*/
    $arq = fopen($arq_prj, "w");
    fwrite ($arq, "----------------- An�lise Individual dos Projetos -----------------\r\n");
    fwrite ($arq, print_r($rapls, true) . "\r\n");
    fwrite ($arq, "\r\n----------------- RESUMO -----------------\r\n");
    fwrite ($arq, print_r($totais, true) . "\r\n");
    fclose ($arq);

    /*--- Grava ZIP ---*/
    if (is_file($arq_zip)) {
        unlink($arq_zip);
    }
    if (FALSE !== strpos(strtolower(php_uname()), 'windows'))  {
        chdir($nm_config['path_scase'] . "prod/third/zip/windows");
        $str_zip = "zip.exe -j \"" . $arq_zip . "\" \"" . $arq_prj . "\"";
        exec($str_zip);
        $str_zip = "zip.exe -j -u \"" . $arq_zip . "\" \"" . $arq_evt . "\"";
        exec($str_zip);
    }
    elseif (FALSE !== strpos(strtolower(php_uname()), 'linux')) {
        if (FALSE !== strpos(strtolower(php_uname()), 'i686')) {
            chdir($nm_config['path_scase'] . "prod/third/zip/linux-i386/bin");
        }
        else {
            chdir($nm_config['path_scase'] . "prod/third/zip/linux-amd64/bin");
        }
        $str_zip = "./7za a \"" . $arq_zip . "\" \"" . $arq_prj . "\"";
        //$fp = fopen($arq_log, 'a');
        $str_zip = "./7za a \"" . $arq_zip . "\" \"" . $arq_evt . "\"";
        exec($str_zip);
    }
    elseif (FALSE !== strpos(strtolower(php_uname()), 'darwin')) {
        chdir($nm_config['path_scase'] . "prod/third/zip/mac/bin");
        $str_zip = "./7za a \"" . $arq_zip . "\" \"" . $arq_prj . "\"";
        exec($str_zip);
        $str_zip = "./7za a \"" . $arq_zip . "\" \"" . $arq_evt . "\"";
        exec($str_zip);
    }

    unlink($arq_prj);
    unlink($arq_evt);

    /*--- Exibe Saida ---*/
    $idioma = (isset($_SERVER["HTTP_ACCEPT_LANGUAGE"]) && substr($_SERVER["HTTP_ACCEPT_LANGUAGE"], 0, 2) != "pt") ? "us" : "pt";
    $mens1['pt'] = "Analise Concluida com Sucesso";
    $mens2['pt'] = "Arquivo .ZIP contendo as informacoes:";
    $mens3['pt'] = "Para salvar o arquivo, clique com o botao direito e escolha a opcao de salvar.";
    $mens4['pt'] = "Este arquivo foi gravado no diretorio \"tmp\" do Scriptcase.";
    $mens1['us'] = "Analysis Completed Successfully";
    $mens2['us'] = ".ZIP file containing the information:";
    $mens3['us'] = "To save the file, right-click and choose the save option.";
    $mens4['us'] = "This file was saved in the Scriptcase \"tmp\" directory.";

    echo "<html>\r\n";
    echo "<head>\r\n";
    echo "<META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\r\n";
    echo "</head>\r\n";
    echo "<body>\r\n";
    echo "<table align='center'><tr><td>\r\n";
    echo "<br><tr><td>\r\n";
    echo "<b><u><font size='5'>" . $mens1[$idioma] . "</font></u></b><br><br>\r\n";
    echo $mens2[$idioma] . "\r\n";
    echo "<a href=\"". $nm_config['url_tmp'] ."sc_scriptcase_info.zip\">sc_scriptcase_info.zip</a>\r\n";
    echo "</td></tr>\r\n";
    echo "<br><br><tr><td>\r\n";
    echo "<b>Obs:</b> 1 - " . $mens3[$idioma] . "\r\n";
    echo "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 2 - " . $mens4[$idioma] . "\r\n";
    echo "</td></tr>\r\n";
    echo "</table>\r\n";
    echo "</body>\r\n";
    echo "</html>\r\n";
    exit;
}


/* Conecta ao banco */
function nm_db_connect_sys()
{
    global $arr_dbms, $arr_err, $arr_form;
    /* Verifica se o PHP esta com suporte para o banco de dados */
    if (!extension_loaded(nm_db_module($arr_form['db_dbms'])))
    {
        $arr_err[] = 'O m�dulo do PHP respons�vel pelo banco de dados ' . $arr_dbms[$arr_form['db_dbms']] . ' n�o est� carregado.';
        return FALSE;
    }
    /* Prepara parametros para a conexao */
    $arrExtraArgs   = array();
    $bol_persistent = false;
    if ('ado_mssql' == $arr_form['db_dbms'])
    {
        $str_host  = 'PROVIDER=MSDASQL;DRIVER={SQL Server};';
        $str_host .= 'SERVER='   . $arr_form['db_host'] . ';';
        $str_host .= 'UID='      . $arr_form['db_user'] . ';';
        $str_host .= 'PWD='      . $arr_form['db_pass'] . ';';
        $str_host .= 'DATABASE=' . $arr_form['db_base'] . ';';
        $str_user  = '';
        $str_pass  = '';
        $str_base  = '';
    }elseif ('adooledb_mssql' == $arr_form['db_dbms'])
    {
        $str_host  = 'PROVIDER=SQLOLEDB;';
        $str_host .= 'Data Source='   . $arr_form['db_host'] . ';';
        $str_host .= 'uid='      . $arr_form['db_user'] . ';';
        $str_host .= 'pwd='      . $arr_form['db_pass'] . ';';
        $str_host .= 'DATABASE=' . $arr_form['db_base'] . ';';
        $str_user  = '';
        $str_pass  = '';
        $str_base  = '';
    }elseif ('db2' == $arr_form['db_dbms'])
    {
        if(empty($arr_form['db_user']))
        {
            $bol_persistent = true;

            $str_host  = "";
            $str_user  = "";
            $str_pass  = "";
            $str_base  = "";
            $arrExtraArgs = array();
            $arrExtraArgs['i5_lib'] = $arr_form['db_base'];
            $arrExtraArgs['autocommit'] = DB2_AUTOCOMMIT_ON;
        }else
        {
            $str_host  = $arr_form['db_host'];
            $str_user  = $arr_form['db_user'];
            $str_pass  = $arr_form['db_pass'];
            $str_base  = $arr_form['db_base'];
        }
    }
    elseif ('db2_odbc' == $arr_form['db_dbms'])
    {
        $str_host  = "driver={IBM db2 odbc DRIVER};Database=". $arr_form['db_base'] .";hostname=". $arr_form['db_host'] .";port=50000;protocol=TCPIP;";
        $str_host .= "uid=". $arr_form['db_user'] ."; pwd=" . $arr_form['db_pass'];
        $str_user  = '';
        $str_pass  = '';
        $str_base  = '';
    }
    elseif ('pdosqlite' == $arr_form['db_dbms'])
    {
        $str_host = $arr_form['db_host'];
        $str_user = $arr_form['db_user'];
        $str_pass = $arr_form['db_pass'];
        $str_base = $arr_form['db_base'];

        $str_host = "sqlite:" . $str_host;
    }
    elseif ('pdo_informix' == $arr_form['db_dbms'])
    {
        $str_host = $arr_form['db_host'];
        $str_user = $arr_form['db_user'];
        $str_pass = $arr_form['db_pass'];
        $str_base = $arr_form['db_base'];

        if(empty($str_host) && !empty($str_base))
        {
            $str_host = "informix:DSN=" . $str_host;
            $str_base = "";
        }else
        {
            $str_port   = "9088";
            $str_server = "";
            if(strpos($str_host, ":") !== false)
            {
                $arr_tmp_list_change = explode(":", $str_host);
                list($str_host, $str_port) = $arr_tmp_list_change;
            }
            if(strpos($str_host, "\\") !== false)
            {
                $arr_tmp_list_change = explode("\\", $str_host);
                list($str_host, $str_server) = $arr_tmp_list_change;
            }
            $str_host = "informix:host=". $str_host ."; service=". $str_port ."; database=". $str_base ."; server=". $str_server ."; protocol=onsoctcp; EnableScrollableCursors=1";
        }
    }
    elseif ('pdo_mysql' == $arr_form['db_dbms'])
    {
        $str_host = $arr_form['db_host'];
        $port = "";
        if(strpos($str_host, ":") !== false)
        {
            $arr_tmp_list_change = explode(":", $str_host);
            list($str_host, $port) = $arr_tmp_list_change;
        }

        $str_host = "mysql:host=" . $str_host;
        if(!empty($port))
        {
            $str_host .= ";port=" . $port;
        }
        $str_user = $arr_form['db_user'];
        $str_pass = $arr_form['db_pass'];
        $str_base = $arr_form['db_base'];
    }
    elseif ('pdo_pgsql' == $arr_form['db_dbms'])
    {
        $str_host = $arr_form['db_host'];
        $port = "";
        if(strpos($str_host, ":") !== false)
        {
            $arr_tmp_list_change = explode(":", $str_host);
            list($str_host, $port) = $arr_tmp_list_change;
        }

        $str_host = "pgsql:host=" . $str_host;
        if(!empty($port))
        {
            $str_host .= ";port=" . $port;
        }
        $str_user = $arr_form['db_user'];
        $str_pass = $arr_form['db_pass'];
        $str_base = $arr_form['db_base'];
    }
    else
    {
        $str_host = $arr_form['db_host'];
        $str_user = $arr_form['db_user'];
        $str_pass = $arr_form['db_pass'];
        $str_base = $arr_form['db_base'];
    }

    //teste sybase
    if ('sybase' == $arr_form['db_dbms'] || 'sqlanywhere' == $arr_form['db_dbms'])
    {
        sybase_min_client_severity(11);
        sybase_min_server_severity(11);
    }

    /* Cria nova conexao ADOdb */
    $obj_db = ADONewConnection(nm_db_adodb_module($arr_form['db_dbms']));

    if($bol_persistent)
    {
        $obj_db->PConnect($str_host, $str_user, $str_pass, $str_base, $arrExtraArgs);
    }else
    {
        $obj_db->Connect($str_host, $str_user, $str_pass, $str_base, false, $arrExtraArgs);
    }

    /* Verifica sucesso da conexao */
    if (FALSE != $obj_db->_connectionID)
    {
        if ('interbase' == nm_db_module($arr_form['db_dbms']))
        {
            ibase_timefmt('%Y-%m-%d %H:%M:%S');
        }
        elseif ('sybase' == $arr_form['db_dbms'] || 'sqlanywhere' == $arr_form['db_dbms'])
        {
            sybase_min_client_severity(11);
            sybase_min_server_severity(11);
        }

        return $obj_db;
    }
    else
    {
        $arr_err[] = 'Ocorreu um erro ao realizar a conex�o com o servidor de banco de dados.<HR>' . $obj_db->ErrorMsg();
        return FALSE;
    }
} // nm_db_connect

/* Retorna o modulo PHP do banco */
if(!function_exists("nm_db_module")) {
    function nm_db_module($v_str_dbms)
    {
        switch ($v_str_dbms) {
            /* ADO */
            case 'ado':
            case 'ado_access':
            case 'ado_mssql':
                if (5 >= nm_php_version()) {
                    return 'com_dotnet';
                } else {
                    return 'com';
                }
                break;
            /* Frontbase */
            case 'fbsql':
                return 'fbsql';
                break;
            /* IBM Db2 */
            case 'db2':
            case 'db2_odbc':
                return 'ibm_db2';
                break;
            /* Informix */
            case 'informix':
            case 'informix72':
                return 'informix';
                break;
            /* Interbase */
            case 'borland_ibase':
            case 'firebird':
            case 'ibase':
                return 'interbase';
                break;
            /* MS SQL Server */
            case 'mssql':
            case 'mssqlpo':
                return 'mssql';
                break;
            /* MS SQL Server Nativo SRV */
            case 'mssqlnative':
                return 'sqlsrv';
                break;
            /* MySQL */
            case 'maxsql':
            case 'mysql':
            case 'mysqlt':
                return 'mysql';
                break;
            /* ODBC */
            case 'access':
            case 'odbc_db2':
            case 'odbc_db2v6':
            case 'odbc':
            case 'odbc_access':
            case 'odbc_mssql':
            case 'odbc_oracle':
            case 'sapdb':
            case 'sqlanywhere':
            case 'vfp':
                return 'odbc';
                break;
            /* Oracle */
            case 'oci8':
            case 'oci805':
            case 'oci8po':
                return 'oci8';
                break;
            case 'oracle':
                return 'oracle';
                break;
            /* SQLite PDO */
            case 'pdosqlite':
            case 'pdo_informix':
            case 'pdo_mysql':
            case 'pdo_pgsql':
                return 'pdo';
                break;
            /* PostGreSQL */
            case 'postgres':
            case 'postgres64':
            case 'postgres7':
                return 'pgsql';
                break;
            /* SQLite */
            case 'sqlite':
                return 'sqlite';
                break;
            /* Sybase */
            case 'sybase':
                return 'sybase_ct';
                break;
            /* Outros */
            default:
                return FALSE;
                break;
        }
    } // nm_db_module
}

/* Retorna o modulo adodb do banco */
    if(!function_exists("nm_db_adodb_module")) {
        function nm_db_adodb_module($v_str_dbms)
        {
            switch ($v_str_dbms) {
                /* DB2 */
                case 'db2_odbc':
                    return 'db2';
                    break;
                /* DB2 */
                case 'odbc_db2v6':
                    return 'odbc_db2';
                    break;
                /* SQLite PDO */
                case 'pdosqlite':
                case 'pdo_informix':
                case 'pdo_mysql':
                case 'pdo_pgsql':
                case 'pdo_sqlsrv':
                    return 'pdo';
                    break;
                /* Outros */
                default:
                    return $v_str_dbms;
                    break;
            }
        }// nm_db_module
}

/* Normaliza um diretorio */
        if(!function_exists("nm_dir_normalize")) {
            function nm_dir_normalize($v_str_dir)
            {
                $str_dir = str_replace("\\", '/', $v_str_dir);
                $str_dir = str_replace('//', '/', $str_dir);
                if ('/' != substr($str_dir, -1)) {
                    $str_dir .= '/';
                }
                return $str_dir;
            } // nm_dir_normalize
}

/* Inclui arquivos auxiliares */
function nm_init_includes()
{
    global $nm_config;

    include_once $nm_config['path_scase'] . 'devel/lib/php/sc_unserialize.php';
    include_once $nm_config['path_scase'] . 'devel/lib/third/gettext/gettext.inc';
    include_once $nm_config['path_scase'] . 'devel/lib/php/languages.inc.php';
    include_once $nm_config['path_scase'] . 'devel/class/xmlparser/nmXmlparser.class.php';
    include_once $nm_config['path_scase'] . 'devel/class/xmlparser/nmXmlparserIni.class.php';
    include_once $nm_config['path_scase'] . 'devel/class/xmlparser/nmXmlparserIniSys.class.php';
    include_once $nm_config['path_scase'] . 'prod/lib/php/crypt.inc.php';
    include_once $nm_config['path_scase'] . 'prod/third/adodb/adodb.inc.php';
} // nm_init_includes

/* Inicializa caminhos */
function nm_init_path()
{
    global $nm_config;
    $str_script   = $_SERVER['PHP_SELF'];
    $str_script   = str_replace("\\", '/', $str_script);
    $str_script   = str_replace('//', '/', $str_script);
    $str_url_base = dirname($str_script);
    if (isset($_SERVER['ORIG_PATH_TRANSLATED']))
    {
        $str_path_base = $_SERVER['ORIG_PATH_TRANSLATED'];
    }
    elseif (isset($_SERVER['PATH_TRANSLATED']))
    {
        $str_path_base = $_SERVER['PATH_TRANSLATED'];
    }
    else
    {
        $str_path_base = $_SERVER['SCRIPT_FILENAME'];
    }
    $str_path_base = str_replace("\\", '/', $str_path_base);
    $str_path_base = str_replace('//', '/', $str_path_base);
    $str_root      = substr($str_path_base, 0, (-1 * strlen($str_script)) + 1);
    $str_path_base = substr($str_path_base, 0, strrpos($str_path_base, '/'));
    for ($i = 0; $i < NM_SCASE_LEVEL; $i++)
    {
        $str_path_base = substr($str_path_base, 0, strrpos($str_path_base, '/'));
        $str_url_base  = substr($str_url_base,  0, strrpos($str_url_base,  '/'));
    }
    $nm_config                    = array();
    $nm_config['script']          = $str_script;
    $nm_config['path_root']       = $str_root;
    $nm_config['path_scase']      = $str_path_base           . '/';
    $nm_config['path_scriptcase'] = $nm_config['path_scase'] . 'devel/conf/scriptcase/';
    $nm_config['path_sys']        = $nm_config['path_scase'] . 'devel/conf/sys/';
    $nm_config['url_scase']       = $str_url_base            . '/';
    $nm_config['backup_hist']     = 5;
    $nm_config['path_lang']       = $nm_config['path_scase'] . 'devel/lang/';
    $nm_config['url_tmp']         = $nm_config['url_scase'] . 'tmp/';

    /*
     * tabelas da V4
     * separado agora em um unico arquivo para todo mundo dar upload
     * $nm_config['tab_apl'] ....
     */
    include_once $nm_config['path_scase'] . 'devel/lib/php/databases_sc.inc.php';
} // nm_init_path

/* Inicializa sessao */
function nm_init_session()
{
    if(session_id() == '') {
        session_start();
    }

    if (!isset($_SESSION['nm_session']))
    {
        $_SESSION['nm_session'] = array();
    }
} // nm_init_session

/* Inicializa variaveis */
function nm_init_vars_base()
{
    global $nm_lang, $arr_dbms;

    /* Lista de SGBDs */
    $arr_dbms                  = array();

    $arr_dbms['ado_mssql']     = 'MS SQL Server ADO';
    $arr_dbms['db2']           = 'DB2';
    $arr_dbms['db2_odbc']      = (isset($nm_lang['conn_list_db2_odbc_nativo'])?$nm_lang['conn_list_db2_odbc_nativo']:"");
    $arr_dbms['odbc_db2']      = (isset($nm_lang['conn_list_db2_odbc_generico'])?$nm_lang['conn_list_db2_odbc_generico']:"");
    $arr_dbms['odbc_db2v6']    = (isset($nm_lang['conn_list_db2_odbc_generico6'])?$nm_lang['conn_list_db2_odbc_generico6']:"");
    $arr_dbms['mssql']         = 'MS SQL Server 7';
    $arr_dbms['mssqlnative']   = 'MS SQL Server NATIVE SRV';
    $arr_dbms['mysql']         = 'MySQL';
    $arr_dbms['mysqlt']        = 'MySQL (Transactional)';
    $arr_dbms['pdo_mysql']     = 'MySQL PDO';
    $arr_dbms['oci8']          = (isset($nm_lang['conn_list_oci8'])?$nm_lang['conn_list_oci8']:"");
    $arr_dbms['oci805']        = 'Oracle 8.0.5';
    $arr_dbms['oci8po']        = 'Oracle 8 Portable';
    $arr_dbms['odbc']          = (isset($nm_lang['conn_list_odbc_generico'])?$nm_lang['conn_list_odbc_generico']:"");
    $arr_dbms['odbc_mssql']    = 'MS SQL Server ODBC';
    $arr_dbms['odbc_oracle']   = 'Oracle ODBC';
    $arr_dbms['oracle']        = 'Oracle 7';
    $arr_dbms['postgres']      = 'PostgreSQL';
    $arr_dbms['postgres64']    = 'PostgreSQL 6.4';
    $arr_dbms['postgres7']     = (isset($nm_lang['conn_list_postgres7'])?$nm_lang['conn_list_postgres7']:"");
    $arr_dbms['sqlite']        = 'SQLite';
    //$arr_dbms['sqlite3']       = 'SQLite 3';
    $arr_dbms['pdosqlite']     = 'SQLite PDO';
    asort($arr_dbms);
}

/* Inicializa variaveis */
function nm_init_vars()
{
    global $arr_err, $arr_form, $str_opt;

    /* Constantes */
    if(!defined("NM_INC_PROD_XML")) {
        define('NM_INC_PROD_XML', TRUE);
    }
    if(!defined("NM_SCASE_LEVEL")) {
        define('NM_SCASE_LEVEL', 3);
    }
    if(!defined("NM_SCASE_MODE")) {
        define('NM_SCASE_MODE', 'GUI');
    }
    if(!defined("SC_LOCKED_VERSION_8976")) {
        define('SC_LOCKED_VERSION_8976', 'CARREGADO4536');
    }

    /* Lista de erros */
    $arr_err = array();
    /* Dados do formulario */
    $arr_form = array(
        'db_base'   => '',
        'db_dbms'    => '',
        'db_host'    => '',
        'db_pass'    => '',
        'db_user'    => '',
        'db_esquema' => '',
    );
    /* Opcao de exibicao */
    $str_opt = 'form';
} // nm_init_vars

/* Carrega uma classe */
if(!function_exists("nm_load_class")) {
    function nm_load_class()
    {
    } // nm_load_class
}

/* Carrega arquivo de inicializacao do desenvolvimento */
function nm_load_ini_devel()
{
    global $arr_form, $nm_config;
    $obj_ini = new nmXmlparserIniSys();
    if ($obj_ini->Verify())
    {
        $obj_ini->Load();

        $_SESSION['nm_session']['status']['lang']    = ($obj_ini->GetTag('sys_idioma')==''?'pt_br':$obj_ini->GetTag('sys_idioma'));

        $arr_form['db_base']    = nm_crypt_decode($obj_ini->GetTag('conn/base'));
        $arr_form['db_dbms']    = $obj_ini->GetTag('conn/dbms');
        $arr_form['db_host']    = nm_crypt_decode($obj_ini->GetTag('conn/host'));
        $arr_form['db_user']    = nm_crypt_decode($obj_ini->GetTag('conn/user'));
        $arr_form['db_pass']    = nm_crypt_decode($obj_ini->GetTag('conn/pass'));
        $arr_form['db_esquema'] = $obj_ini->GetTag('conn/esquema');
    }
    else
    {
        $obj_ini->Handle('');
    }

    return $obj_ini;
} // nm_load_ini_devel

/* Salva arquivo ini de desenvolvimento */
function nm_save_ini_devel()
{
    global $arr_form, $nm_config, $obj_ini;
    if (isset($_SERVER['COMPUTERNAME']))
    {
        $str_host = $_SERVER['COMPUTERNAME'];
    }
    elseif (isset($_SERVER['LOCAL_ADDR']))
    {
        $str_host = $_SERVER['LOCAL_ADDR'];
    }
    else
    {
        $str_host = '';
    }
    $obj_ini->SetTag('conn/base',    nm_crypt_encode_utf8($arr_form['db_base']));
    $obj_ini->SetTag('conn/dbms',    $arr_form['db_dbms']);
    $obj_ini->SetTag('conn/host',    nm_crypt_encode_utf8($arr_form['db_host']));
    $obj_ini->SetTag('conn/pass',    nm_crypt_encode_utf8($arr_form['db_pass']));
    $obj_ini->SetTag('conn/user',    nm_crypt_encode_utf8($arr_form['db_user']));
    $obj_ini->SetTag('conn/esquema', $arr_form['db_esquema']);
    $obj_ini->SetTag('gc',           120);
    $obj_ini->SetTag('started',      'Y');
    $obj_ini->SetTag('url_random',   'Y');
    $obj_ini->SetTag('use_iframe',   'Y');
    $obj_ini->SetTag('def_template', 'sys__NM__scriptcase');
    $obj_ini->SetTag('path_root',    substr($nm_config['path_root'], 0, -1));
    $obj_ini->SetTag('path_app',     $nm_config['url_scase']  . 'app');
    $obj_ini->SetTag('path_prod',    $nm_config['url_scase']  . 'prod');
    $obj_ini->SetTag('path_cab',     $nm_config['url_scase']  . 'prod/img');
    $obj_ini->SetTag('path_doc',     $nm_config['path_scase'] . 'file/doc');
    $obj_ini->SetTag('path_img',     $nm_config['url_scase']  . 'file/img');
    $obj_ini->SetTag('path_cache',     $nm_config['path_scase']  . 'file/cache');
    $obj_ini->SetTag('path_tmp',     $nm_config['url_scase']  . 'tmp');
    if (('' != $str_host) && ('' == $obj_ini->GetTag('sys_datadic')))
    {
        $obj_ini->SetTag('sys_datadic', $str_host . $nm_config['url_scase'] . 'devel/compat/nm_datadic/nm_api.php');
    }
    $obj_ini->Save();
} // nm_save_ini_devel

/* Prepara string para exibicao no formulario */
if(!function_exists("nm_string_form")) {
    function nm_string_form($v_str_value)
    {
        return str_replace('"', '&quot;', $v_str_value);
    } // nm_string_form
}

/* Randomiza uma url */
if(!function_exists("nm_url_rand")) {
    function nm_url_rand($v_str_url)
    {
        $str_url = $v_str_url;
        $str_url .= (FALSE === strpos($v_str_url, '?'))
            ? '?rand='
            : '&rand=';
        $str_url .= substr(md5(mt_rand()), 8, 16);
        return $str_url;
    } // nm_url_rand
}

/**
 * Retorna a versao do PHP.
 *
 * @access  public
 * @return  integer  $int_result  Versao do PHP.
 */
if(!function_exists("nm_php_version")) {
    function nm_php_version()
    {
        if (-1 != version_compare(phpversion(), '5.0.0')) {
            return 5;
        } elseif (-1 != version_compare(phpversion(), '4.0.0')) {
            return 4;
        } else {
            return 3;
        }
    } // nm_php_version
}

nm_init_vars();
nm_init_path();
nm_init_session();
nm_init_includes();

/* Inicializa arquivos ini */
$obj_ini = nm_load_ini_devel();
nm_init_vars_base();
$nm_db = nm_db_connect_sys();
generateOutput($nm_config, $nm_db);
?>