<div class="panel" id="shortcuts-panel" role="dialog" aria-label="menu de contexto com os principais atalhos"
     aria-hidden="true">
    <div class="section" id="shortcuts">
        <?php
        if ($menu_data['check_shortcut_label'] == 'S') {
        ?>
        <div class="shortcuts-title">
            <span><?php echo $this->Nm_lang['lang_othr_menu_shortcuts']; ?></span>
        </div>
        <?php
        }
        ?>
        <ul class="column" id="shortcuts-list">

            <?php

            function safeChars($input) {
                global $apl_charset;
                $out = $input;
                $out = str_replace('"', '__##NM_D##__',$out);
                $out = str_replace("'", '__##NM_S##__',$out);

                return $out;
            }

            function flattenMenu($input) {
                $items_flat = [];
                foreach ($input as $data) {
                    $children = isset($data['itens']) ? $data['itens'] : [];
                    $data['itens'] = [];
                    $items_flat[$data['id']] = $data;
                    $children = flattenMenu($children);
                    foreach ($children as $child) {
                        $items_flat[$child['id']] = $child;
                    }
                }
                return $items_flat;
            }
            $flat_items = flattenMenu(json_decode($menu_itens, true));
            $var_targets_arr = json_decode($var_targets, true);

            $count_fav = 0;
            foreach ($menu_data['shortcuts'] as $fav) {
/*--- PHP 8.2 ---*/
/*                if (array_key_exists($fav, $flat_items)) { */
                if (isset($flat_items[$fav])) {
/*------*/
                    $get_item = $flat_items[$fav];
                    if ($get_item['disabled'] != 'Y' && $get_item['fav_check'] == 'S') {
                        $count_fav++;
                        $ico = '';
                        $icotab = '';

                        if (!empty($_SESSION['scriptcase']['charset']) && $_SESSION['scriptcase']['charset'] != 'UTF-8') {
                            $get_item['label'] = json_encode($get_item['label'], 2097152);
                            $get_item['label'] = substr($get_item['label'], 1, -1);
                            $get_item['label'] = str_replace('\\/','/',  $get_item['label']);
                            $get_item['label'] = preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($match) {
                                return '&#x'.$match[1].';';
                            }, $get_item['label']);
                            $get_item['hint'] = json_encode($get_item['hint'], 2097152);
                            $get_item['hint'] = substr($get_item['hint'], 1, -1);
                            $get_item['hint'] = str_replace('\\/','/',  $get_item['hint']);
                            $get_item['hint'] = preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($match) {
                                return '&#x'.$match[1].';';
                            }, $get_item['hint']);
                        }
                        if ($get_item['icon_check'] == 'S' && !empty($get_item['icon_fa'])) {
                            $ico = '<i class="'.$get_item['icon_fa'].' m-right-1.5"></i>';
                            $icotab = $ico;
                        } else {
                            $ico = '<i class="'.$get_item['icon_fa'].' m-right-1.5" style="visibility: hidden;"></i>';
                            $icotab = '';
                        }

                        $onclick_item = "clickFavLink('".safeChars($get_item['link'])."', '".safeChars($get_item['id'])."', '".safeChars($get_item['label'])."', '".safeChars($get_item['hint'])."', '".safeChars($icotab)."', '".$var_targets_arr[$get_item['link_target']]."', event);";

                        ?>
                        <li class="list-item">
                            <a href="<?php echo $get_item['link']; ?>" onclick="<?php echo $onclick_item; ?>" target="<?php echo $var_targets_arr[$get_item['link_target']]; ?>">
                                <p class="shortcut-title">
                                    <?php echo $ico; ?>
                                    <span><?php echo $get_item['label']; ?></span>
                                </p>
                                <p class="shortcut-description" title="<?php echo $get_item['hint']; ?>">
                                    <?php echo $get_item['hint']; ?>
                                </p>
                            </a>
                        </li>
                        <?php
                    }
                }
            }
            if ($count_fav%2 > 0) {

                ?>
                <li class="list-item dead-item"></li>
                <?php
            }
            ?>
        </ul>
    </div>
</div>
<script>
    <?php
    if ($count_fav == 0) {
    ?>
    $(document).ready(function () {
        hideTBButton('shortcuts');
    })
    <?php
    }
    ?>
    function clickFavLink(url, tabName, tabTitle, tabHint, tabIcon, tabTarget, e) {
        url = url.replaceAll('__##NM_D##__','"').replaceAll('__##NM_S##__',"'");
        tabName = tabName.replaceAll('__##NM_D##__','"').replaceAll('__##NM_S##__',"'");
        tabTitle = tabTitle.replaceAll('__##NM_D##__','"').replaceAll('__##NM_S##__',"'");
        tabIcon = tabIcon.replaceAll('__##NM_D##__','"').replaceAll('__##NM_S##__',"'");
        tabTarget = tabTarget.replaceAll('__##NM_D##__','"').replaceAll('__##NM_S##__',"'");
        SCMenubar.closePanel();
        if (tabTarget == '_self' && (url == '#' || url == '')) {
            window.close();
        }
        if (typeof openInTab == 'function') {
            if (tabTarget == 'nm_frame_app') {
                e.preventDefault();
                e.stopPropagation();
                openInTab(url, tabName, tabTitle, tabHint, tabIcon, tabTarget);
            }
        } else {
            if (tabTarget == 'nm_frame_app') {
                handleLinks(tabName);
            }
        }
    }
</script>