-- ----------------------------
-- Sequence structure for "public"."tb_benefits_benefit_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_benefits_benefit_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_benefits_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_benefits_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 13
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_candidates_candidate_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_candidates_candidate_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_candidates_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_candidates_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 3
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_companies_company_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_companies_company_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_companies_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_companies_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 4
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_contacts_contact_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_contacts_contact_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_contacts_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_contacts_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 8
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_experiences_experience_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_experiences_experience_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_experiences_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_experiences_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 2
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_industries_industry_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_industries_industry_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_industries_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_industries_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 13
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_job_positions_position_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_job_positions_position_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_job_positions_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_job_positions_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 22
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_req_education_education_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_req_education_education_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_req_education_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_req_education_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 8
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_req_status_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_req_status_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 5
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_req_status_status_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_req_status_status_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_req_types_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_req_types_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 7
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_req_types_type_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_req_types_type_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_req_urgencies_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_req_urgencies_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 4
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_req_urgencies_urgency_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_req_urgencies_urgency_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_requisitions_requisition_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_requisitions_requisition_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_requisitions_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_requisitions_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 6
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_sc_log_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_sc_log_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_sc_log_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_sc_log_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 42
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_sec_groups_group_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_sec_groups_group_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_sec_groups_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_sec_groups_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 4
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_submission_status_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_submission_status_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 6
 CACHE 1;

-- ----------------------------
-- Sequence structure for "public"."tb_submission_status_submission_status_id_seq"
-- ----------------------------
CREATE SEQUENCE "public"."tb_submission_status_submission_status_id_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Table structure for "public"."tb_benefits"
-- ----------------------------
CREATE TABLE "public"."tb_benefits" (
"benefit_id" int4 DEFAULT nextval('tb_benefits_seq'::regclass) NOT NULL,
"benefit_description" varchar(45) DEFAULT ''::character varying NOT NULL,
"benefit_note" varchar(60)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_benefits
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_benefits" VALUES ('1', 'Disability', null);
INSERT INTO "public"."tb_benefits" VALUES ('2', 'Vacation Time', null);
INSERT INTO "public"."tb_benefits" VALUES ('3', 'Medical', null);
INSERT INTO "public"."tb_benefits" VALUES ('4', 'Dental', null);
INSERT INTO "public"."tb_benefits" VALUES ('5', 'Vision', null);
INSERT INTO "public"."tb_benefits" VALUES ('6', 'Life', null);
INSERT INTO "public"."tb_benefits" VALUES ('7', '401K', null);
INSERT INTO "public"."tb_benefits" VALUES ('8', '401K Match', null);
INSERT INTO "public"."tb_benefits" VALUES ('9', 'Flexible Spending', null);
INSERT INTO "public"."tb_benefits" VALUES ('10', 'Stock Options', null);
INSERT INTO "public"."tb_benefits" VALUES ('11', 'Education Reimbursement', null);
INSERT INTO "public"."tb_benefits" VALUES ('12', 'PTO', null);
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_candidates"
-- ----------------------------
CREATE TABLE "public"."tb_candidates" (
"candidate_id" int4 DEFAULT nextval('tb_candidates_seq'::regclass) NOT NULL,
"candidate_name" varchar(250) DEFAULT ''::character varying NOT NULL,
"candidate_courtesy_title" varchar(45),
"candidate_birth_date" date,
"candidate_address" varchar(250),
"candidate_city" varchar(150),
"candidate_state" varchar(20),
"candidate_zip" varchar(20),
"candidate_email" varchar(150),
"candidate_phone" varchar(45),
"candidate_resume" bytea,
"candidate_resume_filename" varchar(100),
"candidate_resume_filesize" int4,
"candidate_notes" text,
"tb_sec_users_user_login" varchar(50) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_candidates
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_candidates" VALUES ('1', 'Eldrich Thomas', 'Mr', '1984-01-31', '', '', '', '', '', '', E'', '', '0', '', 'eldrich');
INSERT INTO "public"."tb_candidates" VALUES ('2', 'Mary Jane', 'Ms', '1988-11-11', '', '', '', '', 'mary@scriptcase.net', '', E'RESUME', 'resume.txt', '6', '', 'mary');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_candidates_submissions"
-- ----------------------------
CREATE TABLE "public"."tb_candidates_submissions" (
"requisition_id" int4 NOT NULL,
"candidate_id" int4 NOT NULL,
"submission_date" date,
"submission_status_id" int4,
"submission_interview_date" timestamp(6),
"submission_interview_address" varchar(250),
"submission_rating" int4
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_candidates_submissions
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_candidates_submissions" VALUES ('1', '1', '2013-10-30', '3', '2013-12-20 00:00:00', 'Kennedy Avenue 1001', '0');
INSERT INTO "public"."tb_candidates_submissions" VALUES ('1', '2', '2013-11-13', '1', null, null, null);
INSERT INTO "public"."tb_candidates_submissions" VALUES ('3', '2', '2014-02-03', '1', null, null, null);
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_companies"
-- ----------------------------
CREATE TABLE "public"."tb_companies" (
"company_id" int4 DEFAULT nextval('tb_companies_seq'::regclass) NOT NULL,
"company_name" varchar(150) DEFAULT ''::character varying NOT NULL,
"company_address" varchar(250),
"company_country" varchar(100),
"company_city" varchar(150),
"company_state" varchar(20),
"company_zip" varchar(20),
"company_url" varchar(45),
"industry_id" int4 NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_companies
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_companies" VALUES ('1', 'Netmake', 'Kennedy 1001', 'BR', 'Olinda', 'PE', '53230-630', 'www.scriptcase.net', '9');
INSERT INTO "public"."tb_companies" VALUES ('2', 'Sample company', '', 'US', '', '', '', '', '7');
INSERT INTO "public"."tb_companies" VALUES ('3', 'Scriptcase Company', '', 'BR', '', '', '', '', '9');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_contacts"
-- ----------------------------
CREATE TABLE "public"."tb_contacts" (
"contact_id" int4 DEFAULT nextval('tb_contacts_seq'::regclass) NOT NULL,
"contact_name" varchar(250) DEFAULT ''::character varying NOT NULL,
"job_position_id" int4,
"contact_phone" varchar(45),
"contact_email" varchar(150),
"company_id" int4 NOT NULL,
"tb_sec_users_user_login" varchar(50) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_contacts
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_contacts" VALUES ('2', 'Phill Morrison', '17', '555', 'info@scriptcase.net', '1', 'phill');
INSERT INTO "public"."tb_contacts" VALUES ('3', 'John Mayer', '13', '', 'info@scriptcase.net', '1', 'mayer');
INSERT INTO "public"."tb_contacts" VALUES ('5', 'Alice key', '1', '', 'news@scriptcase.net', '1', 'alice');
INSERT INTO "public"."tb_contacts" VALUES ('6', 'Andy Leroy', '4', '', '', '2', 'andy');
INSERT INTO "public"."tb_contacts" VALUES ('7', 'Paul Walsh', '4', '', '', '3', 'paul');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_experiences"
-- ----------------------------
CREATE TABLE "public"."tb_experiences" (
"experience_id" int4 DEFAULT nextval('tb_experiences_seq'::regclass) NOT NULL,
"experience_start_date" date,
"experience_end_date" date,
"candidate_id" int4 NOT NULL,
"company_id" int4,
"tb_job_positions_position_id" int4,
"experience_summary" text
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_experiences
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_experiences" VALUES ('1', '2008-10-01', '2010-10-01', '1', '2', '18', 'Great experience selling the software xxx in the whole USA.');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_industries"
-- ----------------------------
CREATE TABLE "public"."tb_industries" (
"industry_id" int4 DEFAULT nextval('tb_industries_seq'::regclass) NOT NULL,
"industry_description" varchar(60) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_industries
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_industries" VALUES ('1', 'Banking');
INSERT INTO "public"."tb_industries" VALUES ('2', 'Consulting - Financial');
INSERT INTO "public"."tb_industries" VALUES ('3', 'Consulting - IT');
INSERT INTO "public"."tb_industries" VALUES ('4', 'Financial');
INSERT INTO "public"."tb_industries" VALUES ('5', 'Hardware');
INSERT INTO "public"."tb_industries" VALUES ('6', 'Healthcare');
INSERT INTO "public"."tb_industries" VALUES ('7', 'Manufacturing');
INSERT INTO "public"."tb_industries" VALUES ('8', 'Pharma');
INSERT INTO "public"."tb_industries" VALUES ('9', 'Software');
INSERT INTO "public"."tb_industries" VALUES ('10', 'Telcom');
INSERT INTO "public"."tb_industries" VALUES ('11', 'Transportation');
INSERT INTO "public"."tb_industries" VALUES ('12', 'Other');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_job_positions"
-- ----------------------------
CREATE TABLE "public"."tb_job_positions" (
"position_id" int4 DEFAULT nextval('tb_job_positions_seq'::regclass) NOT NULL,
"position_description" varchar(60) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_job_positions
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_job_positions" VALUES ('1', 'Admin Assistant');
INSERT INTO "public"."tb_job_positions" VALUES ('2', 'Customer Service Manager');
INSERT INTO "public"."tb_job_positions" VALUES ('3', 'Executive');
INSERT INTO "public"."tb_job_positions" VALUES ('4', 'HR');
INSERT INTO "public"."tb_job_positions" VALUES ('5', 'IT - QA');
INSERT INTO "public"."tb_job_positions" VALUES ('6', 'IT - Software Engineer');
INSERT INTO "public"."tb_job_positions" VALUES ('7', 'IT - Technical Support');
INSERT INTO "public"."tb_job_positions" VALUES ('8', 'IT - Systems Analyst');
INSERT INTO "public"."tb_job_positions" VALUES ('9', 'IT - Web Developper');
INSERT INTO "public"."tb_job_positions" VALUES ('10', 'IT - Writting');
INSERT INTO "public"."tb_job_positions" VALUES ('11', 'Marketing Executive');
INSERT INTO "public"."tb_job_positions" VALUES ('12', 'Sales Manager');
INSERT INTO "public"."tb_job_positions" VALUES ('13', 'Accountant');
INSERT INTO "public"."tb_job_positions" VALUES ('14', 'CFO');
INSERT INTO "public"."tb_job_positions" VALUES ('15', 'CIO');
INSERT INTO "public"."tb_job_positions" VALUES ('16', 'COO');
INSERT INTO "public"."tb_job_positions" VALUES ('17', 'CEO');
INSERT INTO "public"."tb_job_positions" VALUES ('18', 'Sales Representative');
INSERT INTO "public"."tb_job_positions" VALUES ('19', 'Product Manager');
INSERT INTO "public"."tb_job_positions" VALUES ('20', 'Systems Administrator');
INSERT INTO "public"."tb_job_positions" VALUES ('21', 'IT - DBA');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_req_education"
-- ----------------------------
CREATE TABLE "public"."tb_req_education" (
"education_id" int4 DEFAULT nextval('tb_req_education_seq'::regclass) NOT NULL,
"education_description" varchar(45) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_req_education
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_req_education" VALUES ('1', 'Associates');
INSERT INTO "public"."tb_req_education" VALUES ('2', 'Bachelors');
INSERT INTO "public"."tb_req_education" VALUES ('3', 'Certificate');
INSERT INTO "public"."tb_req_education" VALUES ('4', 'HS/GED');
INSERT INTO "public"."tb_req_education" VALUES ('5', 'Masters');
INSERT INTO "public"."tb_req_education" VALUES ('6', 'None');
INSERT INTO "public"."tb_req_education" VALUES ('7', 'PhD');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_req_status"
-- ----------------------------
CREATE TABLE "public"."tb_req_status" (
"status_id" int4 DEFAULT nextval('tb_req_status_seq'::regclass) NOT NULL,
"status_description" varchar(45) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_req_status
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_req_status" VALUES ('1', 'Hiring');
INSERT INTO "public"."tb_req_status" VALUES ('2', 'Filled');
INSERT INTO "public"."tb_req_status" VALUES ('3', 'Closed');
INSERT INTO "public"."tb_req_status" VALUES ('4', 'On-Hold');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_req_types"
-- ----------------------------
CREATE TABLE "public"."tb_req_types" (
"type_id" int4 DEFAULT nextval('tb_req_types_seq'::regclass) NOT NULL,
"typ_description" varchar(45) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_req_types
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_req_types" VALUES ('1', 'Full-time');
INSERT INTO "public"."tb_req_types" VALUES ('2', 'Part-time');
INSERT INTO "public"."tb_req_types" VALUES ('3', 'Part-time temp');
INSERT INTO "public"."tb_req_types" VALUES ('4', 'Full-time temp');
INSERT INTO "public"."tb_req_types" VALUES ('5', 'Contract 1099');
INSERT INTO "public"."tb_req_types" VALUES ('6', 'Contract W-9');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_req_urgencies"
-- ----------------------------
CREATE TABLE "public"."tb_req_urgencies" (
"urgency_id" int4 DEFAULT nextval('tb_req_urgencies_seq'::regclass) NOT NULL,
"urgency_description" varchar(45) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_req_urgencies
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_req_urgencies" VALUES ('1', 'Hot');
INSERT INTO "public"."tb_req_urgencies" VALUES ('2', 'Warm');
INSERT INTO "public"."tb_req_urgencies" VALUES ('3', 'Cold');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_requisitions"
-- ----------------------------
CREATE TABLE "public"."tb_requisitions" (
"requisition_id" int4 DEFAULT nextval('tb_requisitions_seq'::regclass) NOT NULL,
"contact_id" int4 NOT NULL,
"requisition_target_fill_date" date,
"status_id" int4,
"urgency_id" int4,
"type_id" int4,
"position_id" int4,
"requisition_title" varchar(150),
"requisition_description" text,
"requisition_contract_duration" varchar(45),
"requisition_location" varchar(250),
"requisition_salary" numeric(10,2),
"requisition_requirements" text,
"required_education" int4
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_requisitions
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_requisitions" VALUES ('1', '5', '2014-01-31', '1', '2', '1', '1', '', '', '', '', '1500.00', '', '5');
INSERT INTO "public"."tb_requisitions" VALUES ('2', '2', '2014-01-31', '1', '1', '1', '8', '', '', '', '', '0.00', '', '2');
INSERT INTO "public"."tb_requisitions" VALUES ('3', '2', '2014-02-28', '1', '3', '2', '7', '', '', '', '', '0.00', '', '6');
INSERT INTO "public"."tb_requisitions" VALUES ('4', '7', '2014-06-01', '1', '3', '1', '1', 'Admin assistant', '', '', '', '1500.00', '', '2');
INSERT INTO "public"."tb_requisitions" VALUES ('5', '6', '2014-03-01', '1', '1', '4', '7', 'Technical Support', '', '2 years', '', '0.00', '', '6');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_requisitions_has_benefits"
-- ----------------------------
CREATE TABLE "public"."tb_requisitions_has_benefits" (
"requisition_id" int4 NOT NULL,
"benefit_id" int4 NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_requisitions_has_benefits
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('1', '2');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('1', '3');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('1', '4');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('1', '9');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('2', '2');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('2', '3');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('2', '4');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('2', '9');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('3', '2');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('4', '2');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('4', '3');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('4', '6');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('5', '2');
INSERT INTO "public"."tb_requisitions_has_benefits" VALUES ('5', '3');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_sc_log"
-- ----------------------------
CREATE TABLE "public"."tb_sc_log" (
"id" int4 DEFAULT nextval('tb_sc_log_seq'::regclass) NOT NULL,
"inserted_date" timestamp(6),
"username" varchar(90) DEFAULT ''::character varying NOT NULL,
"application" varchar(200) DEFAULT ''::character varying NOT NULL,
"creator" varchar(30) DEFAULT ''::character varying NOT NULL,
"ip_user" varchar(32) DEFAULT ''::character varying NOT NULL,
"action" varchar(30) DEFAULT ''::character varying NOT NULL,
"description" text
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_sc_log
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_sc_log" VALUES ('1', '2014-02-12 14:56:54', 'phill', 'form_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('2', '2014-02-12 14:57:08', 'phill', 'form_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('3', '2014-02-12 14:57:23', 'phill', 'form_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('4', '2014-02-12 14:58:12', '', 'app_grid_log', 'Scriptcase', '192.168.254.106', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('5', '2014-02-12 14:58:42', '', 'app_grid_log', 'Scriptcase', '192.168.254.106', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('6', '2014-02-12 14:59:04', 'phill', 'grid_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('7', '2014-02-12 14:59:06', 'phill', 'form_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('8', '2014-02-12 14:59:20', '', 'app_grid_log', 'Scriptcase', '192.168.254.106', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('9', '2014-02-12 14:59:45', '', 'app_grid_log', 'Scriptcase', '192.168.254.106', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('10', '2014-02-12 15:00:04', 'phill', 'grid_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('11', '2014-02-12 15:00:08', 'phill', 'form_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('12', '2014-02-12 15:00:11', 'phill', 'grid_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('13', '2014-02-12 15:00:12', 'phill', 'form_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('14', '2014-02-12 15:00:24', 'phill', 'grid_tb_contacts', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('15', '2014-02-12 15:03:21', '', 'app_grid_log', 'Scriptcase', '192.168.254.106', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('16', '2014-02-12 15:03:53', '', 'app_grid_log', 'Scriptcase', '192.168.254.106', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('17', '2014-02-12 15:11:18', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('18', '2014-02-12 15:11:22', 'mary', 'grid_submitted_candidate', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('19', '2014-02-12 15:11:24', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('20', '2014-02-12 15:11:41', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('21', '2014-02-12 15:11:53', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('22', '2014-02-12 15:11:57', 'mary', 'grid_submitted_candidate', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('23', '2014-02-12 15:12:01', 'mary', 'form_look_requisition', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('24', '2014-02-12 15:12:02', 'mary', 'grid_tb_requisitions_has_benefits', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('25', '2014-02-12 15:12:40', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('26', '2014-02-12 15:13:02', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('27', '2014-02-12 15:13:06', 'mary', 'grid_submitted_candidate', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('28', '2014-02-12 15:13:22', 'mary', 'form_edit_candidate', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('29', '2014-02-12 15:13:23', 'mary', 'form_tb_experiences', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('30', '2014-02-12 15:13:30', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('31', '2014-02-12 15:14:03', 'mary', 'grid_submitted_candidate', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('32', '2014-02-12 15:14:08', 'mary', 'form_look_requisition', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('33', '2014-02-12 15:14:08', 'mary', 'grid_tb_requisitions_has_benefits', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('34', '2014-02-12 15:14:27', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('35', '2014-02-12 15:16:55', '', 'form_add_candidate', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('36', '2014-02-12 15:17:23', '', 'form_add_contact', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('37', '2014-02-12 15:21:26', 'mary', 'menu', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('38', '2014-02-12 15:21:26', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('39', '2014-02-12 15:21:29', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('40', '2014-02-12 15:32:06', 'mary', 'menu', 'Scriptcase', '192.168.254.162', 'access', '');
INSERT INTO "public"."tb_sc_log" VALUES ('41', '2014-02-12 15:32:07', 'mary', 'grid_search_jobs', 'Scriptcase', '192.168.254.162', 'access', '');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_sec_applications"
-- ----------------------------
CREATE TABLE "public"."tb_sec_applications" (
"applications_id" varchar(150) DEFAULT ''::character varying NOT NULL,
"applications_description" text
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_sec_applications
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_sec_applications" VALUES ('app_grid_log', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('blank_submit_candidate', 'blank');
INSERT INTO "public"."tb_sec_applications" VALUES ('control_change_psw', 'contr');
INSERT INTO "public"."tb_sec_applications" VALUES ('control_sync_apps', 'contr');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_add_candidate', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_add_company', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_add_contact', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_edit_candidate', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_look_candidate', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_look_requisition', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_benefits', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_candidates', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_candidates_submissions', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_companies', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_contacts', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_experiences', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_industries', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_job_positions', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_req_education', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_req_status', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_req_types', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_req_urgencies', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_requisitions', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_sec_applications', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_sec_groups', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_sec_groups_applications', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('form_tb_submission_status', 'form');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_search_jobs', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_submitted_candidate', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_benefits', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_candidates', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_candidates_submissions', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_companies', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_contacts', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_contacts_detail', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_experiences', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_industries', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_job_positions', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_req_education', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_req_status', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_req_types', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_req_urgencies', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_requisitions', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_requisitions_has_benefits', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_sec_applications', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_sec_groups', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('grid_tb_submission_status', 'cons');
INSERT INTO "public"."tb_sec_applications" VALUES ('login', 'contr');
INSERT INTO "public"."tb_sec_applications" VALUES ('menu', '');
INSERT INTO "public"."tb_sec_applications" VALUES ('search_tb_sec_groups', 'filter');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_sec_groups"
-- ----------------------------
CREATE TABLE "public"."tb_sec_groups" (
"group_id" int4 DEFAULT nextval('tb_sec_groups_seq'::regclass) NOT NULL,
"group_description" varchar(45) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_sec_groups
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_sec_groups" VALUES ('1', 'Contacts');
INSERT INTO "public"."tb_sec_groups" VALUES ('2', 'Candidates');
INSERT INTO "public"."tb_sec_groups" VALUES ('3', 'Administrator');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_sec_groups_applications"
-- ----------------------------
CREATE TABLE "public"."tb_sec_groups_applications" (
"tb_sec_groups_group_id" int4 NOT NULL,
"tb_sec_applications_id" varchar(150) DEFAULT ''::character varying NOT NULL,
"priv_access" varchar(1),
"priv_insert" varchar(1),
"priv_delete" varchar(1),
"priv_update" varchar(1),
"priv_export" varchar(1),
"priv_print" varchar(1)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_sec_groups_applications
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'control_change_psw', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_add_candidate', null, null, null, null, null, null);
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_add_company', null, null, null, null, null, null);
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_add_contact', null, null, null, null, null, null);
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_look_candidate', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_look_requisition', null, null, null, null, null, null);
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_benefits', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_candidates_submissions', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_companies', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_industries', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_job_positions', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_req_education', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_req_status', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_req_types', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_req_urgencies', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_requisitions', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'form_tb_submission_status', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_submitted_candidate', null, null, null, null, null, null);
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_benefits', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_candidates_submissions', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_companies', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_contacts', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_contacts_detail', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_experiences', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_industries', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_job_positions', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_req_education', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_req_status', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_req_types', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_req_urgencies', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_requisitions', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_requisitions_has_benefits', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'grid_tb_submission_status', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'login', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('1', 'menu', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'blank_submit_candidate', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'control_change_psw', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'form_add_candidate', null, null, null, null, null, null);
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'form_add_company', null, null, null, null, null, null);
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'form_add_contact', null, null, null, null, null, null);
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'form_edit_candidate', 'Y', 'Y', '', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'form_look_requisition', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'form_tb_candidates', 'Y', 'Y', '', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'form_tb_experiences', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'grid_search_jobs', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'grid_submitted_candidate', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'grid_tb_experiences', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'grid_tb_requisitions_has_benefits', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'login', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('2', 'menu', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'app_grid_log', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'blank_submit_candidate', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'control_change_psw', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'control_sync_apps', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_add_candidate', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_add_company', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_add_contact', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_edit_candidate', '', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_look_candidate', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_look_requisition', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_benefits', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_candidates', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_candidates_submissions', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_companies', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_contacts', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_experiences', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_industries', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_job_positions', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_req_education', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_req_status', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_req_types', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_req_urgencies', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_requisitions', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_sec_applications', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_sec_groups', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_sec_groups_applications', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'form_tb_submission_status', 'Y', 'Y', 'Y', 'Y', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_search_jobs', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_submitted_candidate', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_benefits', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_candidates', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_candidates_submissions', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_companies', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_contacts', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_contacts_detail', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_experiences', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_industries', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_job_positions', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_req_education', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_req_status', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_req_types', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_req_urgencies', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_requisitions', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_requisitions_has_benefits', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_sec_applications', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_sec_groups', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'grid_tb_submission_status', 'Y', '', '', '', 'Y', 'Y');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'login', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'menu', 'Y', '', '', '', '', '');
INSERT INTO "public"."tb_sec_groups_applications" VALUES ('3', 'search_tb_sec_groups', 'Y', '', '', '', '', '');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_sec_users"
-- ----------------------------
CREATE TABLE "public"."tb_sec_users" (
"user_login" varchar(50) DEFAULT ''::character varying NOT NULL,
"user_password" varchar(150) DEFAULT ''::character varying NOT NULL,
"tb_sec_groups_group_id" int4 NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_sec_users
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_sec_users" VALUES ('admin', 'admin', '3');
INSERT INTO "public"."tb_sec_users" VALUES ('alice', 'alice', '1');
INSERT INTO "public"."tb_sec_users" VALUES ('andy', 'andy', '1');
INSERT INTO "public"."tb_sec_users" VALUES ('eldrich', 'eldrich', '2');
INSERT INTO "public"."tb_sec_users" VALUES ('mary', 'mary', '2');
INSERT INTO "public"."tb_sec_users" VALUES ('mayer', 'mayer', '1');
INSERT INTO "public"."tb_sec_users" VALUES ('paul', 'paul', '1');
INSERT INTO "public"."tb_sec_users" VALUES ('phill', 'phill', '1');
COMMIT;

-- ----------------------------
-- Table structure for "public"."tb_submission_status"
-- ----------------------------
CREATE TABLE "public"."tb_submission_status" (
"submission_status_id" int4 DEFAULT nextval('tb_submission_status_seq'::regclass) NOT NULL,
"submission_status_description" varchar(45) DEFAULT ''::character varying NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of tb_submission_status
-- ----------------------------
BEGIN;
INSERT INTO "public"."tb_submission_status" VALUES ('1', 'Submitted');
INSERT INTO "public"."tb_submission_status" VALUES ('2', 'Rejected');
INSERT INTO "public"."tb_submission_status" VALUES ('3', 'Scheduled');
INSERT INTO "public"."tb_submission_status" VALUES ('4', 'Cancelled');
INSERT INTO "public"."tb_submission_status" VALUES ('5', 'Hired');
COMMIT;

-- ----------------------------
-- Alter Sequences Owned By 
-- ----------------------------
ALTER SEQUENCE "public"."tb_benefits_benefit_id_seq" OWNED BY "tb_benefits"."benefit_id";
ALTER SEQUENCE "public"."tb_candidates_candidate_id_seq" OWNED BY "tb_candidates"."candidate_id";
ALTER SEQUENCE "public"."tb_companies_company_id_seq" OWNED BY "tb_companies"."company_id";
ALTER SEQUENCE "public"."tb_contacts_contact_id_seq" OWNED BY "tb_contacts"."contact_id";
ALTER SEQUENCE "public"."tb_experiences_experience_id_seq" OWNED BY "tb_experiences"."experience_id";
ALTER SEQUENCE "public"."tb_industries_industry_id_seq" OWNED BY "tb_industries"."industry_id";
ALTER SEQUENCE "public"."tb_job_positions_position_id_seq" OWNED BY "tb_job_positions"."position_id";
ALTER SEQUENCE "public"."tb_req_education_education_id_seq" OWNED BY "tb_req_education"."education_id";
ALTER SEQUENCE "public"."tb_req_status_status_id_seq" OWNED BY "tb_req_status"."status_id";
ALTER SEQUENCE "public"."tb_req_types_type_id_seq" OWNED BY "tb_req_types"."type_id";
ALTER SEQUENCE "public"."tb_req_urgencies_urgency_id_seq" OWNED BY "tb_req_urgencies"."urgency_id";
ALTER SEQUENCE "public"."tb_requisitions_requisition_id_seq" OWNED BY "tb_requisitions"."requisition_id";
ALTER SEQUENCE "public"."tb_sc_log_id_seq" OWNED BY "tb_sc_log"."id";
ALTER SEQUENCE "public"."tb_sec_groups_group_id_seq" OWNED BY "tb_sec_groups"."group_id";
ALTER SEQUENCE "public"."tb_submission_status_submission_status_id_seq" OWNED BY "tb_submission_status"."submission_status_id";

-- ----------------------------
-- Primary Key structure for table "public"."tb_benefits"
-- ----------------------------
ALTER TABLE "public"."tb_benefits" ADD PRIMARY KEY ("benefit_id");

-- ----------------------------
-- Indexes structure for table tb_candidates
-- ----------------------------
CREATE INDEX "fk_tb_candidates_tb_sec_users1_idx" ON "public"."tb_candidates" USING btree ("tb_sec_users_user_login");

-- ----------------------------
-- Primary Key structure for table "public"."tb_candidates"
-- ----------------------------
ALTER TABLE "public"."tb_candidates" ADD PRIMARY KEY ("candidate_id");

-- ----------------------------
-- Indexes structure for table tb_candidates_submissions
-- ----------------------------
CREATE INDEX "fk_requisitions_has_candidates_candidates1_idx" ON "public"."tb_candidates_submissions" USING btree ("candidate_id");
CREATE INDEX "fk_requisitions_has_candidates_requisitions1_idx" ON "public"."tb_candidates_submissions" USING btree ("requisition_id");
CREATE INDEX "fk_tb_candidates_submissions_tb_submission_status1_idx" ON "public"."tb_candidates_submissions" USING btree ("submission_status_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_candidates_submissions"
-- ----------------------------
ALTER TABLE "public"."tb_candidates_submissions" ADD PRIMARY KEY ("requisition_id", "candidate_id");

-- ----------------------------
-- Indexes structure for table tb_companies
-- ----------------------------
CREATE INDEX "fk_tb_companies_tb_industries1_idx" ON "public"."tb_companies" USING btree ("industry_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_companies"
-- ----------------------------
ALTER TABLE "public"."tb_companies" ADD PRIMARY KEY ("company_id");

-- ----------------------------
-- Indexes structure for table tb_experiences
-- ----------------------------
CREATE INDEX "fk_tb_experiences_tb_candidates1_idx" ON "public"."tb_experiences" USING btree ("candidate_id");
CREATE INDEX "fk_tb_experiences_tb_companies1_idx" ON "public"."tb_experiences" USING btree ("company_id");
CREATE INDEX "fk_tb_experiences_tb_job_positions1_idx" ON "public"."tb_experiences" USING btree ("tb_job_positions_position_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_experiences"
-- ----------------------------
ALTER TABLE "public"."tb_experiences" ADD PRIMARY KEY ("experience_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_industries"
-- ----------------------------
ALTER TABLE "public"."tb_industries" ADD PRIMARY KEY ("industry_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_job_positions"
-- ----------------------------
ALTER TABLE "public"."tb_job_positions" ADD PRIMARY KEY ("position_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_req_education"
-- ----------------------------
ALTER TABLE "public"."tb_req_education" ADD PRIMARY KEY ("education_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_req_status"
-- ----------------------------
ALTER TABLE "public"."tb_req_status" ADD PRIMARY KEY ("status_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_req_types"
-- ----------------------------
ALTER TABLE "public"."tb_req_types" ADD PRIMARY KEY ("type_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_req_urgencies"
-- ----------------------------
ALTER TABLE "public"."tb_req_urgencies" ADD PRIMARY KEY ("urgency_id");

-- ----------------------------
-- Indexes structure for table tb_requisitions
-- ----------------------------
CREATE INDEX "fk_requisitions_tb_contacts1_idx" ON "public"."tb_requisitions" USING btree ("contact_id");
CREATE INDEX "fk_tb_requisitions_tb_req_education1_idx" ON "public"."tb_requisitions" USING btree ("required_education");
CREATE INDEX "fk_tb_requisitions_tb_req_positions1_idx" ON "public"."tb_requisitions" USING btree ("position_id");
CREATE INDEX "fk_tb_requisitions_tb_req_status1_idx" ON "public"."tb_requisitions" USING btree ("status_id");
CREATE INDEX "fk_tb_requisitions_tb_req_types1_idx" ON "public"."tb_requisitions" USING btree ("type_id");
CREATE INDEX "fk_tb_requisitions_tb_req_urgencies1_idx" ON "public"."tb_requisitions" USING btree ("urgency_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_requisitions"
-- ----------------------------
ALTER TABLE "public"."tb_requisitions" ADD PRIMARY KEY ("requisition_id");

-- ----------------------------
-- Indexes structure for table tb_requisitions_has_benefits
-- ----------------------------
CREATE INDEX "fk_tb_requisitions_has_tb_benefits_tb_benefits1_idx" ON "public"."tb_requisitions_has_benefits" USING btree ("benefit_id");
CREATE INDEX "fk_tb_requisitions_has_tb_benefits_tb_requisitions1_idx" ON "public"."tb_requisitions_has_benefits" USING btree ("requisition_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_requisitions_has_benefits"
-- ----------------------------
ALTER TABLE "public"."tb_requisitions_has_benefits" ADD PRIMARY KEY ("requisition_id", "benefit_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_sc_log"
-- ----------------------------
ALTER TABLE "public"."tb_sc_log" ADD PRIMARY KEY ("id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_sec_applications"
-- ----------------------------
ALTER TABLE "public"."tb_sec_applications" ADD PRIMARY KEY ("applications_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_sec_groups"
-- ----------------------------
ALTER TABLE "public"."tb_sec_groups" ADD PRIMARY KEY ("group_id");

-- ----------------------------
-- Indexes structure for table tb_sec_groups_applications
-- ----------------------------
CREATE INDEX "fk_tb_sec_groups_applications_tb_sec_application_idx" ON "public"."tb_sec_groups_applications" USING btree ("tb_sec_applications_id");
CREATE INDEX "fk_tb_sec_groups_applications_tb_sec_groups1_idx" ON "public"."tb_sec_groups_applications" USING btree ("tb_sec_groups_group_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_sec_groups_applications"
-- ----------------------------
ALTER TABLE "public"."tb_sec_groups_applications" ADD PRIMARY KEY ("tb_sec_groups_group_id", "tb_sec_applications_id");

-- ----------------------------
-- Indexes structure for table tb_sec_users
-- ----------------------------
CREATE INDEX "fk_tb_sec_users_tb_sec_groups1_idx" ON "public"."tb_sec_users" USING btree ("tb_sec_groups_group_id");

-- ----------------------------
-- Primary Key structure for table "public"."tb_sec_users"
-- ----------------------------
ALTER TABLE "public"."tb_sec_users" ADD PRIMARY KEY ("user_login");

-- ----------------------------
-- Primary Key structure for table "public"."tb_submission_status"
-- ----------------------------
ALTER TABLE "public"."tb_submission_status" ADD PRIMARY KEY ("submission_status_id");

-- ----------------------------
-- Foreign Key structure for table "public"."tb_candidates"
-- ----------------------------
ALTER TABLE "public"."tb_candidates" ADD FOREIGN KEY ("tb_sec_users_user_login") REFERENCES "public"."tb_sec_users" ("user_login") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Key structure for table "public"."tb_candidates_submissions"
-- ----------------------------
ALTER TABLE "public"."tb_candidates_submissions" ADD FOREIGN KEY ("candidate_id") REFERENCES "public"."tb_candidates" ("candidate_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."tb_candidates_submissions" ADD FOREIGN KEY ("requisition_id") REFERENCES "public"."tb_requisitions" ("requisition_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."tb_candidates_submissions" ADD FOREIGN KEY ("submission_status_id") REFERENCES "public"."tb_submission_status" ("submission_status_id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Key structure for table "public"."tb_companies"
-- ----------------------------
ALTER TABLE "public"."tb_companies" ADD FOREIGN KEY ("industry_id") REFERENCES "public"."tb_industries" ("industry_id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Key structure for table "public"."tb_contacts"
-- ----------------------------
ALTER TABLE "public"."tb_contacts" ADD FOREIGN KEY ("tb_sec_users_user_login") REFERENCES "public"."tb_sec_users" ("user_login") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."tb_contacts" ADD FOREIGN KEY ("job_position_id") REFERENCES "public"."tb_job_positions" ("position_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."tb_contacts" ADD FOREIGN KEY ("company_id") REFERENCES "public"."tb_companies" ("company_id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Key structure for table "public"."tb_experiences"
-- ----------------------------
ALTER TABLE "public"."tb_experiences" ADD FOREIGN KEY ("company_id") REFERENCES "public"."tb_companies" ("company_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."tb_experiences" ADD FOREIGN KEY ("candidate_id") REFERENCES "public"."tb_candidates" ("candidate_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."tb_experiences" ADD FOREIGN KEY ("tb_job_positions_position_id") REFERENCES "public"."tb_job_positions" ("position_id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Key structure for table "public"."tb_requisitions_has_benefits"
-- ----------------------------
ALTER TABLE "public"."tb_requisitions_has_benefits" ADD FOREIGN KEY ("benefit_id") REFERENCES "public"."tb_benefits" ("benefit_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."tb_requisitions_has_benefits" ADD FOREIGN KEY ("requisition_id") REFERENCES "public"."tb_requisitions" ("requisition_id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Key structure for table "public"."tb_sec_groups_applications"
-- ----------------------------
ALTER TABLE "public"."tb_sec_groups_applications" ADD FOREIGN KEY ("tb_sec_groups_group_id") REFERENCES "public"."tb_sec_groups" ("group_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE "public"."tb_sec_groups_applications" ADD FOREIGN KEY ("tb_sec_applications_id") REFERENCES "public"."tb_sec_applications" ("applications_id") ON DELETE NO ACTION ON UPDATE NO ACTION;

-- ----------------------------
-- Foreign Key structure for table "public"."tb_sec_users"
-- ----------------------------
ALTER TABLE "public"."tb_sec_users" ADD FOREIGN KEY ("tb_sec_groups_group_id") REFERENCES "public"."tb_sec_groups" ("group_id") ON DELETE NO ACTION ON UPDATE NO ACTION;
